/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.person;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hsas.business.dataport.PersonImportConfig;
import kd.swc.hsas.business.dataport.PersonImportDataTask;
import kd.swc.hsas.business.dataport.PersonImportHelper;
import kd.swc.hsas.business.dataport.SalaryFileImportDataTask;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class PersonImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(PersonImportingPlugin.class);
    public static final Set<String> entitySet = Sets.newHashSet((Object[])new String[]{"hsas_taxfiletmp", "hsas_salaryfile"});
    private static final String BT_SHOW_RESULT = "btnresult";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndetails", BT_SHOW_RESULT});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "btnclose", "btnok"});
        String mainEntityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainEntityId);
        String mainEntityName = mainEntityType.getDisplayName().toString();
        Label lblTitle = (Label)this.getView().getControl("title");
        lblTitle.setText(mainEntityName);
        Object logId = ImportLogHelper.create((String)PersonImportDataTask.getCacheKey((String)mainEntityId, (String)view.getPageId()), (String)mainEntityName);
        this.getPageCache().put("IMPORT_PROGRESS_ID", String.valueOf(logId));
        this.updateImportLog(logId, "importtype", "1");
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        String url = (String)this.getView().getFormShowParameter().getShowParameter().getCustomParam("url");
        try {
            this.putImportCache(mainEntityId, url);
            PersonImportConfig conf = new PersonImportConfig(view, logId, url, mainEntityId);
            RequestContext requestConext = RequestContext.get();
            List<PersonImportDataTask> taskList = this.getDataTask(mainEntityId, requestConext, conf);
            for (PersonImportDataTask task : taskList) {
                SWCThreadPoolFactory.getCommonImportThreadpool().submit((Callable)task);
            }
            progress.start();
        }
        catch (Throwable ex) {
            log.error(ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"PersonImportingPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PersonImportingPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            ImportLogHelper.append((Object)logId, (String)ImportLogger.formatException((Throwable)ex));
            SalaryFileImportDataTask.removeImportCache((String)mainEntityId, (Set)Sets.newHashSet((Object[])new String[]{url}));
        }
    }

    private void updateImportLog(Object pkId, String propertyName, Object value) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)objType);
        dyn.set(propertyName, value);
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    private List<PersonImportDataTask> getDataTask(String mainEntityId, RequestContext requestConext, PersonImportConfig conf) {
        ArrayList<PersonImportDataTask> taskList = new ArrayList<PersonImportDataTask>(2);
        if (entitySet.contains(mainEntityId)) {
            taskList.add((PersonImportDataTask)new SalaryFileImportDataTask(requestConext, conf, "resolveExcel"));
            taskList.add((PersonImportDataTask)new SalaryFileImportDataTask(requestConext, conf, "importData"));
        } else {
            taskList.add(new PersonImportDataTask(requestConext, conf, "resolveExcel"));
            taskList.add(new PersonImportDataTask(requestConext, conf, "importData"));
        }
        return taskList;
    }

    private void putImportCache(String mainEntityId, String url) {
        String userId;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsasimport");
        HashSet<String> fileNames = (HashSet<String>)appCache.get(userId = RequestContext.get().getUserId(), Set.class);
        if (null == fileNames) {
            fileNames = new HashSet<String>();
        }
        fileNames.add(mainEntityId + "_" + PersonImportHelper.getImportFileName((String)url));
        appCache.put(userId, fileNames, 300);
    }

    public void onProgress(ProgressEvent evt) {
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        log.info("{}<----{}", (Object)"Cached_Import_Logger", (Object)cacheLogStr);
        JSONObject info = JSON.parseObject((String)cacheLogStr);
        if (info != null) {
            importProgress = info.getIntValue("progress");
            if (importProgress < 0) {
                this.importProgressError(info);
                return;
            }
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handlecount = (Label)this.getControl("handlecount");
            int row = info.getIntValue("rowindex") - 2;
            int lastrow = info.getIntValue("lastrowindex") - 3;
            int total = info.getIntValue("total");
            int succeed = info.getIntValue("succeed");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastrow);
            }
            handlecount.setText("" + total);
            if (importProgress >= 100) {
                this.importProgressDone(info, succeed);
            }
            if (lastrow > 0) {
                this.importProcessing();
            }
        }
        evt.setProgress(importProgress);
    }

    private void importProcessing() {
        HashMap<String, Integer> meta = new HashMap<String, Integer>();
        meta.put("itime", 3000);
        this.getView().updateControlMetadata("progressbarap", meta);
    }

    private void importProgressDone(JSONObject info, int succeed) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel"});
        int failed = info.getIntValue("failed");
        if (failed > 0) {
            Label successLabel = (Label)this.getControl("success");
            Label failLabel = (Label)this.getControl("failed");
            successLabel.setText("" + succeed);
            failLabel.setText("" + failed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"failpanel", "btnok"});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("failpanel", notHidden);
        } else {
            Label success = (Label)this.getControl("successall");
            success.setText("" + succeed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel"});
            HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("successpanel", notHidden);
        }
    }

    private void importProgressError(JSONObject info) {
        String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef\u3002", (String)"PersonImportingPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(err);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.stop();
    }

    public void click(EventObject evt) {
        String controlKey;
        IFormView view = this.getView();
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btndetails": {
                this.detialsClick();
                break;
            }
            case "btnok": {
                FormShowParameter importShowParameter = new FormShowParameter();
                importShowParameter.setFormId("hsas_person_importstart");
                importShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                importShowParameter.setCustomParam("entityid", view.getFormShowParameter().getCustomParam("entityid"));
                importShowParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
                importShowParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
                importShowParameter.setCustomParam("hastaxfileperm", view.getFormShowParameter().getCustomParam("hastaxfileperm"));
                view.showForm(importShowParameter);
                break;
            }
            case "btnresult": {
                String parentPageId = view.getFormShowParameter().getParentPageId();
                IFormView parentView = view.getViewNoPlugin(parentPageId);
                String pkId = this.getPageCache().get("IMPORT_PROGRESS_ID");
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("bos_importlog");
                parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
                parameter.setParentPageId(view.getFormShowParameter().getParentPageId());
                parameter.setPkId((Object)pkId);
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                if (view.getParentView() != null && view.getParentView().getFormShowParameter() instanceof ListShowParameter) {
                    parameter.getCustomParams().put("ParentEntityId", ((ListShowParameter)view.getParentView().getFormShowParameter()).getBillFormId());
                }
                parentView.showForm((FormShowParameter)parameter);
                view.sendFormAction(parentView);
                view.close();
                break;
            }
        }
    }

    private void detialsClick() {
        String jsonData;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)entityId, (String)this.getView().getPageId()))});
        if (taskData == null || StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PersonImportingPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject data = JSON.parseObject((String)jsonData);
        try {
            JSONObject info = data.getJSONObject("info");
            for (Object obj : info.values()) {
                this.downloadDetail(obj);
            }
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\u3002\u53ef\u80fd\u662f\u56e0\u4e3a\u65e5\u5fd7\u683c\u5f0f\u592a\u65e7\uff0c\u8bf7\u624b\u52a8\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u5730\u5740\u5e76\u5728\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"PersonImportingPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    private void downloadDetail(Object obj) {
        ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
            proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
        } else {
            this.detailClickErrorShow(logger);
        }
    }

    private void detailClickErrorShow(ImportLogger logger) {
        if (logger.getFailed() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"PersonImportingPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else {
            String msg = logger.toString().trim();
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView instanceof ListView) {
            // empty if block
        }
    }
}

