/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personhr;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PerBankCardExtEdit
extends AbstractFormPlugin {
    public static final Log logger = LogFactory.getLog(PerBankCardExtEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addItemClickListeners(new String[]{"bar_save"});
    }

    public void beforeBindData(EventObject e) {
        this.setHisField();
        String boId = this.getModel().getDataEntity().getString("boid");
        String entityId = this.getView().getEntityId();
        Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
        if (isChange != null && isChange.booleanValue()) {
            this.addDataMutexLock(entityId, boId);
        }
    }

    private void addDataMutexLock(String entityId, String boId) {
        String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
        try (DataMutex dataMutex = DataMutex.create();){
            Map<String, String> lockInfo = this.getMutexLockInfo(entityId, boId, groupId, dataMutex);
            if (null != lockInfo && !lockInfo.isEmpty()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_confirmchange1", "bankcardnum", "bankdeposit", "username", "accountrelation", "cardpurpose", "description", "changedescription", "bar_changeupdate"});
                this.showMutexNotification(lockInfo);
            } else {
                this.getPageCache().put("boid", boId);
                this.addMutexLock(entityId, boId, groupId, dataMutex);
            }
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageRelease(EventObject eventObject) {
        String boId = this.getPageCache().get("boid");
        if (!SWCStringUtils.isEmpty((String)boId)) {
            DataMutex dataMutex = DataMutex.create();
            try {
                dataMutex.release(boId, this.getView().getEntityId(), "modify");
            }
            finally {
                try {
                    dataMutex.close();
                }
                catch (IOException ioException) {
                    logger.error((Throwable)ioException);
                }
            }
        }
    }

    private Map<String, String> getMutexLockInfo(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        return dataMutex.getLockInfo(pkId, groupId, entityId);
    }

    private void addMutexLock(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        dataMutex.require(pkId, groupId, entityId, "modify");
    }

    private void showMutexNotification(Map<String, String> lockInfo) {
        Map userInfo;
        String userId = lockInfo.get("userid");
        String operateKey = lockInfo.get("opkey");
        if (!SWCStringUtils.isEmpty((String)userId) && SWCStringUtils.equals((String)operateKey, (String)"modify") && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
            String userName = (String)userInfo.get("name");
            if (!SWCStringUtils.isEmpty((String)userName)) {
                this.getView().showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"AbstractSalaryFileSubTableHisEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), userName));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractSalaryFileSubTableHisEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setHisField() {
        if ("".equals(this.getModel().getDataEntity().getString("username"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"changedescription"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        OperateOption option = formOperate.getOption();
        switch (key) {
            case "confirmchange": {
                boolean permFlag;
                Boolean isHasRight = (Boolean)this.getView().getFormShowParameter().getCustomParam("isHasRight");
                if (!(isHasRight != null && isHasRight.booleanValue() || (permFlag = SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hrpi_perbankcard", (String)"4715a0df000000ac")))) {
                    String tips = SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u94f6\u884c\u5361", (String)"PerBankCardExtListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u4fee\u6539", (String)"PerBankCardExtEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(tips);
                    args.setCancel(true);
                    return;
                }
                args.setCancel(this.validateBankCardNumRepeat() || this.validateIsDelete());
                break;
            }
            case "save": {
                args.setCancel(this.validateBankCardNumRepeat() || this.validateIsDelete());
                break;
            }
            case "saveupdatepaysetting": {
                option.setVariableValue("updatepaysetting", "true");
                this.getView().invokeOperation("save", option);
                break;
            }
            case "changeupdatepaysetting": {
                option.setVariableValue("updatepaysetting", "true");
                this.getView().invokeOperation("confirmchange", option);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String clkKey;
        super.itemClick(evt);
        switch (clkKey = evt.getItemKey()) {
            case "bar_save": {
                this.validateForbidden();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if ("save".equals(key) || "confirmchange".equals(key)) {
            OperateOption option = formOperate.getOption();
            String isUpdate = option.getVariableValue("updatepaysetting", "false");
            if (args.getOperationResult().isSuccess() && Boolean.parseBoolean(isUpdate)) {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
                returnData.put("isUpdate", Boolean.TRUE);
                returnData.put("person", dataEntity.getLong("person.id"));
                this.getView().returnDataToParent((Object)returnData);
            }
        }
    }

    private void validateForbidden() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object parententitynumber = formShowParameter.getCustomParam("parententitynumber");
        if (parententitynumber == null || !parententitynumber.equals("hsas_perbankcardadd")) {
            logger.info("not addnew from hsas_perbankcardadd");
            return;
        }
        boolean hasRight = formShowParameter.isHasRight();
        if (hasRight) {
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("hasRight", "true");
            logger.info("get addnew right for hsas_perbankcardadd by themselves when saving");
        } else {
            logger.info("can not get addnew right for hsas_perbankcardadd by others when saving");
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(hasRight));
        this.getView().invokeOperation("save", option);
    }

    private boolean validateIsDelete() {
        SWCDataServiceHelper perBankCardServiceHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        Long boId = this.getModel().getDataEntity().getLong("boid");
        QFilter idFilter = new QFilter("id", "=", (Object)boId);
        QFilter deleteFilter = new QFilter("isdelete", "=", (Object)"1");
        Boolean exists = perBankCardServiceHelper.isExists(new QFilter[]{idFilter, deleteFilter});
        if (exists.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u5361\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u53d8\u66f4\u3002", (String)"PerBankCardExtEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateBankCardNumRepeat() {
        boolean existSameCard;
        String bankCardNum = this.getModel().getDataEntity().getString("bankcardnum");
        if (SWCStringUtils.isEmpty((String)bankCardNum)) {
            return false;
        }
        SWCDataServiceHelper perBankCardServiceHelper = new SWCDataServiceHelper("hrpi_perbankcard");
        QFilter bankCardNumFilter = new QFilter("bankcardnum", "=", (Object)bankCardNum);
        QFilter isDeleteFilter = new QFilter("isdelete", "=", (Object)"0");
        QFilter personFilter = new QFilter("person", "=", (Object)this.getModel().getDataEntity().getLong("person.id"));
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
        if (null != isChange) {
            personFilter.and(new QFilter("id", "!=", this.getModel().getValue("boid")));
        }
        if (!(existSameCard = perBankCardServiceHelper.isExists(new QFilter[]{isCurrentVersionFilter, bankCardNumFilter, isDeleteFilter, personFilter}))) {
            return false;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u5df2\u5b58\u5728\u3002", (String)"PerBankCardExtEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        Object employeeIdObj = this.getView().getFormShowParameter().getCustomParam("employee");
        Object personIdObj = this.getView().getFormShowParameter().getCustomParam("personid");
        if (null != employeeIdObj && null != personIdObj) {
            this.getView().getModel().setValue("employee", (Object)Long.parseLong(String.valueOf(employeeIdObj)));
            this.getView().getModel().setValue("person", (Object)Long.parseLong(String.valueOf(personIdObj)));
        }
    }

    public void afterBindData(EventObject e) {
        Boolean isChange = (Boolean)this.getView().getFormShowParameter().getCustomParam("isChange");
        if (null == isChange) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"tblclosehis"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirmchange"});
        this.setButton();
    }

    private void setButton() {
        Container toolBar = (Container)this.getView().getControl("tbmain");
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("btn_close");
        Border border = new Border();
        border.setTop("1px_solid_#d9d9d9");
        border.setBottom("1px_solid_#d9d9d9");
        border.setLeft("1px_solid_#d9d9d9");
        border.setRight("1px_solid_#d9d9d9");
        Style style = new Style();
        style.setBorder(border);
        closeBtn.setStyle(style);
        closeBtn.setButtonStyle(1);
        closeBtn.setForeColor("#999999");
        closeBtn.setBackColor("#FFFFFF");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88", (String)"PerBankCardExtEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("bar_confirmchange1");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"PerBankCardExtEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("confirmchange");
        confirmChangeBtn.setCommitValidate(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean isUpdate = (Boolean)formShowParameter.getCustomParam("isUpdate");
        if (isUpdate == null || !isUpdate.booleanValue()) {
            toolBar.addControls(Arrays.asList(closeBtn.createControl(), confirmChangeBtn.createControl()));
            return;
        }
        BarItemAp confirmChangeUpdatePaySettingBtn = new BarItemAp();
        confirmChangeUpdatePaySettingBtn.setKey("bar_changeupdate");
        confirmChangeUpdatePaySettingBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4\u5e76\u66f4\u65b0\u53d1\u653e\u8bbe\u7f6e", (String)"PerBankCardExtEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        confirmChangeUpdatePaySettingBtn.setOperationKey("changeupdatepaysetting");
        confirmChangeUpdatePaySettingBtn.setCommitValidate(true);
        toolBar.addControls(Arrays.asList(closeBtn.createControl(), confirmChangeBtn.createControl(), confirmChangeUpdatePaySettingBtn.createControl()));
    }
}

