/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personhr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsas.formplugin.web.basedata.personhr.SyncPersonMultiThreadService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class SyncPersonDataList
extends SWCDataBaseList {
    private static final Log logger = LogFactory.getLog(SyncPersonDataList.class);
    private static final String BILL_FORM_ID = "hsas_employeelayout";
    private static final String BOS_LIST_F7 = "bos_listf7";
    private static final String WIDTH = "960px";
    private static final String HEIGHT = "580px";
    private static final String KEY_ADD_PERSON = "addpersoncall";
    private static final String KEY_AGAIN_SYNC = "againsynccall";
    private static final String KEY_SYNC_MONITOR = "syncmonitor";
    private static final String KEY_SYNC_ALLPERSON = "syncallperson";
    private static final String KEY_SYNC_PERSONNEW = "syncpersonnew";
    private static final String KEY_BTNVIEWSYNCMONITOR = "btn_viewsyncmonitor";
    private static final int SYNC_PERSON_NUM = 50;

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("empnumber".equals(fieldName)) {
            if (this.getView().getFormShowParameter().getFormId().contains("f7")) {
                return;
            }
            HyperLinkClickEvent linkClick = args.getHyperLinkClickEvent();
            BillList billList = (BillList)linkClick.getSource();
            ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
            if (selectedRow != null) {
                long empId = Long.parseLong(String.valueOf(selectedRow.getPrimaryKeyValue()));
                SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_employee");
                DynamicObject dynamicObject = empHelper.queryOne("id,person", new QFilter[]{new QFilter("id", "=", (Object)empId)});
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hsas_personhr_show");
                showParameter.setCustomParam("person", (Object)dynamicObject.getLong("person.id"));
                showParameter.setCustomParam("employee", (Object)dynamicObject.getLong("id"));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458 - %s", (String)"PersonListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), dynamicObject.getString("person.name")));
                this.getView().showForm(showParameter);
                args.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_syncdata": {
                this.showSyncPerson();
                break;
            }
            case "donothing_addperson": {
                this.showEmployeeLayoutPagelist(null);
                break;
            }
            case "donothing_syncmonitor": {
                this.showNewPagelist("hsas_syncpersonmonitor");
                break;
            }
            case "donothing_syncpersonnew": {
                this.showSyncPersonNew();
                break;
            }
        }
    }

    private void showSyncPerson() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.confirmAllPersonTip();
        } else {
            String monitorNumber = SyncPersonHelper.newRuleNumber();
            this.confirmMonitorTip(monitorNumber);
            this.updatePersonBySelect(selectedRows, monitorNumber);
        }
    }

    private void showSyncPersonNew() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_syncempcondition");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_SYNC_PERSONNEW));
        showParameter.setHasRight(true);
        this.getView().showForm(showParameter);
    }

    private void showEmployeeLayoutPagelist(List<QFilter> qfilters) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("bos_list");
        StyleCss css = new StyleCss();
        css.setWidth("1260px");
        css.setHeight("554px");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        formShowParameter.setShowTitle(true);
        formShowParameter.setHasRight(true);
        formShowParameter.setBillFormId(BILL_FORM_ID);
        formShowParameter.setLookUp(false);
        formShowParameter.setMultiSelect(true);
        if (CollectionUtils.isNotEmpty(qfilters)) {
            formShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
        formShowParameter.getListFilterParameter().setOrderBy("modifytime desc");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ADD_PERSON));
        this.getView().showForm((FormShowParameter)formShowParameter);
        ISWCAppCache appCache = SWCAppCache.get((String)"SyncPersonDataList_AppCache");
        appCache.put("employeeLayout_pageId_" + this.getView().getPageId(), (Object)formShowParameter.getPageId());
    }

    private void confirmMonitorTip(String batchNumber) {
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u4eba\u5458\uff08\u6279\u6b21\u53f7\u4e3a:{0}\uff09\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u540c\u6b65\u8fdb\u5ea6\u3002", (String)"SyncPersonDataList_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{batchNumber});
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setFormId("hsas_personmonitortips");
        parameter.setCustomParam("title", (Object)msg);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BTNVIEWSYNCMONITOR));
        this.getView().showForm(parameter);
    }

    private void confirmAllPersonTip() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_SYNC_ALLPERSON);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u60a8\u672a\u9009\u4e2d\u5217\u8868\u6570\u636e\uff0c\u786e\u5b9a\u540c\u6b65\u5c06\u540c\u6b65\u6240\u6709\u4eba\u5458\u4e14\u8017\u65f6\u8f83\u4e45\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SyncPersonDataList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, options, confirmCallBacks);
    }

    private void returnOperateResult() {
        this.getView().updateView();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"HSASCalTableList_27", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
    }

    private void showNewPagelist(String entityId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(entityId);
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void updatePersonBySelect(ListSelectedRowCollection selectedRows, String monitorNumber) {
        Object[] keyLists = selectedRows.getPrimaryKeyValues();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_employee");
        this.dealSelectEmployeeById(keyLists, helper, 2, monitorNumber);
    }

    private void syncAllPersons(String monitorNumber, List<QFilter> qfilters) {
        logger.info("SyncPersonDataList.syncAllPersons...begin...{}", (Object)monitorNumber);
        SWCUnifiedThreadPoolFactory.SERVICE.execute(() -> {
            int totalRows;
            ArrayList qfilterTotal = new ArrayList(10);
            if (qfilters != null) {
                qfilterTotal.addAll(qfilters);
            }
            if ((totalRows = SyncPersonHelper.queryTotalRows(qfilterTotal)) == 0) {
                totalRows = -1;
            }
            SyncPersonHelper.getInstance().saveMonitorDy(totalRows, null, monitorNumber, "1");
            int pageIndex = 0;
            int pagesize = 100000;
            Long maxId = 0L;
            List<Map<Long, Long>> empIds = null;
            while (totalRows >= 1) {
                CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)true);
                logger.info("SyncPersonDataList.syncAllPersons...begin...{}..{}..{}", new Object[]{monitorNumber, pageIndex, pagesize});
                ArrayList<QFilter> qfilterALL = new ArrayList<QFilter>(10);
                if (qfilters != null) {
                    qfilterALL.addAll(qfilters);
                }
                QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
                QFilter idFilter = new QFilter("id", ">", (Object)maxId);
                qfilterALL.add(currFilter);
                qfilterALL.add(idFilter);
                Object[] empDys = BusinessDataServiceHelper.load((String)"hrpi_employee", (String)"id,person", (QFilter[])qfilterALL.toArray(new QFilter[0]), (String)"id", (int)pagesize);
                logger.info("SyncPersonDataList.syncAllPersons...query end...{}..{}..{}", new Object[]{monitorNumber, pageIndex, pagesize});
                if (ArrayUtils.isEmpty((Object[])empDys)) {
                    SyncPersonHelper.getInstance().saveMonitorDy(0, null, monitorNumber, "0");
                    break;
                }
                maxId = empDys[empDys.length - 1].getLong("id");
                empIds = this.getIdMap((DynamicObject[])empDys);
                try {
                    SyncPersonMultiThreadService service = new SyncPersonMultiThreadService(monitorNumber);
                    service.syncData(2, empIds, monitorNumber);
                }
                catch (Exception exception) {
                    logger.error("SyncPersonDataList.syncAllPersons...error...{}..{}..{}", new Object[]{monitorNumber, pageIndex, pagesize});
                    logger.error((Throwable)exception);
                }
                finally {
                    CachedLoadReferenceObjectManager.disableRefBasedataCache((boolean)false);
                }
                logger.info("SyncPersonDataList.syncAllPersons...end...{}..{}..{}", new Object[]{monitorNumber, ++pageIndex, pagesize});
            }
        }, SWCUnifiedTaskTypeEnum.SWC_COMMONASYNCTHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
    }

    private void batchSyncPerson(List<Map<Long, Long>> empIds, int way, String monitorNumber, boolean isSyncSplitBatch) {
        ConcurrentHashMap<String, Integer> countMap = new ConcurrentHashMap<String, Integer>();
        countMap.put("failcount", 0);
        countMap.put("succcount", 0);
        SyncPersonHelper.getInstance().saveMonitorDy(empIds.size(), countMap, monitorNumber, empIds.size() == 0 ? "0" : "1");
        SWCUnifiedThreadPoolFactory.SERVICE.execute(() -> {
            logger.error("SyncPersonDataList.batchSyncPerson...begin...{}..", (Object)monitorNumber);
            try {
                SyncPersonMultiThreadService service = new SyncPersonMultiThreadService(monitorNumber);
                service.syncData(way, empIds, monitorNumber);
                SyncPersonHelper.getInstance().saveMonitorDy(0, null, monitorNumber, "0");
            }
            catch (Exception exception) {
                logger.error("SyncPersonDataList.batchSyncPerson...error...{}..", (Object)monitorNumber);
                logger.error((Throwable)exception);
            }
            logger.error("SyncPersonDataList.batchSyncPerson...end...{}..", (Object)monitorNumber);
        }, SWCUnifiedTaskTypeEnum.SWC_COMMONASYNCTHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
    }

    private void confirmMonitorDataTip(int totalCount, Map<String, Object> countMap) {
        String msg = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u4eba\u5458\u6570\u636e\uff0c\u540c\u6b65\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\uff0c\u5177\u4f53\u8bf7\u67e5\u770b\u540c\u6b65\u8fdb\u5ea6\u3002", (String)"SyncPersonDataList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalCount, Long.parseLong(String.valueOf(countMap.get("succcount"))), Long.parseLong(String.valueOf(countMap.get("failcount"))));
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setFormId("hsas_personmonitortips");
        parameter.setCustomParam("title", (Object)msg);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BTNVIEWSYNCMONITOR));
        this.getView().showForm(parameter);
    }

    private void dealSelectEmployeeById(Object[] keyLists, SWCDataServiceHelper helper, int way, String monitorNumber) {
        QFilter qFilter = new QFilter("id", "in", (Object)keyLists);
        if ("hsas_employee".equals(helper.getEntityName())) {
            qFilter.and("datasource", "=", (Object)Character.valueOf('C'));
        }
        DynamicObject[] dys = helper.query("id,person", new QFilter[]{qFilter});
        List<Map<Long, Long>> empIds = this.getIdMap(dys);
        ConcurrentHashMap<String, Object> countMap = new ConcurrentHashMap<String, Integer>();
        countMap.put("failcount", 0);
        countMap.put("succcount", 0);
        if (empIds.size() <= 50) {
            SyncPersonHelper.getInstance().saveMonitorDy(empIds.size(), countMap, monitorNumber, empIds.size() == 0 ? "0" : "1");
            countMap = SyncPersonHelper.getInstance().loopSyncData(way, empIds, monitorNumber, "0");
            this.confirmMonitorDataTip(empIds.size(), countMap);
        } else {
            this.batchSyncPerson(empIds, way, monitorNumber, false);
        }
    }

    private List<Map<Long, Long>> getIdMap(DynamicObject[] dys) {
        ArrayList<Map<Long, Long>> empIds = new ArrayList<Map<Long, Long>>(16);
        if (dys == null) {
            return empIds;
        }
        for (DynamicObject dy : dys) {
            HashMap<Long, Long> data = new HashMap<Long, Long>(1);
            data.put(dy.getLong("id"), dy.getLong("person.id"));
            empIds.add(data);
        }
        return empIds;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        String actId = e.getActionId();
        if (returnData == null) {
            return;
        }
        if (KEY_ADD_PERSON.equals(actId)) {
            this.dealAddPersonClosedCallBack((Map)returnData);
        } else if (KEY_BTNVIEWSYNCMONITOR.equals(actId)) {
            this.showNewPagelist("hsas_syncpersonmonitor");
        } else if (KEY_SYNC_PERSONNEW.equals(actId)) {
            this.dealPersonNewClosedCallBack((Map)returnData);
        }
    }

    private void dealAddPersonClosedCallBack(Map<String, Object> returnData) {
        Map<String, Object> returnDataMap = returnData;
        if (returnDataMap == null) {
            return;
        }
        List empIdList = (List)returnDataMap.get("empIdList");
        ArrayList<QFilter> qfilters = new ArrayList(10);
        if (CollectionUtils.isNotEmpty((Collection)empIdList)) {
            QFilter qfilter = new QFilter("id", "in", (Object)empIdList);
            qfilters.add(qfilter);
            String monitorNumber = SyncPersonHelper.newRuleNumber();
            if (empIdList.size() > 50) {
                this.confirmMonitorTip(monitorNumber);
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_employee");
            this.dealSelectEmployeeById(empIdList.toArray(), helper, 1, monitorNumber);
        } else {
            qfilters = (List)returnData.get("qFilters");
            this.syncAllPersonsWithTip(qfilters);
        }
    }

    private void dealPersonNewClosedCallBack(Map<String, Object> returnData) {
        Map<String, Object> returnDataMap = returnData;
        if (!returnDataMap.containsKey("type")) {
            return;
        }
        String type = (String)returnDataMap.get("type");
        if ("syncdata".equals(type)) {
            List qfilters = SyncPersonHelper.getReturnDataQFilters(returnDataMap);
            int dataCount = (Integer)returnDataMap.getOrDefault("dataCount", 0);
            if (dataCount <= 50) {
                QFilter currFilter = BaseDataHisHelper.getHisCurrFilter();
                qfilters.add(currFilter);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_employee");
                DynamicObject[] empIdArr = helper.query("id", qfilters.toArray(new QFilter[0]));
                List empIdList = Arrays.stream(empIdArr).map(oldDy -> oldDy.getLong("id")).collect(Collectors.toList());
                String monitorNumber = SyncPersonHelper.newRuleNumber();
                this.dealSelectEmployeeById(empIdList.toArray(), helper, 1, monitorNumber);
            } else {
                this.syncAllPersonsWithTip(qfilters);
            }
        } else if ("query".equals(type)) {
            List qfilters = SyncPersonHelper.getReturnDataQFilters(returnDataMap);
            this.showEmployeeLayoutPagelist(qfilters);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (KEY_AGAIN_SYNC.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Object[] keyLists = selectedRows.getPrimaryKeyValues();
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_syncpersonhrlog");
                SWCDataServiceHelper empHelper = new SWCDataServiceHelper("hsas_employee");
                DynamicObject[] syncpersonhrlogDys = helper.query("id,employee,syncstatus,syncdate", new QFilter[]{new QFilter("id", "in", (Object)keyLists), new QFilter("syncstatus", "!=", (Object)"S")});
                List empList = Arrays.stream(syncpersonhrlogDys).map(dy -> dy.getLong("employee")).collect(Collectors.toList());
                DynamicObject[] empDys = empHelper.query("id,person", new QFilter[]{new QFilter("id", "in", empList)});
                List<Map<Long, Long>> empIds = this.getIdMap(empDys);
                String monitorNumber = SyncPersonHelper.newRuleNumber();
                this.batchSyncPerson(empIds, 3, monitorNumber, false);
            }
        } else if (KEY_SYNC_ALLPERSON.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.syncAllPersonsWithTip(null);
            }
        } else if (KEY_SYNC_MONITOR.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.showNewPagelist("hsas_syncpersonmonitor");
        }
    }

    private void syncAllPersonsWithTip(List<QFilter> qfilters) {
        String monitorNumber = SyncPersonHelper.newRuleNumber();
        this.confirmMonitorTip(monitorNumber);
        this.syncAllPersons(monitorNumber, qfilters);
    }
}

