/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.personrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.payrollscene.helper.SWCPayRollSceneHelper;
import kd.swc.hsas.business.payrolltask.helper.PayRollTaskHelper;
import kd.swc.hsas.business.payrolltask.service.PayRollTaskService;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCEntryEntityCopyUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskVO;
import kd.swc.hsbp.common.vo.SceneGroupVO;
import kd.swc.hsbp.common.vo.SceneRuleVO;

public class CalPreviewPersonCfgPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
EntryGridBindDataListener,
EntryGridSetRowDataListener {
    private static final String DONOTHING_CONFIRM = "donothing_confirm";
    private static final String KEY_PERIOD = "period";
    private static final String ADD_SALARY_CAL_STYLE = "add_salary_cal_cstyle";

    public void registerListener(EventObject e) {
        BasedataEdit control = (BasedataEdit)this.getView().getControl("payrollgroup");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scene = (BasedataEdit)this.getView().getControl("payrollscene");
        scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizData = (BasedataEdit)this.getView().getControl("calbordermulbd");
        bizData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        entryGrid.addSetRowDataListener((EntryGridSetRowDataListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (SWCStringUtils.equals((String)DONOTHING_CONFIRM, (String)operateKey)) {
            DynamicObjectCollection entryColl = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (entryColl == null || entryColl.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e38\u7528\u7b5b\u9009\u5fc5\u586b\uff0c\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6570\u636e\u3002", (String)"CalPreviewPersonCfgPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < entryColl.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryColl.get(i);
                if (!"1".equals(entry.getString("attachcondition")) || !SWCListUtils.isEmpty((List)entry.getDynamicObjectCollection("calbordermulbd"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e38\u7528\u7b5b\u9009\u7b2c{0}\u884c\u4e1a\u52a1\u9879\u76ee\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CalPreviewPersonCfgPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{String.valueOf(i + 1)}));
                return;
            }
            this.openPreRunPage();
        } else if (SWCStringUtils.equals((String)ADD_SALARY_CAL_STYLE, (String)operateKey)) {
            this.openSalaryCalStyleBaseView();
        }
    }

    private void openSalaryCalStyleBaseView() {
        int currRowIndex = ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).getEntryState("entryentity").getFocusRow();
        this.getModel().setEntryCurrentRowIndex("entryentity", currRowIndex);
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_salarycalcstyle", (boolean)true);
        showParameter.setFormId("hsbp_allowreturnnullf7");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_salarycalcstyle"));
        QFilter filter = new QFilter("salarycalstyle", "=", (Object)"1");
        showParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(filter.toArray()), null));
        Object[] selectedSalaryCalStyleIdArr = this.getSelectedSalaryCalStyleIdArr();
        if (!SWCArrayUtils.isEmpty((Object[])selectedSalaryCalStyleIdArr)) {
            showParameter.setSelectedRows(selectedSalaryCalStyleIdArr);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Object[] getSelectedSalaryCalStyleIdArr() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return null;
        }
        List salaryCalStyleList = entryEntity.stream().map(dyObj -> dyObj.getLong("salarycalcstyle.id")).collect(Collectors.toList());
        QFilter filter = new QFilter("salarycalstyle", "=", (Object)"1");
        filter.and("id", "in", salaryCalStyleList);
        return SWCPayRollSceneHelper.getValidCalSalaryStyleIdArr((QFilter)filter);
    }

    public void afterBindData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PERIOD, "payrollscene"});
    }

    private void openPreRunPage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        CalPayRollTaskVO taskVO = new CalPayRollTaskVO();
        taskVO.setEnddate(dataEntity.getDate("period.enddate"));
        taskVO.setStartdate(dataEntity.getDate("period.startdate"));
        taskVO.setPeriodId(Long.valueOf(dataEntity.getLong("period.id")));
        taskVO.setPayrollgroupId(Long.valueOf(dataEntity.getLong("payrollgroup.id")));
        taskVO.setPayrollsceneId(Long.valueOf(dataEntity.getLong("payrollscene.id")));
        taskVO.setPayrollsceneVid(Long.valueOf(dataEntity.getLong("payrollscene.sourcevid")));
        taskVO.setExratedate(dataEntity.getDate("period.ratedate"));
        taskVO.setPaydate(dataEntity.getDate("period.paydate"));
        taskVO.setCountryId(Long.valueOf(dataEntity.getLong("payrollscene.country.id")));
        taskVO.setTrackerId(Long.valueOf(RequestContext.get().getCurrUserId()));
        taskVO.setPre(true);
        taskVO.setPeriodTypeId(Long.valueOf(dataEntity.getLong("payrollscene.periodtype.id")));
        Date payRollDate = dataEntity.getDate("period.perioddate");
        int month = SWCDateTimeUtils.getMonth((Date)payRollDate);
        taskVO.setPayrollmonth(month);
        taskVO.setPayrollyear(SWCDateTimeUtils.getYear((Date)dataEntity.getDate("period.periodyear")));
        taskVO.setRuleContent((String)this.getView().getFormShowParameter().getCustomParam("rulecontent"));
        List<SceneGroupVO> groups = this.getGroups();
        taskVO.setGroups(groups);
        List couldAddPersonList = CalPersonHelper.getCouldAddPersonList((CalPayRollTaskVO)taskVO);
        ListShowParameter form = ShowFormHelper.createShowListForm((String)"hsas_calpersonprerunnew", (boolean)true);
        form.setFormId("hsas_previewpersonlist");
        List qFilters = form.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", (Object)couldAddPersonList));
        form.setCustomParam("option", (Object)"showhisversion");
        this.getView().showForm((FormShowParameter)form);
    }

    private List<SceneGroupVO> getGroups() {
        ArrayList<SceneGroupVO> groups = new ArrayList<SceneGroupVO>(10);
        DynamicObjectCollection entryColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        SceneGroupVO group = new SceneGroupVO();
        group.setIndex(1);
        group.setName(new LocaleString("default"));
        ArrayList<SceneRuleVO> rules = new ArrayList<SceneRuleVO>(10);
        if (entryColl != null) {
            for (DynamicObject entry : entryColl) {
                SceneRuleVO rule = new SceneRuleVO();
                rule.setAttachcondition(entry.getString("attachcondition"));
                rule.setCalcstyle(Long.valueOf(entry.getLong("salarycalcstyle.id")));
                DynamicObjectCollection mulbizItems = entry.getDynamicObjectCollection("calbordermulbd");
                if (mulbizItems != null) {
                    List bizItems = mulbizItems.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                    rule.setBizItems(bizItems);
                }
                rules.add(rule);
            }
        }
        group.setRules(rules);
        groups.add(group);
        return groups;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "hsas_payrollgrpschis": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (SWCObjectUtils.isEmpty((Object)returnData)) {
                    return;
                }
                Long primaryKeyValue = (Long)returnData.get(0).getPrimaryKeyValue();
                Map resultMap = PayRollTaskHelper.querySceneAndGroupDetailInfoMap((Long)primaryKeyValue);
                if (resultMap == null) break;
                this.getModel().setValue("payrollscene", resultMap.get("payrollscene"));
                PayRollTaskService.createInstance().checkPeriodTypeInfoAndSetFilterForPeriod((AbstractFormPlugin)this, (Long)resultMap.get("periodtype"));
                break;
            }
            case "hsas_salarycalcstyle": {
                this.updateEntryEntity(closedCallBackEvent.getReturnData());
                break;
            }
        }
    }

    private void updateEntryEntity(Object returnData) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        if (returnData == null) {
            return;
        }
        List newSalaryCalStyleIdList = listSelectedRowCollection.stream().map(pkId -> (Long)pkId.getPrimaryKeyValue()).collect(Collectors.toList());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Iterator iterator = entryEntity.iterator();
        while (iterator.hasNext()) {
            DynamicObject entryDyObj = (DynamicObject)iterator.next();
            long oldSalaryCalStyleId = entryDyObj.getLong("salarycalcstyle.id");
            if (!newSalaryCalStyleIdList.contains(oldSalaryCalStyleId)) {
                iterator.remove();
                continue;
            }
            newSalaryCalStyleIdList.remove(oldSalaryCalStyleId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int index = 0;
        for (DynamicObject lastDyObj : entryEntity) {
            vs.set("salarycalcstyle", (Object)lastDyObj.getLong("salarycalcstyle.id"), index);
            String attachCondition = lastDyObj.getString("attachcondition");
            vs.set("attachcondition", (Object)lastDyObj.getString("attachcondition"), index);
            vs.set("calbordermulbd", (Object)lastDyObj.getDynamicObjectCollection("calbordermulbd"), index);
            ++index;
        }
        for (Long newSalaryCalStyleId : newSalaryCalStyleIdList) {
            vs.set("salarycalcstyle", (Object)newSalaryCalStyleId, index);
            vs.set("attachcondition", (Object)"0", index);
            ++index;
        }
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        this.lockBizDataCellIfNeeded(null);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void entryGridSetRowData(EntryGridSetRowDataEvent event) {
        Map columnMap = event.getValues();
        if (columnMap == null || columnMap.isEmpty()) {
            return;
        }
        columnMap.remove("salarycalcstyle");
        Map customColumnMap = SWCEntryEntityCopyUtils.getRowColumnVal((Map)columnMap);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getModel().beginInit();
        for (Map.Entry customColumnEntry : customColumnMap.entrySet()) {
            Boolean hasBizData;
            String attachConditionVal;
            if (customColumnEntry.getKey() == null || (Integer)customColumnEntry.getKey() > entryEntity.size()) continue;
            Integer index = (Integer)customColumnEntry.getKey();
            DynamicObject entity = (DynamicObject)entryEntity.get(index.intValue());
            Map cellsInCurrRow = (Map)customColumnEntry.getValue();
            Object attachCond = cellsInCurrRow.get("attachcondition");
            if (!(attachCond instanceof String) || (attachConditionVal = ((String)attachCond).trim()).length() == 0) {
                attachConditionVal = entity.getString("attachcondition");
            }
            String string = attachConditionVal = (hasBizData = Boolean.valueOf("1".equals(attachConditionVal))) != false ? "1" : "0";
            if (!hasBizData.booleanValue()) {
                this.getModel().setValue("calbordermulbd", null);
                List bizDataTuples = (List)columnMap.get("calbordermulbd");
                if (bizDataTuples != null && !bizDataTuples.isEmpty()) {
                    bizDataTuples.removeIf(bizDataTuple -> index.equals(bizDataTuple.item1));
                }
            }
            this.getModel().setValue("attachcondition", (Object)attachConditionVal, index.intValue());
            this.getView().setEnable(hasBizData, index.intValue(), new String[]{"calbordermulbd"});
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.lockBizDataCellIfNeeded(null);
        columnMap.remove("attachcondition");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey;
        switch (fieldKey = beforeF7SelectEvent.getProperty().getName()) {
            case "payrollgroup": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"/UHMBBGZQ65X", (String)"hsas_payrollgrp", (String)"47150e89000000ac");
                if (permOrgs.hasAllOrgPerm()) break;
                QFilter qFilter = new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs());
                beforeF7SelectEvent.addCustomQFilter(qFilter);
                break;
            }
            case "payrollscene": {
                long payRollGrpId;
                beforeF7SelectEvent.setCancel(true);
                DynamicObject payRollGrpDyObj = (DynamicObject)this.getModel().getValue("payrollgroup");
                if (payRollGrpDyObj == null || (payRollGrpId = payRollGrpDyObj.getLong("id")) == 0L) break;
                ListShowParameter showParameter = PayRollTaskService.createInstance().getPayRollGroupEntityInfoShowParameter(payRollGrpId, SWCDateTimeUtils.getDateWithoutMinTs((Date)new Date()));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_payrollgrpschis"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "calbordermulbd": {
                QFilter filter = new QFilter("islistgenerate", "=", (Object)"1");
                filter.and("cycle", "=", (Object)"0");
                beforeF7SelectEvent.addCustomQFilter(filter);
                break;
            }
        }
    }

    private void lockBizDataCellIfNeeded(int[] needLockRows) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (SWCListUtils.isEmpty((List)entryEntity)) {
            return;
        }
        for (DynamicObject entry : entryEntity) {
            int seq = entry.getInt("seq") - 1;
            Boolean enable = "1".equals(entry.getString("attachcondition"));
            this.getView().setEnable(enable, seq, new String[]{"calbordermulbd"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent event) {
        this.lockBizDataCellIfNeeded(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "payrollscene": {
                this.refreshEntryEntity();
                this.getModel().setValue(KEY_PERIOD, null);
                this.getView().setEnable(Boolean.valueOf(null != changeData.getNewValue()), new String[]{KEY_PERIOD});
                break;
            }
            case "payrollgroup": {
                this.getModel().setValue(KEY_PERIOD, null);
                this.getModel().setValue("payrollscene", null);
                this.getView().setEnable(Boolean.valueOf(null != changeData.getNewValue()), new String[]{"payrollscene"});
                break;
            }
            case "attachcondition": {
                this.lockBizDataCellIfNeeded(null);
                DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", changeData.getRowIndex());
                this.clearBizDataIfLocked(dynamicObject);
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private void clearBizDataIfLocked(DynamicObject currDyObj) {
        if (currDyObj == null) {
            return;
        }
        currDyObj.set("calbordermulbd", null);
    }

    private void refreshEntryEntity() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject scene = model.getDataEntity().getDynamicObject("payrollscene");
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (scene != null) {
            SceneRuleVO rule;
            int i;
            String groupcontent = scene.getString("groupcontent");
            List groups = (List)JSON.parseObject((String)groupcontent, (TypeReference)new TypeReference<List<SceneGroupVO>>(){}, (Feature[])new Feature[0]);
            TableValueSetter tvs = new TableValueSetter(new String[0]);
            if (SWCListUtils.isEmpty((List)groups)) {
                this.getView().showErrorNotification("error data");
                return;
            }
            List rules = ((SceneGroupVO)groups.get(0)).getRules();
            for (i = 0; i < rules.size(); ++i) {
                rule = (SceneRuleVO)rules.get(i);
                tvs.set("salarycalcstyle", (Object)rule.getCalcstyle(), i);
                tvs.set("attachcondition", (Object)rule.getAttachcondition(), i);
            }
            model.batchCreateNewEntryRow("entryentity", tvs);
            for (i = 0; i < rules.size(); ++i) {
                rule = (SceneRuleVO)rules.get(i);
                this.getModel().setValue("calbordermulbd", (Object)rule.getBizItems().toArray(), i);
            }
        }
        model.endInit();
        this.getView().updateView("entryentity");
        this.lockBizDataCellIfNeeded(null);
    }
}

