/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.prorationevent;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IBaseDataService;
import kd.swc.hsas.business.prorationevent.ProrationEventUtils;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class ProrationEventEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    private static final String FIELD_SALARYFILE = "salaryfile";
    private static final String FIELD_PRORATIONGENRULE = "prorationgenrule";
    private static final String FIELD_CHANGEREASON = "changereason";
    private static final String FIELD_PRORATIONDATE = "prorationdate";
    private static final String FIELD_PRORATIONTYPE = "prorationtype";
    private static final String FIELD_SALARYITEM = "salaryitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit genRuleEdit = (BasedataEdit)this.getControl(FIELD_PRORATIONGENRULE);
        genRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit changeReasonEdit = (BasedataEdit)this.getControl(FIELD_CHANGEREASON);
        changeReasonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryFileEdit = (BasedataEdit)this.getControl(FIELD_SALARYFILE);
        salaryFileEdit.addBeforeF7ViewDetailListener((Consumer)this);
        salaryFileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject event) {
        DynamicObject data = this.getModel().getDataEntity();
        if ("2".equals(data.getString("source")) || "2".equals(data.getString("referencestatus")) || "2".equals(data.getString("eventstatus"))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            RefObject afterConfirm = new RefObject();
            boolean isOpen = false;
            if (!operate.getOption().tryGetVariableValue("save", afterConfirm)) {
                isOpen = this.openConfirmPage(args);
            }
            if (!isOpen) {
                operate.getOption().setVariableValue("save", Boolean.TRUE.toString());
            }
        }
    }

    private boolean openConfirmPage(BeforeDoOperationEventArgs args) {
        Map eventMap;
        DynamicObject data = this.getModel().getDataEntity();
        long salaryFileId = data.getLong("salaryfile.id");
        Date prorationDate = data.getDate(FIELD_PRORATIONDATE);
        String type = data.getString(FIELD_PRORATIONTYPE);
        long changeReasonId = data.getLong("changereason.id");
        long id = data.getLong("id");
        if (salaryFileId == 0L || prorationDate == null || SWCStringUtils.isEmpty((String)type) || changeReasonId == 0L) {
            return false;
        }
        QFilter filter = new QFilter("salaryfile.id", "=", (Object)salaryFileId);
        filter.and(FIELD_PRORATIONDATE, "=", (Object)prorationDate);
        filter.and("changereason.id", "=", (Object)changeReasonId);
        filter.and(FIELD_PRORATIONTYPE, "=", (Object)type);
        filter.and("eventstatus", "=", (Object)"1");
        if (id != 0L) {
            filter.and("id", "!=", (Object)id);
        }
        if ((eventMap = ProrationEventUtils.getProrationEventMap((QFilter)filter)).size() == 0) {
            return false;
        }
        String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u201c\u6863\u6848\u201d\u3001\u201c\u5206\u6bb5\u65e5\u671f\u201d\u3001\u201c\u53d8\u52a8\u539f\u56e0\u201d\u3001\u201c\u5206\u6bb5\u7c7b\u578b\u201d\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58?", (String)"ProrationEventEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("save");
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, options, confirmCallBacks);
        args.setCancel(true);
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("save".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("save", Boolean.TRUE.toString());
            this.getView().invokeOperation("save", operateOption);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        switch (fieldKey) {
            case "salaryfile": {
                this.setFieldValueForSalaryFile();
                break;
            }
            case "prorationgenrule": {
                this.setFieldValueForGenRule();
                break;
            }
            case "changereason": {
                this.setFieldValueForChangeReason(changeData);
                break;
            }
        }
    }

    private void setFieldValueForChangeReason(ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        DynamicObject data = this.getModel().getDataEntity();
        long genRuleId = data.getLong("prorationgenrule.id");
        long changeReasonId = data.getLong("changereason.id");
        DynamicObjectCollection entryData = this.getProrationGenRuleEntryData(genRuleId);
        Map<Long, DynamicObject> entryMap = entryData.stream().collect(Collectors.toMap(obj -> obj.getLong("changereason.id"), obj -> obj));
        DynamicObject entry = entryMap.get(changeReasonId);
        this.getModel().setValue(FIELD_PRORATIONTYPE, (Object)entry.getString(FIELD_PRORATIONTYPE));
        this.getModel().setValue(FIELD_SALARYITEM, (Object)entry.getDynamicObjectCollection("prorationitem"));
    }

    private void setFieldValueForGenRule() {
        this.getModel().setValue(FIELD_CHANGEREASON, null);
        this.getModel().setValue(FIELD_PRORATIONTYPE, null);
        this.getModel().setValue(FIELD_SALARYITEM, null);
    }

    private void setFieldValueForSalaryFile() {
        this.getModel().setValue(FIELD_PRORATIONGENRULE, null);
        this.getModel().setValue(FIELD_CHANGEREASON, null);
        this.getModel().setValue(FIELD_PRORATIONTYPE, null);
        this.getModel().setValue(FIELD_SALARYITEM, null);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "salaryfile": {
                this.addSalaryFileFilter(event);
                break;
            }
            case "prorationgenrule": {
                this.addGenRuleFilter(event);
                break;
            }
            case "changereason": {
                this.addChangeReasonFilter(event);
                break;
            }
        }
    }

    private void addSalaryFileFilter(BeforeF7SelectEvent event) {
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_prorationevent", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    private void addChangeReasonFilter(BeforeF7SelectEvent event) {
        DynamicObject data = this.getModel().getDataEntity();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        DynamicObject prorationGenRule = data.getDynamicObject(FIELD_PRORATIONGENRULE);
        if (prorationGenRule == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\uff0c\u518d\u9009\u62e9\u53d8\u52a8\u539f\u56e0\u3002", (String)"ProrationEventEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        DynamicObjectCollection genRuleEntryData = this.getProrationGenRuleEntryData(prorationGenRule.getLong("id"));
        Set changeReasonIdSet = genRuleEntryData.stream().map(obj -> obj.getLong("changereason.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", changeReasonIdSet);
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private DynamicObjectCollection getProrationGenRuleEntryData(long genRuleId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationgenrule");
        DynamicObject genRule = helper.queryOne((Object)genRuleId);
        return genRule.getDynamicObjectCollection("entryentity");
    }

    private void addGenRuleFilter(BeforeF7SelectEvent event) {
        DynamicObject data = this.getModel().getDataEntity();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        DynamicObject salaryFile = data.getDynamicObject(FIELD_SALARYFILE);
        if (salaryFile == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u85aa\u8d44\u6863\u6848\uff0c\u7136\u540e\u9009\u62e9\u5206\u6bb5\u4e8b\u4ef6\u751f\u6210\u89c4\u5219\u3002", (String)"ProrationEventEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("country", "=", (Object)salaryFile.getLong("payrollregion.id"));
        IBaseDataService baseDataService = (IBaseDataService)this.getModel().getService(IBaseDataService.class);
        QFilter qFilter = baseDataService.getBaseDataFilter("hsas_prorationgenrule", Long.valueOf(salaryFile.getLong("org.id")));
        qFilters.add(filter);
        qFilters.add(qFilter);
        showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent event) {
        BasedataEdit base = (BasedataEdit)event.getSource();
        String key = base.getFieldKey();
        if (FIELD_SALARYFILE.equals(key)) {
            event.setCancel(true);
            SWCSalaryFileServiceHelper.assembleSalaryFileDataAndOpenFormView((Long)((Long)event.getPkId()), (IFormView)this.getView(), (String)"true");
        }
    }
}

