/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.basedata.prorationevent;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class ProrationEventList
extends SWCDataBaseList {
    private static final String DONOTHING_ABANDON = "donothing_abandon";

    public void setFilter(SetFilterEvent evt) {
        String orderBy = evt.getOrderBy();
        String eventOrderBy = "prorationdate desc,salaryfile.employee.empnumber asc,salaryfile.number asc";
        if (SWCStringUtils.isNotEmpty((String)orderBy)) {
            eventOrderBy = eventOrderBy + "," + orderBy;
        }
        evt.setOrderBy(eventOrderBy);
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_prorationevent", (String)"47150e89000000ac");
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            evt.getQFilters().add(new QFilter("salaryfile.org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "salaryfile.payrollgroup.name": {
                HasPermOrgResult permOrgs = this.getOrgPerm();
                if (permOrgs == null || permOrgs.hasAllOrgPerm()) break;
                filters.add(new QFilter("org.id", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        HasPermOrgResult hasPermOrgResult = null;
        switch (fieldName) {
            case "salaryfile.number": {
                hasPermOrgResult = this.getOrgPerm();
                if (hasPermOrgResult == null || hasPermOrgResult.hasAllOrgPerm()) break;
                filters.add(new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
                break;
            }
            case "prorationgenrule.name": {
                QFilter baseDataFilter;
                hasPermOrgResult = this.getOrgPerm();
                if (hasPermOrgResult == null || hasPermOrgResult.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsas_prorationgenrule", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
            case "salaryitem.fbasedataid.name": {
                QFilter baseDataFilter;
                hasPermOrgResult = this.getOrgPerm();
                if (hasPermOrgResult == null || hasPermOrgResult.hasAllOrgPerm() || (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (List)hasPermOrgResult.getHasPermOrgs(), (boolean)true)) == null) break;
                filters.add(baseDataFilter);
                break;
            }
        }
    }

    private HasPermOrgResult getOrgPerm() {
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_prorationevent", (String)"47150e89000000ac");
        return hasPermOrgResult;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if ("modify".equals(operationKey)) {
            this.checkIsCanModify(evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "donothing_abandon": {
                this.openConfirmPage(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "donothing_abandon": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void openConfirmPage(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(DONOTHING_ABANDON, afterConfirm)) {
            String msg = ResManager.loadKDString((String)"\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u5e9f\u5f03\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u5df2\u5f15\u7528\u5206\u6bb5\u4e8b\u4ef6\u7684\u6838\u7b97\u4efb\u52a1\u4e0d\u53d7\u5f71\u54cd\uff0c\u786e\u5b9a\u8981\u5e9f\u5f03\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"ProrationEventList_3", (String)"swc-hsas-formplugin", (Object[])new Object[]{args.getListSelectedData().size()});
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DONOTHING_ABANDON);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, options, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (DONOTHING_ABANDON.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(DONOTHING_ABANDON, "true");
            this.getView().invokeOperation(DONOTHING_ABANDON, operateOption);
        }
    }

    private void checkIsCanModify(BeforeItemClickEvent evt) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationEventList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_prorationevent");
        ListSelectedRow row = selectedRows.get(0);
        DynamicObject data = helper.queryOne("id,source,referencestatus,eventstatus", row.getPrimaryKeyValue());
        if ("2".equals(data.getString("source"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4fee\u6539\u81ea\u52a8\u751f\u6210\u7684\u5206\u6bb5\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ProrationEventList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if ("2".equals(data.getString("referencestatus"))) {
            String calTaskName = this.getCalTaskName(data.getLong("id"));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u6bb5\u8bb0\u5f55\u5df2\u88ab\u6838\u7b97\u4efb\u52a1\u201c{0}\u201d\u5f15\u7528\uff0c\u8bf7\u5148\u5c06\u6838\u7b97\u4eba\u5458\u4ece\u6838\u7b97\u540d\u5355\u4e2d\u5220\u9664\uff0c\u518d\u8fdb\u884c\u4fee\u6539\u3002", (String)"ProrationEventList_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{calTaskName}));
            evt.setCancel(true);
            return;
        }
        if ("2".equals(data.getString("eventstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4eba\u5458\u5206\u6bb5\u4e8b\u4ef6\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"ProrationEventList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private String getCalTaskName(long prorationEventId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calprorationrel");
        QFilter filter = new QFilter("prorationevent.id", "=", (Object)prorationEventId);
        DynamicObjectCollection data = helper.queryOriginalCollection("caltask.name", new QFilter[]{filter});
        StringBuilder nameStr = new StringBuilder();
        for (DynamicObject obj : data) {
            nameStr.append(obj.getString("caltask.name")).append(',');
        }
        if (nameStr.length() > 0) {
            return nameStr.substring(0, nameStr.length() - 1);
        }
        return nameStr.toString();
    }
}

