/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class BizDataRejectFailPlugin
extends AbstractFormPlugin {
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";

    public void initialize() {
        this.addClickListeners(new String[]{"btnmore"});
        this.addClickListeners(new String[]{"viewdata"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        int failCount = (Integer)parameter.getCustomParam("failCount");
        if (failCount <= 5 && failCount > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmore"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnmore"});
        }
        String rejectInfo = (String)parameter.getCustomParam("rejectInfo");
        Label label = (Label)this.getControl("rejectinfo");
        label.setText(rejectInfo);
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        String pageId = (String)parameter.getCustomParam("pageId");
        Set recoverFailBizDataCodeSet = (Set)appCache.get("recoverFailBizDataCodeSet_" + pageId, HashSet.class);
        if (recoverFailBizDataCodeSet == null || recoverFailBizDataCodeSet.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uncoverpanel"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"uncoverpanel"});
        }
        if (failCount != 0) {
            Html content = (Html)this.getControl("fcontent");
            content.setConent((String)parameter.getCustomParam("errorMsg"));
            if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnmore"});
            }
        }
    }

    public void click(EventObject evt) {
        if ("btnmore".equals(((Control)evt.getSource()).getKey())) {
            FormShowParameter param = this.getView().getFormShowParameter();
            IFormView view = this.getView();
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ide_showoperationresult");
            parameter.setCustomParam("pkNumbers", param.getCustomParam("pkNumbers"));
            parameter.setCustomParam("operateName", param.getCustomParam("operateName"));
            this.setFailMessageToCache();
            view.showForm(parameter);
        } else if ("viewdata".equals(((Control)evt.getSource()).getKey())) {
            this.showRejectFailPage();
        }
    }

    private void showRejectFailPage() {
        IFormView view = this.getView();
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String pageId = (String)parameter.getCustomParam("pageId");
        BizDataHelper bizDataHelper = new BizDataHelper();
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        Set recoverFailBizDataCodeSet = (Set)appCache.get("recoverFailBizDataCodeSet_" + pageId, HashSet.class);
        QFilter recurBizFilter = new QFilter("identifynumber", "in", (Object)recoverFailBizDataCodeSet);
        DynamicObject[] unCoverBizDatas = bizDataHelper.getBizDataColl(recurBizHelper, recurBizFilter);
        if (unCoverBizDatas == null || unCoverBizDatas.length == 0) {
            return;
        }
        JSONArray rejectParamArray = new JSONArray();
        for (DynamicObject unCoverBizData : unCoverBizDatas) {
            Long salaryFileId = unCoverBizData.getLong("salaryfile.id");
            Long bizItemId = unCoverBizData.getLong("bizitem.id");
            String bizDataCode = unCoverBizData.getString("identifynumber");
            String dataValue = unCoverBizData.getString("datavalue");
            Long currencyId = unCoverBizData.getLong("currency.id");
            Date bsed = unCoverBizData.getDate("bsed");
            Date bsled = unCoverBizData.getDate("bsled");
            Long frequencyId = unCoverBizData.getLong("frequency.id");
            String description = unCoverBizData.getString("description");
            String auditStatus = unCoverBizData.getString("auditstatus");
            JSONObject auditParamObj = new JSONObject();
            auditParamObj.put("salaryFileId", (Object)salaryFileId);
            auditParamObj.put("bizItemId", (Object)bizItemId);
            auditParamObj.put("bizDataCode", (Object)bizDataCode);
            auditParamObj.put("dataValue", (Object)dataValue);
            auditParamObj.put("currencyId", (Object)currencyId);
            auditParamObj.put("bsed", (Object)bsed);
            auditParamObj.put("beforeBsled", (Object)bsled);
            auditParamObj.put("frequencyId", (Object)frequencyId);
            auditParamObj.put("description", (Object)description);
            auditParamObj.put("auditStatus", (Object)auditStatus);
            rejectParamArray.add((Object)auditParamObj);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"BizDataRejectFailPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("hsas_bizdataauditconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("rejectParamArray", (Object)rejectParamArray);
        showParameter.setCustomParam("auditType", (Object)"reject");
        showParameter.setCustomParam("hideBtn", (Object)Boolean.TRUE);
        view.showForm(showParameter);
    }

    private void setFailMessageToCache() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Object operateName = param.getCustomParam("operateName");
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        OperationResult operationResult = new OperationResult();
        List allErrorInfo = operationResult.getAllErrorInfo();
        Object failListObj = param.getCustomParam("failList");
        if (failListObj != null) {
            List faiList = (List)failListObj;
            for (String message : faiList) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setMessage(message);
                if (operateName != null) {
                    errorInfo.setTitle(operateName.toString());
                }
                errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
                allErrorInfo.add(errorInfo);
            }
        }
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
    }
}

