/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.formplugin.web.bizdatatpl.BizCalTaskCalPeriodRel;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class BizDataTplListPlugin
extends SWCDataBaseList {
    private static final String[] FREEZON_COLUMNS = new String[]{"fseq", "salaryfile.name", "salaryfile.employee.empnumber", "salaryfile.number", "bizitem.name"};
    public static final String NOCOUNTTIMES = "nocounttimes";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        for (IListColumn listColumn : columns) {
            String columnName = listColumn.getListFieldKey();
            HashSet<String> freezonSet = new HashSet<String>(Arrays.asList(FREEZON_COLUMNS));
            if (!freezonSet.contains(columnName)) continue;
            listColumn.setFixed(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "usagecount": {
                args.setCancel(true);
                Long focusRowPkId = (Long)this.getFocusRowPkId();
                this.openCalTaskAndCalPeriodRel(focusRowPkId);
                break;
            }
            case "nocounttimes": {
                args.setCancel(true);
                Long pkId = (Long)this.getFocusRowPkId();
                this.openCalTaskAndCalPeriodNoCntRel(pkId);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        List qFilterList = event.getQFilters();
        Iterator iterator = qFilterList.iterator();
        QFilter newFilter = null;
        BizDataHelper helper = new BizDataHelper();
        while (iterator.hasNext()) {
            String propertyName;
            QFilter filter = (QFilter)iterator.next();
            if (filter == null || !SWCStringUtils.equals((String)"usagecountoption", (String)(propertyName = filter.getProperty()))) continue;
            newFilter = helper.buildUsageCountOptionFilter(filter.getValue());
            iterator.remove();
        }
        if (newFilter != null) {
            qFilterList.add(newFilter);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        String billFormId;
        super.beforeClosed(event);
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof IListView && SWCStringUtils.equals((String)(billFormId = ((IListView)parentView).getBillFormId()), (String)"hsas_salaryfile")) {
            return;
        }
        if (parentView != null && !SWCStringUtils.equals((String)parentView.getEntityId(), (String)"hsas_caltabledetailresult")) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "bizdataaccesstpl.name": {
                QFilter filter = this.bizDataAccessTplFilter();
                filters.add(filter);
                break;
            }
            case "bizitem.name": {
                filters.add(this.bizDataBizItemFilter());
                break;
            }
        }
    }

    private void openCalTaskAndCalPeriodNoCntRel(Long pkId) {
        String entityName = ((IListView)this.getView()).getBillFormId();
        QFilter filter = new QFilter("bizdataid", "=", (Object)pkId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        if (SWCStringUtils.equals((String)entityName, (String)"hsas_nonrecurbizdata")) {
            showParameter.setBillFormId("hsas_noncalbsnocntrel");
        } else {
            showParameter.setBillFormId("hsas_calbsnocntrel");
        }
        showParameter.setHasRight(true);
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f7f\u7528\u8be6\u60c5", (String)"BizDataTplListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.addCustPlugin(BizCalTaskCalPeriodRel.class.getName());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openCalTaskAndCalPeriodRel(Long primaryKeyValue) {
        String entityName = ((IListView)this.getView()).getBillFormId();
        QFilter filter = new QFilter("bizdataid", "=", (Object)primaryKeyValue);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        if (SWCStringUtils.equals((String)entityName, (String)"hsas_nonrecurbizdata")) {
            showParameter.setBillFormId("hsas_calnonbizdatarel");
        } else {
            showParameter.setBillFormId("hsas_calbizdatarel");
        }
        showParameter.setHasRight(true);
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f7f\u7528\u8be6\u60c5", (String)"BizDataTplListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.addCustPlugin(BizCalTaskCalPeriodRel.class.getName());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter bizDataAccessTplFilter() {
        String entityName = ((IListView)this.getView()).getBillFormId();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        List allOrgList = hasPermOrgResult.getHasPermOrgs();
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitemgroup", (List)allOrgList, (boolean)true);
        return orgFilter;
    }

    private QFilter bizDataBizItemFilter() {
        String entityName = ((IListView)this.getView()).getBillFormId();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)entityName, (String)"47150e89000000ac");
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        List allOrgList = hasPermOrgResult.getHasPermOrgs();
        QFilter orgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", (List)allOrgList, (boolean)true);
        return orgFilter;
    }
}

