/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;

public class NonRecurBizDataListPlugin
extends SWCDataBaseList {
    private static final int BATCH_TRANS_PAYROLLGRP_NUM = 500;
    private static final String CALLBACK_INVOKE = "callback_invoke";
    private static final Log LOGGER = LogFactory.getLog(NonRecurBizDataListPlugin.class);
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";
    public static final String OPERATE_UPDATEBSED = "1";
    public static final String MODELTYPE_1 = "1";

    public void initialize() {
        super.initialize();
        List filterIdList = (List)this.getView().getFormShowParameter().getCustomParam("filterIdList");
        if (filterIdList != null) {
            try {
                this.getPageCache().put("filterIdList", JSONUtils.toString((Object)filterIdList));
            }
            catch (IOException e) {
                LOGGER.error("filterIdList\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
            }
        }
        this.getView().getFormShowParameter().setCustomParam("filterIdList", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (source.getOption().tryGetVariableValue(CALLBACK_INVOKE, new RefObject())) {
            return;
        }
        switch (operateKey) {
            case "donothing_reject": {
                args.setCancel(true);
                this.doReject();
                break;
            }
            case "donothing_abandon": {
                args.setCancel(true);
                this.doAbandon();
                break;
            }
            case "submit": 
            case "save": {
                source.getOption().setVariableValue("isImport", Boolean.FALSE.toString());
                break;
            }
            case "donothing_updatebsed": {
                args.setCancel(true);
                this.updateBsedConfirm();
                break;
            }
            case "donothing_grptrans": {
                args.setCancel(true);
                this.doPayRollGrpTrans();
                break;
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "payrollgroup.id": 
            case "payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_nonrecurbizdata");
                break;
            }
            case "empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_nonrecurbizdata");
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "payrollgroup.id": 
            case "payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_nonrecurbizdata");
                break;
            }
            case "empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_nonrecurbizdata");
                break;
            }
            case "bizitem.name": 
            case "bizitem.number": {
                filters.add(BizDataHelper.getClassificationFilter());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate op = (FormOperate)args.getSource();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Object> primaryKeyValues = Arrays.asList(selectedRows.getPrimaryKeyValues());
        switch (operateKey) {
            case "donothing_abandon": 
            case "donothing_reject": 
            case "donothing_updatebsled": 
            case "donothing_updatebsed": {
                if (args.getOperationResult() == null || args.getOperationResult().getSuccessPkIds().isEmpty()) {
                    return;
                }
                ((IEntityOperate)op).setCancelRefresh(false);
                break;
            }
            case "donothing_bsedupdaterecord": {
                this.viewBsedUpdateRecord(primaryKeyValues);
                break;
            }
            case "donothing_viewmodifyrecord": {
                this.viewBizDataModifyRecord(primaryKeyValues);
                break;
            }
            case "donothing_viewmodifyrecordcol": {
                ArrayList<Object> focusRows = new ArrayList<Object>(1);
                focusRows.add(this.getFocusRowPkId());
                this.viewBizDataModifyRecord(focusRows);
                break;
            }
            case "donothing_grptrans": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void viewBizDataModifyRecord(List<Object> primaryKeyValues) {
        QFilter filter = new QFilter("modeltype", "=", (Object)"1");
        filter.and("bizitem.cycle", "=", (Object)"0");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            filter.and("dataid", "in", primaryKeyValues);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_bizdatamodifyrecord");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            showParameter.setCustomParam("dataids", primaryKeyValues);
        }
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (SWCStringUtils.equals((String)callBackId, (String)"updateBsedConfirm")) {
            this.doUpdateBsedPop();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            if (SWCStringUtils.equals((String)actionId, (String)"donothing_grptrans")) {
                ListSelectedRowCollection selectColl = (ListSelectedRowCollection)returnData;
                if (selectColl == null || selectColl.size() == 0) {
                    return;
                }
                Long payRollGroupId = (Long)selectColl.get(0).getPrimaryKeyValue();
                OperateOption option = OperateOption.create();
                option.setVariableValue("payRollGroupId", String.valueOf(payRollGroupId));
                option.setVariableValue(CALLBACK_INVOKE, "true");
                option.setVariableValue("batchop_batchsize", String.valueOf(500));
                this.getView().invokeOperation("donothing_grptrans", option);
            }
        } else {
            Map rsMap = (Map)closedCallBackEvent.getReturnData();
            if (rsMap != null && "ok".equals(rsMap.get("operate"))) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("userId", String.valueOf(RequestContext.get().getCurrUserId()));
                option.setVariableValue("pageId", this.getView().getPageId());
                option.setVariableValue("isRecur", "N");
                option.setVariableValue(CALLBACK_INVOKE, "true");
                if (SWCStringUtils.equals((String)actionId, (String)"donothing_reject")) {
                    option.setVariableValue("opreason", (String)rsMap.get("opreason"));
                    option.setVariableValue("pageId", this.getView().getPageId());
                    this.getView().invokeOperation("donothing_reject", option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_abandon")) {
                    option.setVariableValue("opreason", (String)rsMap.get("opreason"));
                    this.getView().invokeOperation("donothing_abandon", option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_updatebsed")) {
                    option.setVariableValue("description", (String)rsMap.get("description"));
                    option.setVariableValue("updatebsed", (String)rsMap.get("updatebsed"));
                    this.getView().invokeOperation("donothing_updatebsed", option);
                }
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonBaseDataFilterColumn filterColumn;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns != null && !commonFilterColumns.isEmpty() && (filterColumn = (CommonBaseDataFilterColumn)commonFilterColumns.get(0)).getFieldName().equals("org.name")) {
            filterColumn.setDefaultValue("");
        }
        this.setFastFilterDefautValue(args);
        this.setCommonFilterDefaultValue(args);
    }

    private void setCommonFilterDefaultValue(FilterContainerInitArgs args) {
        String startData = (String)this.getView().getFormShowParameter().getCustomParam("startDate");
        String endDate = (String)this.getView().getFormShowParameter().getCustomParam("endDate");
        if (SWCStringUtils.isEmpty((String)startData) || SWCStringUtils.isEmpty((String)endDate)) {
            return;
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        if (commonFilterColumns != null && !commonFilterColumns.isEmpty()) {
            ArrayList<String> dateList = new ArrayList<String>(2);
            dateList.add(startData);
            dateList.add(endDate);
            for (FilterColumn filterColumn : commonFilterColumns) {
                if (!filterColumn.getFieldName().equals("bsed")) continue;
                filterColumn.setDefaultValues(dateList);
            }
        }
    }

    private void setFastFilterDefautValue(FilterContainerInitArgs args) {
        String filterIdListStr = this.getView().getPageCache().get("filterIdList");
        if (SWCStringUtils.isEmpty((String)filterIdListStr)) {
            return;
        }
        List filterIdList = null;
        try {
            filterIdList = (List)JSONUtils.cast((String)filterIdListStr, List.class);
        }
        catch (IOException ioException) {
            LOGGER.error("filterIdList\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)ioException);
        }
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        QFilter filter = new QFilter("id", "in", (Object)filterIdList);
        DynamicObjectCollection bizDataColl = dataHelper.queryOriginalCollection("identifynumber", new QFilter[]{filter});
        if (bizDataColl == null || bizDataColl.size() == 0) {
            return;
        }
        List fastFilterColumns = args.getFastFilterColumns();
        Set identifyNumSet = bizDataColl.stream().map(obj -> obj.getString("identifynumber")).collect(Collectors.toSet());
        for (FilterColumn filterColumn : fastFilterColumns) {
            if (!"identifynumber".equals(filterColumn.getFieldName())) continue;
            filterColumn.setDefaultValues(identifyNumSet.toArray());
        }
    }

    public void setFilter(SetFilterEvent event) {
        String filterIdListStr = this.getView().getPageCache().get("filterIdList");
        if (SWCStringUtils.isNotEmpty((String)filterIdListStr)) {
            event.getQFilters().clear();
            this.getPageCache().put("filterIdList", null);
            List filterIdList = null;
            try {
                filterIdList = (List)JSONUtils.cast((String)filterIdListStr, List.class);
            }
            catch (IOException ioException) {
                LOGGER.error("filterIdList\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)ioException);
            }
            if (CollectionUtils.isNotEmpty((Collection)filterIdList)) {
                event.getQFilters().add(new QFilter("id", "in", (Object)filterIdList));
            }
            QFilter filter = new QFilter("bizdatarecord", "<=", (Object)0);
            event.getQFilters().add(filter);
            return;
        }
        List qFilterList = event.getQFilters();
        QFilter filter = new QFilter("bizdatarecord", "<=", (Object)0);
        qFilterList.add(filter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "updatetimes": {
                args.setCancel(true);
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_nonrecurbizdata", (String)"3PLJZFCY0TLG");
                if (!permFlag) {
                    String errorTips = ResManager.loadKDString((String)"\u65e0\u201c\u524d\u7aef\u4e1a\u52a1\u6570\u636e\uff08\u7eb5\u8868\uff09_\u975e\u5faa\u73af\u201d\u7684\u201c\u751f\u6548\u65e5\u671f\u66f4\u65b0\u8bb0\u5f55\u201d\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NonRecurBizDataListPlugin_05", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorTips);
                    break;
                }
                Long focusRowPkId = (Long)this.getFocusRowPkId();
                ArrayList<Object> idList = new ArrayList<Object>(10);
                idList.add(focusRowPkId);
                this.viewBsedUpdateRecord(idList);
                break;
            }
        }
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }

    private void doReject() {
        SWCDataServiceHelper nonRecurHelper;
        BizDataHelper helper = new BizDataHelper();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List rejectIdList = helper.filterRejectIdList(selectedRows, nonRecurHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata"));
        if (rejectIdList.size() == 0 || rejectIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u524d\u7aef\u63d0\u62a5\u201d\uff0c\u4f7f\u7528\u6b21\u6570\u4e3a0\uff0c\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        appCache.put("rejectIdList_" + pageId, (Object)rejectIdList);
        int rejectCount = rejectIdList.size();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("rejectCount", (Object)rejectCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("operate", (Object)"reject");
        StyleCss css = new StyleCss();
        css.setWidth("870px");
        css.setHeight("534px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u786e\u8ba4", (String)"BizDataTplListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_reject"));
        this.getView().showForm(showParameter);
    }

    private void doPayRollGrpTrans() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> payRollGrpTransIdList = this.filterPayRollGrpTransIdList(selectedRows);
        if (payRollGrpTransIdList.size() != selectedRows.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e14\u4f7f\u7528\u6b21\u6570\u4e3a0\u7684\u6570\u636e\u6309\u85aa\u8d44\u6838\u7b97\u7ec4\u8f6c\u79fb\u3002", (String)"NonRecurBizDataListPlugin_07", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter permFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"payrollgroup");
        HasPermOrgResult hasBuResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"47150e89000000ac");
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollgrp", (boolean)false);
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_grptrans"));
        if (permFilter != null) {
            showParameter.getListFilterParameter().getQFilters().add(permFilter);
            LOGGER.info("query getDataRuleForBdProp is:{}", (Object)permFilter.toString());
        }
        showParameter.getListFilterParameter().getQFilters().add(permFilter);
        if (!hasBuResult.hasAllOrgPerm()) {
            List orgList = hasBuResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void doAbandon() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> abandonIdList = this.filterAbandonIdList(selectedRows);
        if (abandonIdList.size() == 0 || abandonIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        appCache.put("abandonIdList", abandonIdList);
        int abandonCount = abandonIdList.size();
        QFilter filter = new QFilter("id", "in", abandonIdList);
        filter.and("datasources", "=", (Object)"3");
        SWCDataServiceHelper nonRecurBizHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        DynamicObject[] nonRecurbizDatas = nonRecurBizHelper.query("id", new QFilter[]{filter});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("abandonCount", (Object)abandonCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("hpdiCount", (Object)nonRecurbizDatas.length);
        showParameter.setCustomParam("operate", (Object)"abandon");
        StyleCss css = new StyleCss();
        css.setWidth("870px");
        css.setHeight("534px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e9f\u5f03\u786e\u8ba4", (String)"BizDataTplListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_abandon"));
        this.getView().showForm(showParameter);
    }

    private List<Long> filterAbandonIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List abandonIdList = bizDataHelper.getBizDataIdList(recurHelper, filter);
        return abandonIdList;
    }

    private List<Long> filterPayRollGrpTransIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        filter.and("usagecount", "=", (Object)0);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List transIdList = bizDataHelper.getBizDataIdList(helper, filter);
        return transIdList;
    }

    private void updateBsedConfirm() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() > 10000) {
            String showMsg = ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u8d85\u8fc71w\u6761\uff0c\u6570\u636e\u91cf\u5927\uff0c\u64cd\u4f5c\u65f6\u95f4\u53ef\u80fd\u8f83\u957f\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"NonRecurBizDataListPlugin_06", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(showMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateBsedConfirm"));
            return;
        }
        this.doUpdateBsedPop();
    }

    private void doUpdateBsedPop() {
        if (!this.updateBsed()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e14\u4f7f\u7528\u6b21\u6570\u4e3a0\u7684\u6570\u636e\u66f4\u65b0\u751f\u6548\u65e5\u671f\u3002", (String)"NonRecurBizDataListPlugin_01", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openUpdateBsedPop();
    }

    private boolean updateBsed() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Object> bizDataIdList = Arrays.asList(selectedRows.getPrimaryKeyValues());
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        filter.and("usagecount", "=", (Object)BigDecimal.ZERO);
        SWCDataServiceHelper nonRecurHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        BizDataHelper bizDataHelper = new BizDataHelper();
        DynamicObject[] bizDataColl = bizDataHelper.getBizDataColl(nonRecurHelper, filter);
        return bizDataIdList.size() == bizDataColl.length;
    }

    private void openUpdateBsedPop() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("operate", (Object)"updateBsed");
        StyleCss css = new StyleCss();
        css.setWidth("460px");
        css.setHeight("310px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u6548\u65e5\u671f", (String)"NonRecurBizDataListPlugin_02", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_updatebsed"));
        this.getView().showForm(showParameter);
    }

    private void viewBsedUpdateRecord(List<Object> primaryKeyValues) {
        QFilter filter = new QFilter("operate", "=", (Object)"1");
        filter.and("modeltype", "=", (Object)"1");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            filter.and("dataid", "in", primaryKeyValues);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_bizdatamodify_vbsed");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        showParameter.setCustomParam("modeltype", (Object)"1");
        showParameter.setCaption(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u66f4\u65b0\u8bb0\u5f55", (String)"NonRecurBizDataListPlugin_03", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addOrgPermFilter(List<QFilter> filters, String propKey, String appId, String entityNum) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        if (permOrgs != null) {
            if (permOrgs.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            QFilter permFilter = new QFilter(propKey, "in", (Object)hasPermOrgs);
            filters.add(permFilter);
        }
    }

    public void setOrgAuthorFilter(List<QFilter> qFilters) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_nonrecurbizdata", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            LOGGER.info("NonRecurbizDataListPlugin.setOrgAuthorFilter: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            QFilter permFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            qFilters.add(permFilter);
        }
    }
}

