/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class RecurBizDataBillEdit
extends SWCDataBaseEdit {
    private static final String BIZITEMPROP_FLEX = "bizpropflex";
    private static final String BIZITEMPROP_ENTRY = "recurbizpropentry";
    private static final long NUMBERIC = 1010L;
    private static final String PROP_DATAVALUE = "propdatavalue";
    private static final String CLOSE_CALBACK_AUDIT = "closecalbackaudit";

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.getView().getPageCache().put("BOS.setRowDataByNumberDisable", "true");
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "true");
    }

    public void afterBindData(EventObject event) {
        DynamicObject bizItemObj = this.getModel().getDataEntity().getDynamicObject("bizitem");
        this.bizItemChangeEvent(bizItemObj);
        this.cachePropValue();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "bizitem": {
                DynamicObject newValue = (DynamicObject)event.getChangeSet()[0].getNewValue();
                this.bizItemChangeEvent(newValue);
                break;
            }
            case "propdatavalue": {
                this.cachePropValue();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "save": 
            case "submit": {
                source.getOption().setVariableValue("checkProp", Boolean.TRUE.toString());
                source.getOption().setVariableValue("isImport", Boolean.FALSE.toString());
                source.getOption().setVariableValue("isListOp", Boolean.FALSE.toString());
                break;
            }
            case "donothing_audit": {
                args.setCancel(true);
                this.doAudit();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || args.getOperationResult().getSuccessPkIds().isEmpty()) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Map rsMap = (Map)closedCallBackEvent.getReturnData();
        if (rsMap != null && "ok".equals(rsMap.get("operate")) && SWCStringUtils.equals((String)CLOSE_CALBACK_AUDIT, (String)actionId)) {
            this.auditCloseCalBackEvent();
        }
    }

    private void auditCloseCalBackEvent() {
        Long bizDataId = (Long)this.getModel().getValue("id");
        if (bizDataId == null) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "=", (Object)bizDataId);
        DynamicObject queryData = helper.queryOne("id,identifynumber,auditstatus", new QFilter[]{filter});
        if (SWCObjectUtils.isEmpty((Object)queryData)) {
            return;
        }
        String auditStatus = queryData.getString("auditstatus");
        String bizDataCode = queryData.getString("identifynumber");
        if (!SWCStringUtils.equals((String)auditStatus, (String)"B")) {
            String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u6570\u636e\u72b6\u6001\u4e0d\u662f\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u5bf9\u5e94\u5173\u8054\u6570\u636e\u7684\u5931\u6548\u65e5\u671f\u4e0d\u505a\u66f4\u65b0\u3002", (String)"RecurBizDataBillEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), bizDataCode);
            this.getView().showTipNotification(msg);
            return;
        }
        this.getView().invokeOperation("audit");
    }

    private void cachePropValue() {
        HashMap<String, String> cachePropValMap = new HashMap<String, String>(16);
        DynamicObjectCollection propEntryColl = this.getModel().getEntryEntity(BIZITEMPROP_ENTRY);
        for (DynamicObject propEntryObj : propEntryColl) {
            DynamicObject propObj = propEntryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)propObj)) continue;
            long propId = propObj.getLong("id");
            String propVal = propEntryObj.getString(PROP_DATAVALUE);
            if (!SWCStringUtils.isNotEmpty((String)propVal)) continue;
            cachePropValMap.put(String.valueOf(propId), propVal);
        }
        if (cachePropValMap.size() > 0) {
            SWCPageCache cache = new SWCPageCache(this.getView());
            cache.put("propValMap", cachePropValMap);
        }
    }

    private void bizItemChangeEvent(DynamicObject bizItemObj) {
        if (SWCObjectUtils.isEmpty((Object)bizItemObj)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZITEMPROP_FLEX});
            this.getModel().deleteEntryData(BIZITEMPROP_ENTRY);
            return;
        }
        boolean isExtProp = bizItemObj.getBoolean("isextprop");
        if (isExtProp) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BIZITEMPROP_FLEX});
            this.loadBizItemPropEntry(bizItemObj.getLong("id"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BIZITEMPROP_FLEX});
            this.getModel().deleteEntryData(BIZITEMPROP_ENTRY);
        }
    }

    private void loadBizItemPropEntry(long bizItemId) {
        DynamicObjectCollection bizItemPropEntry = this.getModel().getEntryEntity(BIZITEMPROP_ENTRY);
        HashMap<Long, String> cachePropMap = new HashMap<Long, String>(bizItemPropEntry.size());
        for (DynamicObject bizItemPropEntryObj : bizItemPropEntry) {
            long bizItemPropId = bizItemPropEntryObj.getLong("bizitemprop.id");
            String propValue = bizItemPropEntryObj.getString(PROP_DATAVALUE);
            cachePropMap.put(bizItemPropId, propValue);
        }
        BizDataHelper helper = new BizDataHelper();
        DynamicObjectCollection bizItemEntryColl = helper.getBizItemPropInfo(bizItemId);
        if (SWCObjectUtils.isEmpty((Object)bizItemEntryColl)) {
            return;
        }
        boolean isCopy = this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("bizitemprop", new Object[0]);
        setter.addField(PROP_DATAVALUE, new Object[0]);
        for (DynamicObject bizItemEntryObj : bizItemEntryColl) {
            String enable;
            String status;
            DynamicObject bizItemPropObj = bizItemEntryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj)) continue;
            long bizItemPropId = bizItemPropObj.getLong("id");
            String propVal = (String)cachePropMap.get(bizItemPropId);
            if (SWCStringUtils.isEmpty((String)propVal)) {
                status = bizItemPropObj.getString("status");
                enable = bizItemPropObj.getString("enable");
                if (!SWCStringUtils.equals((String)status, (String)"C") || !SWCStringUtils.equals((String)enable, (String)"1")) {
                    continue;
                }
            } else if (isCopy) {
                status = bizItemPropObj.getString("status");
                enable = bizItemPropObj.getString("enable");
                if (!SWCStringUtils.equals((String)status, (String)"C") || !SWCStringUtils.equals((String)enable, (String)"1")) continue;
            }
            setter.addRow(new Object[]{bizItemPropId, propVal});
        }
        model.deleteEntryData(BIZITEMPROP_ENTRY);
        model.batchCreateNewEntryRow(BIZITEMPROP_ENTRY, setter);
        this.getView().updateView(BIZITEMPROP_ENTRY);
        model.endInit();
        this.bizItemPropEntryInputValSet();
    }

    private void bizItemPropEntryInputValSet() {
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(BIZITEMPROP_ENTRY);
        if (entryColl == null || entryColl.size() == 0) {
            return;
        }
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            long dataTypeId;
            DynamicObject dataType;
            DynamicObject entryObj = (DynamicObject)entryColl.get(i);
            DynamicObject bizItemPropObj = entryObj.getDynamicObject("bizitemprop");
            if (SWCObjectUtils.isEmpty((Object)bizItemPropObj) || SWCObjectUtils.isEmpty((Object)(dataType = bizItemPropObj.getDynamicObject("datatype"))) || 1010L != (dataTypeId = dataType.getLong("id"))) continue;
            String scaleLimit = bizItemPropObj.getString("scalelimit");
            BigDecimal maxVal = bizItemPropObj.getBigDecimal("maxvalue");
            BigDecimal minVal = bizItemPropObj.getBigDecimal("minvalue");
            String isMinValNull = bizItemPropObj.getString("isminvalnull");
            String isMaxValNull = bizItemPropObj.getString("ismaxvalnull");
            int scale = 10;
            if (StringUtils.isNotEmpty((String)scaleLimit)) {
                scale = Integer.parseInt(scaleLimit);
            }
            if (SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
                this.getModel().setValue("propminvalue", null, i);
            } else {
                this.getModel().setValue("propminvalue", (Object)minVal.setScale(scale, 4).toPlainString(), i);
            }
            if (SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
                this.getModel().setValue("propmaxvalue", null, i);
                continue;
            }
            this.getModel().setValue("propmaxvalue", (Object)maxVal.setScale(scale, 4).toPlainString(), i);
        }
    }

    private void doAudit() {
        String auditStatus = (String)this.getModel().getValue("auditstatus");
        if (!SWCStringUtils.equals((String)auditStatus, (String)"B")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5df2\u63d0\u4ea4\u201d\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"RecurBizDataBillEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(1);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(1);
        DynamicObject salaryFileObj = this.getModel().getDataEntity().getDynamicObject("salaryfile");
        Long dealSalaryFileId = salaryFileObj.getLong("id");
        salaryFileIdSet.add(dealSalaryFileId);
        DynamicObject bizItemObj = this.getModel().getDataEntity().getDynamicObject("bizitem");
        Long dealBizItemId = bizItemObj.getLong("id");
        bizItemIdSet.add(dealBizItemId);
        String bizDataCode = (String)this.getModel().getValue("identifynumber");
        BizDataHelper bizDataHelper = new BizDataHelper();
        Table oldRecurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        if (oldRecurBizData != null && oldRecurBizData.size() > 0) {
            for (Long salaryFileId : oldRecurBizData.rowKeySet()) {
                for (Long bizItemId : oldRecurBizData.columnKeySet()) {
                    List oldBizDataList = (List)oldRecurBizData.get((Object)salaryFileId, (Object)bizItemId);
                    if (oldBizDataList == null || oldBizDataList.size() == 0) continue;
                    for (Object oldBizDataObj : oldBizDataList) {
                        String oldBizDataCode = oldBizDataObj.getString("identifynumber");
                        Long oldBizItemId = oldBizDataObj.getLong("bizitem.id");
                        Date oldBsled = oldBizDataObj.getDate("bsled");
                        if (oldBsled == null) continue;
                        bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                    }
                }
            }
        } else {
            this.getView().invokeOperation("audit");
            return;
        }
        ArrayList needUpdateObjList = new ArrayList(10);
        Date bsed = (Date)this.getModel().getValue("bsed");
        Date bsled = (Date)this.getModel().getValue("bsled");
        JSONObject dataObj = new JSONObject();
        dataObj.put("salaryFileId", (Object)dealSalaryFileId);
        dataObj.put("bizItemId", (Object)dealBizItemId);
        dataObj.put("bsed", (Object)bsed);
        dataObj.put("bsled", (Object)bsled);
        List updateList = bizDataHelper.dealNeedUpdateBsledDataByCondition(oldRecurBizData, dataObj);
        if (updateList != null && updateList.size() > 0) {
            needUpdateObjList.addAll(updateList);
        }
        if (needUpdateObjList != null && needUpdateObjList.size() > 0) {
            JSONArray auditParamArray = new JSONArray();
            for (DynamicObject needUpdateObj : needUpdateObjList) {
                Long salaryFileId = needUpdateObj.getLong("salaryfile.id");
                Long bizItemId = needUpdateObj.getLong("bizitem.id");
                String newBizDataCode = needUpdateObj.getString("identifynumber");
                String dataValue = needUpdateObj.getString("datavalue");
                Long currencyId = needUpdateObj.getLong("currency.id");
                Date newBsed = needUpdateObj.getDate("bsed");
                Date beforeBsled = (Date)bizDataBsledDateMap.get(newBizDataCode + '#' + bizItemId);
                Date afterBsled = needUpdateObj.getDate("bsled");
                Long frequencyId = needUpdateObj.getLong("frequency.id");
                String description = needUpdateObj.getString("description");
                String newAuditStatus = needUpdateObj.getString("auditstatus");
                JSONObject auditParamObj = new JSONObject();
                auditParamObj.put("salaryFileId", (Object)salaryFileId);
                auditParamObj.put("bizItemId", (Object)bizItemId);
                auditParamObj.put("bizDataCode", (Object)newBizDataCode);
                auditParamObj.put("dataValue", (Object)dataValue);
                auditParamObj.put("currencyId", (Object)currencyId);
                auditParamObj.put("bsed", (Object)newBsed);
                auditParamObj.put("beforeBsled", (Object)beforeBsled);
                auditParamObj.put("afterBsled", (Object)afterBsled);
                auditParamObj.put("frequencyId", (Object)frequencyId);
                auditParamObj.put("description", (Object)description);
                auditParamObj.put("auditStatus", (Object)newAuditStatus);
                auditParamArray.add((Object)auditParamObj);
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hsas_bizdataauditconfirm");
            SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"RecurBizDataListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALBACK_AUDIT));
            showParameter.setCustomParam("auditParamArray", (Object)auditParamArray);
            showParameter.setCustomParam("auditType", (Object)"audit");
            this.getView().showForm(showParameter);
        } else {
            this.getView().invokeOperation("audit");
        }
    }
}

