/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.bizdatatpl.transversetable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.IEntityOperate;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.transversetable.BizDataEntityTypeBillList;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListExportService;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListHelper;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListService;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsas.common.vo.BizDataRecordExportProgressInfo;
import kd.swc.hsas.formplugin.web.bizdatatpl.BizCalTaskCalPeriodRel;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSecurityServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BizDataRecordListPlugin
extends SWCDataBaseList {
    public final Log log = LogFactory.getLog(BizDataRecordListPlugin.class);
    private static final String DONOTHING_UPDATEBSED = "donothing_updatebsed";
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final int TEXT_DEFAULT_LENGTH = 1000;
    private static final int NUM_DEFAULT_LENGTH = 10;
    private static final String CLOSE_LABEL = "donothing_close";
    private static final String BIZITEMGROUP = "bizitemgroup";
    private Map<Long, DynamicObject> cacheBizItemMap = new HashMap<Long, DynamicObject>(16);
    private Map<Long, String> cacheDataTypeMap;
    private BizDataEntityTypeBillList billList;
    private static final String HSAS_BIZDATARECORD_CACHE_KEY = "hsas_bizdatarecord_cache_key";
    private static final String CALLBACK_INVOKE = "callback_invoke";
    private static final String EXPORT = "donothing_export";
    public static final Integer PAGE_SIZE = 100;
    private static final String MODULE_NAME = "swc-hsas-formplugin";
    public static final int ROW_ACCESS_WINDOWS_SIZE = PAGE_SIZE;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    public static final int MAX_EXPORT_AWAIT_MINUTES = 30;
    private static final String OPERATE_UPDATEBSED = "1";
    private static final String MODELTYPE_2 = "2";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (source.getOption().tryGetVariableValue(CALLBACK_INVOKE, new RefObject())) {
            return;
        }
        switch (operateKey) {
            case "donothing_close": {
                this.pageCloseEvent();
                break;
            }
            case "donothing_abandon": {
                args.setCancel(true);
                this.doAbandon();
                break;
            }
            case "donothing_reject": {
                args.setCancel(true);
                this.doReject();
                break;
            }
            case "donothing_updatebsed": {
                args.setCancel(true);
                this.doUpdateBsedPop();
                break;
            }
            case "donothing_bsedupdaterecord": 
            case "donothing_viewmodifyrecord": 
            case "donothing_viewmodifyrecordcol": {
                DynamicObject bizItemGroup = (DynamicObject)this.getView().getParentView().getModel().getValue(BIZITEMGROUP);
                if (!SWCObjectUtils.isEmpty((Object)bizItemGroup)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u3002", (String)"BizDataRecordListPlugin_05", (String)MODULE_NAME, (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "donothing_grptrans": {
                args.setCancel(true);
                this.doPayRollGrpTrans();
                break;
            }
        }
    }

    public void destory() {
        super.destory();
        GlobalParam.remove();
    }

    private void doPayRollGrpTrans() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> payRollGrpTransIdList = this.filterPayRollGrpTransIdList(selectedRows);
        if (payRollGrpTransIdList.size() != selectedRows.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e14\u4f7f\u7528\u6b21\u6570\u4e3a0\u7684\u6570\u636e\u6309\u85aa\u8d44\u6838\u7b97\u7ec4\u8f6c\u79fb\u3002", (String)"BizDataRecordListPlugin_07", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        QFilter permFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"payrollgroup");
        HasPermOrgResult hasBuResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_transpayrollgrp", (String)"47150e89000000ac");
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"hsas_payrollgrp", (boolean)false);
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_grptrans"));
        if (permFilter != null) {
            showParameter.getListFilterParameter().getQFilters().add(permFilter);
            this.log.info("query getDataRuleForBdProp is:{}", (Object)permFilter.toString());
        }
        if (!hasBuResult.hasAllOrgPerm()) {
            List orgList = hasBuResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)orgList);
            showParameter.getListFilterParameter().getQFilters().add(orgFilter);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> filterPayRollGrpTransIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        filter.and("usagecount", "=", (Object)0);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bizdatarecord");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List transIdList = bizDataHelper.getBizDataIdList(helper, filter);
        return transIdList;
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "salaryfile.payrollgroup.id": 
            case "salaryfile.payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "salaryfile.org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_bizdatarecord");
                break;
            }
            case "salaryfile.empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_bizdatarecord");
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "salaryfile.payrollgroup.id": 
            case "salaryfile.payrollgroup.name": {
                this.setOrgAuthorFilter(filters);
                break;
            }
            case "salaryfile.org.name": {
                this.addOrgPermFilter(filters, "id", "/UHMBBGZQ65X", "hsas_bizdatarecord");
                break;
            }
            case "salaryfile.empgroup.name": {
                QFilter empGroupFilter = new QFilter("id", "in", (Object)SWCPermissionServiceHelper.getEmpgroupByAppNumber((String)"hsas"));
                filters.add(empGroupFilter);
                break;
            }
            case "salaryfile.name": 
            case "salaryfile.number": {
                this.addOrgPermFilter(filters, "org.id", "/UHMBBGZQ65X", "hsas_bizdatarecord");
                break;
            }
        }
    }

    private void addOrgPermFilter(List<QFilter> filters, String propKey, String appId, String entityNum) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)appId, (String)entityNum, (String)"47150e89000000ac");
        if (permOrgs != null) {
            if (permOrgs.hasAllOrgPerm()) {
                return;
            }
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            QFilter permFilter = new QFilter(propKey, "in", (Object)hasPermOrgs);
            filters.add(permFilter);
        }
    }

    public void setOrgAuthorFilter(List<QFilter> qFilters) {
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_bizdatarecord", (String)"47150e89000000ac");
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            this.log.info("BizDataRecordListPlugin.setOrgAuthorFilter: hasPermOrgs is {}", (Object)JSON.toJSONString((Object)hasPermOrgs));
            QFilter permFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            qFilters.add(permFilter);
        }
    }

    private void doReject() {
        SWCDataServiceHelper bizDataRecordHelper;
        BizDataHelper helper = new BizDataHelper();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List rejectIdList = helper.filterRejectIdList(selectedRows, bizDataRecordHelper = new SWCDataServiceHelper("hsas_bizdatarecord"));
        if (rejectIdList.size() == 0 || rejectIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6765\u6e90\u4e3a\u201c\u524d\u7aef\u63d0\u62a5\u201d\uff0c\u4f7f\u7528\u6b21\u6570\u4e3a0\uff0c\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_0", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATARECORD_CACHE_KEY);
        String pageId = this.getView().getPageId();
        appCache.put("rejectIdList_" + pageId, (Object)rejectIdList);
        int rejectCount = rejectIdList.size();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("rejectCount", (Object)rejectCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("operate", (Object)"reject");
        showParameter.setCaption(ResManager.loadKDString((String)"\u9a73\u56de\u786e\u8ba4", (String)"BizDataTplListPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_reject"));
        this.getView().showForm(showParameter);
    }

    private void doAbandon() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Long> abandonIdList = this.filterAbandonIdList(selectedRows);
        if (abandonIdList.size() == 0 || abandonIdList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u7684\u6570\u636e\u3002", (String)"BizDataTplListPlugin_3", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATARECORD_CACHE_KEY);
        appCache.put("abandonIdList", abandonIdList);
        int abandonCount = abandonIdList.size();
        QFilter filter = new QFilter("id", "in", abandonIdList);
        filter.and("datasources", "=", (Object)"3");
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
        DynamicObject[] recordbizDatas = recordHelper.query("id", new QFilter[]{filter});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("abandonCount", (Object)abandonCount);
        showParameter.setCustomParam("totalCount", (Object)selectedRows.size());
        showParameter.setCustomParam("hpdiCount", (Object)recordbizDatas.length);
        showParameter.setCustomParam("operate", (Object)"abandon");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e9f\u5f03\u786e\u8ba4", (String)"BizDataTplListPlugin_4", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "donothing_abandon"));
        this.getView().showForm(showParameter);
    }

    private List<Long> filterAbandonIdList(ListSelectedRowCollection selectedRows) {
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow row : selectedRows) {
            bizDataIdList.add((Long)row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        SWCDataServiceHelper recurHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
        BizDataHelper bizDataHelper = new BizDataHelper();
        List abandonIdList = bizDataHelper.getBizDataIdList(recurHelper, filter);
        return abandonIdList;
    }

    private void pageCloseEvent() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getView().close();
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }

    public void setFilter(SetFilterEvent event) {
        HasPermOrgResult hasPermOrgResult;
        this.cacheColumnFilter(event);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            event.getQFilters().add(new QFilter(OPERATE_UPDATEBSED, "!=", (Object)1));
            return;
        }
        String parentEntityId = parentView.getEntityId();
        if (!SWCStringUtils.equals((String)parentEntityId, (String)"hsas_bizdatarecordlist")) {
            return;
        }
        DynamicObject bizItemGroupObj = (DynamicObject)parentView.getModel().getValue(BIZITEMGROUP);
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupObj)) {
            event.getQFilters().add(new QFilter(OPERATE_UPDATEBSED, "!=", (Object)1));
        } else {
            ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
            Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
            event.getQFilters().add(new QFilter("bizdataaccesstpl", "=", (Object)bizItemGroupId));
        }
        if (this.getView().getFormShowParameter().getCustomParam("salaryFileId") != null) {
            Long salaryFileId = (Long)this.getView().getFormShowParameter().getCustomParam("salaryFileId");
            event.getQFilters().add(new QFilter("salaryfile.id", "=", (Object)salaryFileId));
        }
        if (this.getView().getFormShowParameter().getCustomParam("bizDataRecordIds") != null) {
            String bizDataRecordIds = (String)this.getView().getFormShowParameter().getCustomParam("bizDataRecordIds");
            this.log.info("bizdatarecordlist get bizDataRecordIds is:{}", (Object)bizDataRecordIds);
            JSONArray bizDataRecordIdArray = JSONArray.parseArray((String)bizDataRecordIds);
            HashSet<Long> bizDataRecordSet = new HashSet<Long>(bizDataRecordIdArray.size());
            for (int i = 0; i < bizDataRecordIdArray.size(); ++i) {
                bizDataRecordSet.add(bizDataRecordIdArray.getLong(i));
            }
            event.getQFilters().add(new QFilter("id", "in", bizDataRecordSet));
        }
        if (!(hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_bizdatarecord", (String)"47150e89000000ac")).hasAllOrgPerm()) {
            event.getQFilters().add(new QFilter("salaryfile.org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        this.cacheColumnFilter(event);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            if (SWCStringUtils.equals((String)actionId, (String)"donothing_grptrans")) {
                ListSelectedRowCollection selectColl = (ListSelectedRowCollection)returnData;
                this.bizDataRecordOperate(selectColl);
            }
        } else {
            Map rsMap = (Map)closedCallBackEvent.getReturnData();
            if (rsMap != null && "ok".equals(rsMap.get("operate"))) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("userId", String.valueOf(RequestContext.get().getCurrUserId()));
                option.setVariableValue("pageId", this.getView().getPageId());
                option.setVariableValue(CALLBACK_INVOKE, "true");
                if (SWCStringUtils.equals((String)actionId, (String)"donothing_reject")) {
                    option.setVariableValue("opreason", (String)rsMap.get("opreason"));
                    option.setVariableValue("pageId", this.getView().getPageId());
                    this.getView().invokeOperation("donothing_reject", option);
                } else if (SWCStringUtils.equals((String)actionId, (String)"donothing_abandon")) {
                    option.setVariableValue("opreason", (String)rsMap.get("opreason"));
                    this.getView().invokeOperation("donothing_abandon", option);
                }
                if (SWCStringUtils.equals((String)actionId, (String)DONOTHING_UPDATEBSED)) {
                    option.setVariableValue("description", (String)rsMap.get("description"));
                    option.setVariableValue("updatebsed", (String)rsMap.get("updatebsed"));
                    DynamicObject bizItemGroup = (DynamicObject)this.getView().getParentView().getModel().getValue(BIZITEMGROUP);
                    option.setVariableValue(BIZITEMGROUP, bizItemGroup.getString("id"));
                    this.getView().invokeOperation(DONOTHING_UPDATEBSED, option);
                }
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List columns = args.getListColumns();
        List<IListColumn> newColumns = this.buildBizDataCloumns(columns);
        args.setListColumns(newColumns);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        FormOperate op = (FormOperate)args.getSource();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Object> primaryKeyValues = Arrays.asList(selectedRows.getPrimaryKeyValues());
        switch (operateKey) {
            case "donothing_abandon": 
            case "donothing_reject": 
            case "donothing_updatebsed": {
                ((IEntityOperate)op).setCancelRefresh(false);
                break;
            }
            case "donothing_export": {
                this.doExport();
                break;
            }
            case "donothing_bsedupdaterecord": {
                this.viewBsedUpdateRecord(primaryKeyValues);
                break;
            }
            case "donothing_viewmodifyrecord": {
                this.viewBizDataModifyRecord(primaryKeyValues);
                break;
            }
            case "donothing_viewmodifyrecordcol": {
                ArrayList<Object> focusRows = new ArrayList<Object>(1);
                focusRows.add(this.getFocusRowPkId());
                this.viewBizDataModifyRecord(focusRows);
                break;
            }
            case "donothing_grptrans": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void viewBizDataModifyRecord(List<Object> primaryKeyValues) {
        QFilter filter = new QFilter("modeltype", "=", (Object)MODELTYPE_2);
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            filter.and("dataid", "in", primaryKeyValues);
        }
        DynamicObject bizItemGroup = (DynamicObject)this.getView().getParentView().getModel().getValue(BIZITEMGROUP);
        filter.and(BIZITEMGROUP, "=", (Object)bizItemGroup.getLong("id"));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_bizdatamodify_hvall");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            showParameter.setCustomParam("dataids", primaryKeyValues);
        }
        showParameter.setCustomParam("modeltype", (Object)MODELTYPE_2);
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BizDataRecordLoadDataImpl());
    }

    public void getEntityType(GetEntityTypeEventArgs event) {
        super.getEntityType(event);
        event.setNewEntityType(this.getEntityType());
    }

    public void onGetControl(OnGetControlArgs event) {
        super.onGetControl(event);
        String key = event.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            event.setControl((Control)customControl);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        Long focusRowPkId = (Long)this.getFocusRowPkId();
        switch (fieldName) {
            case "usagecount": {
                args.setCancel(true);
                this.openCalTaskAndCalPeriodRel(focusRowPkId, false);
                break;
            }
            case "nocounttimes": {
                args.setCancel(true);
                this.openCalTaskAndCalPeriodRel(focusRowPkId, true);
                break;
            }
            case "updatetimes": {
                args.setCancel(true);
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_bizdatarecord", (String)"3PLJZFCY0TLG");
                if (!permFlag) {
                    String errorTips = ResManager.loadKDString((String)"\u65e0\u201c\u524d\u7aef\u4e1a\u52a1\u6570\u636e\uff08\u6a2a\u8868\uff09\u201d\u7684\u201c\u751f\u6548\u65e5\u671f\u66f4\u65b0\u8bb0\u5f55\u201d\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizDataRecordListPlugin_06", (String)MODULE_NAME, (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorTips);
                    break;
                }
                ArrayList<Object> idList = new ArrayList<Object>(10);
                idList.add(focusRowPkId);
                this.viewBsedUpdateRecord(idList);
                break;
            }
        }
    }

    protected BillList createBillList(String key) {
        if (this.billList != null) {
            return this.billList;
        }
        this.billList = new BizDataEntityTypeBillList((EntityType)this.getEntityType());
        this.billList.setKey(key);
        this.billList.setEntityId("hsas_bizdatarecord");
        ListView listView = (ListView)this.getView();
        this.billList.setBillFormId(listView.getBillFormId());
        this.billList.setView((IFormView)listView);
        Container rootControl = (Container)this.getView().getRootControl();
        this.replaceBillList(rootControl.getItems(), (Control)this.billList);
        return this.billList;
    }

    private void replaceBillList(List<Control> items, Control billList) {
        for (int i = 0; i < items.size(); ++i) {
            Control control = items.get(i);
            if (control.getKey().equals(billList.getKey())) {
                items.set(i, billList);
                return;
            }
            if (!(control instanceof Container)) continue;
            this.replaceBillList(((Container)control).getItems(), billList);
        }
    }

    private MainEntityType getEntityType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_bizdatarecord");
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = (MainEntityType)mainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("getNewEntityType: ", (Throwable)e1);
        }
        if (mainEntityType == null) {
            return mainType;
        }
        MainEntityType returnEntityType = this.addMainEntityType(mainEntityType);
        if (returnEntityType == null) {
            return mainType;
        }
        return returnEntityType;
    }

    private MainEntityType addMainEntityType(MainEntityType mainEntityType) {
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            return null;
        }
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject bizItemGroupDetailObj = this.cacheBizItemMap.get(bizItemGroupId);
        if (bizItemGroupDetailObj == null) {
            bizItemGroupDetailObj = bizDataRecordListHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
            this.cacheBizItemMap.put(bizItemGroupId, bizItemGroupDetailObj);
        }
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return null;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return null;
        }
        Map<Long, String> dataTypeMap = this.getCacheDataTypeMap();
        for (DynamicObject bizItemEntryObj : bizItemColl) {
            DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
            DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeMap.get(dataTypeId);
            this.addBizItemProp(bizItemObj, dataType, (DynamicObjectType)mainEntityType);
        }
        return mainEntityType;
    }

    private Map<Long, String> getCacheDataTypeMap() {
        if (this.cacheDataTypeMap != null && this.cacheDataTypeMap.size() > 0) {
            return this.cacheDataTypeMap;
        }
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject[] dataTypeArray = bizDataRecordListHelper.getDataType();
        if (dataTypeArray == null || dataTypeArray.length == 0) {
            return new HashMap<Long, String>(16);
        }
        HashMap<Long, String> dataTypeMap = new HashMap<Long, String>(16);
        for (DynamicObject dataTypeObj : dataTypeArray) {
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeObj.getString("storagetype");
            dataTypeMap.put(dataTypeId, dataType);
        }
        this.cacheDataTypeMap = dataTypeMap;
        return dataTypeMap;
    }

    private void addBizItemProp(DynamicObject bizItemObj, String dataType, DynamicObjectType mainEntityType) {
        String bizItemNumber = bizItemObj.getString("number");
        String bizItemName = bizItemObj.getString("name");
        if (SWCShowType.TEXT.getCode().equals(dataType)) {
            TextProp property = new TextProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setMaxLenth(bizItemObj.getInt("datalength") == 0 ? 1000 : bizItemObj.getInt("datalength"));
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.NUM.getCode().equals(dataType)) {
            DecimalProp property = new DecimalProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setPrecision(23);
            String scalelimit = bizItemObj.getString("scalelimit");
            if (SWCStringUtils.isEmpty((String)scalelimit)) {
                property.setScale(10);
            } else {
                property.setScale(Integer.parseInt(scalelimit));
            }
            property.setZeroShow(true);
            property.setEnableNull(true);
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.DATE.getCode().equals(dataType)) {
            DateProp property = new DateProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            mainEntityType.addProperty((DynamicProperty)property);
        } else if (SWCShowType.AMOUNT.getCode().equals(dataType)) {
            TextProp property = new TextProp();
            property.setName(bizItemNumber.toLowerCase());
            property.setDisplayName(new LocaleString(bizItemName));
            property.setMaxLenth(50);
            mainEntityType.addProperty((DynamicProperty)property);
        }
    }

    private List<IListColumn> buildBizDataCloumns(List<IListColumn> columns) {
        ArrayList<IListColumn> newColumns = new ArrayList<IListColumn>(10);
        for (int i = 0; i <= 3; ++i) {
            columns.get(i).setFixed(true);
            newColumns.add(columns.get(i));
        }
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            return columns;
        }
        DynamicObject bizItemGroupDetailObj = this.cacheBizItemMap.get(bizItemGroupId);
        if (bizItemGroupDetailObj == null) {
            bizItemGroupDetailObj = bizDataRecordListHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
            this.cacheBizItemMap.put(bizItemGroupId, bizItemGroupDetailObj);
        }
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return columns;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        if (bizItemColl == null || bizItemColl.size() == 0) {
            return columns;
        }
        Map<Long, String> dataTypeMap = this.getCacheDataTypeMap();
        for (DynamicObject bizItemObj : bizItemColl) {
            DynamicObject bizItemInfo = bizItemObj.getDynamicObject("bizitem");
            if (SWCObjectUtils.isEmpty((Object)bizItemInfo)) continue;
            String bizItemNumber = bizItemInfo.getString("number");
            String bizItemName = bizItemInfo.getString("name");
            DynamicObject dataTypeObj = bizItemInfo.getDynamicObject("datatype");
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeMap.get(dataTypeId);
            this.addBizItemColumns(bizItemNumber, bizItemName, dataType, newColumns);
        }
        for (int i = 4; i < columns.size(); ++i) {
            newColumns.add(columns.get(i));
        }
        return newColumns;
    }

    private void addBizItemColumns(String number, String name, String dataType, List<IListColumn> columns) {
        if (SWCShowType.NUM.getCode().equals(dataType)) {
            DecimalListColumn decimalCol = new DecimalListColumn();
            decimalCol.setCaption(new LocaleString(name));
            decimalCol.setKey(number.toLowerCase());
            decimalCol.setListFieldKey(number.toLowerCase());
            decimalCol.setZeroShow(true);
            columns.add((IListColumn)decimalCol);
        } else {
            ListColumn column = new ListColumn();
            column.setCaption(new LocaleString(name));
            column.setKey(number.toLowerCase());
            column.setListFieldKey(number.toLowerCase());
            columns.add((IListColumn)column);
        }
    }

    private void openCalTaskAndCalPeriodRel(Long bizDataRecordId, boolean isNoCnt) {
        if (bizDataRecordId == null) {
            return;
        }
        HashSet<Long> bizDataRecordIsSet = new HashSet<Long>(1);
        bizDataRecordIsSet.add(bizDataRecordId);
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject[] nonBizDatas = bizDataRecordListHelper.getNonBizDataRecordDatasByIds(bizDataRecordIsSet);
        HashSet<Long> nonBizDataIdSet = new HashSet<Long>(16);
        for (DynamicObject nonBizDataObj : nonBizDatas) {
            nonBizDataIdSet.add(nonBizDataObj.getLong("id"));
        }
        QFilter filter = new QFilter("bizdataid", "in", nonBizDataIdSet);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        ListShowParameter showParameter = new ListShowParameter();
        if (isNoCnt) {
            showParameter.setBillFormId("hsas_noncalbsnocntrel");
        } else {
            showParameter.setBillFormId("hsas_calnonbizdatarel");
        }
        showParameter.setFormId("bos_listf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4f7f\u7528\u8be6\u60c5", (String)"BizDataRecordListPlugin_5", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setListFilterParameter(new ListFilterParameter(filters, null));
        showParameter.setCustomParam("pageType", (Object)"bizDataRecord");
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.setHasRight(true);
        showParameter.addCustPlugin(BizCalTaskCalPeriodRel.class.getName());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void doExport() {
        BillList billListAp = new BillList();
        billListAp.setKey(KEY_BILL_LIST_AP);
        billListAp.setEntityId("hsas_bizdatarecord");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        for (int index = 0; index < size; ++index) {
            selectRows[index] = (Long)selectedRows.get(index).getPrimaryKeyValue();
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"bizdatagroupcacheid");
        Long bizItemGroupId = (Long)appCache.get(this.getView().getPageId() + "_cachegroupid", Long.class);
        if (bizItemGroupId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"BizDataRecordListPlugin_4", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = this.getQueryFilters(selectRows, bizItemGroupId);
        BizDataRecordListHelper bizDataRecordListHelper = new BizDataRecordListHelper();
        DynamicObject bizItemGroupDetailObj = bizDataRecordListHelper.getBizItemInfoByBizItemGroupId(bizItemGroupId.longValue());
        if (SWCObjectUtils.isEmpty((Object)bizItemGroupDetailObj)) {
            return;
        }
        DynamicObjectCollection bizItemColl = bizItemGroupDetailObj.getDynamicObjectCollection("entryentity");
        BizDataRecordListExportService bizDataRecordListExportService = new BizDataRecordListExportService();
        Map headerMap = bizDataRecordListExportService.getExportHeaders(bizItemColl);
        this.startExport(filters, headerMap, bizItemGroupId, bizItemColl);
    }

    private QFilter[] getQueryFilters(long[] selectRows, Long bizItemGroupId) {
        SWCPageCache pageCache;
        List columnFilterList;
        QFilter filter = new QFilter("bizdataaccesstpl", "=", (Object)bizItemGroupId);
        if (selectRows != null && selectRows.length > 0) {
            filter.and("id", "in", (Object)selectRows);
        }
        if ((columnFilterList = (List)(pageCache = new SWCPageCache(this.getView())).get("columnFilterList", List.class)) != null && columnFilterList.size() > 0) {
            for (String columnFilterStr : columnFilterList) {
                QFilter columnFilter = QFilter.fromSerializedString((String)columnFilterStr);
                filter.and(columnFilter);
            }
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    private void startExport(QFilter[] filters, Map<String, String> headerMap, Long bizItemGroupId, DynamicObjectCollection bizItemColl) {
        Map<Long, String> dataTypeMap = this.getCacheDataTypeMap();
        HashMap bizItemDetailMap = new HashMap(bizItemColl.size());
        for (DynamicObject bizItemEntryObj : bizItemColl) {
            DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
            String number = bizItemObj.getString("number");
            DynamicObject dataTypeObj = bizItemObj.getDynamicObject("datatype");
            long dataTypeId = dataTypeObj.getLong("id");
            String dataType = dataTypeMap.get(dataTypeId);
            if (SWCStringUtils.isEmpty((String)dataType) || !SWCShowType.NUM.getCode().equals(dataType)) continue;
            HashMap<String, Object> decimalMap = new HashMap<String, Object>(3);
            decimalMap.put("dataType", SWCShowType.NUM.getCode());
            decimalMap.put("bizItemName", bizItemObj.get("name"));
            String scalelimit = bizItemObj.getString("scalelimit");
            if (SWCStringUtils.isEmpty((String)scalelimit)) {
                decimalMap.put("scale", 10);
            } else {
                decimalMap.put("scale", Integer.parseInt(scalelimit));
            }
            bizItemDetailMap.put(number, decimalMap);
        }
        String downLoadTaskId = TaskUtil.getExportTaskID();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_bizdatarecord", filters);
        if (totalElements == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"BizDataRecordListPlugin_4", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = MessageFormat.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5217\u8868_\u524d\u7aef\u4e1a\u52a1\u6570\u636e\uff08\u6a2a\u8868\uff09_{0}", (String)"BizDataRecordListPlugin_2", (String)MODULE_NAME, (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        BizDataRecordExportProgressInfo progressInfo = new BizDataRecordExportProgressInfo();
        ThreadPools.executeOnce((String)"BIZDATARECORD_EXPORT_EXCEL_POOL_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try (SXSSFWorkbook wb = new SXSSFWorkbook(ROW_ACCESS_WINDOWS_SIZE);){
                SXSSFSheet sheet = wb.createSheet();
                sheet.setRandomAccessWindowSize(-1);
                wb.setSheetName(0, fileName);
                BizDataRecordListExportService bizDataRecordListExportService = new BizDataRecordListExportService();
                bizDataRecordListExportService.write2ExportHead(sheet, headerMap);
                ReentrantLock lock = new ReentrantLock();
                int pageIndex = 0;
                while (pageIndex < totalPages) {
                    int currentPage = pageIndex++;
                    SWCThreadPoolFactory.getBizdataExportThreadpool().execute(() -> {
                        try {
                            RequestContext.copyAndSet((RequestContext)ctx);
                            List data = bizDataRecordListExportService.getExportData(filters, bizItemGroupId, currentPage, PAGE_SIZE.intValue());
                            lock.lock();
                            bizDataRecordListExportService.write2ExportContent(sheet, Integer.valueOf(currentPage * PAGE_SIZE + 1), data, headerMap, bizItemDetailMap);
                        }
                        catch (Exception e) {
                            this.log.error("BizDataRecordListExportPlugin.doExportAll.error. ", (Throwable)e);
                        }
                        finally {
                            lock.unlock();
                            countDownLatch.countDown();
                            SWCPageCache pageCache = new SWCPageCache(this.getView());
                            double percent = (double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages;
                            double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
                            long complete = 0L;
                            if (totalElements < 100) {
                                complete = totalElements;
                            } else {
                                complete = ((long)totalPages - countDownLatch.getCount()) * (long)PAGE_SIZE.intValue();
                                if (complete > (long)totalElements) {
                                    complete = totalElements;
                                }
                            }
                            pageCache.put(PROGRESS + downLoadTaskId, (Object)progress);
                            pageCache.put(COMPLETE + downLoadTaskId, (Object)complete);
                            pageCache.saveChanges();
                            TaskUtil.addTaskInfoToCache((BizDataRecordExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)((int)complete), (String)downLoadTaskId);
                        }
                    });
                }
                if (countDownLatch.await(30L, TimeUnit.MINUTES)) {
                    this.flushAll(headerMap, sheet, fileName, totalPages, stopWatch, countDownLatch, downLoadTaskId, progressInfo, totalElements);
                }
            }
            catch (Exception e) {
                this.log.error((Throwable)e);
            }
        });
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCaption(ResManager.loadKDString((String)"\u524d\u7aef\u4e1a\u52a1\u6570\u636e\uff08\u6a2a\u8868\uff09\u5bfc\u51fa\u8fdb\u5ea6", (String)"BizDataRecordListPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]));
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u8bb0\u5f55", (String)"BizDataRecordListPlugin_3", (String)MODULE_NAME, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void flushAll(Map<String, String> headers, SXSSFSheet sheet, String fileName, int totalPages, StopWatch stopWatch, CountDownLatch countDownLatch, String downLoadTaskId, BizDataRecordExportProgressInfo progressInfo, int totalElements) throws IOException {
        List headList = SWCExportDataHelper.HeadMapToListMap(headers);
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            Map columnMap = (Map)headList.get(i);
            String key = (String)columnMap.get("key");
            if (SWCStringUtils.equals((String)key, (String)"fseq")) {
                sheet.setColumnWidth(i, columnWidth);
                continue;
            }
            sheet.setColumnWidth(i, columnWidth * 4);
        }
        String url = SWCExportDataHelper.safeWriteFile((SXSSFWorkbook)sheet.getWorkbook(), (String)fileName);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        if (percent.intValue() >= 100) {
            pageCache.put("url" + downLoadTaskId, (Object)url);
            pageCache.put(PROGRESS + downLoadTaskId, (Object)percent);
            pageCache.put(COMPLETE + downLoadTaskId, (Object)totalElements);
            pageCache.saveChanges();
            progressInfo.setUrl(url);
        }
        double progress = BigDecimal.valueOf(percent).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        TaskUtil.addTaskInfoToCache((BizDataRecordExportProgressInfo)progressInfo, (int)totalElements, (Double)progress, (int)totalElements, (String)downLoadTaskId);
        stopWatch.stop();
        this.log.info("ending export data: {},countdown: {}", (Object)stopWatch.toString(), (Object)countDownLatch.getCount());
    }

    private void cacheColumnFilter(SetFilterEvent event) {
        List filterList = event.getMergeQFilters();
        if (filterList != null && filterList.size() > 0) {
            ArrayList<String> columnFilterList = new ArrayList<String>(filterList.size());
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            for (QFilter qFilter : filterList) {
                if (qFilter == null) continue;
                String comulnFilterStr = qFilter.toSerializedString();
                columnFilterList.add(comulnFilterStr);
            }
            pageCache.put("columnFilterList", columnFilterList);
        }
    }

    private void doUpdateBsedPop() {
        if (!this.updateBsed()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6570\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u4e14\u4f7f\u7528\u6b21\u6570\u4e3a0\u7684\u6570\u636e\u66f4\u65b0\u751f\u6548\u65e5\u671f\u3002", (String)"NonRecurBizDataListPlugin_01", (String)MODULE_NAME, (Object[])new Object[0]));
            return;
        }
        this.openUpdateBsedPop();
    }

    private boolean updateBsed() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List<Object> bizDataIdList = Arrays.asList(selectedRows.getPrimaryKeyValues());
        QFilter filter = new QFilter("id", "in", bizDataIdList);
        filter.and("auditstatus", "=", (Object)"C");
        filter.and("usagecount", "=", (Object)BigDecimal.ZERO);
        SWCDataServiceHelper nonRecurHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
        BizDataHelper bizDataHelper = new BizDataHelper();
        DynamicObject[] bizDataColl = bizDataHelper.getBizDataColl(nonRecurHelper, filter);
        return bizDataIdList.size() == bizDataColl.length;
    }

    private void openUpdateBsedPop() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_bizdataopconfirm");
        SWCSecurityServiceHelper.setSwcSecurityFlag((FormShowParameter)showParameter);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("operate", (Object)"updateBsed");
        StyleCss css = new StyleCss();
        css.setWidth("460px");
        css.setHeight("310px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u6548\u65e5\u671f", (String)"NonRecurBizDataListPlugin_02", (String)MODULE_NAME, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DONOTHING_UPDATEBSED));
        this.getView().showForm(showParameter);
    }

    private void viewBsedUpdateRecord(List<Object> primaryKeyValues) {
        DynamicObject bizItemGroup = (DynamicObject)this.getView().getParentView().getModel().getValue(BIZITEMGROUP);
        QFilter filter = new QFilter("operate", "=", (Object)OPERATE_UPDATEBSED);
        filter.and("modeltype", "=", (Object)MODELTYPE_2);
        filter.and(BIZITEMGROUP, "=", (Object)bizItemGroup.getLong("id"));
        if (!CollectionUtils.isEmpty(primaryKeyValues)) {
            filter.and("dataid", "in", primaryKeyValues);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_bizdatamodify_hvbsed");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        showParameter.setCustomParam("modeltype", (Object)MODELTYPE_2);
        showParameter.setCaption(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u66f4\u65b0\u8bb0\u5f55", (String)"BizDataRecordListPlugin_6", (String)MODULE_NAME, (Object[])new Object[0]));
        ListFilterParameter filterParams = showParameter.getListFilterParameter();
        filterParams.setQFilters(Collections.singletonList(filter));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void bizDataRecordOperate(ListSelectedRowCollection selectColl) {
        if (selectColl == null || selectColl.size() == 0) {
            return;
        }
        Long payRollGroupId = (Long)selectColl.get(0).getPrimaryKeyValue();
        OperateOption option = OperateOption.create();
        DynamicObject bizItemGroup = (DynamicObject)this.getView().getParentView().getModel().getValue(BIZITEMGROUP);
        Long bizItemGroupId = bizItemGroup.getLong("id");
        String bizItemGroupName = bizItemGroup.getString("name");
        BizDataHelper bizDataHelper = new BizDataHelper();
        Map payRollGroupInfo = bizDataHelper.getPayRollGroupOrgId(payRollGroupId);
        Long payRollGroupOrgId = (Long)payRollGroupInfo.get("payRollGroupId");
        String payRollGroupName = (String)payRollGroupInfo.get("payRollGroupName");
        HashSet<Long> bizItemGroupIdSet = new HashSet<Long>(1);
        bizItemGroupIdSet.add(bizItemGroupId);
        Set queryBizItemGroupIdSet = SWCPermissionServiceHelper.queryBaseDataUseOrgSet((String)"hsbs_bizitemgroup", (Long)payRollGroupOrgId, bizItemGroupIdSet);
        if (queryBizItemGroupIdSet == null || queryBizItemGroupIdSet.size() == 0 || !queryBizItemGroupIdSet.contains(bizItemGroupId)) {
            String errorMsg = ResManager.loadKDString((String)"\u8f6c\u79fb\u5931\u8d25\uff1a\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u201c{0}\u201d\u5728\u8f6c\u79fb\u540e\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201c{1}\u201d\u4e0b\u4e0d\u53ef\u7528\u3002", (String)"BizDataRecordListPlugin_08", (String)MODULE_NAME, (Object[])new Object[0]);
            this.getView().showErrorNotification(MessageFormat.format(errorMsg, bizItemGroupName, payRollGroupName));
            return;
        }
        option.setVariableValue("payRollGroupId", String.valueOf(payRollGroupId));
        option.setVariableValue("bizItemGroupId", String.valueOf(bizItemGroupId));
        option.setVariableValue(CALLBACK_INVOKE, "true");
        this.getView().invokeOperation("donothing_grptrans", option);
    }

    public class BizDataRecordLoadDataImpl
    extends ListDataProvider {
        boolean isSelectAllRows = false;

        protected boolean isOnlyPK4SelectedAllRows() {
            this.isSelectAllRows = true;
            return true;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection bizDataRecordDatas = super.getData(start, limit);
            if (bizDataRecordDatas == null || bizDataRecordDatas.size() == 0 || this.isSelectAllRows) {
                return bizDataRecordDatas;
            }
            BizDataRecordListPlugin.this.addMainEntityType((MainEntityType)bizDataRecordDatas.getDynamicObjectType());
            BizDataRecordListService service = new BizDataRecordListService();
            Map dataTypeMap = BizDataRecordListPlugin.this.getCacheDataTypeMap();
            service.getBizDataRecordDatas(bizDataRecordDatas, dataTypeMap);
            return bizDataRecordDatas;
        }
    }
}

