/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalCheckWaitPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(CalCheckWaitPlugin.class);

    public void initialize() {
        super.initialize();
        ProgressBar calCheckWaitProcess = (ProgressBar)this.getControl("waitprogress");
        calCheckWaitProcess.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        Control control = (Control)progressEvent.getSource();
        String progressKey = control.getKey();
        int progress = progressEvent.getProgress();
        log.info("onProgress:{}", (Object)progress);
        if (100 == progress) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String cacheUUID = formShowParameter.getCustomParam("cacheUUID").toString();
            Boolean isOneCalTaskForTax = (Boolean)formShowParameter.getCustomParam("isOneCalTaskForTax");
            HashMap<String, Object> backData = new HashMap<String, Object>(3);
            backData.put("cacheUUID", cacheUUID);
            backData.put("isOneCalTaskForTax", isOneCalTaskForTax);
            this.getView().returnDataToParent(backData);
            this.getView().close();
        }
        if (StringUtils.equals((CharSequence)progressKey, (CharSequence)"waitprogress")) {
            this.queryAndSetProgressDetails(progressEvent);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        ProgressBar calCheckWaitProcess = (ProgressBar)this.getControl("waitprogress");
        calCheckWaitProcess.start();
        calCheckWaitProcess.setPercent(0);
    }

    public void pageRelease(EventObject eventObject) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String cacheUUID = formShowParameter.getCustomParam("cacheUUID").toString();
        ISWCAppCache errMsgCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_ERRMSG_%s", cacheUUID));
        errMsgCache.remove("cal_param");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
        String finishCacheKey = String.format(Locale.ROOT, "finish_cal_check_%s", cacheUUID);
        String finishCheckCertCacheKey = String.format(Locale.ROOT, "finish_check_cert_%s", cacheUUID);
        String checkCertFailKey = String.format(Locale.ROOT, "check_cert_fail_%s", cacheUUID);
        appCache.remove(finishCacheKey);
        appCache.remove(finishCheckCertCacheKey);
        appCache.remove(checkCertFailKey);
    }

    private void queryAndSetProgressDetails(ProgressEvent progressEvent) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String cacheUUID = formShowParameter.getCustomParam("cacheUUID").toString();
        Boolean isOneCalTaskForTax = (Boolean)formShowParameter.getCustomParam("isOneCalTaskForTax");
        Integer personCount = (Integer)formShowParameter.getCustomParam("personCount");
        HashMap<String, Object> backData = new HashMap<String, Object>(3);
        backData.put("cacheUUID", cacheUUID);
        backData.put("isOneCalTaskForTax", isOneCalTaskForTax);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
        String finishCacheKey = String.format(Locale.ROOT, "finish_cal_check_%s", cacheUUID);
        String finishCheckCertCacheKey = String.format(Locale.ROOT, "finish_check_cert_%s", cacheUUID);
        String checkCertFailKey = String.format(Locale.ROOT, "check_cert_fail_%s", cacheUUID);
        if (this.getView() == null || this.getView().getParentView() == null) {
            appCache.remove(finishCacheKey);
            appCache.remove(finishCheckCertCacheKey);
            return;
        }
        String parentPageId = this.getView().getParentView().getPageId();
        ISWCAppCache errMsgCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_ERRMSG_%s", parentPageId));
        String errMsg = (String)errMsgCache.get("cal_param", String.class);
        if (SWCStringUtils.isNotEmpty((String)errMsg)) {
            HashMap<String, String> errMsgMap = new HashMap<String, String>(1);
            errMsgMap.put("errMsg", errMsg);
            backData.put("errMap", errMsgMap);
            progressEvent.setProgress(100);
            this.getView().returnDataToParent(backData);
            this.getView().close();
            return;
        }
        if ("1".equals(appCache.get(checkCertFailKey, String.class))) {
            progressEvent.setProgress(100);
            this.getView().returnDataToParent(backData);
            this.getView().close();
            return;
        }
        Integer finishCheckCertCount = (Integer)appCache.get(finishCheckCertCacheKey, Integer.class);
        Integer finishCount = (Integer)appCache.get(finishCacheKey, Integer.class);
        if (finishCount == null) {
            finishCount = 0;
        }
        if (finishCheckCertCount == null) {
            finishCheckCertCount = 0;
        }
        int progress = (finishCount * 10 + finishCheckCertCount * 90) / personCount;
        progressEvent.setProgress(progress);
        if (progress >= 100) {
            this.getView().returnDataToParent(backData);
            this.getView().close();
        }
    }
}

