/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class CalPerformanceReportPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(CalPerformanceReportPlugin.class);
    private static final String FIELD_CALTASK = "caltask";
    private static final String FIELD_SALARYFILE = "salaryfile";
    private static final String EXPORTCALCLASS = "exportcalclass";
    private static final String CAL = "cal";

    public void registerListener(EventObject e) {
        BasedataEdit salaryFile = (BasedataEdit)this.getView().getControl(FIELD_SALARYFILE);
        salaryFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject data;
        DynamicObjectCollection salaryFileList;
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (CAL.equals(opKey) && ((salaryFileList = (data = this.getModel().getDataEntity()).getDynamicObjectCollection(FIELD_SALARYFILE)) == null || salaryFileList.size() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u85aa\u8d44\u6863\u6848", (String)"CalPerformanceReportPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (EXPORTCALCLASS.equals(args.getOperateKey())) {
            this.buildCalClass();
        } else if (CAL.equals(args.getOperateKey())) {
            this.exportCalPerformanceReport();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCalPerformanceReport() {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject calTask = data.getDynamicObject(FIELD_CALTASK);
        DynamicObjectCollection salaryFileList = data.getDynamicObjectCollection(FIELD_SALARYFILE);
        List salaryFileIdList = salaryFileList.stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
        QFilter filter = new QFilter("salaryfile.id", "in", salaryFileIdList);
        filter.and("caltask.id", "=", (Object)calTask.getLong("id"));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection calPersonData = helper.queryOriginalCollection("id,filenumber", new QFilter[]{filter});
        HashMap<Long, String> calPersonMap = new HashMap<Long, String>(calPersonData.size());
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(calPersonData.size());
        for (DynamicObject obj2 : calPersonData) {
            calPersonIdList.add(obj2.getLong("id"));
            calPersonMap.put(obj2.getLong("id"), obj2.getString("filenumber"));
        }
        Map resultMap = (Map)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ISalaryCalToolService", (String)"getCalPerformanceReportData", (Object[])new Object[]{calTask.getLong("id"), calPersonIdList});
        String totalMsg = ResManager.loadKDString((String)"\u672c\u6b21\u8ba1\u7b97\u7684\u4efb\u52a1\u4e3a\u201c{0}\u201d\uff0c\u8ba1\u7b97\u4eba\u6570\u4e3a{1}\u4e2a\uff0c\u603b\u8017\u65f6{2}\u6beb\u79d2\uff08\u4e0d\u5305\u542b\u6570\u636e\u4fdd\u5b58\u8017\u65f6\uff09\uff0c\u5176\u4e2d\u8ba1\u7b97\u524d\u53c2\u6570\u5904\u7406\u8017\u65f6{3}\u6beb\u79d2\uff0c\u521b\u5efa\u8ba1\u7b97\u7c7b\u8017\u65f6{4}\u6beb\u79d2\uff0c\u53d6\u6570\u8017\u65f6{5}\u6beb\u79d2\uff0c\u8ba1\u7b97\u8017\u65f6{6}\u6beb\u79d2\u3002", (String)"CalPerformanceReportPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        long totalConsumeTime = (Long)resultMap.get("totalConsumeTime");
        long handleParamsBeforCal = (Long)resultMap.get("handleParamsBeforCal");
        long createCalClass = (Long)resultMap.get("createCalClass");
        long fecthData = (Long)resultMap.get("fecthData");
        long cal = (Long)resultMap.get(CAL);
        totalMsg = MessageFormat.format(totalMsg, calTask.getString("number"), calPersonIdList.size(), totalConsumeTime, handleParamsBeforCal, createCalClass, fecthData, cal);
        String fetchMsg = ResManager.loadKDString((String)"\u53d6\u6570\u8017\u65f6\u8be6\u60c5\u5982\u4e0b\uff1a\u793e\u4fdd\u9879\u76ee\u53d6\u6570\u8017\u65f6{0}\u6beb\u79d2\uff0c\u7ed3\u679c\u8986\u76d6\u53d6\u6570\u8017\u65f6{1}\u6beb\u79d2\uff0c\u53d6\u6570\u9879\u76ee\u53d6\u6570\u8017\u65f6{2}\u6beb\u79d2\uff0c\u7d2f\u52a0\u5668\u8fd0\u884c\u8017\u65f6{3}\u6beb\u79d2\uff0c\u4e1a\u52a1\u9879\u76ee\u53d6\u6570\u8017\u65f6{4}\u6beb\u79d2\u3002", (String)"CalPerformanceReportPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        Map fetchConsumeTimeMap = (Map)resultMap.get("fetchConsumeTimeMap");
        long insuranceItem = (Long)fetchConsumeTimeMap.get("insuranceItem");
        long resultCover = (Long)fetchConsumeTimeMap.get("resultCover");
        long ftItem = (Long)fetchConsumeTimeMap.get("ftItem");
        long acc = (Long)fetchConsumeTimeMap.get("acc");
        long bsItem = (Long)fetchConsumeTimeMap.get("bsItem");
        fetchMsg = MessageFormat.format(fetchMsg, insuranceItem, resultCover, ftItem, acc, bsItem);
        StringBuilder exportContentSb = new StringBuilder();
        exportContentSb.append(totalMsg).append(" \r\n").append(" \r\n").append(fetchMsg).append("  \r\n").append("  \r\n");
        this.getFetchConfigData(fetchConsumeTimeMap, exportContentSb);
        this.buildFormulaData(exportContentSb, resultMap, calPersonMap);
        String exportContent = exportContentSb.toString();
        String fileName = ResManager.loadKDString((String)"\u8ba1\u7b97\u6027\u80fd\u5206\u6790\u62a5\u544a", (String)"CalPerformanceReportPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        fileName = this.getDownloadFileName(fileName, "txt");
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(exportContent.getBytes("UTF-8"));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            this.getView().download(url);
        }
        catch (Exception ex) {
            log.error("exportCalPerformanceReport err", (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    log.error("exportCalPerformanceReport err", (Throwable)ex);
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
        }
    }

    private void buildFormulaData(StringBuilder exportContentSb, Map<String, Object> resultMap, Map<Long, String> calPersonMap) {
        Map formulaConsumeTimeMap = (Map)resultMap.get("formulaConsumeTimeMap");
        if (formulaConsumeTimeMap == null || formulaConsumeTimeMap.size() == 0) {
            return;
        }
        String fileMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u201c{0}\u201d\u7684\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u516c\u5f0f\u8017\u65f6\u60c5\u51b5\u5982\u4e0b", (String)"CalPerformanceReportPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String formulaMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u5bf9\u5e94\u7684\u8ba1\u7b97\u516c\u5f0f\u8017\u65f6{1}\u6beb\u79d2\u3002", (String)"CalPerformanceReportPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        for (Map.Entry entry : formulaConsumeTimeMap.entrySet()) {
            if (entry.getValue() == null || ((Map)entry.getValue()).size() == 0) continue;
            exportContentSb.append("******").append(MessageFormat.format(fileMsg, calPersonMap.get(entry.getKey()))).append("******").append("\r\n");
            for (Map.Entry formulaEntry : ((Map)entry.getValue()).entrySet()) {
                exportContentSb.append("    ").append(MessageFormat.format(formulaMsg, formulaEntry.getKey(), formulaEntry.getValue())).append("\r\n");
            }
        }
    }

    private void getFetchConfigData(Map<String, Object> fetchConsumeTimeMap, StringBuilder exportContentSb) {
        Map fetchConfigMap = (Map)fetchConsumeTimeMap.get("ftItemConfig");
        if (fetchConfigMap != null && fetchConfigMap.size() > 0) {
            exportContentSb.append(ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee\u5bf9\u5e94\u7684\u53d6\u6570\u914d\u7f6e\u8017\u65f6\u8be6\u60c5\u660e\u7ec6\u5982\u4e0b", (String)"CalPerformanceReportPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append("\uff1a").append("\r\n");
            String fetchConfigMsg = ResManager.loadKDString((String)"\u53d6\u6570\u914d\u7f6e\u201c{0}\u201d\u8017\u65f6{1}\u6beb\u79d2\u3002", (String)"CalPerformanceReportPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            for (Map.Entry entry : fetchConfigMap.entrySet()) {
                exportContentSb.append("    ").append(MessageFormat.format(fetchConfigMsg, entry.getKey(), entry.getValue())).append("\r\n");
            }
        }
        exportContentSb.append("\r\n");
    }

    private String getDownloadFileName(String name, String type) {
        String fileName = name + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + type;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCalClass() {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject calTask = data.getDynamicObject(FIELD_CALTASK);
        byte[] calClassArr = (byte[])SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"ISalaryCalToolService", (String)"getCalClass", (Object[])new Object[]{calTask.getLong("id")});
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(calClassArr);
            String fileName = "FormulaParseImplDemo.class";
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            this.getView().download(url);
        }
        catch (Exception ex) {
            log.error("buildCalClass err", (Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    log.error("buildCalClass err", (Throwable)ex);
                    this.getView().showErrorNotification(ex.getMessage());
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject calTask = data.getDynamicObject(FIELD_CALTASK);
        if (calTask == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u4efb\u52a1", (String)"CalPerformanceReportPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (FIELD_SALARYFILE.equals(fieldKey)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            QFilter filter = new QFilter("caltask.id", "=", (Object)calTask.getLong("id"));
            DynamicObjectCollection collection = helper.queryOriginalCollection("id,salaryfile.id", new QFilter[]{filter});
            Set salaryFileIdSet = collection.stream().map(obj -> obj.getLong("salaryfile.id")).collect(Collectors.toSet());
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            filter = new QFilter("id", "in", salaryFileIdSet);
            param.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (FIELD_CALTASK.equals(name)) {
            this.getModel().setValue(FIELD_SALARYFILE, null);
        }
    }
}

