/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.calreport.utils.CalReportDateUtil;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalRecordListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CalRecordListPlugin.class);
    public static final String CALRECORDID_KEY = "calRecordIds";
    private static final String REPORTNUM_KEY = "reportnum";
    private static final String BTN_CALSTOP = "btncancelcal";
    private static final String CAL_STATUS_CALING = "1";
    private static final String CAL_REPORT_PAGE = "hsas_calreport";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (SWCStringUtils.equals((String)BTN_CALSTOP, (String)key)) {
            IListView view = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalRecordListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CALSTOP, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
            btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalRecordListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"CalRecordListPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u8ba1\u7b97\u5c06\u505c\u6b62\u5f53\u524d\u8ba1\u7b97\uff0c\u5e76\u56de\u6eda\u672c\u6b21\u8ba1\u7b97\u7684\u6240\u6709\u6838\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CalRecordListPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
        }
    }

    private void cancelCal() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection calRecordList = calRecordHelper.queryOriginalCollection("id,calstatus,caltask.id,reportnum", new QFilter[]{filter});
        CalTableCalService calService = new CalTableCalService();
        ArrayList<String> failList = new ArrayList<String>(calRecordList.size());
        StringBuilder msgKey = new StringBuilder();
        Map resultMap = null;
        int successCount = 0;
        String errorLevel = null;
        for (DynamicObject calRecord : calRecordList) {
            msgKey.setLength(0);
            if (!SWCStringUtils.equals((String)CAL_STATUS_CALING, (String)calRecord.getString("calstatus"))) {
                failList.add(msgKey.append(calRecord.getString(REPORTNUM_KEY)).append('\uff1a').append(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8ba1\u7b97\u72b6\u6001\u4e3a\u201c\u8ba1\u7b97\u4e2d\u201d\u7684\u62a5\u544a\u8fdb\u884c\u7ec8\u6b62\u8ba1\u7b97\u3002", (String)"CalRecordListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0])).toString());
                continue;
            }
            try {
                resultMap = calService.cancelCal(Long.valueOf(calRecord.getLong("id")), Long.valueOf(calRecord.getLong("caltask.id")));
                if (resultMap != null && resultMap.size() > 0) {
                    failList.add(msgKey.append(calRecord.getString(REPORTNUM_KEY)).append('\uff1a').append((String)resultMap.get("msg")).toString());
                    errorLevel = (String)resultMap.get("level");
                    continue;
                }
                ++successCount;
            }
            catch (Exception e) {
                logger.error("cancelCal error", (Throwable)e);
                failList.add(msgKey.append(calRecord.getString(REPORTNUM_KEY)).append('\uff1a').append(e.getMessage()).toString());
            }
        }
        if (calRecordList.size() == 1) {
            if (failList.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u3002\u6bcf\u4e2a\u8ba1\u7b97\u8bf7\u6c425\u5206\u949f\u5185\u4ec5\u5141\u8bb8\u7ec8\u6b62\u4e00\u6b21\u3002", (String)"CalRecordListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else if (SWCStringUtils.equals(errorLevel, (String)String.valueOf(ErrorLevel.Warning.getValue()))) {
                this.getView().showTipNotification((String)failList.get(0));
            } else {
                this.getView().showErrorNotification((String)failList.get(0));
            }
        } else if (failList.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u3002\u6bcf\u4e2a\u8ba1\u7b97\u8bf7\u6c425\u5206\u949f\u5185\u4ec5\u5141\u8bb8\u7ec8\u6b62\u4e00\u6b21\u3002", (String)"CalRecordListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalRecordListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u7ec8\u6b62\u8ba1\u7b97\u64cd\u4f5c\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761\u3002", (String)"CalRecordListPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), successCount, failList.size());
            FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
            this.getView().showForm(parameters);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        String callBackId = evt.getCallBackId();
        if (SWCStringUtils.equals((String)BTN_CALSTOP, (String)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.cancelCal();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List fastFilterColumnsList = args.getFastFilterColumns();
        if (fastFilterColumnsList.isEmpty()) {
            return;
        }
        for (FilterColumn fastFilterColumn : fastFilterColumnsList) {
            String fieldName;
            switch (fieldName = fastFilterColumn.getFieldName()) {
                case "reportnum": {
                    List calRecordIds = (List)formShowParameter.getCustomParam(CALRECORDID_KEY);
                    if (SWCObjectUtils.isEmpty((Object)calRecordIds)) break;
                    fastFilterColumn.setDefaultValues(this.getReportNums(calRecordIds));
                    break;
                }
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        Date startDate = e.getRowData().getDate("starttime");
        Date endDate = e.getRowData().getDate("endtime");
        String timeStr = CalReportDateUtil.getTimeStr((Date)startDate, (Date)endDate);
        e.getRowData().set("calduration", (Object)timeStr);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String entryId = this.getView().getEntityId();
        if (SWCStringUtils.equals((String)entryId, (String)"bos_list")) {
            args.setCancel(true);
            IListView listView = (IListView)this.getView();
            ListSelectedRow selectRow = listView.getCurrentSelectedRowInfo();
            Long selectId = (Long)selectRow.getPrimaryKeyValue();
            if (selectId != null) {
                this.openCalReportPage(selectId);
            }
        }
    }

    private void openCalReportPage(Long calReportId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(CAL_REPORT_PAGE);
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CalRecordListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("calReportId", (Object)calReportId);
        this.getView().showForm(showParameter);
    }

    private List<Object> getReportNums(List<Long> calRecordIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrecord");
        String selectProperties = REPORTNUM_KEY;
        QFilter filter = new QFilter("id", "in", calRecordIds);
        DynamicObject[] query = helper.query(selectProperties, new QFilter[]{filter});
        ArrayList<Object> results = new ArrayList<Object>(10);
        if (query == null || query.length == 0) {
            return results;
        }
        for (DynamicObject dynamicObject : query) {
            results.add(dynamicObject.getString(REPORTNUM_KEY));
        }
        return results;
    }

    public void setFilter(SetFilterEvent event) {
        event.setOrderBy("starttime desc");
    }
}

