/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.cal.export.SWCExportDataHelper;
import kd.swc.hsas.business.cal.helper.CalVersionHelper;
import kd.swc.hsas.business.calitem.CalItemGroupHelper;
import kd.swc.hsas.common.constants.SalaryFileExportConstants;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CalVersionListPlugin
extends AbstractListPlugin
implements EntryGridBindDataListener,
SearchEnterListener {
    private static Log logger = LogFactory.getLog(CalVersionListPlugin.class);
    private static final String CALVERSIONNO = "calversionno";
    private static final String HSAS_CALVERSION = "hsas_calversion";
    private static final String KEY_SEARCH = "searchap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadCustomData();
    }

    private void loadCustomData() {
        String calVersionNo = this.getCalVersionNo();
        List list = CalVersionHelper.getEntryContent((String)calVersionNo);
        Map<Double, DynamicObject> dataMap = this.assembleDataMap(list);
        this.rebuildEntryEntity(dataMap);
    }

    private String getCalVersionNo() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String calversionno = (String)parameter.getCustomParam(CALVERSIONNO);
        return calversionno;
    }

    private void rebuildEntryEntity(Map<Double, DynamicObject> dataMap) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.deleteEntryData("treeentryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("pid", new Object[0]);
        vs.addField("index", new Object[0]);
        vs.addField("versiontype", new Object[0]);
        vs.addField("number", new Object[0]);
        vs.addField("name", new Object[0]);
        vs.addField("showname", new Object[0]);
        vs.addField("formulaexp", new Object[0]);
        vs.addField("salaryitemname", new Object[0]);
        vs.addField("formulav", new Object[0]);
        vs.addField("datagradev", new Object[0]);
        vs.addField("datatype", new Object[0]);
        vs.addField("taxprojschemev", new Object[0]);
        for (Map.Entry<Double, DynamicObject> entryInfo : dataMap.entrySet()) {
            DynamicObject obj = entryInfo.getValue();
            if (SWCStringUtils.equals((String)"0", (String)obj.getString("datatype"))) {
                this.addTaxItemSchRow(entryInfo, vs);
                continue;
            }
            boolean isFormula = SWCStringUtils.equals((String)"1", (String)obj.getString("datatype"));
            String index = isFormula ? String.valueOf(entryInfo.getKey().intValue()) : String.valueOf(entryInfo.getKey());
            long id = isFormula ? obj.getLong("formulav.id") : obj.getLong("datagradev.id");
            long pid = isFormula ? 0L : obj.getLong("formulav.id");
            String name = isFormula ? obj.getString("formulav.name") : obj.getString("datagradev.name");
            String number = isFormula ? obj.getString("formulav.number") : obj.getString("datagradev.number");
            String formulaExp = isFormula ? obj.getString("formulav.originalexp") : "";
            String versionType = isFormula ? ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"CalVersionFormulaKey_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7", (String)"CalVersionFormulaKey_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            vs.addRow(new Object[]{id, pid, index, versionType, number, name, obj.getString("showname"), formulaExp, obj.getString("salaryitemname"), obj.getString("formulav.id"), obj.getString("datagradev.id"), obj.getString("datatype"), obj.getLong("taxprojschemev.id")});
        }
        model.batchCreateNewEntryRow("treeentryentity", vs);
        model.endInit();
        this.getView().updateView("treeentryentity");
    }

    private void addTaxItemSchRow(Map.Entry<Double, DynamicObject> entryInfo, TableValueSetter vs) {
        DynamicObject obj = entryInfo.getValue();
        String versionType = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848", (String)"CalVersionFormulaKey_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        long id = obj.getLong("taxprojschemev.id");
        long pid = 0L;
        String index = String.valueOf(entryInfo.getKey().intValue());
        vs.addRow(new Object[]{id, pid, index, versionType, obj.getString("taxprojschemev.number"), obj.getString("taxprojschemev.name"), obj.getString("showname"), "", obj.getString("salaryitemname"), obj.getString("formulav.id"), obj.getString("datagradev.id"), obj.getString("datatype"), obj.getLong("taxprojschemev.id")});
    }

    private Map<Double, DynamicObject> assembleDataMap(List<DynamicObject> list) {
        double formulaIndex;
        HashMap<Long, Map<String, String>> tmap = new HashMap<Long, Map<String, String>>(list.size());
        HashMap<Double, Object> dataMap = new HashMap<Double, Object>(list.size());
        double gradeStep = 0.1;
        List taxItemSchList = list.stream().filter(obj -> SWCStringUtils.equals((String)"0", (String)obj.getString("datatype"))).collect(Collectors.toList());
        if (taxItemSchList.size() > 0) {
            formulaIndex = 2.0;
            dataMap.put(1.0, taxItemSchList.get(0));
        } else {
            formulaIndex = 1.0;
        }
        list.sort(Comparator.comparingLong(single -> single.getLong("datagradev.id")));
        for (DynamicObject obj2 : list) {
            String gradeIndex;
            Map<String, String> indexMap;
            if (SWCStringUtils.equals((String)"0", (String)obj2.getString("datatype"))) continue;
            if (obj2.getLong("datagradev.id") <= 0L) {
                indexMap = new HashMap(1);
                gradeIndex = String.format(Locale.ROOT, "%.1f", formulaIndex + gradeStep);
                indexMap.put("gindex", gradeIndex);
                tmap.put(obj2.getLong("formulav.id"), indexMap);
                dataMap.put(formulaIndex, obj2);
                formulaIndex += 1.0;
                continue;
            }
            indexMap = (Map)tmap.get(obj2.getLong("formulav.id"));
            if (indexMap == null) {
                indexMap = new HashMap(1);
                gradeIndex = String.format(Locale.ROOT, "%.1f", formulaIndex + gradeStep);
                indexMap.put("gindex", gradeIndex);
                tmap.put(obj2.getLong("formulav.id"), indexMap);
            }
            BigDecimal bigDecimal = new BigDecimal(Double.parseDouble(indexMap.get("gindex").toString())).setScale(1, RoundingMode.HALF_UP);
            double newDouble = bigDecimal.doubleValue();
            dataMap.put(newDouble, obj2);
            String gIndex = String.format(Locale.ROOT, "%.1f", Double.parseDouble(String.valueOf(indexMap.get("gindex"))) + gradeStep);
            indexMap.put("gindex", gIndex);
        }
        Map sortedMap = dataMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
        return sortedMap;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String calVersionNo = this.getCalVersionNo();
        List list = CalVersionHelper.getEntryContentByQueryText((String)calVersionNo, (String)searchText);
        Map<Double, DynamicObject> dataMap = this.assembleDataMap(list);
        this.rebuildEntryEntity(dataMap);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "donothing-export": {
                this.doExport();
                break;
            }
            case "donothing-refresh": {
                this.loadCustomData();
                break;
            }
            case "donothing-viewformulagrade": {
                int index = this.getModel().getEntryCurrentRowIndex("treeentryentity");
                DynamicObject obj = this.getModel().getEntryRowEntity("treeentryentity", index);
                String dataType = obj.getString("datatype");
                DynamicObject formulavObj = obj.getDynamicObject("formulav");
                DynamicObject datagradevObj = obj.getDynamicObject("datagradev");
                DynamicObject taxItemSchObj = obj.getDynamicObject("taxprojschemev");
                if (SWCStringUtils.equals((String)"1", (String)dataType) && formulavObj != null) {
                    CalItemGroupHelper.openFormulahisPage((IFormView)this.getView(), (Long)formulavObj.getLong("id"), (String)formulavObj.getString("name"));
                    break;
                }
                if (SWCStringUtils.equals((String)"2", (String)dataType) && datagradevObj != null) {
                    CalItemGroupHelper.openDataGradeHisPage((IFormView)this.getView(), (Long)datagradevObj.getLong("id"), (String)datagradevObj.getString("name"));
                    break;
                }
                if (!SWCStringUtils.equals((String)"0", (String)dataType) || taxItemSchObj == null) break;
                this.openTaxItemProjSchPage(this.getView(), taxItemSchObj.getLong("id"), taxItemSchObj.getString("name"));
                break;
            }
        }
    }

    private void openTaxItemProjSchPage(IFormView formView, Long pkId, String name) {
        boolean hasPageermission = SWCPermissionServiceHelper.hasViewPermission((String)"/UHLXNRR9KPZ", (String)"hsbs_taxprojscheme");
        if (!hasPageermission) {
            formView.showMessage(ResManager.loadKDString((String)"\u65e0\"\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848\"\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalVersionFormulaKey_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("hsbs_taxprojscheme");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setPkId((Object)pkId);
        formView.showForm((FormShowParameter)showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        SXSSFWorkbook wb = new SXSSFWorkbook(SalaryFileExportConstants.ROW_ACCESS_WINDOWS_SIZE);
        try {
            SXSSFSheet sheet = wb.createSheet();
            sheet.setRandomAccessWindowSize(-1);
            wb.setSheetName(0, this.getExportFileName());
            String calVersionNo = this.getCalVersionNo();
            List<Map<String, Object>> headers = this.assembleExportHeaders();
            this.writeHeader(wb, sheet, headers);
            List list = CalVersionHelper.getEntryContent((String)calVersionNo);
            Map<Double, DynamicObject> dataMap = this.assembleDataMap(list);
            List<Map<String, Object>> dataList = this.assembleExportDataList(dataMap);
            this.writeData(wb, sheet, dataList, headers);
            this.flushAll(sheet, this.getExportFileName());
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
        finally {
            try {
                wb.close();
            }
            catch (IOException exception) {
                logger.error((Throwable)exception);
            }
        }
    }

    private void flushAll(SXSSFSheet sheet, String fileName) {
        String url = SWCExportDataHelper.storeFile((Workbook)sheet.getWorkbook(), (String)fileName);
        this.getView().download(url);
    }

    private void writeHeader(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, Object>> headers) {
        SXSSFRow headRow2 = sheet.createRow(0);
        for (int i = 0; i < headers.size(); ++i) {
            SXSSFCell cell = headRow2.createCell(i);
            String headValue = MapUtils.getString(headers.get(i), (Object)"displayName");
            cell.setCellValue(headValue);
            CellStyle headColumnStyle = CalVersionListPlugin.getHeadColumnStyle(wb);
            cell.setCellStyle(headColumnStyle);
            int width = MapUtils.getIntValue(headers.get(i), (Object)"width");
            sheet.setColumnWidth(i, width);
        }
    }

    private static CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.LEFT);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    private void writeData(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, Object>> dataList, List<Map<String, Object>> headers) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> rowData = dataList.get(i);
            if (rowData == null) continue;
            SXSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < headers.size(); ++j) {
                Map<String, Object> columnInfo = headers.get(j);
                if (columnInfo == null) continue;
                SXSSFCell cell = row.createCell(j);
                String columnCode = MapUtils.getString(columnInfo, (Object)"code");
                Object columnValue = MapUtils.getObject(rowData, (Object)columnCode);
                String columnType = MapUtils.getString(columnInfo, (Object)"dataType");
                CellStyle defaultStyle = SWCExportDataHelper.getDefaultCellStyle(columnInfo, (String)"", (SXSSFWorkbook)wb);
                cell.setCellValue(columnValue + "");
                cell.setCellType(SWCExportDataHelper.getCellType((String)columnType));
                defaultStyle.setAlignment(HorizontalAlignment.LEFT);
                cell.setCellStyle(defaultStyle);
            }
        }
    }

    private List<Map<String, Object>> assembleExportDataList(Map<Double, DynamicObject> dataMap) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<Double, DynamicObject> entryInfo : dataMap.entrySet()) {
            DynamicObject obj = entryInfo.getValue();
            String dataType = obj.getString("datatype");
            String typeName = this.getTypeNameByType(dataType);
            if (SWCStringUtils.equals((String)"0", (String)dataType)) {
                dataList.add(this.assembleExportData(typeName, String.valueOf(entryInfo.getKey().intValue()), obj.getString("taxprojschemev.number"), obj.getString("taxprojschemev.name"), obj.getString("showname"), "", obj.getString("salaryitemname")));
                continue;
            }
            boolean isFormula = SWCStringUtils.equals((String)"1", (String)dataType);
            String index = isFormula ? String.valueOf(entryInfo.getKey().intValue()) : String.valueOf(entryInfo.getKey());
            String name = isFormula ? obj.getString("formulav.name") : obj.getString("datagradev.name");
            String number = isFormula ? obj.getString("formulav.number") : obj.getString("datagradev.number");
            String formulaExp = isFormula ? obj.getString("formulav.originalexp") : "";
            dataList.add(this.assembleExportData(typeName, index, number, name, obj.getString("showname"), formulaExp, obj.getString("salaryitemname")));
        }
        return dataList;
    }

    private String getTypeNameByType(String dataType) {
        String typeName = "";
        if (SWCStringUtils.equals((String)"1", (String)dataType)) {
            typeName = ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"CalVersionFormulaKey_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)"2", (String)dataType)) {
            typeName = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7", (String)"CalVersionFormulaKey_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        } else if (SWCStringUtils.equals((String)"0", (String)dataType)) {
            typeName = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u6620\u5c04\u65b9\u6848", (String)"CalVersionFormulaKey_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        }
        return typeName;
    }

    private Map<String, Object> assembleExportData(String typeName, String index, String number, String name, String showname, String formulaExp, String salaryitemname) {
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("index", index);
        data.put("typename", typeName);
        data.put("number", number);
        data.put("name", name);
        data.put("showname", showname);
        data.put("formulaexp", formulaExp);
        data.put("salaryitemname", salaryitemname);
        return data;
    }

    private List<Map<String, Object>> assembleExportHeaders() {
        Map<String, Object> index = this.assembleHeaderColumn("index", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"CalVersionExportHeader_0", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> typename = this.assembleHeaderColumn("typename", ResManager.loadKDString((String)"\u6838\u7b97\u5de5\u5177\u7c7b\u578b", (String)"CalVersionExportHeader_6", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> number = this.assembleHeaderColumn("number", ResManager.loadKDString((String)"\u7f16\u7801", (String)"CalVersionExportHeader_1", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> name = this.assembleHeaderColumn("name", ResManager.loadKDString((String)"\u540d\u79f0", (String)"CalVersionExportHeader_2", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> showname = this.assembleHeaderColumn("showname", ResManager.loadKDString((String)"\u7248\u672c\u4fe1\u606f", (String)"CalVersionExportHeader_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> formulaexp = this.assembleHeaderColumn("formulaexp", ResManager.loadKDString((String)"\u516c\u5f0f\u5185\u5bb9", (String)"CalVersionExportHeader_4", (String)"swc-hsas-business", (Object[])new Object[0]));
        Map<String, Object> salaryitemname = this.assembleHeaderColumn("salaryitemname", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"CalVersionExportHeader_5", (String)"swc-hsas-business", (Object[])new Object[0]));
        List<Map<String, Object>> headers = Arrays.asList(index, typename, number, name, showname, formulaexp, salaryitemname);
        return headers;
    }

    private Map<String, Object> assembleHeaderColumn(String key, String name) {
        HashMap<String, Object> columnInfo = new HashMap<String, Object>(4);
        columnInfo.put("code", key);
        columnInfo.put("displayName", name);
        columnInfo.put("dataType", "text");
        columnInfo.put("width", 512 * name.getBytes(StandardCharsets.UTF_8).length);
        return columnInfo;
    }

    private String getExportFileName() {
        Date now = new Date();
        String dateStr = SWCDateTimeUtils.format((Date)now, (String)"yyyyMMddHHmmss");
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u7248\u672c\u5bfc\u51fa\uff08\u6309\u5217\u8868\uff09_%s", (String)"CalVersionExportConfig_0", (String)"swc-hsas-business", (Object[])new Object[0]), dateStr);
        return fileName;
    }
}

