/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsas.formplugin.web.cal.floatball.export.ExportProgressFloatBallTask;
import kd.swc.hsas.formplugin.web.cal.floatball.export.ExportProgressFloatBallTaskClick;
import kd.swc.hsbp.business.record.TaskRecordHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HSASCalTableExportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log logger = LogFactory.getLog(HSASCalTableExportProgressPlugin.class);
    private static final String EVENT_COMMFIREEXPORT = "ExportListConfirmCallBack";
    private static final String MARK_TOTAL = "total";
    private static final String COMPLETE = "complete";
    private static final String PROGRESS = "progress";
    private static final String TOTALCOUNT = "totalCount";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTNCANCEL = "btncancel";
    private static final String OPERATEPANEL = "operatepanel";
    private static final String URL = "url";
    private boolean ISINITIALIZE = true;
    private static final String TASK_RECORD = "task_record_%s";
    private static final String CAL_INFO = "calInfo_%s";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        progressBar.start();
        Optional optionalInteger = Optional.empty();
        this.showProgress(new ProgressEvent(optionalInteger), this.ISINITIALIZE);
        this.setExportProgressStatus("2");
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTNCANCEL});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTNCANCEL, (CharSequence)source.getKey())) {
            this.setExportProgressStatus("1");
            this.stopProgressBar();
            this.getView().close();
            if (!this.closeFloating()) {
                String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
                ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
                JobFormInfo jobFormInfo = (JobFormInfo)appCache.get(MessageFormat.format("prorationPlatformTaskInfo_{0}", downLoadTaskId), JobFormInfo.class);
                if (ObjectUtils.isNotEmpty((Object)jobFormInfo)) {
                    String taskId = jobFormInfo.getJobInfo().getTaskId();
                    if (StringUtils.isNotBlank((CharSequence)taskId)) {
                        TaskRecordHelper.delTask((String)taskId, (JobFormInfo)jobFormInfo, null);
                    }
                    appCache.remove(MessageFormat.format("prorationPlatformTaskInfo_{0}", downLoadTaskId));
                    String progressInfoKey = MessageFormat.format("progressInfo_{0}", downLoadTaskId);
                    appCache.remove(progressInfoKey);
                }
            }
            String message = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"HSASCalTableExportProgressPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(message);
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (StringUtils.equals((CharSequence)this.getPageCache().get(this.getCurrentViewAppCacheKey()), (CharSequence)"1")) {
            this.stopProgressBar();
            this.getView().close();
        }
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        cache.put("progressBarPage", (Object)this.getView().getPageId());
        this.showProgress(progressEvent, false);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        boolean isEndTask;
        int statusTask;
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        cache.put("progressBarPage", (Object)this.getView().getPageId());
        double progress = this.getProgress().orElseGet(() -> cache.get(PROGRESS + downLoadTaskId, Double.class) != null ? (Double)cache.get(PROGRESS + downLoadTaskId, Double.class) : Double.valueOf(0.0));
        String status = this.getPageCache().get(this.getCurrentViewAppCacheKey());
        int n = statusTask = this.getView().getFormShowParameter().getCustomParam("status") != null ? (Integer)this.getView().getFormShowParameter().getCustomParam("status") : 0;
        if (StringUtils.isBlank((CharSequence)downLoadTaskId)) {
            return;
        }
        boolean bl = isEndTask = Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("isEndTask")) || progress >= 100.0 && StringUtils.equals((CharSequence)status, (CharSequence)"2");
        if (isEndTask) {
            this.downloadExecl((String)cache.get(URL + downLoadTaskId, String.class));
            this.setExportProgressStatus("3");
            this.closeFloating();
        } else if (progress < 100.0 && StringUtils.equals((CharSequence)status, (CharSequence)"2") && statusTask == 0) {
            event.setCancel(true);
            this.changeTplConfirm();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "ExportListConfirmCallBack": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                String floatingTaskId = this.getFloatingTaskId();
                if (SWCStringUtils.isNotEmpty((String)floatingTaskId)) {
                    HRBackgroundTaskHelper.getInstance().removeProgressPageId(this.getView().getMainView(), floatingTaskId);
                    HRBackgroundTaskHelper.getInstance().showBaskgroundTask(floatingTaskId);
                } else {
                    String taskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
                    this.openProgressBall(taskId);
                }
                this.setExportProgressStatus("3");
                this.getView().close();
                break;
            }
        }
    }

    private void changeTplConfirm() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"HSASCalTableExportProgressPlugin_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EVENT_COMMFIREEXPORT, (IFormPlugin)this));
    }

    private void showProgress(ProgressEvent progressEvent, boolean flag) {
        String text;
        int status;
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        CalTableExportProgressInfo progressInfo = this.getCalTableExportProgressInfo(downLoadTaskId);
        String url = "";
        double progress = 0.0;
        int totalCount = 0;
        Long complete = 0L;
        int n = status = this.getView().getFormShowParameter().getCustomParam("status") != null ? (Integer)this.getView().getFormShowParameter().getCustomParam("status") : 0;
        if (ObjectUtils.isNotEmpty((Object)progressInfo)) {
            totalCount = progressInfo.getTotal();
            Optional<Double> optionalProgress = this.getProgress();
            progress = optionalProgress.isPresent() ? optionalProgress.get() : 0.0;
            complete = progressInfo.getComplete();
            if (progress >= 100.0 && progressInfo.getStatus() == 2) {
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNCANCEL});
            }
            url = progressInfo.getUrl();
        } else {
            totalCount = this.getView().getFormShowParameter().getCustomParam(TOTALCOUNT) != null ? (Integer)this.getView().getFormShowParameter().getCustomParam(TOTALCOUNT) : 0;
            SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
            url = (String)cache.get(URL + downLoadTaskId, String.class);
        }
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        if (flag) {
            if (progress >= 100.0) {
                progress = 100.0;
                progressBar.setPercent(99);
            } else {
                progressBar.setPercent((int)progress);
            }
        } else if (progress >= 100.0) {
            progress = 100.0;
            progressEvent.setProgress(99);
            text = ResManager.loadKDString((String)"\u5b8c\u6210", (String)"HSASCalTableExportProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            progressEvent.setText(text);
            if (progressInfo.getStatus() != 2 && StringUtils.isNotBlank((CharSequence)url)) {
                this.getView().close();
            }
        } else if (complete == 0L) {
            text = ResManager.loadKDString((String)"\u6b63\u5728\u5f00\u59cb\uff0c\u8bf7\u7a0d\u5019...", (String)"HSASCalTableExportProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            progressEvent.setText(text);
            progressEvent.setProgress(0);
        } else {
            this.setExportProgressStatus("2");
            progressEvent.setProgress((int)progress);
        }
        Label totalTitle = (Label)this.getControl(MARK_TOTAL);
        String msg = "";
        String exportMsg = (String)this.getView().getFormShowParameter().getCustomParam("exportMsg");
        msg = SWCStringUtils.isEmpty((String)exportMsg) ? ResManager.loadKDString((String)"\u5171\u9009\u4e2d{0}\u6761\u6838\u7b97\u8bb0\u5f55", (String)"HSASCalTableExportProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{totalCount}) : String.format(Locale.ROOT, exportMsg, String.valueOf(totalCount));
        totalTitle.setText(msg);
        Label completeTitle = (Label)this.getControl(COMPLETE);
        completeTitle.setText(String.valueOf(complete));
        Label progressTitle = (Label)this.getControl(PROGRESS);
        progressTitle.setText(String.valueOf((int)progress) + "%");
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private void setExportProgressStatus(String status) {
        this.getPageCache().put(this.getCurrentViewAppCacheKey(), status);
    }

    private String getCurrentViewAppCacheKey() {
        return "EXPT_SUSPEND_" + this.getBillNumber();
    }

    private String getBillNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam("hsas_caltableexportprog");
    }

    private void downloadExecl(String url) {
        String downLoadTaskId;
        CalTableExportProgressInfo progressInfo;
        if (StringUtils.isBlank((CharSequence)url) && (progressInfo = this.getCalTableExportProgressInfo(downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId"))) != null) {
            url = progressInfo.getUrl();
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.addAction("download", (Object)url);
        }
    }

    private void openProgressBall(String taskId) {
        JobInfo jobInfo = new JobInfo();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        jobInfo.setName(ResManager.loadKDString((String)"\u5bfc\u51fa - \u85aa\u8d44\u6838\u7b97\u5217\u8868", (String)"HSASCalTableExportProgressPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setTaskClassname(ExportProgressFloatBallTask.class.getName());
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("downLoadTaskId", taskId);
        jobInfo.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getParentView().getPageId());
        jobFormInfo.setRootPageId(formShowParameter.getRootPageId());
        jobFormInfo.getParams().putAll(formShowParameter.getCustomParams());
        jobFormInfo.setCloseCallBack(new CloseCallBack("kd.swc.hsas.formplugin.web.cal.floatball.export.ExportProgressCloseCallBack", taskId));
        jobFormInfo.setClickClassName(ExportProgressFloatBallTaskClick.class.getName());
        String platformTaskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        String pageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", taskId));
        appCache.put(MessageFormat.format("prorationPlatformTaskInfo_{0}", taskId), (Object)jobFormInfo);
        TaskRecordHelper.showTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (String)platformTaskId, (String)pageId);
    }

    private CalTableExportProgressInfo getCalTableExportProgressInfo(String downLoadTaskId) {
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
        String progressInfoKey = MessageFormat.format("progressInfo_{0}", downLoadTaskId);
        return (CalTableExportProgressInfo)appCache.get(progressInfoKey, CalTableExportProgressInfo.class);
    }

    private Optional<Double> getProgress() {
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        CalTableExportProgressInfo progressInfo = this.getCalTableExportProgressInfo(downLoadTaskId);
        if (progressInfo != null) {
            int totalCount = progressInfo.getTotal();
            long complete = 0L;
            double progress = totalCount == 0 ? 100.0 : Double.parseDouble(String.valueOf(progressInfo.getComplete())) / Double.parseDouble(String.valueOf(progressInfo.getTotal())) * 100.0;
            return Optional.of(progress);
        }
        return Optional.empty();
    }

    private String getFloatingTaskId() {
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
        return (String)appCache.get("floatingTaskId", String.class);
    }

    private void removeCache() {
        String downLoadTaskId = (String)this.getView().getFormShowParameter().getCustomParam("downLoadTaskId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
        appCache.clear();
    }

    private boolean closeFloating() {
        String floatingTaskId = this.getFloatingTaskId();
        if (SWCStringUtils.isNotEmpty((String)floatingTaskId)) {
            HRBackgroundTaskHelper.getInstance().confirmEndTask(floatingTaskId, "ABORTED");
            this.removeCache();
            return true;
        }
        return false;
    }
}

