/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.calreport;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.calreport.dto.CalDetailExportDto;
import kd.swc.hsas.business.cal.calreport.helper.CalDetailExportHelper;
import kd.swc.hsas.business.cal.calreport.helper.CalDetailFilterParser;
import kd.swc.hsas.common.utils.TaskUtil;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalDetailListExportPlugin
extends AbstractListPlugin {
    private static final String EXPORT = "donothing_export";
    public static final Integer PAGE_SIZE = 100;
    private static final String PROGRESS = "progress";
    private static final String COMPLETE = "complete";
    private static final String MODULE_NAME = "swc-hsas-formplugin";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        long userId;
        boolean permFlag;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (EXPORT.equals(optKey) && !(permFlag = SWCPermissionServiceHelper.hasPerm((long)(userId = RequestContext.get().getCurrUserId()), (String)"/UHMBBGZQ65X", (String)"hsas_caldetail", (String)"4730fc9f000004ae"))) {
            String msg = ResManager.loadKDString((String)"\u65e0\u5bfc\u51fa\u6743\u9650\uff01", (String)"CalDetailListExportPlugin_3", (String)MODULE_NAME, (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (operationResult.isSuccess() && EXPORT.equals(opKey)) {
            this.doExport();
        }
    }

    private void doExport() {
        BillList billListAp = new BillList();
        billListAp.setKey("billlistap");
        billListAp.setEntityId("hsas_caldetail");
        ListView listView = (ListView)this.getView();
        billListAp.setBillFormId(listView.getBillFormId());
        billListAp.setView((IFormView)listView);
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        int size = selectedRows.size();
        long[] selectRows = new long[size];
        for (int index = 0; index < size; ++index) {
            selectRows[index] = (Long)selectedRows.get(index).getPrimaryKeyValue();
        }
        QFilter[] filters = this.getQueryFilters(selectRows);
        CalDetailExportHelper helper = new CalDetailExportHelper();
        Map headers = helper.getExportHeaders();
        CalDetailExportDto.Builder builder = new CalDetailExportDto.Builder();
        builder.setFilters(filters).setHeaders(headers);
        String downLoadTaskId = TaskUtil.getExportTaskID();
        this.startExport(builder, downLoadTaskId, helper);
    }

    public void startExport(CalDetailExportDto.Builder builder, String downLoadTaskId, CalDetailExportHelper helper) {
        CalDetailExportDto dto = builder.build();
        QFilter[] filters = dto.getFilters();
        int totalElements = ORM.create().count("BusinessDataServiceHelper.load", "hsas_caldetail", filters);
        int totalPages = (int)Math.ceil((double)totalElements * 1.0 / (double)PAGE_SIZE.intValue());
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        this.openExportProgressBar(totalElements, totalPages, countDownLatch, downLoadTaskId);
        Map headers = dto.getHeaders();
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6838\u7b97\u8bb0\u5f55\u8be6\u7ec6\u8868\u5bfc\u51fa_%s", (String)"CalDetailListExportPlugin_0", (String)MODULE_NAME, (Object[])new Object[0]), date);
        RequestContext ctx = RequestContext.get();
        helper.mutiThreadExport(ctx, fileName, headers, totalPages, filters, countDownLatch, this.getView(), totalElements, downLoadTaskId);
    }

    private void openExportProgressBar(int totalCount, int totalPages, CountDownLatch countDownLatch, String downLoadTaskId) {
        String pageId = this.getView().getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("hsas_caltableexportprog");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("totalCount", (Object)totalCount);
        para.setCustomParam("status", (Object)0);
        para.setCustomParam("downLoadTaskId", (Object)downLoadTaskId);
        para.setCustomParam("exportMsg", (Object)ResManager.loadKDString((String)"\u5171\u9009\u4e2d%s\u6761\u6570\u636e", (String)"CalDetailListExportPlugin_2", (String)MODULE_NAME, (Object[])new Object[0]));
        para.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"CalDetailListExportPlugin_1", (String)MODULE_NAME, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        if (totalPages <= 0) {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)100);
            para.setCustomParam(PROGRESS, (Object)100);
        } else {
            pageCache.put(PROGRESS + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) / (long)totalPages));
            pageCache.put(COMPLETE + downLoadTaskId, (Object)(((long)totalPages - countDownLatch.getCount()) * 100L));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    protected QFilter[] getQueryFilters(long[] selectRows) {
        QFilter statusFilter;
        CalDetailFilterParser parser = new CalDetailFilterParser();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        Map filterValues = filterContainer.getCachedFilterValues().createMapFilterValues();
        List schemeFilter = new ArrayList();
        List fastFilter = new ArrayList();
        List customFilter = new ArrayList();
        if (filterValues.get("schemefilter") != null) {
            schemeFilter = (List)filterValues.get("schemefilter");
        }
        if (filterValues.get("fastfilter") != null) {
            fastFilter = (List)filterValues.get("fastfilter");
        }
        if (filterValues.get("customfilter") != null) {
            customFilter = (List)filterValues.get("customfilter");
        }
        QFilter[] sFilter = parser.parseSchemeFilter(schemeFilter);
        QFilter[] fFilter = parser.parseFastFilter(fastFilter);
        QFilter[] cFilter = parser.parseCustomFilter(customFilter);
        Long recordId = (Long)this.getView().getFormShowParameter().getCustomParam("recordId");
        QFilter filter = new QFilter("record.id", "=", (Object)recordId);
        filter = this.margeFilter(filter, fFilter);
        filter = this.margeFilter(filter, cFilter);
        filter = this.margeFilter(filter, sFilter);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)pageType, (String)"success")) {
            statusFilter = new QFilter("calstatus", "=", (Object)CalStatusEnum.SUCCESS.getCode());
            filter.and(statusFilter);
        } else if (SWCStringUtils.equals((String)pageType, (String)"fail")) {
            statusFilter = new QFilter("calstatus", "=", (Object)CalStatusEnum.FAIL.getCode());
            filter.and(statusFilter);
        } else if (SWCStringUtils.equals((String)pageType, (String)"viewPerson")) {
            String failReason;
            String errorElement;
            String failType = (String)this.getView().getFormShowParameter().getCustomParam("failType");
            if (SWCStringUtils.isNotEmpty((String)failType)) {
                QFilter failTypeFilter = new QFilter("failtype", "=", (Object)failType);
                filter.and(failTypeFilter);
            }
            if (SWCStringUtils.isNotEmpty((String)(errorElement = (String)this.getView().getFormShowParameter().getCustomParam("errorElement")))) {
                QFilter errorElementFilter = new QFilter("errorelement", "=", (Object)errorElement);
                filter.and(errorElementFilter);
            }
            if (SWCStringUtils.isNotEmpty((String)(failReason = (String)this.getView().getFormShowParameter().getCustomParam("failReason")))) {
                QFilter failReasonFilter = new QFilter("failmsg", "=", (Object)failReason);
                filter.and(failReasonFilter);
            }
        }
        if (selectRows != null && selectRows.length > 0) {
            filter.and("id", "in", (Object)selectRows);
        }
        QFilter[] filters = new QFilter[]{filter};
        return filters;
    }

    private QFilter margeFilter(QFilter filter, QFilter[] filters) {
        if (filters != null) {
            for (QFilter qFilter : filters) {
                filter = filter == null ? qFilter : filter.and(qFilter);
            }
        }
        return filter;
    }
}

