/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.calreport;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.cal.calreport.CalDetailViewHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.CalStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalDetailListViewPlugin
extends AbstractListPlugin
implements FilterContainerInitListener {
    private static final String[] HIDE_BTN = new String[]{"tblreturn", "tblnew", "baritemap", "tbexport", "tbldel", "tblrefresh"};
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String VIEW_DETAIL_LABEL = "viewdetail";
    private Map<Long, String> calPersonRelationMap;

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        this.getView().addCustomControls(new String[]{KEY_BILL_LIST_AP});
    }

    public void filterContainerInit(FilterContainerInitEvent arg0) {
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.buildCalPersonIdAndStatusRelation();
    }

    public void afterBindData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, HIDE_BTN);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        ListOperationColumnDesc listOperationColumnDesc;
        String listKey;
        if (packageDataEvent.getSource() instanceof ListOperationColumnDesc && SWCStringUtils.equals((String)VIEW_DETAIL_LABEL, (String)(listKey = (listOperationColumnDesc = (ListOperationColumnDesc)packageDataEvent.getSource()).getKey()))) {
            List operationColItems = (List)packageDataEvent.getFormatValue();
            Long calPersonId = packageDataEvent.getRowData().getLong("calpersonid");
            if (this.calPersonRelationMap == null || this.calPersonRelationMap.size() == 0) {
                operationColItems.forEach(item -> item.setVisible(false));
            } else {
                String calStatus = this.calPersonRelationMap.get(calPersonId);
                if (SWCStringUtils.isEmpty((String)calStatus)) {
                    operationColItems.forEach(item -> item.setVisible(false));
                } else if (SWCStringUtils.equals((String)CalStateEnum.UNCAL.getCode(), (String)calStatus) || SWCStringUtils.equals((String)CalStateEnum.CALING.getCode(), (String)calStatus) || SWCStringUtils.equals((String)CalStateEnum.PRECAL_ERROR.getCode(), (String)calStatus)) {
                    operationColItems.forEach(item -> item.setVisible(false));
                }
            }
        }
    }

    private void buildCalPersonIdAndStatusRelation() {
        CalDetailViewHelper helper = new CalDetailViewHelper();
        List<QFilter> filterList = this.buildFilterList();
        DynamicObject[] calPersonIds = helper.getCalPersonIds(filterList);
        if (calPersonIds == null || calPersonIds.length == 0) {
            return;
        }
        ArrayList<Long> calPersonIdList = new ArrayList<Long>(10);
        for (DynamicObject dataObj : calPersonIds) {
            Long calPersonId = dataObj.getLong("calpersonid");
            calPersonIdList.add(calPersonId);
        }
        QFilter filter = new QFilter("id", "in", calPersonIdList);
        DynamicObject[] relations = helper.getCalPersonAndStatusRelations(filter);
        if (relations == null || relations.length == 0) {
            return;
        }
        HashMap<Long, String> relationMap = new HashMap<Long, String>(16);
        for (DynamicObject dataObj : relations) {
            Long calPersonId = dataObj.getLong("id");
            String calStatus = dataObj.getString("calstatus");
            relationMap.put(calPersonId, calStatus);
        }
        this.calPersonRelationMap = relationMap;
    }

    private List<QFilter> buildFilterList() {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        Long recordId = (Long)this.getView().getFormShowParameter().getCustomParam("recordId");
        if (recordId == null) {
            recordId = 0L;
        }
        QFilter qFilter = new QFilter("record.id", "=", (Object)recordId);
        filterList.add(qFilter);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)pageType, (String)"success")) {
            QFilter statusFilter = new QFilter("calstatus", "=", (Object)CalStatusEnum.SUCCESS.getCode());
            filterList.add(statusFilter);
        } else if (SWCStringUtils.equals((String)pageType, (String)"fail")) {
            QFilter statusFilter = new QFilter("calstatus", "=", (Object)CalStatusEnum.FAIL.getCode());
            filterList.add(statusFilter);
        } else if (SWCStringUtils.equals((String)pageType, (String)"viewPerson")) {
            String failReason;
            String errorElement;
            String failType = (String)this.getView().getFormShowParameter().getCustomParam("failType");
            if (SWCStringUtils.isNotEmpty((String)failType)) {
                QFilter failTypeFilter = new QFilter("failtype", "=", (Object)failType);
                filterList.add(failTypeFilter);
            }
            if (SWCStringUtils.isNotEmpty((String)(errorElement = (String)this.getView().getFormShowParameter().getCustomParam("errorElement")))) {
                QFilter errorElementFilter = new QFilter("errorelement", "=", (Object)errorElement);
                filterList.add(errorElementFilter);
            }
            if ((failReason = (String)this.getView().getFormShowParameter().getCustomParam("failReason")) != null) {
                QFilter failReasonFilter = new QFilter("failmsg", "=", (Object)failReason);
                filterList.add(failReasonFilter);
            }
        }
        return filterList;
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        List<QFilter> filterList = this.buildFilterList();
        setFilterEvent.getQFilters().addAll(filterList);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        billList.setOrderBy("salaryfile.number asc");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "donothing_viewcalresultform": {
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_caltabledetailresult", (String)"47150e89000000ac");
                if (!permFlag) {
                    this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e0e\u7ed3\u679c\u67e5\u770b", (String)"CalPersonListViewPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                    return;
                }
                this.viewCalResultForm();
                break;
            }
        }
    }

    private void viewCalResultForm() {
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        long pkid = (Long)billList.getFocusRowPkId();
        Long recordId = (Long)this.getView().getFormShowParameter().getCustomParam("recordId");
        CalDetailViewHelper helper = new CalDetailViewHelper();
        DynamicObject calDetailObj = helper.getCalReportInfoById(Long.valueOf(pkid), recordId);
        if (calDetailObj == null) {
            return;
        }
        Long calPersonId = calDetailObj.getLong("calpersonid");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsas_caltabledetailresult");
        parameter.setCustomParam("pkId", (Object)String.valueOf(calPersonId));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(parameter);
    }
}

