/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.calrequest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.cal.helper.CalPayRollTaskCalHelper;
import kd.swc.hsas.business.cal.service.CalTableCalService;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalRequestStatusEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalRequestVO;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;

public class CalRequestList
extends SWCDataBaseList
implements ProgresssListener {
    private static final String DONOTHING_STOP = "donothing_stop";
    public static final String DONOTHING_VIEWCALRECORD = "donothing_viewcalrecord";
    private Map<Long, CalRequestVO> queuingMap;
    private String queueingName;
    private static final String KEY_QUEUELABEL = "queuelabel";
    private static final String KEY_CALLABEL = "callabel";
    private static final String KEY_RUNSTATUS = "runstatus";
    private static final String KEY_BATCHNUM = "batchnum";

    public void initialize() {
        super.initialize();
        ProgressBar refreshProgressBar = (ProgressBar)this.getControl("progressbarap");
        if (refreshProgressBar != null) {
            refreshProgressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        ProgressBar refreshProgressBar = (ProgressBar)this.getControl("progressbarap");
        if (refreshProgressBar != null) {
            refreshProgressBar.start();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            if (!SWCStringUtils.equals((String)KEY_RUNSTATUS, (String)commonFilterColumn.getFieldName())) continue;
            commonFilterColumn.setDefaultValues(new Object[]{"queuing", "doing"});
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rows.size());
                DynamicProperty runStatusProperty = rows.getDynamicObjectType().getProperty(CalRequestList.KEY_RUNSTATUS);
                if (runStatusProperty == null) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    String runstatus = row.getString(CalRequestList.KEY_RUNSTATUS);
                    if (SWCStringUtils.equals((String)runstatus, (String)CalRequestStatusEnum.STOPPED.getCode()) || SWCStringUtils.equals((String)runstatus, (String)CalRequestStatusEnum.FINISHED.getCode())) continue;
                    CellStyle cellStyle = new CellStyle();
                    cellStyle.setFieldKey(CalRequestList.KEY_RUNSTATUS);
                    cellStyle.setRow(start + row.getInt("fseq") - 1);
                    cellStyle.setForeColor("#4E8FDB");
                    CellStyle cellStyle1 = new CellStyle();
                    cellStyle1.setFieldKey(CalRequestList.KEY_BATCHNUM);
                    cellStyle1.setRow(start + row.getInt("fseq") - 1);
                    cellStyle1.setForeColor("#4E8FDB");
                    cellStyles.add(cellStyle);
                    cellStyles.add(cellStyle1);
                }
                BillList billList = (BillList)CalRequestList.this.getView().getControl("billlistap");
                billList.setCellStyle(cellStyles);
                return rows;
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        List requestVOS = CalRequestHelper.loadAllRequestWithOrder();
        this.queuingMap = requestVOS.stream().collect(Collectors.toMap(CalRequestVO::getFid, o -> o, (v1, v2) -> v1));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hsas_calrequest");
        ComboProp runstatusfiled = (ComboProp)dataEntityType.getProperty(KEY_RUNSTATUS);
        this.queueingName = runstatusfiled.getItemByName(CalRequestStatusEnum.QUEUING.getCode());
        Map<String, Long> statusCount = requestVOS.stream().collect(Collectors.groupingBy(CalRequestVO::getRunStatus, Collectors.counting()));
        Long queueCount = statusCount.get(CalRequestStatusEnum.QUEUING.getCode());
        Long calCount = statusCount.get(CalRequestStatusEnum.DOING.getCode());
        if (queueCount == null) {
            queueCount = 0L;
        }
        if (calCount == null) {
            calCount = 0L;
        }
        Label queuelabel = (Label)this.getControl(KEY_QUEUELABEL);
        queuelabel.setText(ResManager.loadKDString((String)"\u6392\u961f\u4e2d\u7684\u8bf7\u6c42\uff1a{0}", (String)"CalRequestList_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{queueCount}));
        Label callabel = (Label)this.getControl(KEY_CALLABEL);
        callabel.setText(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u4e2d\uff1a{0}", (String)"CalRequestList_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{calCount}));
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = e.getRowData();
        switch (fieldKey) {
            case "runstatus": {
                long id = rowData.getLong("id");
                CalRequestVO requestVO = this.queuingMap.get(id);
                if (requestVO != null && SWCStringUtils.equals((String)requestVO.getRunStatus(), (String)CalRequestStatusEnum.QUEUING.getCode())) {
                    e.setFormatValue((Object)(this.queueingName + '-' + requestVO.getOrder()));
                    break;
                }
                if (requestVO == null) break;
                e.setFormatValue((Object)requestVO.getRunStatus());
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)this.getControl("billlistap");
        Long focusRowPkId = (Long)billList.getFocusRowPkId();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrequest");
        DynamicObject request = helper.queryOne((Object)focusRowPkId);
        ((ListView)this.getView()).refresh();
        if (request == null) {
            String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalRequestList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorTips);
            return;
        }
        long calRecordId = request.getLong("calrecord.id");
        long calTaskId = request.getLong("caltask.id");
        String runStatus = request.getString(KEY_RUNSTATUS);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_calrecord");
        DynamicObject record = recordHelper.queryOne((Object)calRecordId);
        String type = request.getString("type");
        if (SWCStringUtils.equals((String)runStatus, (String)CalRequestStatusEnum.FINISHED.getCode()) || SWCStringUtils.equals((String)runStatus, (String)CalRequestStatusEnum.STOPPED.getCode())) {
            return;
        }
        switch (fieldName) {
            case "batchnum": {
                String batchnum = request.getString(KEY_BATCHNUM);
                int batch = CalRequestHelper.getCalRequestCountByBatchNum((String)batchnum);
                if (SWCStringUtils.equals((String)type, (String)"cal")) {
                    if (batch == 1) {
                        this.showCalProgress(request, calRecordId, calTaskId, record);
                        break;
                    }
                    this.showCalTaskProgress(batchnum);
                    break;
                }
                if (batch == 1) {
                    this.showCancelProgress(request, calRecordId, calTaskId, record);
                    break;
                }
                this.showCancelTaskProgress(batchnum);
                break;
            }
            case "runstatus": {
                if (SWCStringUtils.equals((String)type, (String)"cal")) {
                    this.showCalProgress(request, calRecordId, calTaskId, record);
                    break;
                }
                this.showCancelProgress(request, calRecordId, calTaskId, record);
                break;
            }
        }
    }

    private void showCancelProgress(DynamicObject request, long calRecordId, long calTaskId, DynamicObject record) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_cancelcalprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(8);
        parameterMap.put("calTaskId", calTaskId);
        parameterMap.put("calRecordId", calRecordId);
        parameterMap.put("cancelCount", request.getInt("count"));
        parameterMap.put("startTime", record.getDate("starttime"));
        parameterMap.put("calTaskName", request.getString("caltask.name"));
        showParameter.setCustomParams(parameterMap);
        this.getView().showForm(showParameter);
    }

    private void showCalTaskProgress(String batchnum) {
        ISWCAppCache calRequestCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_request_param_%s", batchnum));
        Map calRequestParams = (Map)calRequestCache.get("cal_param", Map.class);
        if (calRequestParams == null) {
            return;
        }
        String cacheUUID = (String)calRequestParams.get("cacheUUID");
        String traceId = (String)calRequestParams.get("traceId");
        ISWCAppCache calParamCache = SWCAppCache.get((String)String.format(Locale.ROOT, "swc_cal_param_%s", cacheUUID));
        List calParamList = (List)calParamCache.get("cal_param", List.class);
        if (calParamList == null) {
            FormShowParameter showParameter = CalPayRollTaskCalHelper.getModalFormShowParameter((String)"hsas_caltaskcalprocess");
            showParameter.setCustomParam("cacheUUID", (Object)cacheUUID);
            showParameter.setCustomParam("traceId", (Object)traceId);
            showParameter.setCustomParam("rootPageId", (Object)this.getView().getPageId());
            this.getView().showForm(showParameter);
        } else {
            this.getView().showForm(CalPayRollTaskCalHelper.getCalProcessPage((String)"hsas_caltaskcalprocess", (List)calParamList, (String)traceId, (String)this.getView().getPageId()));
        }
    }

    private void showCancelTaskProgress(String batchnum) {
        ISWCAppCache calRequestCache = SWCAppCache.get((String)String.format(Locale.ROOT, "cal_request_param_%s", batchnum));
        Map calRequestParams = (Map)calRequestCache.get("cal_param", Map.class);
        if (calRequestParams == null) {
            return;
        }
        List data = (List)calRequestParams.get("data");
        String traceId = (String)calRequestParams.get("traceId");
        this.getView().showForm(CalPayRollTaskCalHelper.getCalProcessPage((String)"hsas_cancelcalprocess", (List)data, (String)traceId, (String)this.getView().getPageId()));
    }

    private void showCalProgress(DynamicObject request, long calRecordId, long calTaskId, DynamicObject record) {
        SWCDataServiceHelper recordHelper = new SWCDataServiceHelper("hsas_calrecord");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        filter.and("optype", "=", (Object)"1");
        int count = recordHelper.count(new QFilter[]{filter});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCustomParam("calRecordId", (Object)calRecordId);
        showParameter.setCustomParam("calType", (Object)"preTaxCal");
        showParameter.setCustomParam("calCount", (Object)request.getInt("count"));
        showParameter.setCustomParam("calTimes", (Object)count);
        showParameter.setCustomParam("calTaskName", (Object)request.getString("caltask.name"));
        showParameter.setCustomParam("starttime", (Object)record.getDate("starttime"));
        this.getView().showForm(showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (SWCStringUtils.equals((String)DONOTHING_STOP, (String)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            if (!SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"hsas_calrequest", (String)"03LUYX=W8VW7")) {
                this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u8ba1\u7b97\u8bf7\u6c42", (String)"CalRequestList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"CalRequestList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
                return;
            }
            MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u7ec8\u6b62\u6210\u529f", "CalRequestList_15", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_calrequest", (String)DONOTHING_STOP, (String)"", (MultiLangEnumBridge)bridge, (String[])new String[0]);
            IListView view = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            SWCDataServiceHelper requestHelper = new SWCDataServiceHelper("hsas_calrequest");
            QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
            DynamicObjectCollection requestList = requestHelper.queryOriginalCollection("id,runstatus,caltask.id,number,calrecord.id,calrecord.calstatus,type", new QFilter[]{filter});
            CalTableCalService calService = new CalTableCalService();
            HashMap<DynamicObject, String> failMap = new HashMap<DynamicObject, String>(requestList.size());
            Map resultMap = null;
            int successCount = 0;
            String errorLevel = null;
            for (DynamicObject request : requestList) {
                if (SWCStringUtils.equals((String)CalRequestStatusEnum.FINISHED.getCode(), (String)request.getString(KEY_RUNSTATUS)) || SWCStringUtils.equals((String)CalRequestStatusEnum.STOPPED.getCode(), (String)request.getString(KEY_RUNSTATUS))) {
                    failMap.put(request, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6267\u884c\u72b6\u6001\u4e3a\u201c\u6392\u961f\u4e2d\u201d\u3001\u201c\u6b63\u5728\u5904\u7406\u4e2d\u201d\u7684\u8ba1\u7b97\u8bf7\u6c42\u6570\u636e\u8fdb\u884c\u7ec8\u6b62\u3002", (String)"CalRequestList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    continue;
                }
                if (SWCStringUtils.equals((String)"1", (String)request.getString("calrecord.calstatus"))) {
                    try {
                        resultMap = calService.cancelCal(Long.valueOf(request.getLong("calrecord.id")), Long.valueOf(request.getLong("caltask.id")));
                        if (resultMap != null && resultMap.size() > 0) {
                            failMap.put(request, (String)resultMap.get("msg"));
                            errorLevel = (String)resultMap.get("level");
                            continue;
                        }
                        ++successCount;
                    }
                    catch (Exception e) {
                        failMap.put(request, e.getMessage());
                    }
                    continue;
                }
                CalRequestHelper.updateCalRequest((Long)request.getLong("calrecord.id"), (String)CalRequestStatusEnum.STOPPED.getCode());
            }
            if (requestList.size() == 1) {
                if (failMap.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u3002\u6bcf\u4e2a\u8ba1\u7b97\u8bf7\u6c425\u5206\u949f\u5185\u4ec5\u5141\u8bb8\u7ec8\u6b62\u4e00\u6b21\u3002", (String)"CalRequestList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                } else if (SWCStringUtils.equals(errorLevel, (String)String.valueOf(ErrorLevel.Warning.getValue()))) {
                    this.getView().showTipNotification((String)failMap.get(requestList.get(0)));
                } else {
                    this.getView().showErrorNotification((String)failMap.get(requestList.get(0)));
                }
            } else if (failMap.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u6b63\u5728\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u3002\u6bcf\u4e2a\u8ba1\u7b97\u8bf7\u6c425\u5206\u949f\u5185\u4ec5\u5141\u8bb8\u7ec8\u6b62\u4e00\u6b21\u3002", (String)"CalRequestList_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            } else {
                String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalRequestList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                String title = MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u7ec8\u6b62\u8ba1\u7b97\u64cd\u4f5c\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761\u3002", (String)"CalRequestList_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]), successCount, failMap.size());
                List failList = failMap.entrySet().stream().map(o -> ((DynamicObject)o.getKey()).getString("number") + "\uff1a" + (String)o.getValue()).collect(Collectors.toList());
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, failList);
                this.getView().showForm(parameters);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "donothing_stop": {
                args.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DONOTHING_STOP, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMap = new HashMap<Integer, String>();
                btnNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CalRequestList_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                btnNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"CalRequestList_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u7ec8\u6b62\u8ba1\u7b97\u5c06\u505c\u6b62\u5f53\u524d\u8ba1\u7b97\uff0c\u5e76\u56de\u6eda\u672c\u6b21\u8ba1\u7b97\u7684\u6240\u6709\u6838\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u7ee7\u7eed\u5417\uff1f", (String)"CalRequestList_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMap);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "donothing_viewcalrecord": {
                Long focusRowPkId = (Long)this.getFocusRowPkId();
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrequest");
                DynamicObject request = helper.queryOne((Object)focusRowPkId);
                if (request == null) {
                    String errorTips = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CalRequestList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorTips);
                    return;
                }
                long calRecordId = request.getLong("calrecord.id");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hsas_calreport");
                showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"CalRequestList_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("calReportId", (Object)calRecordId);
                this.parentViewShow(showParameter);
                break;
            }
        }
    }

    private void parentViewShow(FormShowParameter showParameter) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.showForm(showParameter);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showForm(showParameter);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        IListView view = (IListView)this.getView();
        view.refresh();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "closecaldetailpage": {
                this.openSalaryResultPage(closedCallBackEvent);
                break;
            }
        }
    }

    private void openSalaryResultPage(ClosedCallBackEvent event) {
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
        if (!SWCObjectUtils.isEmpty((Object)returnData)) {
            ListSelectedRow selectRow = returnData.get(0);
            Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
            Long calTaskId = this.getCalTaskId();
            if (calTaskId == null) {
                return;
            }
            FormShowParameter formShowParameter = SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
            if (formShowParameter == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664,\u8bf7\u68c0\u67e5\u3002", (String)"CalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private Long getCalTaskId() {
        SWCPageCache pageChche = new SWCPageCache(this.getView());
        Long calTaskId = (Long)pageChche.get(this.getView().getPageId() + "_cacheCalTaskId", Long.class);
        return calTaskId;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "caltask.payrollscene.name": 
            case "caltask.payrollscene.id": {
                HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHMBBGZQ65X", (String)"hsas_calrequest", (String)"47150e89000000ac");
                if (permOrgs.hasAllOrgPerm()) break;
                args.addCustomQFilter(new QFilter("org", "in", (Object)permOrgs.getHasPermOrgs()));
                break;
            }
        }
    }
}

