/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.floatball.export;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import org.apache.commons.lang3.ObjectUtils;

public class ExportProgressFloatBallTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ExportProgressFloatBallTask.class);

    public void execute(RequestContext arg0, Map<String, Object> param) throws KDException {
        Date now;
        String downLoadTaskId = String.valueOf(param.get("downLoadTaskId"));
        int preProgress = 0;
        Date preChangeTime = new Date();
        do {
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
            String progressInfoKey = MessageFormat.format("progressInfo_{0}", downLoadTaskId);
            CalTableExportProgressInfo progressInfo = (CalTableExportProgressInfo)appCache.get(progressInfoKey, CalTableExportProgressInfo.class);
            if (ObjectUtils.isEmpty((Object)progressInfo)) break;
            int status = progressInfo.getStatus();
            int progress = (int)(Double.parseDouble(String.valueOf(progressInfo.getComplete())) / Double.parseDouble(String.valueOf(progressInfo.getTotal())) * 100.0);
            String desc = "";
            if (progress >= 100) {
                desc = ResManager.loadKDString((String)"\u5bfc\u51fa - \u85aa\u8d44\u6838\u7b97\u5217\u8868\u5df2\u5b8c\u6210", (String)"HSASCalTableExportProgressPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                logger.info(desc);
                appCache.put(progressInfoKey, (Object)progressInfo);
                this.feedbackProgress(progress, desc, null);
                break;
            }
            desc = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa - \u85aa\u8d44\u6838\u7b97\u5217\u8868\uff1a%d%%", (String)"HSASCalTableExportProgressPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), progress);
            logger.info(desc);
            this.feedbackProgress(progress, desc, null);
            if (status == 2) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                String errorInfo = ResManager.loadKDString((String)"\u4f11\u7720\u5931\u8d25\uff1a%s\u3002", (String)"HSASCalTableExportProgressPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                logger.error(String.format(Locale.ROOT, errorInfo, e.getMessage()));
            }
            now = new Date();
            if (progress == preProgress) continue;
            preProgress = progress;
            preChangeTime = now;
        } while (now.getTime() - preChangeTime.getTime() <= 10800000L);
    }
}

