/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.floatball.export;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.swc.hsas.common.vo.CalTableExportProgressInfo;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class ExportProgressFloatBallTaskClick
extends AbstractTaskClick {
    private static final String COMPLETE = "complete";
    private static final String PROGRESS = "progress";
    private static final String STATUS = "status";

    public void click(ClickEventArgs e) {
        this.showProgressForm();
    }

    public boolean release() {
        TaskInfo taskInfo = this.queryTask();
        return taskInfo.isTaskEnd();
    }

    private void showProgressForm() {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_caltableexportprog");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        TaskInfo taskInfo = this.queryTask();
        Map params = this.getJobFormInfo().getParams();
        String downLoadTaskId = (String)params.get("downLoadTaskId");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALTABLE_%s", downLoadTaskId));
        String progressInfoKey = MessageFormat.format("progressInfo_{0}", downLoadTaskId);
        CalTableExportProgressInfo progressInfo = (CalTableExportProgressInfo)appCache.get(progressInfoKey, CalTableExportProgressInfo.class);
        if (taskInfo.isTaskEnd()) {
            params.put(COMPLETE, params.get("totalCount"));
            params.put(PROGRESS, 100.0);
            params.put(STATUS, 2);
            if (progressInfo == null) {
                progressInfo = new CalTableExportProgressInfo();
            }
            progressInfo.setStatus(2);
        } else {
            params.put(COMPLETE, progressInfo.getComplete());
            params.put(PROGRESS, progressInfo.getProgress());
            params.put(STATUS, 1);
            progressInfo.setStatus(1);
        }
        appCache.put(progressInfoKey, (Object)progressInfo);
        showParameter.setCustomParams(this.getJobFormInfo().getParams());
        showParameter.setCustomParam("ServiceAppId", (Object)this.getJobFormInfo().getJobInfo().getAppId());
        showParameter.setCustomParam("sch_taskid", (Object)this.getTaskId());
        showParameter.setCustomParam("openByProgressBall", (Object)"1");
        IFormView view = this.getMainView();
        view.showForm(showParameter);
        view.sendFormAction(this.getMainView());
        this.setProgressPageId(showParameter.getPageId());
    }
}

