/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.genbizdata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.genbizdata.GenBizDataService;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang.time.DateUtils;

public class GenBizDataConfirmPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTN_OK = "btnok";
    private static final String LABEL_TOTALCNT = "totalcnt";
    private static final String LABEL_VALIDCNT = "validcnt";
    private static final String KEY_VALIDIDLIST = "validIdList";
    private static final String BASE_DATE_STARTDATE = "1";
    private static final String BASE_DATE_ENDDATE = "2";
    private static final String BASE_DATE_PAYDATE = "3";
    private static final String MONTH_NEXT = "2";
    private static final String DATE_TYPE_FIRST = "1";
    private static final String DATE_TYPE_LAST = "2";

    public void initialize() {
        this.addClickListeners(new String[]{KEY_BTN_OK});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer totalCnt = (Integer)formShowParameter.getCustomParam(LABEL_TOTALCNT);
        List validIdList = (List)formShowParameter.getCustomParam(KEY_VALIDIDLIST);
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        Date genDate = this.genBizDataBsed(taskId);
        IFormView view = this.getView();
        Label total = (Label)view.getControl(LABEL_TOTALCNT);
        Label valid = (Label)view.getControl(LABEL_VALIDCNT);
        total.setText(totalCnt + "");
        valid.setText(validIdList.size() + "");
        this.getModel().setValue("gendate", (Object)genDate);
        view.updateView("gendate");
    }

    private Date genBizDataBsed(Long taskId) {
        SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
        DynamicObject taskDateInfo = sceneService.getTaskDateInfo(taskId);
        if (taskDateInfo == null) {
            return null;
        }
        DynamicObject genBizDataConf = sceneService.getGenBizDataConfByTaskId(taskId);
        if (genBizDataConf == null) {
            return null;
        }
        boolean autoGenBsed = genBizDataConf.getBoolean("isautogenbsed");
        if (!autoGenBsed) {
            return null;
        }
        String baseDataType = genBizDataConf.getString("basedatetype");
        String month = genBizDataConf.getString("month");
        String dateType = genBizDataConf.getString("datetype");
        Date startDate = taskDateInfo.getDate("startdate");
        Date endDate = taskDateInfo.getDate("enddate");
        Date payDate = taskDateInfo.getDate("paydate");
        Date genBizDataBsed = null;
        switch (baseDataType) {
            case "1": {
                genBizDataBsed = this.generateDate(startDate, month, dateType);
                break;
            }
            case "2": {
                genBizDataBsed = this.generateDate(endDate, month, dateType);
                break;
            }
            case "3": {
                genBizDataBsed = this.generateDate(payDate, month, dateType);
                break;
            }
        }
        return genBizDataBsed;
    }

    private Date generateDate(Date originalDate, String month, String dateType) {
        Date newDate = SWCStringUtils.equals((String)"2", (String)month) ? DateUtils.addMonths((Date)originalDate, (int)1) : originalDate;
        if (SWCStringUtils.equals((String)"1", (String)dateType)) {
            return SWCDateUtils.firstDayOfMonth((Date)newDate);
        }
        if (SWCStringUtils.equals((String)"2", (String)dateType)) {
            return SWCDateUtils.lastDayOfMonth((Date)newDate);
        }
        return null;
    }

    public void click(EventObject evt) {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"43+730XBEQJ9")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u751f\u6210\u4e1a\u52a1\u6570\u636e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GenBizDataConfirmPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        String controlKey = ((Control)evt.getSource()).getKey();
        if (!SWCStringUtils.equals((String)KEY_BTN_OK, (String)controlKey)) {
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List validIdList = (List)formShowParameter.getCustomParam(KEY_VALIDIDLIST);
        GenBizDataService genBizDataService = new GenBizDataService();
        List calPersonObjs = genBizDataService.getCalPersonObjs(validIdList, "43+730XBEQJ9");
        List<String> approvedStatusList = Arrays.asList(CalStateEnum.AUDIT.getCode(), CalStateEnum.WAIT_APPROVALED.getCode(), CalStateEnum.APPROVALING.getCode(), CalStateEnum.APPROVAL.getCode(), CalStateEnum.APPROVALED_NOT_PASS.getCode(), CalStateEnum.APPROVALED.getCode());
        ArrayList genValidPersonList = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject calPersonObj : calPersonObjs) {
            String calStatus = calPersonObj.getString("calstatus");
            String bizDataGenStatus = calPersonObj.getString("bizdatagenstatus");
            if (!approvedStatusList.contains(calStatus) || !SWCStringUtils.equals((String)"1", (String)bizDataGenStatus)) continue;
            genValidPersonList.add(calPersonObj);
        }
        if (SWCListUtils.isEmpty((List)genValidPersonList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u8981\u6c42\u7684\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5df2\u7ecf\u5ba1\u6838\u540e\u4e14\u672a\u751f\u6210\u4e1a\u52a1\u6570\u636e\u7684\u6570\u636e\u3002", (String)"CalPersonGenBizDataPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        validIdList = genValidPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        returnData.put("gendate", this.getModel().getValue("gendate"));
        returnData.put(KEY_VALIDIDLIST, validIdList);
        returnData.put("taskId", taskId);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }
}

