/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.mvc.list.AbstractListView;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class HSASCalTableImportLogPlugin
extends AbstractBillPlugIn {
    public void initialize() {
        this.addClickListeners(new String[]{"exporterrfile"});
        this.addClickListeners(new String[]{"filename"});
    }

    public void afterBindData(EventObject eventObject) {
        String jsonData = (String)this.getModel().getValue("data");
        this.refreshByData(jsonData);
        String importstatus = (String)this.getModel().getValue("importstatus");
        if ("1".equals(importstatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsuspend"});
        }
    }

    public void afterLoadData(EventObject e) {
        String jsonData;
        if (!this.parentIsCurBillListView()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        if (StringUtils.isBlank((CharSequence)(jsonData = (String)this.getModel().getValue("data")))) {
            return;
        }
        JSONObject data = JSON.parseObject((String)jsonData);
        this.getModel().setValue("data", (Object)data);
        Date createTime = (Date)this.getModel().getValue("createtime");
        Date finishTime = (Date)this.getModel().getValue("modifytime");
        this.getModel().setValue("usetime", (Object)this.getUseTime(createTime, finishTime));
    }

    private void refreshByData(String jsonData) {
        if (StringUtils.isBlank((CharSequence)jsonData)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exporterrfile"});
            Label errfileName1 = (Label)this.getView().getControl("exporterrfile");
            errfileName1.setText("");
            return;
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("importurls", 1);
        JSONObject info = JSON.parseObject((String)jsonData).getJSONObject("info");
        int total = Integer.parseInt(info.get((Object)"total").toString());
        int failed = Integer.parseInt(info.get((Object)"failed").toString());
        String srcFile = (String)info.get((Object)"srcFile");
        String filename = srcFile.substring(srcFile.lastIndexOf(47) + 1);
        Label fileName = (Label)this.getView().getControl("filename");
        Label succeedcount = (Label)this.getView().getControl("succeedcount");
        Label failedcount = (Label)this.getView().getControl("failedcount");
        fileName.setText(filename);
        succeedcount.setText(String.valueOf(total - failed));
        failedcount.setText(String.valueOf(failed));
        model.setValue("errfile", info.get((Object)"errFile"));
        model.setValue("importfile", info.get((Object)"srcFile"));
        model.setValue("total", (Object)total);
        model.setValue("failed", (Object)failed);
        if (failed == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exporterrfile", "logsflex"});
            Label errfileName = (Label)this.getView().getControl("exporterrfile");
            errfileName.setText("");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exporterrfile", "logsflex"});
            Label errfileName = (Label)this.getView().getControl("exporterrfile");
            errfileName.setText(ResManager.loadKDString((String)"\u5bfc\u51fa\u9519\u8bef\u6570\u636e", (String)"HSASCalTableImportLogPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            Object errMsg = info.get((Object)"errMsg");
            if (errMsg != null) {
                Label errMsgLabel = (Label)this.getView().getControl("errmsg1");
                errMsgLabel.setText(errMsg.toString());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.getModel().setDataChanged(false);
        String jsonData = (String)this.getModel().getValue("data");
        this.refreshByData(jsonData);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void click(EventObject evt) {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000003ae")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6838\u7b97\u540d\u5355\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HSASCalTableImportLogPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("exporterrfile".equals(((Control)evt.getSource()).getKey())) {
            String errFilePath = (String)this.getModel().getValue("errfile");
            if (StringUtils.isBlank((CharSequence)errFilePath)) {
                return;
            }
            this.getView().download(errFilePath);
        } else if ("filename".equals(((Control)evt.getSource()).getKey())) {
            String importFilePath = (String)this.getModel().getValue("importfile");
            if (StringUtils.isBlank((CharSequence)importFilePath)) {
                return;
            }
            this.getView().download(importFilePath);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btnsuspend".equals(evt.getItemKey())) {
            String billFormId = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("MainEntityId");
            String appId = EntityMetadataCache.getDataEntityType((String)billFormId).getAppId();
            AppCache.get((String)appId).put("IMPT_SUSPEND_" + billFormId, (Object)("IMPT_SUSPEND" + billFormId));
        }
    }

    private String getUseTime(Date createtime, Date finishTime) {
        String secondDes = ResManager.loadKDString((String)"\u79d2", (String)"ImportLogPlugin_2", (String)"bos-form-business", (Object[])new Object[0]);
        String minuteDes = ResManager.loadKDString((String)"\u5206\u949f", (String)"ImportLogPlugin_3", (String)"bos-form-business", (Object[])new Object[0]);
        String hourDes = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"ImportLogPlugin_4", (String)"bos-form-business", (Object[])new Object[0]);
        String useTime = "1" + secondDes;
        if (null != createtime && null != finishTime) {
            long between = (finishTime.getTime() - createtime.getTime()) / 1000L;
            if (between != 0L) {
                StringBuilder sb = new StringBuilder();
                long hour = between / 3600L;
                long minute = between % 3600L / 60L;
                long second = between % 60L;
                if (hour != 0L) {
                    sb.append(hour).append(hourDes);
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else if (minute != 0L) {
                    sb.append(minute).append(minuteDes);
                    sb.append(second).append(secondDes);
                } else {
                    sb.append(second).append(secondDes);
                }
                useTime = sb.toString();
            }
        } else {
            useTime = "";
        }
        return useTime;
    }

    private boolean parentIsCurBillListView() {
        String parentBillId;
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        String formId = view.getEntityId();
        return parentView instanceof AbstractListView && StringUtils.equals((CharSequence)formId, (CharSequence)(parentBillId = ((IListView)parentView).getBillFormId()));
    }
}

