/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.paynode.PayNodeHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections.CollectionUtils;

public class PayNodeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String DONOTHING_ADDITEM = "donothing_additem";
    private static final String BIZ_ITEM = "bizitem";
    private static final String KEY_ENTRYENTITYGET = "entryentityget";
    private static final String PAY_NODE_GRP = "paynodegrp";
    private static final String PAY_NODE_GRP_HIS = "paynodegrphis";
    private static final String PAY_NODE_GRP_ENT = "paynodegrpent";
    private static final String KEY_BIZALLCFG = "bizallcfg";
    private static final String ADVCONAP = "advconap";
    private static final String ADD_CAL_RULE = "add_calrule";
    private static final String CAL_PERIOD_TYPE_ID = "calperiodtype.id";
    private static final String PAY_NODE_TYPE = "paynodetype";
    private static final String DELETE_ENTRY = "deleteentry";
    private final SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynode");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit payNodeGrpHis = (BasedataEdit)this.getView().getControl(PAY_NODE_GRP_HIS);
        payNodeGrpHis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payNodeGrpEnt = (BasedataEdit)this.getView().getControl(PAY_NODE_GRP_ENT);
        payNodeGrpEnt.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payNodeGrp = (BasedataEdit)this.getView().getControl(PAY_NODE_GRP);
        payNodeGrp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject payNodeGrp = dataEntity.getDynamicObject(PAY_NODE_GRP);
        DynamicObject payNodeGrpHis = dataEntity.getDynamicObject(PAY_NODE_GRP_HIS);
        this.getView().setEnable(Boolean.valueOf(payNodeGrp != null), new String[]{PAY_NODE_GRP_HIS});
        this.getView().setEnable(Boolean.valueOf(payNodeGrpHis != null), new String[]{PAY_NODE_GRP_ENT});
        this.initShowType();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "donothing_additem": {
                if (this.getModel().getDataEntity().getDynamicObject("createorg") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"PayNodeEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject payNodeGrpHis = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS);
                if (payNodeGrpHis == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u3002", (String)"PayNodeEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)"hsbs_bizitemgroup", (boolean)true);
                Object[] selectBizItems = this.getSelectRows();
                showListForm.setSelectedRows(selectBizItems);
                QFilter qFilter = new QFilter("enable", "=", (Object)"1");
                QFilter andFilter = qFilter.and(new QFilter("status", "=", (Object)"C")).and(this.notExistQFilter());
                andFilter.and(this.matchPeriodQFilter());
                qFilter.and(new QFilter("createorg", "=", (Object)this.getModel().getDataEntity().getLong("createorg.id")));
                showListForm.getListFilterParameter().setFilter(qFilter);
                showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DONOTHING_ADDITEM));
                this.getView().showForm((FormShowParameter)showListForm);
                break;
            }
            case "save": {
                DynamicObject dataEntity;
                DynamicObject dy;
                Set<Long> calPeriodIds = this.getCalPeriodIds();
                if (calPeriodIds.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea6\u675f\u5bf9\u8c61\u5b58\u5728\u591a\u4e2a\u671f\u95f4\u7c7b\u578b\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PayNodeEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!Objects.nonNull(dy = PayNodeHelper.getSameCons((DynamicObject)(dataEntity = this.getModel().getDataEntity())))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u4e2d\u5df2\u5b58\u5728\u542f\u7528\u4e86\u5168\u90e8\u4e1a\u52a1\u9879\u76ee\u7684\u7ea6\u675f\u8bbe\u7f6e\uff0c\u8bf7\u5148\u7981\u7528\u540e\u518d\u6dfb\u52a0\u3002", (String)"PayNodeEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{dy.getString("name")}));
                args.setCancel(true);
                break;
            }
            case "newentry": {
                if (!Objects.isNull(this.getModel().getDataEntity().get(PAY_NODE_GRP_HIS))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u65f6\u95f4\u7a97\u53e3\u6a21\u677f\u7248\u672c\u201d\u3002", (String)"PayNodeEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs.length > 0 && "entryentity".equals(entryProp.getName())) {
            this.showConfirm(DELETE_ENTRY, ResManager.loadKDString((String)"\u5220\u9664\u540e\u8be5\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u7684\u4e1a\u52a1\u6570\u636e\u5c06\u4e0d\u518d\u53d7\u5230\u65f6\u95f4\u7a97\u53e3\u7684\u9650\u5236\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PayNodeEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "", SerializationUtils.toJsonString((Object)rowIndexs));
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        List validateResults = Optional.ofNullable(args.getOperationResult()).map(OperationResult::getValidateResult).map(ValidateResultCollection::getValidateErrors).orElseGet(Collections::emptyList);
        FormOperate operate = (FormOperate)args.getSource();
        if ("save".equals(operate.getOperateKey()) && validateResults.isEmpty()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PayNodeEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private QFilter notExistQFilter() {
        QFilter notSelf = new QFilter("id", "!=", this.getModel().getDataEntity().getPkValue());
        DynamicObject[] dys = this.helper.query("entryentity.bizitem", new QFilter[]{notSelf});
        List pkIds = Arrays.stream(dys).map(dy -> dy.getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(dy -> dy.get("bizitem.id")).collect(Collectors.toList());
        return new QFilter("id", "not in", pkIds);
    }

    private QFilter matchPeriodQFilter() {
        Long calPeriodTypeId = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP_HIS).getLong(CAL_PERIOD_TYPE_ID);
        return new QFilter("calperiodtype", "=", (Object)calPeriodTypeId);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "donothing_additem": {
                Object returnData = closedCallBackEvent.getReturnData();
                ArrayList<Long> bizItems = new ArrayList(10);
                if (returnData instanceof ListSelectedRowCollection) {
                    ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                    for (ListSelectedRow selectedRow : listSelectedRows) {
                        bizItems.add((Long)selectedRow.getPrimaryKeyValue());
                    }
                } else if (returnData instanceof List) {
                    bizItems = (List)returnData;
                }
                if (bizItems.size() <= 0) break;
                DynamicObjectCollection beforeDelEntryEntities = this.getModel().getEntryEntity("entryentity");
                Map<Integer, DynamicObject> deleteBizItems = this.getDelEntryBizItem(bizItems, beforeDelEntryEntities);
                int[] delRowIndex = this.getDelRowIndex(deleteBizItems);
                this.getModel().deleteEntryRows("entryentity", delRowIndex);
                List<Long> addNewBizItem = this.getAddNewBizItemID(bizItems, beforeDelEntryEntities);
                this.batchCreateNewEntry(addNewBizItem);
                break;
            }
            case "paynodegrp": {
                ListSelectedRowCollection payNodeGrpId = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (Objects.isNull(payNodeGrpId) || payNodeGrpId.get(0).getPrimaryKeyValue().equals(this.getModel().getDataEntity().getLong("paynodegrp.id"))) break;
                this.getModel().setValue(PAY_NODE_GRP, payNodeGrpId.get(0).getPrimaryKeyValue());
                this.getModel().beginInit();
                this.getModel().deleteEntryData("entryentity");
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    private Object[] getSelectRows() {
        DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("entryentity");
        Object[] selectBizItems = new Object[entryEntities.size()];
        for (int index = 0; index < entryEntities.size(); ++index) {
            selectBizItems[index] = ((DynamicObject)entryEntities.get(index)).getLong("bizitem.id");
        }
        return selectBizItems;
    }

    private int[] getDelRowIndex(Map<Integer, DynamicObject> deleteBizItems) {
        int[] delRowIndex = new int[deleteBizItems.size()];
        int index = 0;
        for (Map.Entry<Integer, DynamicObject> deleteBizItem : deleteBizItems.entrySet()) {
            delRowIndex[index++] = deleteBizItem.getKey();
        }
        return delRowIndex;
    }

    private void batchCreateNewEntry(List<Long> addNewBizItem) {
        if (addNewBizItem.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter entry = new TableValueSetter(new String[0]);
        entry.addField(BIZ_ITEM, new Object[0]);
        for (Long bizItem : addNewBizItem) {
            entry.addRow(new Object[]{bizItem});
        }
        model.batchCreateNewEntryRow("entryentity", entry);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<Long> getAddNewBizItemID(List<Long> bizItems, DynamicObjectCollection beforeDelEntryEntities) {
        HashMap<Long, DynamicObject> beforeDelEntryEntityMap = new HashMap<Long, DynamicObject>(beforeDelEntryEntities.size());
        for (DynamicObject beforeDelEntryEntity : beforeDelEntryEntities) {
            beforeDelEntryEntityMap.put((Long)beforeDelEntryEntity.getDynamicObject(BIZ_ITEM).getPkValue(), beforeDelEntryEntity);
        }
        ArrayList<Long> addNewBizItem = new ArrayList<Long>(10);
        for (Long bizItemId : bizItems) {
            if (beforeDelEntryEntityMap.containsKey(bizItemId)) continue;
            addNewBizItem.add(bizItemId);
        }
        return addNewBizItem;
    }

    private Map<Integer, DynamicObject> getDelEntryBizItem(List<Long> bizItems, DynamicObjectCollection beforeDelEntryEntities) {
        HashSet<Long> bizItemSet = new HashSet<Long>(bizItems);
        HashMap<Integer, DynamicObject> deleteBizItems = new HashMap<Integer, DynamicObject>(16);
        for (int index = 0; index < beforeDelEntryEntities.size(); ++index) {
            DynamicObject entryBizItem = ((DynamicObject)beforeDelEntryEntities.get(index)).getDynamicObject(BIZ_ITEM);
            Long entryBizItemID = (Long)entryBizItem.getPkValue();
            if (!bizItemSet.add(entryBizItemID)) continue;
            deleteBizItems.put(index, entryBizItem);
        }
        return deleteBizItems;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey;
        switch (fieldKey = event.getProperty().getName()) {
            case "paynodegrp": {
                this.setPayNodeGrpF7Filter(event);
                break;
            }
            case "paynodegrphis": {
                this.setPayNodeGrpHisF7Filter(event);
                break;
            }
            case "paynodegrpent": {
                this.setPayNodeGrpEntF7Filter(event);
                break;
            }
        }
    }

    private void setPayNodeGrpF7Filter(BeforeF7SelectEvent event) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entry)) {
            event.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u5c06\u6e05\u7a7a\u5df2\u6dfb\u52a0\u7684\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u3002\u662f\u5426\u5207\u6362\uff1f", (String)"PayNodeEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(PAY_NODE_GRP, (IFormPlugin)this));
            return;
        }
        Set<Long> ids = this.getCalPeriodIds();
        if (ids.isEmpty()) {
            return;
        }
        QFilter qFilterCalPeriodType = new QFilter("calperiodtype", "in", (Object)ids.toArray());
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilterCalPeriodType);
    }

    private Set<Long> getCalPeriodIds() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entry)) {
            return Collections.EMPTY_SET;
        }
        return entry.stream().map(dy -> dy.getLong("bizitem.calperiodtype.id")).collect(Collectors.toSet());
    }

    private void setPayNodeGrpEntF7Filter(BeforeF7SelectEvent event) {
        long workPlanId = this.getModel().getDataEntity().getLong("paynodegrphis.workplan.id");
        event.getFormShowParameter().setCustomParam("workPlanId", (Object)workPlanId);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject payNodeGrpHis = dataEntity.getDynamicObject(PAY_NODE_GRP_HIS);
        QFilter filter = new QFilter("vid", "in", payNodeGrpHis.getPkValue());
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{filter}));
    }

    private void setPayNodeGrpHisF7Filter(BeforeF7SelectEvent event) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject payNodeGrp = dataEntity.getDynamicObject(PAY_NODE_GRP);
        if (Objects.isNull(payNodeGrp)) {
            return;
        }
        QFilter boFilter = new QFilter("boid", "in", payNodeGrp.getPkValue());
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{boFilter, dataStatusFilter}));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        switch (fieldKey) {
            case "bizallcfg": {
                if (((Boolean)this.getModel().getValue(KEY_BIZALLCFG)).booleanValue()) {
                    this.getModel().deleteEntryData("entryentity");
                    this.getView().setVisible(Boolean.FALSE, new String[]{ADVCONAP});
                    break;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{ADVCONAP});
                break;
            }
            case "paynodegrp": {
                this.getModel().setValue(PAY_NODE_GRP_HIS, null);
                this.getModel().setValue(PAY_NODE_GRP_ENT, null);
                this.getView().setEnable(Boolean.TRUE, new String[]{PAY_NODE_GRP_HIS});
                this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_GRP_ENT});
                if (Objects.nonNull(changeData[0].getNewValue())) {
                    this.setPayNodeGrpHis();
                    break;
                }
                this.getModel().setValue(PAY_NODE_GRP_HIS, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_GRP_HIS});
                break;
            }
            case "paynodegrphis": {
                this.getModel().setValue(PAY_NODE_GRP_ENT, null);
                if (Objects.nonNull(changeData[0].getNewValue())) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{PAY_NODE_GRP_ENT});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_GRP_ENT});
                break;
            }
        }
    }

    private void showConfirm(String actionId, String title, String messages, String customValue) {
        if (SWCStringUtils.isEmpty((String)customValue)) {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this));
        } else {
            this.getView().showConfirm(title, messages, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(actionId, (IFormPlugin)this), new HashMap(2), customValue);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String customValue = messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "deleteentry": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                List objects = SerializationUtils.fromJsonStringToList((String)customValue, Integer.class);
                int[] ints = objects.stream().mapToInt(Integer::intValue).toArray();
                this.getModel().beginInit();
                this.getModel().deleteEntryRows("entryentity", ints);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "paynodegrp": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.openPayNodeGrp();
                break;
            }
        }
    }

    private void openPayNodeGrp() {
        ListShowParameter payNodeGrpForm = ShowFormHelper.createShowListForm((String)"hsas_paynodegrp", (boolean)false);
        Set<Long> ids = this.getCalPeriodIds();
        if (!ids.isEmpty()) {
            QFilter qFilterCalPeriodType = new QFilter("calperiodtype", "in", (Object)ids.toArray());
            payNodeGrpForm.getListFilterParameter().setFilter(qFilterCalPeriodType);
        }
        payNodeGrpForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PAY_NODE_GRP));
        this.getView().showForm((FormShowParameter)payNodeGrpForm);
    }

    private void initShowType() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String stat = this.getModel().getDataEntity().getString("status");
        if (OperationStatus.ADDNEW.equals((Object)status) || "A".equals(stat) && this.hasPerm()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap_close"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap_cancel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap_cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap_close"});
        }
        if ("B".equals(stat) || "C".equals(stat)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonap_save"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{ADVCONAP, KEY_BIZALLCFG});
        if (((Boolean)this.getModel().getValue(KEY_BIZALLCFG)).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADVCONAP});
        }
    }

    private boolean hasPerm() {
        return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)this.getView().getEntityId(), (String)"4715a0df000000ac");
    }

    private void setPayNodeGrpHis() {
        DynamicObject payNodeGrp = this.getModel().getDataEntity().getDynamicObject(PAY_NODE_GRP);
        QFilter boFilter = new QFilter("boid", "=", payNodeGrp.getPkValue());
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1"}));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paynodegrp");
        BaseDataHisHelper.addHisVerFilter((QFilter)boFilter);
        DynamicObject[] dyGrpHisArr = helper.query("bsed,datastatus", new QFilter[]{boFilter, dataStatusFilter});
        DynamicObject bsedDy = Arrays.stream(dyGrpHisArr).min(Comparator.comparing(dy -> dy.getDate("bsed"))).orElse(null);
        this.getModel().setValue(PAY_NODE_GRP_HIS, Objects.isNull(bsedDy) ? null : bsedDy.getPkValue());
    }
}

