/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.vo.PayNodeTimeConfig;
import kd.swc.hsas.formplugin.web.basedata.HisBaseDataSummaryEdit;
import kd.swc.hsbp.business.coderule.CodeRuleHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PayNodeGrpEdit
extends HisBaseDataSummaryEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PayNodeGrpEdit.class);
    public static final String NODENUMBER = "nodenumber";
    public static final String NODENAME = "nodename";
    private static final String START_TIME_OPERATION = "starttimeoperation";
    public static final String START_TIME_CHECK_BOX = "starttimebox";
    public static final String START_TIME_CFG = "starttimecfg";
    private static final String END_TIME_OPERATION = "endtimeoperate";
    public static final String END_TIME_CFG = "endtimecfg";
    private static final String PAY_NODE = "paynode";
    private static final String CAL_PERIOD_TYPE = "calperiodtype";
    private static final String PAY_NODE_RULE = "paynoderule";
    private static final String WORK_CALENDAR = "workcalendar";
    private static final String NO_DATA_FLEX = "nodataflex";
    private static final String IS_COPY = "is_copy";
    private static final String COUNTRY = "country";
    private static final String WORKPLAN = "workplan";
    private final SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsas_paynodegrpenthis");
    private static final String CALPERIOD_FIELD = "calperiodfield";
    private static final String END_CALPERIOD_FIELD = "endcalperiodfield";
    private static final Set<String> KEYS_CLEAR = Sets.newHashSet((Object[])new String[]{"calperiodfield", "calperiodway", "workrule", "holidayway", "workcalday", "specifictime"});
    private static final Set<String> KEYS_END_CLEAR = Sets.newHashSet((Object[])new String[]{"endcalperiodfield", "endcalperiodway", "endworkrule", "endholidayway", "endworkcalday", "endspecifictime"});
    private static final List<String> FIELD_PERIOD = Lists.newArrayList((Object[])new String[]{"calperiodfield", "calperiodway", "endcalperiodfield", "endcalperiodway"});
    private static final List<String> FIELD_CALENDAR = Lists.newArrayList((Object[])new String[]{"workrule", "workcalday", "endworkrule", "endworkcalday"});
    private static final Set<String> FIELD_OPERATION = Sets.newHashSet((Object[])new String[]{"starttimeoperation", "endtimeoperate"});

    public void afterCreateNewData(EventObject e) {
        this.setEntryFieldName();
    }

    public void afterLoadData(EventObject e) {
        this.setEntryFieldName();
    }

    public void beforeBindData(EventObject e) {
    }

    private void refreshEntryVisible() {
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = entry.getFieldEdits();
        ArrayList hideFields = FIELD_CALENDAR;
        ArrayList showFields = FIELD_PERIOD;
        if (WORK_CALENDAR.equals(this.getModel().getValue(PAY_NODE_RULE))) {
            hideFields = FIELD_PERIOD;
            showFields = FIELD_CALENDAR;
        } else if ("paydate".equals(this.getModel().getValue(PAY_NODE_RULE))) {
            showFields = Lists.newArrayList(FIELD_PERIOD);
            showFields.remove(CALPERIOD_FIELD);
            showFields.remove(END_CALPERIOD_FIELD);
            hideFields = Lists.newArrayList(FIELD_CALENDAR);
            hideFields.add(CALPERIOD_FIELD);
            hideFields.add(END_CALPERIOD_FIELD);
        }
        for (FieldEdit edit : fieldEdits) {
            if (hideFields.contains(edit.getFieldKey())) {
                edit.setVisible("beyondpolicy", false);
            }
            if (!showFields.contains(edit.getFieldKey())) continue;
            edit.setVisible("beyondpolicy", true);
        }
        this.getView().updateView("entryentity");
    }

    private void checkIsCopy() {
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView())) {
            return;
        }
        Boolean isCopy = Optional.ofNullable(this.getView().getFormShowParameter()).map(param -> param.getCustomParam("iscopy")).map(copy -> (Boolean)copy).orElse(Boolean.FALSE);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isCopyAgain = (Boolean)Optional.ofNullable(pageCache.get(IS_COPY, Boolean.class)).orElse(Boolean.FALSE);
        if (isCopy.booleanValue() && !isCopyAgain.booleanValue()) {
            int size = this.getModel().getEntryEntity("entryentity").size();
            for (int i = 0; i < size; ++i) {
                this.getModel().setValue(NODENUMBER, null, i);
            }
            pageCache.put(IS_COPY, (Object)Boolean.TRUE);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{NO_DATA_FLEX});
        this.checkIsCopy();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!entryEntity.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_RULE});
            for (int i = 0; i < entryEntity.size(); ++i) {
                PayNodeTimeConfig startConfig = (PayNodeTimeConfig)JSON.parseObject((String)((DynamicObject)entryEntity.get(i)).getString(START_TIME_CFG), PayNodeTimeConfig.class);
                PayNodeTimeConfig endConfig = (PayNodeTimeConfig)JSON.parseObject((String)((DynamicObject)entryEntity.get(i)).getString(END_TIME_CFG), PayNodeTimeConfig.class);
                this.initPayNodeTimeConfig(startConfig, true, i);
                this.initPayNodeTimeConfig(endConfig, false, i);
            }
        }
        this.getView().setEnable(Boolean.valueOf(this.getModel().getValue(COUNTRY) != null), new String[]{WORKPLAN, CAL_PERIOD_TYPE});
        boolean hisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (hisPage) {
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{START_TIME_CHECK_BOX});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", CAL_PERIOD_TYPE, COUNTRY});
        }
        this.refreshEntryVisible();
        DynamicObjectCollection entryEntity2 = this.getModel().getEntryEntity("entryentity");
        if (!entryEntity2.isEmpty()) {
            this.setEntryFieldName();
            this.getView().updateView("entryentity");
            this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_RULE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit payNodeGrpHis = (BasedataEdit)this.getView().getControl(CAL_PERIOD_TYPE);
        payNodeGrpHis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit workPlan = (BasedataEdit)this.getView().getControl(WORKPLAN);
        workPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (fieldKey) {
            case "starttimebox": {
                Boolean newValue = (Boolean)changeSet[0].getNewValue();
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                if (!newValue.booleanValue()) {
                    this.getModel().setValue(START_TIME_OPERATION, null, entryCurrentRowIndex);
                    KEYS_CLEAR.forEach(key -> this.getModel().setValue(key, null));
                    break;
                }
                this.getModel().setValue(START_TIME_OPERATION, (Object)this.getOperationName(), entryCurrentRowIndex);
                DynamicObject dy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
                PayNodeTimeConfig startConfig = (PayNodeTimeConfig)JSON.parseObject((String)dy.getString(START_TIME_CFG), PayNodeTimeConfig.class);
                this.initPayNodeTimeConfig(startConfig, true, entryCurrentRowIndex);
                break;
            }
            case "paynoderule": {
                this.refreshEntryVisible();
                if (!WORK_CALENDAR.equals(changeSet[0].getNewValue())) {
                    return;
                }
                DynamicObject calPeriodType = this.getModel().getDataEntity().getDynamicObject(CAL_PERIOD_TYPE);
                if (Objects.isNull(calPeriodType)) {
                    return;
                }
                SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calfrequency");
                DynamicObject dynamicObject = swcDataServiceHelper.queryOne((Object)calPeriodType.getString("calfrequency.id"));
                if (SWCStringUtils.equals((String)"MONTH", (String)dynamicObject.getString("type"))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u7c7b\u578b\u7684\u9891\u5ea6\u7c7b\u578b\u4e0d\u4e3a\u201c\u6708\u201d\uff0c\u65e0\u6cd5\u6309\u7167\u5de5\u4f5c\u65e5\u5386\u521b\u5efa\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayNodeGrpEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(PAY_NODE_RULE, null);
                break;
            }
            case "country": {
                this.getModel().setValue(CAL_PERIOD_TYPE, null);
                this.getModel().setValue(WORKPLAN, null);
                this.getView().setEnable(Boolean.valueOf(changeSet[0].getNewValue() != null), new String[]{WORKPLAN, CAL_PERIOD_TYPE});
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (fieldKey) {
            case "calperiodtype": {
                String payNodeRule = dataEntity.getString(PAY_NODE_RULE);
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                if (!SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject(COUNTRY))) {
                    QFilter qFilter = new QFilter(COUNTRY, "=", (Object)dataEntity.getLong("country.id")).or(new QFilter("areatype", "=", (Object)"1"));
                    showParameter.getListFilterParameter().setFilter(qFilter);
                }
                if (!WORK_CALENDAR.equals(payNodeRule)) {
                    return;
                }
                SWCDataServiceHelper swcDataServiceHelper = new SWCDataServiceHelper("hsbs_calfrequency");
                QFilter qFilterCalFrequency = new QFilter("type", "=", (Object)CalFrequencyEnum.MONTH.name());
                DynamicObject[] calFrequencies = swcDataServiceHelper.query("type", new QFilter[]{qFilterCalFrequency});
                List pkIds = Arrays.stream(calFrequencies).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                QFilter qFilter = new QFilter("calfrequency", "in", pkIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "workplan": {
                ListShowParameter workPlanShowParameter = (ListShowParameter)event.getFormShowParameter();
                QFilter countryFilter = new QFilter("countryid", "=", (Object)dataEntity.getLong("country.id"));
                workPlanShowParameter.getListFilterParameter().setFilter(countryFilter);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String operationName = this.getOperationName();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        this.getModel().setValue(END_TIME_OPERATION, (Object)operationName, entryEntity.size() - 1);
    }

    private void generateNumber(DynamicObject entryDy) {
        String number = String.valueOf(this.getModel().getValue("number"));
        String name = String.valueOf(this.getModel().getValue("name"));
        DynamicObject dy = this.swcDataServiceHelper.generateEmptyDynamicObject();
        dy.set("number", (Object)number);
        dy.set("name", (Object)name);
        if (StringUtils.isEmpty((CharSequence)entryDy.getString(NODENUMBER)) || !entryDy.getString(NODENUMBER).startsWith(number)) {
            entryDy.set(NODENUMBER, (Object)CodeRuleHelper.getNumber((DynamicObject)dy, null));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u65f6\u95f4\u8282\u70b9\u3002", (String)"PayNodeGrpEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                for (DynamicObject dy : entryEntity) {
                    this.generateNumber(dy);
                }
                break;
            }
            case "newentry": {
                if (!SWCStringUtils.isEmpty((String)this.getModel().getDataEntity().getString(PAY_NODE_RULE))) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65f6\u95f4\u89c4\u5219\u57fa\u51c6\u3002", (String)"PayNodeGrpEdit_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "submit": 
            case "audit": 
            case "confirmchange": {
                OperationResult operationResult = args.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.setInVisible(false);
                this.getModel().setDataChanged(false);
                this.getView().updateView("entryentity");
                break;
            }
            case "unsubmit": {
                this.setInVisible(true);
                this.setEntryFieldName();
                this.getModel().setDataChanged(false);
                this.getView().updateView("entryentity");
                break;
            }
            case "newentry": {
                this.getView().setEnable(Boolean.FALSE, new String[]{PAY_NODE_RULE});
                break;
            }
            case "deleteentry": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                if (entryEntity.size() != 0) break;
                this.getView().setEnable(Boolean.TRUE, new String[]{PAY_NODE_RULE});
                break;
            }
            case "save": {
                this.getView().updateView("entryentity");
                break;
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Object source = hyperLinkClickEvent.getSource();
        if (source instanceof EntryGrid) {
            FormShowParameter parameters = this.getFormShowParameter(hyperLinkClickEvent);
            this.getView().showForm(parameters);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "starttimeoperation": {
                PayNodeTimeConfig startOperationReturnData = (PayNodeTimeConfig)closedCallBackEvent.getReturnData();
                if (startOperationReturnData == null) break;
                this.initPayNodeTimeConfig(startOperationReturnData, true, this.getModel().getEntryCurrentRowIndex("entryentity"));
                this.getModel().setValue(START_TIME_CFG, (Object)JSON.toJSONString((Object)startOperationReturnData));
                this.getModel().setValue(NODENAME, (Object)startOperationReturnData.getNodeName());
                break;
            }
            case "endtimeoperate": {
                PayNodeTimeConfig endOperationReturnData = (PayNodeTimeConfig)closedCallBackEvent.getReturnData();
                if (endOperationReturnData == null) break;
                this.initPayNodeTimeConfig(endOperationReturnData, false, this.getModel().getEntryCurrentRowIndex("entryentity"));
                this.getModel().setValue(END_TIME_CFG, (Object)JSON.toJSONString((Object)endOperationReturnData));
                this.getModel().setValue(NODENAME, (Object)endOperationReturnData.getNodeName());
                break;
            }
        }
    }

    private void initPayNodeTimeConfig(PayNodeTimeConfig payNodeTimeConfig, boolean isStart, int index) {
        boolean holidayEnable;
        boolean isOpen = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(index)).getBoolean(START_TIME_CHECK_BOX);
        if (!isOpen && isStart || payNodeTimeConfig == null || !payNodeTimeConfig.getAutoCreateEnable()) {
            if (isStart) {
                KEYS_CLEAR.forEach(key -> this.getModel().setValue(key, null, index));
            } else {
                KEYS_END_CLEAR.forEach(key -> this.getModel().setValue(key, null, index));
            }
            return;
        }
        String workRuleKey = isStart ? "workrule" : "end".concat("workrule");
        String workCalDayKey = isStart ? "workcalday" : "end".concat("workcalday");
        String calPeriodFieldKey = isStart ? CALPERIOD_FIELD : "end".concat(CALPERIOD_FIELD);
        String calPeriodWayKey = isStart ? "calperiodway" : "end".concat("calperiodway");
        String holidayWayKey = isStart ? "holidayway" : "end".concat("holidayway");
        String specificTimeKey = isStart ? "specifictime" : "end".concat("specifictime");
        String payNodeRule = payNodeTimeConfig.getPayNodeRule();
        if (WORK_CALENDAR.equals(payNodeRule)) {
            this.getModel().setValue(workRuleKey, (Object)payNodeTimeConfig.getWorkRule(), index);
            if (payNodeTimeConfig.getWorkCalDay() > 0) {
                this.getModel().setValue(workCalDayKey, (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6bcf\u6708%s\u65e5", (String)"PayNodeGrpEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), payNodeTimeConfig.getWorkCalDay()), index);
            }
        } else {
            this.getModel().setValue(calPeriodFieldKey, (Object)payNodeTimeConfig.getCalPeriodField(), index);
            this.getModel().setValue(calPeriodWayKey, (Object)(this.getConfigValue(payNodeTimeConfig.getCalPeriodWay()) + payNodeTimeConfig.getCalPeriodDays() + this.getConfigValue(payNodeTimeConfig.getDateType())), index);
        }
        if (holidayEnable = payNodeTimeConfig.getHolidayEnable()) {
            this.getModel().setValue(holidayWayKey, (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u53d6\u5de5\u4f5c\u65e5", (String)"PayNodeGrpEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), this.getConfigValue(payNodeTimeConfig.getHolidayWay())), index);
        } else {
            this.getModel().setValue(holidayWayKey, (Object)ResManager.loadKDString((String)"\u4e0d\u9700\u8981", (String)"PayNodeGrpEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), index);
        }
        Integer specificTime = payNodeTimeConfig.getSpecificTime();
        if (specificTime == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(10, specificTime / 3600);
        calendar.set(12, specificTime % 3600 / 60);
        this.getModel().setValue(specificTimeKey, (Object)SWCDateTimeUtils.format((Date)calendar.getTime(), (String)SWCDateTimeUtils.getUserTimeFormat()), index);
    }

    private String getConfigValue(String key) {
        String before = ResManager.loadKDString((String)"\u5411\u524d", (String)"PayNodeGrpEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String after = ResManager.loadKDString((String)"\u5411\u540e", (String)"PayNodeGrpEdit_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String natural = ResManager.loadKDString((String)"\u81ea\u7136\u65e5", (String)"PayNodeGrpEdit_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        String work = ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5", (String)"PayNodeGrpEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        HashMap configMap = Maps.newHashMapWithExpectedSize((int)4);
        configMap.put("before", before);
        configMap.put("after", after);
        configMap.put("natural", natural);
        configMap.put("work", work);
        return (String)configMap.get(key);
    }

    private FormShowParameter getFormShowParameter(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        String title = this.getPayNodeTimeRuleCfgTitle(fieldName);
        String data = this.getPayNodeTimeRuleCfg(this.getModel().getEntryRowEntity("entryentity", hyperLinkClickEvent.getRowIndex()), fieldName);
        DynamicObject entryDy = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(hyperLinkClickEvent.getRowIndex());
        PayNodeTimeConfig config = Optional.ofNullable(JSON.parseObject((String)data, PayNodeTimeConfig.class)).orElseGet(PayNodeTimeConfig::new);
        config.setNodeName(entryDy.getString(NODENAME));
        config.setNodeNumber(entryDy.getString(NODENUMBER));
        config.setPayNodeRule(this.getModel().getDataEntity().getString(PAY_NODE_RULE));
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("hsas_paynodetimecfg");
        parameters.setShowTitle(false);
        parameters.setStatus(this.getOperationStatus());
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("data", (Object)JSON.toJSONString((Object)config));
        parameters.setCustomParam(PAY_NODE_RULE, this.getModel().getValue(PAY_NODE_RULE));
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldName));
        return parameters;
    }

    private String getPayNodeTimeRuleCfg(DynamicObject dynamicObject, String operationKey) {
        switch (operationKey) {
            case "starttimeoperation": {
                return dynamicObject.getString(START_TIME_CFG);
            }
            case "endtimeoperate": {
                return dynamicObject.getString(END_TIME_CFG);
            }
        }
        return null;
    }

    private String getPayNodeTimeRuleCfgTitle(String operationKey) {
        switch (operationKey) {
            case "starttimeoperation": {
                return ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u89c4\u5219", (String)"PayNodeGrpEdit_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
            case "endtimeoperate": {
                return ResManager.loadKDString((String)"\u622a\u6b62\u65f6\u95f4\u89c4\u5219", (String)"PayNodeGrpEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    private void setEntryFieldName() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String operationName = this.getOperationName();
        for (DynamicObject dynamicObject : entryEntity) {
            if (dynamicObject.getBoolean(START_TIME_CHECK_BOX)) {
                dynamicObject.set(START_TIME_OPERATION, (Object)operationName);
            }
            dynamicObject.set(END_TIME_OPERATION, (Object)operationName);
        }
        this.getModel().setDataChanged(false);
    }

    private String getOperationName() {
        if (OperationStatus.VIEW.equals((Object)this.getOperationStatus())) {
            this.setInVisible(false);
        }
        return ResManager.loadKDString((String)"\u7f16\u8f91", (String)"PayNodeGrpEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
    }

    private void setInVisible(boolean enable) {
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        List fieldEdits = entry.getFieldEdits();
        for (FieldEdit edit : fieldEdits) {
            if (!FIELD_OPERATION.contains(edit.getFieldKey())) continue;
            edit.setVisible("beyondpolicy", enable);
        }
    }

    private OperationStatus getOperationStatus() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return OperationStatus.ADDNEW;
        }
        if (!this.isPermFlag()) {
            return OperationStatus.VIEW;
        }
        if (BaseDataHisHelper.isHisPage((IFormView)this.getView()) && "view".equals(this.getPageCache().get("pageStatus"))) {
            return OperationStatus.VIEW;
        }
        if (BaseDataHisHelper.isCurrPage((IFormView)this.getView())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String status = dataEntity.getString("status");
            if ("A".equals(status)) {
                return OperationStatus.EDIT;
            }
            return OperationStatus.VIEW;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("datastatus");
        if (StringUtils.isEmpty((CharSequence)status) || "-3".equals(status)) {
            return OperationStatus.EDIT;
        }
        return OperationStatus.VIEW;
    }

    private boolean isPermFlag() {
        return SWCPermissionServiceHelper.hasPerm((long)RequestContext.get().getCurrUserId(), (String)"/UHMBBGZQ65X", (String)this.getView().getEntityId(), (String)"4715a0df000000ac");
    }
}

