/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.swc.hsas.common.enums.PayNodeRuleEnum;
import kd.swc.hsas.common.vo.PayNodeTimeConfig;
import kd.swc.hsbp.business.util.MultiLangHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayNodeTimeConfigPlugin
extends AbstractFormPlugin {
    public static final String TITLE = "title";
    private static final String ENABLE_AUTO_CREATE = "autocreatebox";
    public static final String PAY_NODE_RULE = "paynoderule";
    private static final String CAL_PERIOD = "period";
    private static final String WORK_CALENDAR = "workcalendar";
    private static final String CAL_PERIOD_PAY = "paydate";
    private static final String CAL_PERIOD_FIELD = "calperiodfield";
    private static final String CAL_PERIOD_WAY = "calperiodway";
    private static final String CAL_PERIOD_DAYS = "calperioddays";
    private static final String CAL_PERIOD_DATE_TYPE = "datetype";
    private static final String HOLIDAY_AP = "holidayap";
    private static final String HOLIDAY = "holiday";
    private static final String HOLIDAY_WAY = "holidayway";
    private static final String WORK_CAL_DAY = "workcalday";
    private static final String WORK_RULE = "workrule";
    private static final String SPECIFIC_TIME = "specifictime";
    private static final String INTE_TIME_ZONE = "intetimezone";
    private static final int DEFAULT_SPECIFIC_TIME = 86399;
    public static final String DATA = "data";
    private static final String OPERATION_SAVE = "donothing_save";
    public static final String TIPS_AP = "tipsap";
    public static final String RULE_DESC = "ruledesc";
    private static final Set<Integer> LAST_DAY = new HashSet<Integer>(3);
    private static final String NOT_ENABLE = "none";
    private static final String FLEX_PANELAP_WAY = "flexpanelapway";
    private static final String CONFIGTITLE = "configtitle";
    private static final String FLEXPANELAP_TIP = "flexpanelaptip";
    private static final String LABELAP_TIP = "labelaptip";
    private static final String DONOTHING_HIDE = "donothing_hide";
    private static final String IS_CLOSE = "is_close";

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String title = (String)formShowParameter.getCustomParam(TITLE);
        Label label = (Label)this.getView().getControl(TITLE);
        Label labelConfig = (Label)this.getView().getControl(CONFIGTITLE);
        label.setText(title);
        labelConfig.setText(title);
        TimeEdit timeEdit = (TimeEdit)this.getView().getControl(SPECIFIC_TIME);
        timeEdit.setCaption(new LocaleString(title.substring(0, 4)));
        String payNodeRule = (String)formShowParameter.getCustomParam(PAY_NODE_RULE);
        model.setValue(PAY_NODE_RULE, (Object)payNodeRule);
        if (SWCStringUtils.equals((String)payNodeRule, (String)CAL_PERIOD_PAY)) {
            model.setValue(CAL_PERIOD_WAY, (Object)"before");
        }
        if (formShowParameter.getCustomParam(DATA) == null || SWCStringUtils.isEmpty((String)((String)formShowParameter.getCustomParam(DATA)))) {
            model.setValue(SPECIFIC_TIME, (Object)86399);
            model.setValue(INTE_TIME_ZONE, (Object)InteServiceHelper.getUserTimezone((Long)RequestContext.get().getCurrUserId()));
            this.getView().setVisible(Boolean.FALSE, new String[]{TIPS_AP});
        } else {
            PayNodeTimeConfig payNodeTimeConfig = (PayNodeTimeConfig)JSONObject.parseObject((String)((String)formShowParameter.getCustomParam(DATA)), PayNodeTimeConfig.class);
            this.initDynamicObject(model, payNodeTimeConfig);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IFormView view = this.getView();
        OperationStatus parentStatus = view.getFormShowParameter().getStatus();
        Boolean initPageStatus = Boolean.TRUE;
        if (OperationStatus.VIEW.equals((Object)parentStatus)) {
            initPageStatus = Boolean.FALSE;
            view.setEnable(Boolean.FALSE, new String[]{ENABLE_AUTO_CREATE, SPECIFIC_TIME, INTE_TIME_ZONE});
        } else if (!dataEntity.getBoolean(ENABLE_AUTO_CREATE)) {
            view.setEnable(Boolean.FALSE, new String[]{SPECIFIC_TIME, INTE_TIME_ZONE});
            initPageStatus = Boolean.FALSE;
        } else {
            this.getModel().setValue(RULE_DESC, (Object)this.buildRuleDesc());
        }
        this.initPageAttribute(initPageStatus);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "autocreatebox": {
                this.setEnable((Boolean)changeData.getNewValue());
                break;
            }
            case "workcalday": {
                String workCalDay;
                if (newValue == null || !LAST_DAY.contains(Integer.valueOf(workCalDay = (String)newValue))) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP_TIP});
                ((Label)this.getControl(LABELAP_TIP)).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5982\u679c\u8be5\u6708\u5e76\u65e0%s\u53f7\uff0c\u5c06\u53d6\u8be5\u6708\u6700\u540e\u4e00\u5929\u3002", (String)"PayNodeTimeConfigPlugin_0", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), workCalDay));
                break;
            }
            case "datetype": {
                if (SWCStringUtils.equals((String)"natural", (String)((String)newValue))) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{HOLIDAY_WAY});
                    break;
                }
                this.getModel().setValue(HOLIDAY_WAY, (Object)NOT_ENABLE);
                this.getView().setEnable(Boolean.FALSE, new String[]{HOLIDAY_WAY});
                break;
            }
            case "holidayway": {
                this.getModel().setValue(HOLIDAY, (Object)(!NOT_ENABLE.equals(this.getModel().getDataEntity().getString(HOLIDAY_WAY)) ? 1 : 0));
                break;
            }
        }
        this.showRuleDesc(name);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (OPERATION_SAVE.equals(operateKey)) {
            if (dataEntity.getDynamicObject(INTE_TIME_ZONE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u65f6\u533a\u201d", (String)"PayNodeTimeConfigPlugin_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean holidayEnable = dataEntity.getBoolean(HOLIDAY);
            String dateType = dataEntity.getString(CAL_PERIOD_DATE_TYPE);
            if (dataEntity.getBoolean(ENABLE_AUTO_CREATE) && holidayEnable && SWCStringUtils.isEmpty((String)dataEntity.getString(HOLIDAY_WAY)) && (SWCStringUtils.equals((String)dateType, (String)"natural") || SWCStringUtils.equals((String)dataEntity.getString(PAY_NODE_RULE), (String)WORK_CALENDAR))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9047\u975e\u5de5\u4f5c\u65e5\u5982\u4f55\u5904\u7406\u3002", (String)"PayNodeTimeConfigPlugin_1", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            PayNodeTimeConfig returnData = this.buildReturnData(dataEntity);
            this.returnDataToParent(returnData);
        } else if (DONOTHING_HIDE.equals(operateKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_TIP});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operate.getOperateKey();
        if (OPERATION_SAVE.equals(operateKey)) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put(IS_CLOSE, (Object)Boolean.TRUE);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isContinueClose = (Boolean)pageCache.get(IS_CLOSE, Boolean.class);
        if (null == isContinueClose || !isContinueClose.booleanValue()) {
            IDataModel dataModel = this.getModel();
            IFormView view = this.getView();
            String desc = "";
            if (dataModel.getDataChanged()) {
                desc = dataModel.getChangeDesc();
                PayNodeTimeConfigPlugin.showChangeForm(view, (IFormPlugin)this, desc);
                e.setCancel(true);
            }
        } else {
            pageCache.remove(IS_CLOSE);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "continue_close": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(IS_CLOSE, (Object)Boolean.TRUE);
                this.getModel().setDataChanged(false);
                this.getView().invokeOperation("close");
                break;
            }
        }
    }

    private String buildRuleDesc() {
        String ruleDesc = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String payNodeRule = (String)formShowParameter.getCustomParam(PAY_NODE_RULE);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (payNodeRule) {
            case "period": {
                String calPeriodField = dataEntity.getString(CAL_PERIOD_FIELD);
                String calPeriodWay = dataEntity.getString(CAL_PERIOD_WAY);
                BigDecimal calPeriodDays = (BigDecimal)this.getModel().getValue(CAL_PERIOD_DAYS);
                String calPeriodDateType = dataEntity.getString(CAL_PERIOD_DATE_TYPE);
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0\uff1a\u4ee5{0}\u4e3a\u65f6\u95f4\u951a\u70b9\uff0c{1}\u504f\u79fb{2}{3}", (String)"PayNodeTimeConfigPlugin_8", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)calPeriodField), PayNodeRuleEnum.getDesc((String)calPeriodWay), calPeriodDays == null ? Integer.valueOf(0) : calPeriodDays, PayNodeRuleEnum.getDesc((String)calPeriodDateType));
                if (SWCStringUtils.equals((String)calPeriodDateType, (String)"natural") && dataEntity.getBoolean(HOLIDAY)) {
                    ruleDesc = this.buildHolidayRule(ruleDesc, dataEntity);
                }
                return ruleDesc;
            }
            case "workcalendar": {
                String workRule = dataEntity.getString(WORK_RULE);
                int workCalDay = dataEntity.getInt(WORK_CAL_DAY);
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0\uff1a\u5bf9\u7167\u5de5\u4f5c\u65e5\u5386\uff0c\u5728{0}\u627e\u6bcf\u6708{1}\u65e5", (String)"PayNodeTimeConfigPlugin_10", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)workRule), workCalDay);
                if (dataEntity.getBoolean(HOLIDAY)) {
                    ruleDesc = this.buildHolidayRule(ruleDesc, dataEntity);
                }
                return ruleDesc;
            }
            case "paydate": {
                String calPeriodPayDateWay = dataEntity.getString(CAL_PERIOD_WAY);
                String calPeriodPayDateDateType = dataEntity.getString(CAL_PERIOD_DATE_TYPE);
                BigDecimal calPeriodPayDays = (BigDecimal)this.getModel().getValue(CAL_PERIOD_DAYS);
                ruleDesc = MessageFormat.format(ResManager.loadKDString((String)"\u89c4\u5219\u63cf\u8ff0\uff1a\u4ee5\u5f53\u524d\u671f\u95f4\u7684\u652f\u4ed8\u65e5\u671f\u4e3a\u951a\u70b9\uff0c{0}\u504f\u79fb{1}{2}", (String)"PayNodeTimeConfigPlugin_9", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)calPeriodPayDateWay), calPeriodPayDays == null ? Integer.valueOf(0) : calPeriodPayDays, PayNodeRuleEnum.getDesc((String)calPeriodPayDateDateType));
                if (SWCStringUtils.equals((String)calPeriodPayDateDateType, (String)"natural") && dataEntity.getBoolean(HOLIDAY)) {
                    ruleDesc = this.buildHolidayRule(ruleDesc, dataEntity);
                }
                return ruleDesc;
            }
        }
        return ruleDesc;
    }

    private String buildHolidayRule(String ruleDesc, DynamicObject dataEntity) {
        String holidayWay = dataEntity.getString(HOLIDAY_WAY);
        if (SWCStringUtils.isNotEmpty((String)holidayWay)) {
            ruleDesc = ruleDesc + MultiLangHelper.getMultiLangCommaDelimiter() + MessageFormat.format(ResManager.loadKDString((String)"\u5982\u9047\u975e\u5de5\u4f5c\u65e5\uff0c{0}\u53d6\u6700\u8fd1\u7684\u5de5\u4f5c\u65e5", (String)"PayNodeTimeConfigPlugin_11", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), PayNodeRuleEnum.getDesc((String)holidayWay));
        }
        return ruleDesc;
    }

    public static void showChangeForm(IFormView view, IFormPlugin plugin, String desc) {
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("continue_close", plugin);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PayNodeTimeConfigPlugin_3", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PayNodeTimeConfigPlugin_4", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String str1 = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"PayNodeTimeConfigPlugin_5", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        String str2 = ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"PayNodeTimeConfigPlugin_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]);
        String message = str1 + "\\r\\n" + str2;
        view.showConfirm(message, desc, options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
    }

    private void addTips() {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(PAY_NODE_RULE);
        Tips tips = new Tips();
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8be5\u89c4\u5219\u4ec5\u652f\u6301\u9891\u5ea6\u4e3a\u6708\u7684\u671f\u95f4\u7c7b\u578b", (String)"PayNodeTimeConfigPlugin_12", (String)"swc-hsbs-formplugin", (Object[])new Object[0])));
        tips.setType("text");
        tips.setTriggerType("hover");
        comboEdit.addTips(tips);
    }

    private void setEnable(Boolean autoCreateStatus) {
        IFormView view = this.getView();
        view.setEnable(autoCreateStatus, new String[]{HOLIDAY, SPECIFIC_TIME, INTE_TIME_ZONE});
        this.initPageAttribute(autoCreateStatus);
        if (autoCreateStatus.booleanValue()) {
            this.getModel().setValue(RULE_DESC, (Object)this.buildRuleDesc());
            view.setVisible(Boolean.TRUE, new String[]{TIPS_AP});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{TIPS_AP});
        }
    }

    private void showRuleDesc(String name) {
        switch (name) {
            case "calperiodfield": 
            case "calperiodway": 
            case "calperioddays": 
            case "datetype": 
            case "workcalday": 
            case "workrule": 
            case "holiday": 
            case "holidayway": {
                this.getModel().setValue(RULE_DESC, (Object)this.buildRuleDesc());
                break;
            }
        }
    }

    private void setFieldMustInput(boolean tag, String ... keys) {
        for (String key : keys) {
            FieldEdit fieldEdit = (FieldEdit)this.getControl(key);
            fieldEdit.setMustInput(tag);
            fieldEdit.setVisible(key, tag);
        }
    }

    private void setHolidayApVisible() {
        IDataModel model = this.getModel();
        String dataType = model.getDataEntity().getString(CAL_PERIOD_DATE_TYPE);
        if (SWCStringUtils.isNotEmpty((String)dataType)) {
            if (SWCStringUtils.equals((String)dataType, (String)"natural")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{HOLIDAY_AP});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{HOLIDAY_AP});
            }
        }
    }

    private void initDynamicObject(IDataModel model, PayNodeTimeConfig payNodeTimeConfig) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_TIP});
        boolean autoCreateEnable = payNodeTimeConfig.getAutoCreateEnable();
        model.setValue("nodename", (Object)payNodeTimeConfig.getNodeName());
        model.setValue("nodenumber", (Object)payNodeTimeConfig.getNodeNumber());
        model.setValue(ENABLE_AUTO_CREATE, (Object)autoCreateEnable);
        model.setValue(PAY_NODE_RULE, (Object)payNodeTimeConfig.getPayNodeRule());
        String payNodeRule = payNodeTimeConfig.getPayNodeRule();
        if (WORK_CALENDAR.equals(payNodeRule)) {
            model.setValue(WORK_RULE, (Object)payNodeTimeConfig.getWorkRule());
            if (payNodeTimeConfig.getWorkCalDay() > 0) {
                model.setValue(WORK_CAL_DAY, (Object)payNodeTimeConfig.getWorkCalDay());
            }
            boolean holidayEnable = payNodeTimeConfig.getHolidayEnable();
            model.setValue(HOLIDAY, (Object)holidayEnable);
            if (holidayEnable) {
                model.setValue(HOLIDAY_WAY, (Object)payNodeTimeConfig.getHolidayWay());
            }
            this.getView().setVisible(Boolean.valueOf(payNodeTimeConfig.getWorkCalDay() > 28), new String[]{FLEXPANELAP_TIP});
        } else if (CAL_PERIOD.equals(payNodeRule)) {
            model.setValue(CAL_PERIOD_FIELD, (Object)payNodeTimeConfig.getCalPeriodField());
            String calPeriodWay = payNodeTimeConfig.getCalPeriodWay();
            if (calPeriodWay == null) {
                calPeriodWay = "before";
            }
            model.setValue(CAL_PERIOD_WAY, (Object)calPeriodWay);
            model.setValue(CAL_PERIOD_DAYS, (Object)payNodeTimeConfig.getCalPeriodDays());
            String datetype = payNodeTimeConfig.getDateType();
            if (datetype == null) {
                datetype = "natural";
            }
            model.setValue(CAL_PERIOD_DATE_TYPE, (Object)datetype);
            this.setHolidayFiled(model, payNodeTimeConfig, autoCreateEnable);
        } else if (CAL_PERIOD_PAY.equals(payNodeRule)) {
            String calPeriodWay = payNodeTimeConfig.getCalPeriodWay();
            if (calPeriodWay == null) {
                calPeriodWay = "before";
            }
            model.setValue(CAL_PERIOD_WAY, (Object)calPeriodWay);
            model.setValue(CAL_PERIOD_DAYS, (Object)payNodeTimeConfig.getCalPeriodDays());
            String datetype = payNodeTimeConfig.getDateType();
            if (datetype == null) {
                datetype = "natural";
            }
            model.setValue(CAL_PERIOD_DATE_TYPE, (Object)datetype);
            this.setHolidayFiled(model, payNodeTimeConfig, autoCreateEnable);
        }
        model.setValue(SPECIFIC_TIME, (Object)payNodeTimeConfig.getSpecificTime());
        if (payNodeTimeConfig.getInteTimeZoneId() != null) {
            this.getModel().setValue(INTE_TIME_ZONE, (Object)payNodeTimeConfig.getInteTimeZoneId());
        }
        this.getView().setVisible(Boolean.valueOf(autoCreateEnable), new String[]{TIPS_AP});
        if (autoCreateEnable) {
            model.setValue(RULE_DESC, (Object)this.buildRuleDesc());
        }
    }

    private void setHolidayFiled(IDataModel model, PayNodeTimeConfig payNodeTimeConfig, boolean autoCreateEnable) {
        String dateType = payNodeTimeConfig.getDateType();
        IFormView view = this.getView();
        if (SWCStringUtils.equals((String)"natural", (String)dateType)) {
            boolean holidayEnable = payNodeTimeConfig.getHolidayEnable();
            view.setVisible(Boolean.TRUE, new String[]{HOLIDAY_AP});
            view.setEnable(Boolean.valueOf(autoCreateEnable), new String[]{HOLIDAY});
            model.setValue(HOLIDAY, (Object)holidayEnable);
            view.setEnable(Boolean.valueOf(holidayEnable), new String[]{HOLIDAY_WAY});
            if (holidayEnable) {
                model.setValue(HOLIDAY_WAY, (Object)payNodeTimeConfig.getHolidayWay());
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{HOLIDAY_AP});
        }
    }

    private void initPageAttribute(Boolean autoCreateStatus) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String payNodeRule = (String)formShowParameter.getCustomParam(PAY_NODE_RULE);
        IFormView view = this.getView();
        view.setVisible(autoCreateStatus, new String[]{CAL_PERIOD_FIELD, WORK_RULE, WORK_CAL_DAY, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE, HOLIDAY, HOLIDAY_WAY, SPECIFIC_TIME});
        switch (payNodeRule) {
            case "period": {
                view.setVisible(Boolean.FALSE, new String[]{WORK_RULE, WORK_CAL_DAY});
                this.setFieldMustInput(false, WORK_RULE, WORK_CAL_DAY);
                this.setFieldMustInput(true, CAL_PERIOD_FIELD, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE);
                view.setEnable(autoCreateStatus, new String[]{CAL_PERIOD_FIELD, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE, HOLIDAY, HOLIDAY_WAY});
                this.setHolidayApVisible();
                break;
            }
            case "workcalendar": {
                view.setVisible(Boolean.FALSE, new String[]{CAL_PERIOD_FIELD, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE, FLEX_PANELAP_WAY});
                this.setFieldMustInput(false, CAL_PERIOD_FIELD, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE);
                this.setFieldMustInput(true, WORK_RULE, WORK_CAL_DAY);
                view.setVisible(Boolean.TRUE, new String[]{HOLIDAY_AP});
                view.setEnable(autoCreateStatus, new String[]{WORK_RULE, WORK_CAL_DAY, HOLIDAY, HOLIDAY_WAY});
                this.addTips();
                break;
            }
            case "paydate": {
                view.setVisible(Boolean.FALSE, new String[]{CAL_PERIOD_FIELD, WORK_RULE, WORK_CAL_DAY});
                this.setFieldMustInput(false, CAL_PERIOD_FIELD, WORK_RULE, WORK_CAL_DAY);
                this.setFieldMustInput(true, CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE);
                view.setEnable(autoCreateStatus, new String[]{CAL_PERIOD_WAY, CAL_PERIOD_DAYS, CAL_PERIOD_DATE_TYPE, HOLIDAY, HOLIDAY_WAY});
                this.setHolidayApVisible();
                break;
            }
        }
        if ("work".equals(this.getModel().getValue(CAL_PERIOD_DATE_TYPE))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{HOLIDAY_WAY});
        }
    }

    private PayNodeTimeConfig buildReturnData(DynamicObject dataEntity) {
        PayNodeTimeConfig returnData = new PayNodeTimeConfig();
        returnData.setAutoCreateEnable(dataEntity.getBoolean(ENABLE_AUTO_CREATE));
        String payNodeRule = dataEntity.getString(PAY_NODE_RULE);
        returnData.setPayNodeRule(payNodeRule);
        returnData.setNodeName(dataEntity.getString("nodename"));
        switch (payNodeRule) {
            case "period": {
                String calPeriodFiled = dataEntity.getString(CAL_PERIOD_FIELD);
                String calPeriodWay = dataEntity.getString(CAL_PERIOD_WAY);
                BigDecimal calPeriodDays = dataEntity.getBigDecimal(CAL_PERIOD_DAYS);
                boolean holidayEnable = !NOT_ENABLE.equals(dataEntity.getString(HOLIDAY_WAY));
                returnData.setHolidayEnable(holidayEnable);
                String dateType = dataEntity.getString(CAL_PERIOD_DATE_TYPE);
                if (holidayEnable && SWCStringUtils.equals((String)dateType, (String)"natural")) {
                    returnData.setHolidayWay(dataEntity.getString(HOLIDAY_WAY));
                }
                returnData.setCalPeriodField(calPeriodFiled);
                returnData.setCalPeriodWay(calPeriodWay);
                returnData.setCalPeriodDays(calPeriodDays == null ? BigDecimal.ZERO : calPeriodDays);
                returnData.setDateType(dateType);
                break;
            }
            case "workcalendar": {
                String workRule = dataEntity.getString(WORK_RULE);
                int workCalDay = dataEntity.getInt(WORK_CAL_DAY);
                returnData.setWorkRule(workRule);
                returnData.setWorkCalDay(workCalDay);
                boolean workCalendarHolidayEnable = !NOT_ENABLE.equals(dataEntity.getString(HOLIDAY_WAY));
                returnData.setHolidayEnable(workCalendarHolidayEnable);
                if (!workCalendarHolidayEnable) break;
                returnData.setHolidayWay(dataEntity.getString(HOLIDAY_WAY));
                break;
            }
            case "paydate": {
                String calPeriodPayDateWay = dataEntity.getString(CAL_PERIOD_WAY);
                BigDecimal calPeriodPayDateDays = dataEntity.getBigDecimal(CAL_PERIOD_DAYS);
                boolean payDateHolidayEnable = !NOT_ENABLE.equals(dataEntity.getString(HOLIDAY_WAY));
                String payDateType = dataEntity.getString(CAL_PERIOD_DATE_TYPE);
                returnData.setHolidayEnable(payDateHolidayEnable);
                if (payDateHolidayEnable && SWCStringUtils.equals((String)payDateType, (String)"natural")) {
                    returnData.setHolidayWay(dataEntity.getString(HOLIDAY_WAY));
                }
                returnData.setCalPeriodWay(calPeriodPayDateWay);
                returnData.setCalPeriodDays(calPeriodPayDateDays == null ? BigDecimal.ZERO : calPeriodPayDateDays);
                returnData.setDateType(payDateType);
                break;
            }
        }
        Object inteTimeZone = dataEntity.get(SPECIFIC_TIME);
        if (inteTimeZone == null || (Integer)inteTimeZone < 0) {
            returnData.setSpecificTime(Integer.valueOf(86399));
        } else {
            returnData.setSpecificTime(Integer.valueOf(dataEntity.getInt(SPECIFIC_TIME)));
        }
        returnData.setInteTimeZoneId((Long)dataEntity.getDynamicObject(INTE_TIME_ZONE).getPkValue());
        return returnData;
    }

    private void returnDataToParent(PayNodeTimeConfig returnData) {
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return;
        }
        view.returnDataToParent((Object)returnData);
    }

    static {
        LAST_DAY.add(29);
        LAST_DAY.add(30);
        LAST_DAY.add(31);
    }
}

