/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.paynode.imports;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.web.actions.export.ExportSheetStyle;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ImportConfig;
import kd.swc.hsas.formplugin.web.cal.paynode.imports.ListExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ListTemplateExporter
extends ListExporter {
    private final EntryColumnWrapper wrapper;
    private static final int templateFixedRowNum = 3;

    public ListTemplateExporter(EntryColumnWrapper wrapper, EntityType entryType, ImportConfig importConfig) {
        this.wrapper = wrapper;
        this.sheet = this.wb.createSheet("sheet1");
        this.styles = new ExportSheetStyle(this.wb);
        this.entryType = entryType;
        this.importConfig = importConfig;
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)wrapper.getContainers());
        this.fieldCaptions = new ArrayList(captions.values());
        this.fieldCaptions.add(0, new KeyValue("seq", (Object)ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"PayNodeDynamicEntryImportEdit_10", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
    }

    private CellStyle getCellStyle(IndexedColors fontColor, String align, IndexedColors foregroundColor) {
        CellStyle style = this.styles.getTitleStyle(align);
        Font font = this.wb.createFont();
        font.setColor(fontColor.getIndex());
        style.setFont(font);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(foregroundColor.index);
        return style;
    }

    private CellStyle getCellStyle() {
        return this.getCellStyle(IndexedColors.BLACK, "default", IndexedColors.WHITE);
    }

    private CellStyle getCellDateTimeStyle() {
        CellStyle style = this.getCellStyle(IndexedColors.BLACK, "default", IndexedColors.WHITE);
        DataFormat format = this.wb.createDataFormat();
        style.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
        return style;
    }

    private void setColumnWidth(Integer[] colWidths) {
        for (int col = 0; col < this.fieldCaptions.size(); ++col) {
            String value = (String)((KeyValue)this.fieldCaptions.get((int)col)).value;
            this.sheet.setColumnWidth(col, (value.toCharArray().length + 1) * 2 * 256 * colWidths[col]);
        }
    }

    @Override
    public void writeTemplate() {
        this.setColumnWidth(this.colWidths);
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight((List)this.wrapper.getContainers());
        String[][] headArray = new String[headHeight + 3][this.fieldCaptions.size()];
        SWCExportEntryHelper.fillTemplateFixedInfo((String[][])headArray, (String)this.importConfig.getTemplateCaption(), (String)this.importConfig.getTemplateWarningInfo(), (List)this.fieldCaptions);
        List containers = this.wrapper.getContainers();
        if (containers.size() > 1) {
            ((EntryColumnContainer)containers.get(1)).setVisible(true);
        }
        SWCExportEntryHelper.fillSheetHeadArray((List)containers, (String[][])headArray, (int)3, (int)0);
        SWCExportEntryHelper.setTemplateFixedInfoCell((SXSSFSheet)this.sheet, (String[][])headArray, (ExportSheetStyle)this.styles, (SXSSFWorkbook)this.wb);
        SWCExportEntryHelper.setAndMergeHeadCell((SXSSFSheet)this.sheet, (String[][])headArray, (CellStyle)this.getCellStyle(), (int)3);
        this.setBorderStyle(this.styles.getTitleStyle());
        SXSSFRow lastFieldRow = this.sheet.getRow(headArray.length - 1);
        SXSSFDrawing drawingPatriarch = this.sheet.createDrawingPatriarch();
        XSSFCellStyle borderStyle = this.getNormalCellStyle();
        XSSFCellStyle borderStyleRed = this.getNormalCellStyle();
        borderStyleRed.setFont(this.styles.getRedFont());
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            String annotationStr;
            Map fieldAnnotation;
            KeyValue keyValue = (KeyValue)this.fieldCaptions.get(i);
            SXSSFCell cell = lastFieldRow.getCell(i);
            cell.setCellStyle((CellStyle)borderStyle);
            if (this.mustInput[i] == 1) {
                String original = cell.getStringCellValue();
                cell.setCellValue("*" + original);
                cell.setCellStyle((CellStyle)borderStyleRed);
            }
            if ((fieldAnnotation = this.importConfig.getFieldAnnotation()) == null || !StringUtils.isNotEmpty((CharSequence)(annotationStr = (String)fieldAnnotation.get(keyValue.key)))) continue;
            Comment comment = drawingPatriarch.createCellComment((ClientAnchor)new XSSFClientAnchor(cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2, cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex() + 1, cell.getRowIndex() + 2));
            comment.setString((RichTextString)new XSSFRichTextString(annotationStr));
            comment.setAuthor("kindee");
            cell.setCellComment(comment);
        }
    }

    private XSSFCellStyle getNormalCellStyle() {
        XSSFCellStyle borderStyle = SWCExportEntryHelper.createBorderStyle((XSSFWorkbook)this.wb.getXSSFWorkbook());
        borderStyle.setAlignment(HorizontalAlignment.LEFT);
        borderStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        return borderStyle;
    }

    @Override
    public void writeLine(List<Object> row, int index) {
        int col = 0;
        for (int i = 0; i < this.fieldCaptions.size(); ++i) {
            Object value = row.get(i);
            if (StringUtils.isBlank((CharSequence)((CharSequence)value))) {
                CellStyle titleStyle = this.getCellStyle(IndexedColors.BLACK, "todo", IndexedColors.PALE_BLUE);
                DataFormat format = this.wb.createDataFormat();
                titleStyle.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
                ListTemplateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)ListTemplateExporter.getRow((SXSSFSheet)this.sheet, (int)index), (int)col++, (CellStyle)titleStyle);
                continue;
            }
            ListTemplateExporter.createCell((SXSSFWorkbook)this.wb, (SXSSFRow)ListTemplateExporter.getRow((SXSSFSheet)this.sheet, (int)index), (int)col++, (CellStyle)this.getCellDateTimeStyle()).setCellValue(value.toString());
        }
    }

    protected final void setBorderStyle(CellStyle style) {
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
    }

    @Override
    public int exportEntryTemplate(IDataModel model, DynamicObjectCollection rows, Map<String, KeyValue> captions, int excelRowIndex, ImportConfig importConfig) {
        ArrayList<Object> rowdata = new ArrayList<Object>(captions.size());
        Set<String> clearColumns = importConfig.getClearColumns();
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            rowdata.add(String.valueOf(i + 1));
            for (String filedName : captions.keySet()) {
                DateFormat dateFormat;
                Object value;
                if (clearColumns.contains(filedName)) {
                    rowdata.add(null);
                    continue;
                }
                IDataEntityProperty prop = model.getProperty(filedName);
                Object val = null;
                if (prop instanceof BooleanProp) {
                    val = Boolean.TRUE.equals(prop.getValue((Object)row)) ? ResManager.loadKDString((String)"\u662f", (String)"DynamicEntryImportStartEdit_4", (String)"swc-hsbp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicEntryImportStartEdit_5", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
                } else if (prop instanceof MulBasedataProp) {
                    value = (DynamicObjectCollection)prop.getValue((Object)row);
                    BasedataProp refBaseProp = (BasedataProp)((MulBasedataProp)prop).getRefBaseProp();
                    ArrayList<String> valStrs = new ArrayList<String>(value.size());
                    for (int j = 0; j < value.size(); ++j) {
                        DynamicObject baseDataObj = ((DynamicObject)value.get(j)).getDynamicObject((IDataEntityProperty)refBaseProp);
                        String displayValue = refBaseProp.getDisplayValue((Object)baseDataObj);
                        valStrs.add(j, displayValue);
                    }
                    val = String.join((CharSequence)";", valStrs);
                } else if (prop instanceof DecimalProp) {
                    val = prop.getValue((Object)row);
                    if (null != val) {
                        NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                        val = number.toString();
                    }
                } else if (prop instanceof BasedataProp) {
                    DynamicObject dy = (DynamicObject)prop.getValue((Object)row);
                    val = ((BasedataProp)prop).getDisplayValue((Object)dy);
                } else if (prop instanceof DateProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateProp)prop).getDateFormat();
                        val = dateFormat.format((Date)value);
                    }
                } else if (prop instanceof DateTimeProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateTimeProp)prop).getDateFormat();
                        val = dateFormat.format((Date)value);
                    }
                } else {
                    val = prop.getValue((Object)row);
                }
                rowdata.add(val);
            }
            this.writeLine(rowdata, excelRowIndex++);
            rowdata.clear();
        }
        return excelRowIndex;
    }
}

