/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.print;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.form.plugin.print.PrintSelectTemplatePlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.url.UrlService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;

public class SelectSalarySlipPrintSchemePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String FIELD_SALARYSLIPPRINT = "salaryslipprint";
    private static final String FIELD_SELECTTEMPLATE = "selecttemplate";
    private static final String SELECT_TEMPLATE_FLEX = "flexpanelap2";
    private static final String CONFIG_CACHE_KEY = "_printSelectSlipPrintTplConfig";
    private static final String FORMID = "formid";
    private static final String BOS_NOTEPRINT = "bos-noteprint";
    private static final Log log = LogFactory.getLog(PrintSelectTemplatePlugin.class);
    private static final String SELECT_PRINTER = "selectprinter";
    private static final String PERMITEM_SALSLIPPRINT = "3HH+ZE6F0TG3";
    private List<Object> ids = new ArrayList<Object>(10);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnconfilm", "btncancel"});
        BasedataEdit printTemplateEdit = (BasedataEdit)this.getView().getControl(FIELD_SALARYSLIPPRINT);
        printTemplateEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        this.initPrintScheme();
        String text = (String)this.getView().getFormShowParameter().getCustomParam("text");
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"PrintingSchemePlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("labelap");
        label.setText(text);
        if (text != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"imageap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"imageap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        }
        boolean isShowPrintType = this.isShowPrintType();
        if (!isShowPrintType) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"printtypepanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
        }
        String userId = RequestContext.get().getUserId();
        String key = formId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            String curLang = (String)jsonData.get("printlang");
            if (curLang == null) {
                curLang = RequestContext.get().getLang().toString();
            }
            this.getPageCache().put("CACHE_LANG", curLang);
            Object printerId = jsonData.get("printerid");
            this.getModel().setValue(SELECT_PRINTER, printerId);
        }
    }

    private void initPrintScheme() {
        QFilter filter;
        SWCDataServiceHelper helper;
        DynamicObjectCollection salarySlipPrintColl;
        Map selectTplConfigMap;
        String salarySlipPrintId;
        String printSelectTplConfigJson = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)this.getCacheKey());
        if (StringUtils.isNotBlank((CharSequence)printSelectTplConfigJson) && StringUtils.isNotBlank((CharSequence)(salarySlipPrintId = (String)(selectTplConfigMap = (Map)SerializationUtils.fromJsonString((String)printSelectTplConfigJson, Map.class)).get(FIELD_SALARYSLIPPRINT))) && (salarySlipPrintColl = (helper = new SWCDataServiceHelper("hsbs_salslipprint")).queryOriginalCollection("id,printtpl.id,enable,status", new QFilter[]{filter = this.getSalarySlipPrintFilter()})) != null) {
            for (DynamicObject dynamicObject : salarySlipPrintColl) {
                Long salarySlipPrintSchemeId = dynamicObject.getLong("id");
                if (!Long.valueOf(salarySlipPrintId).equals(salarySlipPrintSchemeId)) continue;
                this.getModel().setValue(FIELD_SALARYSLIPPRINT, (Object)dynamicObject.getLong("id"));
                this.getModel().setValue(FIELD_SELECTTEMPLATE, (Object)dynamicObject.getString("printtpl.id"));
            }
        }
    }

    private boolean isShowPrintType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isShowPrintType = false;
        if (customParams.containsKey("isShowPrintType")) {
            isShowPrintType = Boolean.parseBoolean(String.valueOf(customParams.get("isShowPrintType")));
        }
        return isShowPrintType;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("btnconfilm".equals(btn.getKey())) {
            boolean hasPerm;
            String permAppId = (String)this.getView().getFormShowParameter().getCustomParam("permAppId");
            String permEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("permEntityNumber");
            String permOperateNumber = (String)this.getView().getFormShowParameter().getCustomParam("permOperateNumber");
            if (StringUtils.isBlank((CharSequence)permAppId)) {
                permAppId = "/UHMBBGZQ65X";
            }
            if (StringUtils.isBlank((CharSequence)permEntityNumber)) {
                permEntityNumber = "hsas_calperson";
            }
            if (StringUtils.isBlank((CharSequence)permOperateNumber)) {
                permOperateNumber = "donothing_printsalryslip";
            }
            if (!(hasPerm = SWCPermissionServiceHelper.checkEntityOperatePerm((IFormView)this.getView(), (String)permAppId, (String)permEntityNumber, (String)permOperateNumber))) {
                return;
            }
            Object salaryslipprintObj = this.getView().getModel().getValue(FIELD_SALARYSLIPPRINT);
            if (salaryslipprintObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u65b9\u6848\u3002", (String)"SelectSalarySlipPrintSchemePlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object template = this.getModel().getValue(FIELD_SELECTTEMPLATE);
            if (template == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"PrintDataProgressFormPlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return;
            }
            String templateId = null;
            if (template instanceof DynamicObject) {
                templateId = ((DynamicObject)template).getString("id");
            }
            if (StringUtils.isBlank(templateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"PrintDataProgressFormPlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> config = new HashMap<String, String>(1);
            Object salarySlipPrintObj = this.getModel().getValue(FIELD_SALARYSLIPPRINT);
            Long salarySlipPrintId = 0L;
            if (salarySlipPrintObj instanceof DynamicObject) {
                salarySlipPrintId = ((DynamicObject)salarySlipPrintObj).getLong("id");
            }
            config.put(FIELD_SALARYSLIPPRINT, String.valueOf(salarySlipPrintId));
            UserConfigServiceHelper.setSetting((long)RequestContext.get().getCurrUserId(), (String)this.getCacheKey(), (String)SerializationUtils.toJsonString(config));
            this.doPrint(templateId);
        } else {
            this.getView().close();
        }
    }

    private IFormView getParentView() {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            }
            return parentView;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"radiogroupfield")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet == null || changeSet[0] == null) {
                return;
            }
            String newValue = String.valueOf(changeSet[0].getNewValue());
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"1")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
            }
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"2")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SELECT_TEMPLATE_FLEX});
            }
        } else if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)FIELD_SALARYSLIPPRINT)) {
            ChangeData[] changeSets = e.getChangeSet();
            if (null == changeSets || changeSets.length == 0) {
                return;
            }
            Object newValue = changeSets[0].getNewValue();
            if (newValue == null) {
                this.getModel().setValue(FIELD_SELECTTEMPLATE, null);
            } else if (newValue instanceof DynamicObject) {
                DynamicObject printSchemeInfo = (DynamicObject)newValue;
                String prineTemplateId = printSchemeInfo.getString("printtpl.id");
                this.getModel().setValue(FIELD_SELECTTEMPLATE, (Object)prineTemplateId);
            }
        }
    }

    private String getCacheKey() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        return formId + CONFIG_CACHE_KEY;
    }

    private void doPrint(String tplId) {
        String taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        try {
            this.doNewPreview(taskId, tplId);
            log.info("\u65b0\u6a21\u7248\u6253\u5370\u6210\u529f\u3002");
            PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
            List attachList = taskResult.getAttach();
            IFormView parentView = this.getParentView();
            if (this.checkPrintType("printexportexcel")) {
                this.xlsPrint(taskId, attachList);
            } else if (this.checkPrintType("print")) {
                this.print(taskId, attachList, parentView);
            } else if (this.checkPrintType("selectTpl")) {
                Object filetype = this.getModel().getValue("filetype");
                if ("excel".equals(filetype)) {
                    this.xlsPrint(taskId, attachList);
                } else {
                    this.printPreview(taskId, attachList, parentView);
                }
            } else {
                this.printPreview(taskId, attachList, parentView);
            }
            List distinctIds = this.ids.stream().distinct().collect(Collectors.toList());
            PrintOperationHelper.updatePrintCountField((String)((String)this.getView().getFormShowParameter().getCustomParam(FORMID)), distinctIds);
            this.getView().close();
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                parentView.showTipNotification(e.getMessage());
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
            throw e;
        }
    }

    private void printPreview(String taskId, List<PrtTaskResult.Attach> attachList, IFormView parentView) {
        if (attachList.size() <= 3) {
            for (PrtTaskResult.Attach attach : attachList) {
                String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> reservedSpace = new HashMap<String, String>();
                reservedSpace.put("reservedSpace", "true");
                para.getOpenStyle().setCustParam(reservedSpace);
                para.setCustomParam("src", (Object)downloadUrl);
                parentView.showForm(para);
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"PrintDataProgressFormPlugin_0", (String)BOS_NOTEPRINT, (Object[])new Object[0]));
        para.setFormId("bos_print_resultview");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("taskId", (Object)taskId);
        parentView.showForm(para);
        this.getView().sendFormAction(parentView);
    }

    private void print(String taskId, List<PrtTaskResult.Attach> attachList, IFormView parentView) {
        PrtTaskResult.Attach attach;
        NotePrintService printSvr = new NotePrintService();
        boolean printResult = true;
        Object printer = this.getModel().getValue(SELECT_PRINTER);
        if (!(printer instanceof DynamicObject)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u673a\uff0c\u8bf7\u5728\u201c\u6253\u5370\u201d->\u201c\u8bbe\u7f6e\u201d\u4e2d\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_6", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            parentView.showSuccessNotification(msg);
            this.getView().sendFormAction(parentView);
            return;
        }
        DynamicObject printerObj = (DynamicObject)printer;
        Object printerId = printerObj.getPkValue();
        Iterator<PrtTaskResult.Attach> iterator = attachList.iterator();
        while (iterator.hasNext() && (printResult = printSvr.createPrintJob((attach = iterator.next()).getAttachId(), attach.getAttachId(), attach.getFilePath(), new LocaleString(attach.getFileName()), printerId))) {
        }
        if (printResult) {
            String message = ResManager.loadKDString((String)"\u6253\u5370\u8bf7\u6c42\u53d1\u9001\u6210\u529f\u3002", (String)"Print_7", (String)BOS_NOTEPRINT, (Object[])new Object[0]);
            parentView.showSuccessNotification(message);
            this.getView().sendFormAction(parentView);
        }
    }

    private void xlsPrint(String taskId, List<PrtTaskResult.Attach> attachList) {
        for (PrtTaskResult.Attach attach : attachList) {
            String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
            downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
            this.getView().download(downloadUrl);
        }
    }

    private PrintParam buildNewPrintJobs(String taskId, String tplId) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        Object pkids = this.getView().getFormShowParameter().getCustomParam("pkids");
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        ArrayList<PrintJob> jobs = new ArrayList<PrintJob>(10);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (pkids != null && tplId != null) {
            PrintJob job = new PrintJob();
            job.setBillIds((List)pkids);
            job.setFormId(formId);
            job.setPageId(parentPageId);
            job.setTemplateId((Object)tplId);
            jobs.add(job);
        }
        for (PrintJob job : jobs) {
            PrintTask task = new PrintTask();
            task.setPkIds(job.getBillIds());
            task.setFormId(job.getFormId());
            task.setPageId(job.getPageId());
            task.setTplId(String.valueOf(job.getTemplateId()));
            task.setPrintType("billForm");
            taskList.add(task);
        }
        PrintParam param = new PrintParam();
        param.setPageId(parentPageId);
        param.setPrintLang(this.getPrintLang());
        boolean isPrintExcel = this.checkPrintType("printexportexcel");
        if (isPrintExcel) {
            param.setExpType("xls");
        } else {
            param.setExpType("pdf");
        }
        param.setTaskList(taskList);
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        String billFormId = parentView.getFormShowParameter().getFormId();
        if (parentView instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)parentView.getFormShowParameter();
            billFormId = mo.getFormConfig().getEntityTypeId();
        } else if (parentView instanceof IListView) {
            billFormId = ((ListView)parentView).getBillFormId();
        }
        param.setBillFormId(billFormId);
        Object extParam = this.getView().getFormShowParameter().getCustomParam("extParam");
        Map paramMap = null;
        if (extParam instanceof Map) {
            paramMap = (Map)extParam;
        }
        if (paramMap != null) {
            paramMap.put("printSchemeId", this.getModel().getDataEntity().getLong("salaryslipprint.id"));
            param.setExtParam(paramMap);
        }
        return param;
    }

    private boolean checkPrintType(String printType) {
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        boolean isPrintExcel = StringUtils.equals((CharSequence)printType, (CharSequence)String.valueOf(type));
        return isPrintExcel;
    }

    private void doNewPreview(String taskId, String tplId) {
        PrintParam param = this.buildNewPrintJobs(taskId, tplId);
        if (param == null) {
            return;
        }
        List taskList = param.getTaskList();
        if (taskList.isEmpty()) {
            return;
        }
        for (PrintTask task : taskList) {
            this.ids.addAll(task.getPkIds());
        }
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        service.doPrint(taskId, (Object)param);
    }

    private String getPrintLang() {
        Map jsonData;
        String printlang;
        String userId = RequestContext.get().getUserId();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String key = formId + "_printsetting";
        String curLang = RequestContext.get().getLang().toString();
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData) && (printlang = (String)(jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class)).get("printlang")) != null) {
            curLang = printlang;
        }
        return curLang;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey;
        switch (fieldKey = arg.getProperty().getName()) {
            case "salaryslipprint": {
                QFilter qFiler = this.getSalarySlipPrintFilter();
                if (qFiler == null) break;
                ListShowParameter param = (ListShowParameter)arg.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(qFiler);
                break;
            }
        }
    }

    private QFilter getSalarySlipPrintFilter() {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and(QFilter.isNotNull((String)"printtpl.id"));
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject caltaskInfo = helper.queryOne("org.id,country.id", (Object)calTaskId);
        if (caltaskInfo != null) {
            filter.and("country.id", "=", (Object)caltaskInfo.getLong("country.id"));
            QFilter permFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salslipprint", (Long)caltaskInfo.getLong("org.id"));
            if (permFilter != null) {
                filter.and(permFilter);
            }
        }
        return filter;
    }
}

