/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.cal.task;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.quartz.Calendar;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalTaskNewTplSchEdit
extends SWCDataBaseEdit {
    private static final String BAR_SAVE = "btnsave";
    private static final String OP_SAVE = "donothing";
    private static CronParser parser;
    private static Log logger;
    private DcJsonSerializer schDcSerializer = new DcJsonSerializer((DcBinder)new DynamicObjectSerializationBinder(new DynamicObjectType("hsas_caltasknewtplschplan")));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("frombiz", (Object)"true");
        String schPlanStr = (String)formShowParameter.getCustomParam("schPlan");
        if (schPlanStr != null) {
            DynamicObject schPlan = (DynamicObject)this.schDcSerializer.deserializeFromString(schPlanStr, (Object)new SWCDataServiceHelper("hsas_caltasknewtplschplan").generateEmptyDynamicObject());
            for (IDataEntityProperty property : schPlan.getDataEntityType().getProperties()) {
                this.getView().getModel().setValue(property.getName(), schPlan.get(property.getName()));
            }
            if ("true".equals(formShowParameter.getCustomParam("isview"))) {
                formShowParameter.setStatus(OperationStatus.VIEW);
                this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
            }
        } else {
            this.getModel().setValue("number", (Object)("hsas_atpytk_" + System.currentTimeMillis()));
            this.getModel().setValue("txthost", (Object)"127.0.0.1");
            this.getModel().setValue("starttime", (Object)new Date());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        if (args.getSource() instanceof AbstractOperate && OP_SAVE.equals((oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            Object number;
            QFilter q1;
            QFilter[] filters;
            boolean exists;
            if (!this.checkData()) {
                args.cancel = true;
                return;
            }
            Object id = this.getModel().getValue("id");
            if (StringUtils.isBlank((Object)id) && (exists = QueryServiceHelper.exists((String)"sch_schedule", (QFilter[])(filters = new QFilter[]{q1 = new QFilter("number", "=", number = this.getModel().getValue("number"))})))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CalTaskNewTplSchPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                args.cancel = true;
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (OP_SAVE.equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
            this.getView().close();
        }
    }

    private boolean checkData() {
        if (this.isBlank()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5fc5\u586b\u9879\u3002", (String)"CalTaskNewTplSchPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date startTime = (Date)this.getView().getModel().getValue("starttime");
        Date endTime = (Date)this.getView().getModel().getValue("endtime");
        String repeatmode = (String)this.getView().getModel().getValue("repeatmode");
        if (startTime.after(endTime)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6267\u884c\u65f6\u95f4\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"CalTaskNewTplSchPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
        String plan = this.getModel().getValue("plan").toString();
        try {
            if ("def".equalsIgnoreCase(repeatmode)) {
                return this.checkCron(plan);
            }
            parser.parse(plan);
            return true;
        }
        catch (Exception var8) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u65f6\u95f4\u8bbe\u7f6e\u9519\u8bef", (String)"CalTaskNewTplSchPlugin_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
    }

    private boolean isBlank() {
        DynamicObject obj = this.getView().getModel().getDataEntity();
        if (StringUtils.isBlank((CharSequence)obj.getString("number"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("name"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("starttime"))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)obj.getString("endtime"))) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)obj.getString("cyclenum")) || 0 == obj.getInt("cyclenum");
    }

    private boolean checkCron(String cron) {
        try {
            parser.parse(cron);
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, (Calendar)null, (int)2);
            long leadTime = Math.abs(((Date)dates.get(1)).getTime() - ((Date)dates.get(0)).getTime());
            if (leadTime < 60000L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u7684\u5468\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u53ea\u652f\u6301\u5206\u949f\u7ea7\u522b\u7684\u5468\u671f\u3002", (String)"CalTaskNewTplSchPlugin_18", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        catch (Exception var6) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201ccron\u8868\u8fbe\u5f0f\u201d\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CalTaskNewTplSchPlugin_19", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return false;
        }
    }

    static {
        logger = LogFactory.getLog(CalTaskNewTplSchEdit.class);
        parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ));
    }
}

