/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsbp.business.addperson.entity.CalPersonAddProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class CalDoRefreshPlugin
extends SWCDataBaseEdit
implements ProgresssListener,
HyperLinkClickListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String PROGRESS_AP = "progressap";
    private static final String FINISH_AP = "finishap";
    private static final String TOTAL_LABEL = "totallabel";
    private static final String TOTAL_LABEL1 = "totallabel1";
    private static final String SUCCESS_LABEL = "successlabel";
    private static final String FAIL_LABEL = "faillabel";
    private static final String TOTAL = "total";
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String FINISH_TIME_LABEL = "finishtimelabel";
    private static final String FAIL_DETAIL_HYPER = "faildetailhyper";
    private static final String MINI_FINISH_AP = "minifinishap";
    private static final String PROGRESS_NUM_LABEL = "progressnumlabel";

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        Label hyperLinkLabel = (Label)this.getControl(FAIL_DETAIL_HYPER);
        hyperLinkLabel.addClickListener((ClickListener)this);
        progress.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FINISH_AP, FAIL_DETAIL_HYPER, MINI_FINISH_AP});
    }

    public void onProgress(ProgressEvent progressEvent) {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonAddProgressInfo progressInfo = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        int finishCount = progressInfo.getFinish();
        int totalCount = progressInfo.getTotal();
        int percent = 0;
        if (totalCount > 0) {
            percent = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(totalCount)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        Map failMap = progressInfo.getFailIds();
        int failTotal = ((List)failMap.get("addFailIds")).size() + ((List)failMap.get("updateFailIds")).size() + ((List)failMap.get("delFailIds")).size();
        ((Label)this.getControl(SUCCESS)).setText(String.valueOf(finishCount - failTotal));
        ((Label)this.getControl(FAIL)).setText(String.valueOf(failTotal));
        int total = (Integer)this.getView().getFormShowParameter().getCustomParam("refreshTotalNum");
        ((Label)this.getControl(TOTAL)).setText(String.valueOf(total - finishCount));
        ((Label)this.getControl(PROGRESS_NUM_LABEL)).setText(String.valueOf(percent));
        Label timeLabel = (Label)this.getControl("timelabel");
        CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, null, (Boolean)Boolean.FALSE);
        progressEvent.setProgress(percent);
        if (progressInfo.getStatus() == 2 || percent == 100) {
            this.finishTask();
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        boolean isFinish = Boolean.parseBoolean(this.getView().getPageCache().get("isFinish"));
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        String schTaskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
        if (isFinish) {
            SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").remove(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId));
            if (this.getView().getParentView() instanceof IListView) {
                this.getView().getParentView().invokeOperation("refresh");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getView().setReturnData((Object)"dorefreshfinish");
            this.getView().returnDataToParent(this.getView().getReturnData());
            if (!SWCObjectUtils.isEmpty((Object)schTaskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(schTaskId, "COMPLETED");
            }
        } else {
            this.toBackground();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        String itemKey = itemControl.getKey();
        if (SWCStringUtils.equals((String)itemKey, (String)"btnok")) {
            this.getView().close();
        } else if (SWCStringUtils.equals((String)itemKey, (String)FAIL_DETAIL_HYPER)) {
            Map failMsgMap = null;
            failMsgMap = (Map)JSON.parseObject((String)this.getPageCache().get("failMsg"), Map.class);
            ListShowParameter show = ShowFormHelper.createShowListForm((String)"hsas_calpersonupdatefail", (boolean)true);
            show.setCustomParam("failMsg", (Object)failMsgMap);
            this.getView().getParentView().showForm((FormShowParameter)show);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonAddProgressInfo progressInfo = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        int total = (Integer)this.getView().getFormShowParameter().getCustomParam("refreshTotalNum");
        ((Label)this.getControl(TOTAL)).setText(String.valueOf(total));
        ((Label)this.getControl(TOTAL_LABEL1)).setText(String.valueOf(total));
        int finishCount = progressInfo.getFinish();
        int totalCount = progressInfo.getTotal();
        int percent = 0;
        if (totalCount > 0) {
            percent = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(totalCount)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        Map failMap = progressInfo.getFailIds();
        int failTotal = ((List)failMap.get("addFailIds")).size() + ((List)failMap.get("updateFailIds")).size() + ((List)failMap.get("delFailIds")).size();
        ((Label)this.getControl(SUCCESS)).setText(String.valueOf(finishCount - failTotal));
        ((Label)this.getControl(FAIL)).setText(String.valueOf(failTotal));
        ((Label)this.getControl(TOTAL)).setText(String.valueOf(total - finishCount));
        ((Label)this.getControl(PROGRESS_NUM_LABEL)).setText(String.valueOf(percent));
        Label timeLabel = (Label)this.getControl("timelabel");
        if (percent == 100) {
            CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)Boolean.TRUE);
            this.finishTask();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnok"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel"});
        }
        this.start();
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    private void finishTask() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.stop();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnok", TOTAL, "labelap3", "labelap5"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"btncancel", MINI_FINISH_AP});
        this.getView().getPageCache().put("isFinish", "true");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonAddProgressInfo progressInfo = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        this.getPageCache().put("failMsg", JSON.toJSONString((Object)progressInfo.getFailIds()));
        this.setFinishNumLabel(progressInfo);
        PayrollTaskHelper.updateCalPayRollTaskStatus((Long)calTaskId);
        String opKey = CalPersonOperationEnum.OP_REFRESH.getOperationKey();
        MultiLangEnumBridge bridge = new MultiLangEnumBridge("\u66f4\u65b0\u6838\u7b97\u4eba\u5458\u6210\u529f", "CalDoRefreshPlugin_2", SWC_HSAS_FORMPLUGIN);
        SWCOpLogServiceHelper.addOpLog((String)"hsas", (String)"hsas_calperson", (String)opKey, (String)"", (MultiLangEnumBridge)bridge, (String[])new String[0]);
    }

    private void start() {
        String isOpenByProgressBall;
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonAddProgressInfo progressInfo = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        int totalCount = progressInfo.getTotal();
        int finishCount = progressInfo.getFinish();
        int percent = 0;
        if (totalCount > 0) {
            percent = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(totalCount)), 2, 1).multiply(new BigDecimal("100")).intValue();
        }
        if (SWCStringUtils.equals((String)(isOpenByProgressBall = (String)this.getView().getFormShowParameter().getCustomParam("openByProgressBall")), (String)"1")) {
            progressBar.setPercent(percent);
            Label timeLabel = (Label)this.getControl("timelabel");
            CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, null, (Boolean)Boolean.FALSE);
            if (progressInfo.getStatus() == 2 || percent == 100) {
                this.finishTask();
            }
        }
        progressBar.start();
    }

    private void toBackground() {
        IFormView mainView;
        String str = (String)this.getView().getFormShowParameter().getCustomParam("sch_clientjobinfo");
        Map jobFormInfo = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("calTaskId");
        CalPersonAddProgressInfo progressInfo = (CalPersonAddProgressInfo)SWCAppCache.get((String)"cachekey_hsas_calperson_refresh").get(String.format(Locale.ROOT, "cache_addperson_key_%s", calTaskId), CalPersonAddProgressInfo.class);
        progressInfo.setShowInProgress(false);
        if (SWCObjectUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("sch_taskid")) && (mainView = this.getView().getMainView()) != null) {
            HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
            String bgTaskId = instance.createBaskgroundTask("swc_hsas_dorefresh", (String)jobFormInfo.get("taskName"), true, mainView.getPageId(), this.getView().getParentView().getPageId(), jobFormInfo);
            instance.showBaskgroundTask(bgTaskId);
        }
    }

    private void setFinishNumLabel(CalPersonAddProgressInfo progressInfo) {
        Map failMap = progressInfo.getFailIds();
        int failTotal = ((List)failMap.get("addFailIds")).size() + ((List)failMap.get("updateFailIds")).size() + ((List)failMap.get("delFailIds")).size();
        if (failTotal != 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FAIL_DETAIL_HYPER});
        }
        Label timeLabel = (Label)this.getControl("timelabel");
        CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)Boolean.TRUE);
    }
}

