/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsbp.business.addperson.entity.CalGetCouldAddPersonProgressInfo;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalGetAddFilesProgressPlugin
extends AbstractListPlugin
implements ProgresssListener {
    private static final String BTN_CLOSE = "btnclose";
    private static final String BTN_MIN = "btnok";
    private static final String PROGRESS_AP = "progressap";
    private static final String FINISH_AP = "finishap";
    private static final String ONGET_AP = "ongetap";
    private static final String AFTERGET_AP = "aftergetap";

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FINISH_AP, AFTERGET_AP, BTN_CLOSE});
    }

    public void initialize() {
        super.initialize();
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btncancel", BTN_MIN});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.start();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String clkKey = ((Control)evt.getSource()).getKey();
        if (SWCStringUtils.equals((String)clkKey, (String)"btncancel")) {
            this.getView().getPageCache().put("cancel", "true");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control itemControl = (Control)evt.getSource();
        String itemKey = itemControl.getKey();
        if (SWCStringUtils.equals((String)itemKey, (String)"btncancel")) {
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            progressBar.stop();
            Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
            this.getView().close();
            String taskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
            if (!SWCObjectUtils.isEmpty((Object)taskId)) {
                HRBackgroundTaskHelper.getInstance().confirmEndTask(taskId, "COMPLETED");
            }
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(payrolltaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
        }
    }

    private void start() {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        CalGetCouldAddPersonProgressInfo progressInfo = (CalGetCouldAddPersonProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getperson_key_%s", payrolltaskId), CalGetCouldAddPersonProgressInfo.class);
        if (progressInfo != null) {
            if (progressInfo.getPercent() == 100) {
                this.finishTask(progressInfo);
                progressBar.setPercent(progressInfo.getPercent());
            } else {
                progressBar.setPercent(progressInfo.getPercent());
            }
            Label taglabel = (Label)this.getControl("percent");
            taglabel.setText(ResManager.loadKDString((String)"{0}%", (String)"CalGetAddFilesProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{progressInfo.getPercent()}));
            Label timeLabel = (Label)this.getControl("timelabel");
            CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)(progressInfo.getPercent() == 100 ? 1 : 0));
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        Long payrolltaskId;
        ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
        CalGetCouldAddPersonProgressInfo progressInfo = (CalGetCouldAddPersonProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getperson_key_%s", payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid")), CalGetCouldAddPersonProgressInfo.class);
        if (progressInfo == null) {
            return;
        }
        Label timeLabel = (Label)this.getControl("timelabel");
        CalPersonListHelper.setCostTime((Date)progressInfo.getStartDate(), (Label)timeLabel, (Date)progressInfo.getEndDate(), (Boolean)(progressInfo.getPercent() == 100 ? 1 : 0));
        Label taglabel = (Label)this.getControl("percent");
        taglabel.setText(ResManager.loadKDString((String)"{0}%", (String)"CalGetAddFilesProgressPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[]{progressInfo.getPercent()}));
        progressEvent.setProgress(progressInfo.getPercent());
        if (progressInfo.getPercent() == 100) {
            this.finishTask(progressInfo);
        }
    }

    private void finishTask(CalGetCouldAddPersonProgressInfo progressInfo) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.stop();
        if (SWCListUtils.isEmpty((List)progressInfo.getFileIds())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FINISH_AP, BTN_CLOSE});
            this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESS_AP, "btncancel", BTN_MIN});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE, AFTERGET_AP});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", BTN_MIN, ONGET_AP, BTN_MIN});
            Label taglabel = (Label)this.getControl("taglabel");
            taglabel.setText(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u529f\u53ef\u6dfb\u52a0{0}\u4eba", (String)"CalGetAddFilesProgressPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[]{progressInfo.getFileIds().size()}));
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent beforeClosedEvent) {
        String isCancel = this.getView().getPageCache().get("cancel");
        if (SWCStringUtils.isEmpty((String)isCancel)) {
            Long payrolltaskId;
            ISWCAppCache appCache = SWCAppCache.get((String)"cache_getperson_key_%s");
            CalGetCouldAddPersonProgressInfo progressInfo = (CalGetCouldAddPersonProgressInfo)appCache.get(String.format(Locale.ROOT, "cache_getperson_key_%s", payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid")), CalGetCouldAddPersonProgressInfo.class);
            if (progressInfo != null && progressInfo.getPercent() == 100 && !SWCListUtils.isEmpty((List)progressInfo.getFileIds())) {
                this.showAddPersonPage();
                String taskId = (String)this.getView().getFormShowParameter().getCustomParam("sch_taskid");
                if (SWCStringUtils.isNotEmpty((String)taskId)) {
                    HRBackgroundTaskHelper.getInstance().confirmEndTask(taskId, "COMPLETED");
                }
            } else if (progressInfo != null && progressInfo.getPercent() < 100 && SWCObjectUtils.isEmpty((Object)this.getView().getFormShowParameter().getCustomParam("sch_taskid"))) {
                this.toBackground();
            } else if (progressInfo != null && progressInfo.getPercent() == 100 && SWCListUtils.isEmpty((List)progressInfo.getFileIds())) {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(payrolltaskId), (String)CalPersonOperationEnum.OP_ADDCALPERSON.getOperationKey());
            }
        }
    }

    private void showAddPersonPage() {
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        ListShowParameter form = ShowFormHelper.createShowListForm((String)"hsas_enableaddpersonf7new", (boolean)true);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setFormId("hsas_addpersontreelist");
        form.setCustomParam("payrolltaskdataid", (Object)payrolltaskId);
        form.setCustomParam("option", (Object)"showhisversion");
        form.setCloseCallBack(new CloseCallBack("kd.swc.hsas.formplugin.web.calpersonlist.CalPersonOperateList", "addcalperson"));
        this.getView().getParentView().showForm((FormShowParameter)form);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void toBackground() {
        Long payrolltaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        String calTaskName = (String)this.getView().getFormShowParameter().getCustomParam("calTaskName");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("taskId", payrolltaskId);
        params.put("calTaskName", calTaskName);
        IFormView mainView = this.getView().getMainView();
        if (mainView != null) {
            HRBackgroundTaskHelper instance = HRBackgroundTaskHelper.getInstance();
            String bgTaskId = instance.createBaskgroundTask("swc_hsas_getcanaddperson", ResManager.loadKDString((String)"\u83b7\u53d6\u53ef\u6dfb\u52a0\u6838\u7b97\u4eba\u5458_{0}", (String)"CalGetAddFilesProgressPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[]{calTaskName}), true, mainView.getPageId(), this.getView().getParentView().getPageId(), params);
            instance.showBaskgroundTask(bgTaskId);
        }
    }
}

