/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.cal.check.SalaryCalCheckService;
import kd.swc.hsas.business.cal.helper.CalHelper;
import kd.swc.hsas.business.cal.helper.CalTableCalHelper;
import kd.swc.hsas.business.cal.service.CalRollBackService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCShowFormServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.CalConstants;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPersonCalOperateList
extends AbstractCalPersonList {
    private static final Log logger = LogFactory.getLog(CalPersonCalOperateList.class);
    private static final String BK_CAL_ID_LIST_CACHE_KEY = "BK_CAL_ID_LIST_CACHE_KEY";
    private static final String CANCEL_CAL_CONFIRM = "cancelCalConfirm";
    public static final Set<String> CAL_ROLL_BACK_STATUS_FOR_TAX = new HashSet<String>(Arrays.asList(CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode()));

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CAL);
        calPersonOperationEnums.add(CalPersonOperationEnum.CANCEL_CAL);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEWCALREPORTHIS);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean operationMutex() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWCALREPORTHIS: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isSelectData() {
        switch (this.calPersonOperationEnum) {
            case OP_VIEWCALREPORTHIS: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterOperationUpdateView(CalPersonOperationEnum calPersonOperationEnum) {
        return false;
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        try {
            switch (this.calPersonOperationEnum) {
                case OP_CAL: {
                    this.checkCalRecordState(calPayRollTask);
                    break;
                }
                case OP_VIEWCALREPORTHIS: {
                    this.openCalreportHis();
                    break;
                }
                case CANCEL_CAL: {
                    this.cancelCal(calPayRollTask);
                    break;
                }
            }
        }
        catch (Exception e) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
            throw e;
        }
    }

    private void checkCalRecordState(CalPayRollTask calPayRollTask) {
        HashMap extParmaMap;
        SalaryCalCheckService salaryCalCheckService = new SalaryCalCheckService();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        DynamicObject taskDyObj = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        String errorMsg = salaryCalCheckService.beforeCalCheck(calPayRollTask, taskDyObj, extParmaMap = new HashMap(16));
        if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            Boolean isShowForm = (Boolean)extParmaMap.get("isShowForm");
            if (isShowForm != null && isShowForm.booleanValue()) {
                List failList = (List)extParmaMap.get("failList");
                String title = (String)extParmaMap.get("title");
                String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalPersonCalOperateList_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, (List)failList);
                this.getView().showForm(parameters);
            } else {
                this.getView().showErrorNotification(errorMsg);
            }
            return;
        }
        List calPersons = calPayRollTask.getCalPersons();
        DynamicObjectCollection calPersonDataList = CalHelper.getCalPersonData((List)calPersons, (Long)taskId, null);
        if (calPersonDataList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u6838\u7b97\u72b6\u6001\u4e3a\u672a\u8ba1\u7b97\u3001\u7a0e\u524d\u8ba1\u7b97\u5b8c\u6210\u3001\u8ba1\u7b97\u5b8c\u6210\u3001\u8ba1\u7b97\u5931\u8d25\uff0c\u4e14\u505c\u7f13\u53d1\u72b6\u6001\u4e0d\u4e3a\u7ec8\u6b62\u53d1\u653e\u7684\u6570\u636e\uff0c\u624d\u80fd\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"CalPersonCalOperateList_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(msg);
            return;
        }
        String calType = "cal";
        if (SWCStringUtils.equals((String)"1", (String)calPayRollTask.getOpenTaxCal())) {
            calType = "preTaxCal";
        }
        List calPersonIdList = calPersonDataList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map operationParam = calPayRollTask.getOperationParam();
        CalHelper.groupByCalStatusForCalPerson((DynamicObjectCollection)calPersonDataList, (Map)operationParam);
        calPayRollTask.setCalPersons(calPersonIdList);
        Boolean isHandleProration = taskDyObj.getBoolean("ishandleproration");
        operationParam.put("enddate", SWCDateTimeUtils.format((Date)taskDyObj.getDate("enddate"), (String)"yyyy-MM-dd"));
        operationParam.put("startdate", SWCDateTimeUtils.format((Date)taskDyObj.getDate("startdate"), (String)"yyyy-MM-dd"));
        operationParam.put("calType", calType);
        operationParam.put("ishandleproration", String.valueOf(isHandleProration));
        operationParam.put("totalCount", String.valueOf(calPersons.size()));
        operationParam.put("calCount", String.valueOf(calPersonIdList.size()));
        operationParam.put("unCalCount", String.valueOf(calPersons.size() - calPersonIdList.size()));
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calmodeconfirm");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calconfirm"));
        showParameter.setCustomParam("taskType", (Object)taskDyObj.getString("tasktype"));
        showParameter.setCustomParam("calTaskId", (Object)taskId);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object data = e.getReturnData();
        if (SWCStringUtils.equals((String)actionId, (String)"hsas_calconfirm")) {
            if (data != null) {
                Map backData = (Map)data;
                Map taskPersonMap = (Map)backData.get("taskInfo");
                String cacheUUID = backData.get("cacheUUID").toString();
                int personCount = 0;
                for (Map.Entry entry : taskPersonMap.entrySet()) {
                    personCount += ((Integer)entry.getValue()).intValue();
                }
                if (personCount > CalConstants.SYN_CHECK_CERT_MAX_KEY) {
                    this.openCalCheckWaitPage(cacheUUID, personCount);
                } else {
                    this.openCalProcessPage(cacheUUID);
                }
            } else {
                this.releaseDistributedLock();
                this.getView().invokeOperation("refresh");
            }
        } else if (SWCStringUtils.equals((String)actionId, (String)"hsas_calprogress")) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)actionId, (String)"hsas_calcheckwait")) {
            Map backData = (Map)data;
            if (backData == null || backData.get("cacheUUID") == null) {
                return;
            }
            String cacheUUID = backData.get("cacheUUID").toString();
            ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_%s", RequestContext.get().getCurrUserId()));
            String checkCertResultKey = String.format(Locale.ROOT, "check_cert_result_%s", cacheUUID);
            Map result = (Map)appCache.get(checkCertResultKey, Map.class);
            appCache.remove(checkCertResultKey);
            result.put("isCurrentView", Boolean.TRUE);
            CalHelper.handlePrompts((Map)result, (IFormView)this.getView());
            if (!Boolean.TRUE.equals(result.get("success"))) {
                return;
            }
            Map errMap = (Map)backData.get("errMap");
            if (errMap != null) {
                String errMsg = (String)errMap.get("errMsg");
                if (SWCStringUtils.isNotEmpty((String)errMsg)) {
                    this.getView().showErrorNotification(errMsg);
                }
            } else {
                this.openCalProcessPage(cacheUUID);
            }
        } else if (SWCStringUtils.equals((String)CANCEL_CAL_CONFIRM, (String)actionId)) {
            if (data != null && SWCStringUtils.equals((String)"success", (String)((String)((Map)data).get("result")))) {
                this.doCancelCal();
            } else {
                this.releaseDistributedLock();
            }
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)actionId, (String)"cancelCal")) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)actionId, (String)"closecaldetailpage") && !SWCObjectUtils.isEmpty((Object)(returnData = (ListSelectedRowCollection)e.getReturnData()))) {
            Long calTaskId;
            ListSelectedRow selectRow = returnData.get(0);
            Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
            FormShowParameter formShowParameter = SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)(calTaskId = this.getCalTaskId()), (String)this.getView().getPageId());
            if (formShowParameter == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664,\u8bf7\u68c0\u67e5\u3002", (String)"CalPersonF7List_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private void openCalProcessPage(String cacheUUID) {
        ISWCAppCache errMsgCache = SWCAppCache.get((String)String.format(Locale.ROOT, "SWC_CALCHECK_ERRMSG_%s", cacheUUID));
        ISWCAppCache calParamCache = SWCAppCache.get((String)String.format(Locale.ROOT, "swc_cal_param_%s", cacheUUID));
        List param = new ArrayList(10);
        int tryCnt = 60;
        while (tryCnt > 0) {
            String errMsg = (String)errMsgCache.get("cal_param", String.class);
            if (SWCStringUtils.isNotEmpty((String)errMsg)) {
                this.getView().showErrorNotification(errMsg);
                return;
            }
            param = (List)calParamCache.get("cal_param", List.class);
            if (!SWCListUtils.isEmpty(param)) break;
            try {
                Thread.sleep(1000L);
                --tryCnt;
            }
            catch (InterruptedException exception) {
                logger.error("openCalProcessPage_getCalParam_error", (Throwable)exception);
            }
        }
        Long calTaskId = this.getCalTaskId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calprogress"));
        for (Map.Entry entry : ((Map)param.get(0)).entrySet()) {
            showParameter.setCustomParam((String)entry.getKey(), entry.getValue());
        }
        showParameter.setCustomParam("calTimes", this.getView().getFormShowParameter().getCustomParam("calTimes"));
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCustomParam("calTaskName", this.getView().getFormShowParameter().getCustomParam("name"));
        showParameter.setCustomParam("openTaxCal", (Object)TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId));
        this.getView().showForm(showParameter);
    }

    private void openCalCheckWaitPage(String cacheUUID, int personCount) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calcheckwait");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calcheckwait"));
        showParameter.setCustomParam("cacheUUID", (Object)cacheUUID);
        showParameter.setCustomParam("personCount", (Object)personCount);
        this.getView().showForm(showParameter);
    }

    private void openCalreportHis() {
        Long calTaskId = this.getCalTaskId();
        ListShowParameter show = new ListShowParameter();
        show.setBillFormId("hsas_calrecord");
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        show.setCustomParam("calTaskId", (Object)calTaskId);
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        show.setListFilterParameter(new ListFilterParameter(filters, "starttime desc"));
        show.setPageId(this.getView().getPageId() + "_" + calTaskId);
        this.getView().showForm((FormShowParameter)show);
    }

    public void cancelCal(CalPayRollTask calPayRollTask) {
        HashMap extParmaMap;
        boolean calCheck = CalTableCalHelper.checkIsHasCalingRecord((Long)calPayRollTask.getCalPayRollTaskId(), (String)"2");
        if (calCheck) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            String errMsg = ResManager.loadKDString((String)"%s\u6b63\u5728\u56de\u6eda\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"CalPersonCalOperateList_12", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(Locale.ROOT, errMsg, calPayRollTask.getNumber()));
            return;
        }
        SalaryCalCheckService salaryCalCheckService = new SalaryCalCheckService();
        DynamicObject taskDyObj = CalPayrollTaskHelper.queryTaskInfoById((Long)calPayRollTask.getCalPayRollTaskId());
        String errorMsg = salaryCalCheckService.checkCalConditionInvalid(calPayRollTask, taskDyObj, extParmaMap = new HashMap(16));
        if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            Boolean isShowForm = (Boolean)extParmaMap.get("isShowForm");
            if (isShowForm != null && isShowForm.booleanValue()) {
                List failList = (List)extParmaMap.get("failList");
                String title = (String)extParmaMap.get("title");
                String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"CalPersonCalOperateList_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                FormShowParameter parameters = SWCShowFormServiceHelper.getOperationResultParameter((String)operateName, (String)title, (List)failList);
                this.getView().showForm(parameters);
            } else {
                this.getView().showErrorNotification(errorMsg);
            }
            return;
        }
        List calPersonIdList = calPayRollTask.getCalPersons();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter filter = new QFilter("id", "in", (Object)calPersonIdList);
        filter.and("calstatus", "in", CAL_ROLL_BACK_STATUS_FOR_TAX);
        DynamicObjectCollection calPersonCollection = helper.queryOriginalCollection("id", new QFilter[]{filter});
        if (calPersonCollection == null || calPersonCollection.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u8bb0\u5f55\u6b63\u5728\u5904\u7406\u4e2d/\u672a\u8ba1\u7b97/\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u8ba1\u7b97\u56de\u6eda\u3002", (String)"HSASCalTableListCalPlugin_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(msg);
            try {
                MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25", "CalResultCoverListPlugin_13", "swc-hsas-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey(), (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            }
            catch (Exception e) {
                logger.error("CalPersonCalOperateList.cancelCal: ", (Throwable)e);
            }
            return;
        }
        List<Long> rollBackCalIdList = calPersonCollection.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        int cancelCalCount = rollBackCalIdList.size();
        int failCount = calPersonIdList.size() - cancelCalCount;
        try {
            this.getPageCache().put(BK_CAL_ID_LIST_CACHE_KEY, JSONUtils.toString(rollBackCalIdList));
        }
        catch (IOException e) {
            logger.error("json to string error.", (Throwable)e);
        }
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
        this.openCancelCalConfirmPage(cancelCalCount, failCount, rollBackCalIdList);
    }

    private void openCancelCalConfirmPage(int cancelCalCount, int failCount, List<Long> passIdList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calconfirm");
        showParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u56de\u6eda\u786e\u8ba4", (String)"CalPersonCalOperateList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CANCEL_CAL_CONFIRM));
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        paramMap.put("cancelCalCount", String.valueOf(cancelCalCount));
        paramMap.put("failCount", String.valueOf(failCount));
        paramMap.put("isCancel", String.valueOf(true));
        CalTableCalHelper.setCalTaskParam(paramMap, passIdList, (DynamicObject)this.getCalTaskInfo("id,org.id,payrolldate,calrulev.id"));
        showParameter.setCustomParams(paramMap);
        this.getView().showForm(showParameter);
    }

    private void doCancelCal() {
        List<Long> rollBackCalIdList = this.getCancelCalDirectlyIdList(BK_CAL_ID_LIST_CACHE_KEY);
        long calTaskId = this.getCalTaskId();
        try {
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f", "CalResultCoverListPlugin_12", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)CalPersonOperationEnum.CANCEL_CAL.getOperationKey(), (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        }
        catch (Exception e) {
            logger.error("CalPersonCalOperateList.doCancelCal: ", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        CalRollBackService calRollBackService = new CalRollBackService(calTaskId, rollBackCalIdList);
        Long recordId = calRollBackService.calRollBack("cancelcal", null);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_cancelcalprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(8);
        parameterMap.put("calTaskId", calTaskId);
        parameterMap.put("calRecordId", recordId);
        parameterMap.put("cancelCount", rollBackCalIdList.size());
        parameterMap.put("startTime", SWCDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        parameterMap.put("calTaskName", this.getCalTaskInfo("name").getString("name"));
        showParameter.setCustomParams(parameterMap);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cancelCal"));
        this.getView().showForm(showParameter);
    }

    private List<Long> getCancelCalDirectlyIdList(String calPersonIdListCacheKey) {
        IPageCache pageCache = this.getPageCache();
        String cancelCalIdListStr = pageCache.get(calPersonIdListCacheKey);
        ArrayList cancelCalDirectlyIdList = null;
        try {
            cancelCalDirectlyIdList = (ArrayList)JSONUtils.cast((String)cancelCalIdListStr, List.class);
        }
        catch (IOException e1) {
            logger.error((Throwable)e1);
        }
        if (cancelCalDirectlyIdList == null) {
            cancelCalDirectlyIdList = new ArrayList(0);
        }
        return cancelCalDirectlyIdList;
    }
}

