/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.IInteService;
import kd.bos.list.BillList;
import kd.bos.list.DateListColumn;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.JSONUtils;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.payrollscene.service.SWCPayRollSceneService;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsas.common.vo.CalPersonStatusDefault;
import kd.swc.hsas.formplugin.web.salarydetailresult.AbstractCalPersonListViewBasePlugin;
import kd.swc.hsbp.business.calrequest.CalRequestHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPersonListViewPlugin
extends AbstractCalPersonListViewBasePlugin
implements FilterContainerInitListener {
    private static final String SWC_HSAS_FORMPLUGIN = "swc-hsas-formplugin";
    private static final String KEY_BILL_LIST_AP = "billlistap";
    private static final String LABLE_PAYROLLGRP = "payrollgroupvalue";
    private static final String LABLE_CALSCENE = "calscenevalue";
    private static final String LABLE_CALTASKTYPE = "caltasktypevalue";
    private static final String LABEL_CALPERIOD = "calperiodvalue";
    private static final String LABEL_CALTASKNAME = "caltasknamevalue";
    private static final int SORT_COUNT_MAX = 5;
    private static final String KEY_GRIDVIEW = "gridview";
    private Map<Long, List<DynamicObject>> allCalPersonMarkMap;
    private Map<Long, String> calPersonCalStatusMap = new HashMap<Long, String>(16);
    private static final String KEY_CALREQUESTICON = "calrequesticon";
    private static final String KEY_CALINGICON = "calingicon";
    private static final String CAL_PERSON_MARK_DEL_CALLBACK = "calPersonDelMarkCloseBack";
    private static Set<String> errStatus = new HashSet<String>();
    private Set<String> numberFields = new HashSet<String>(16);
    private Set<String> dateFields = new HashSet<String>(16);
    private Map<String, DynamicObject> operationFields = new HashMap<String, DynamicObject>(16);
    private static final String[] HIDE_BTN;
    private static final String[] hideBtn;
    private static final String[] commonCalBtn;
    private static final String[] calapproveBtn;
    private static final String[] costallotBtn;
    private static final String[] genbizdataBtn;

    private void groupSpecialFields() {
        SWCDataServiceHelper calFieldHelper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        QFilter numberFilter = new QFilter("type", "in", Arrays.asList("number", "date", "operation"));
        DynamicObject[] fields = calFieldHelper.query("field,type,number,name", new QFilter[]{numberFilter});
        if (this.numberFields.isEmpty() || this.dateFields.isEmpty()) {
            for (DynamicObject dynamicObject : fields) {
                if (SWCStringUtils.equals((String)dynamicObject.getString("type"), (String)"number")) {
                    this.numberFields.add(dynamicObject.getString("field"));
                    continue;
                }
                if (SWCStringUtils.equals((String)dynamicObject.getString("type"), (String)"date")) {
                    this.dateFields.add(dynamicObject.getString("field"));
                    continue;
                }
                if (!SWCStringUtils.equals((String)dynamicObject.getString("type"), (String)"operation")) continue;
                this.operationFields.put(dynamicObject.getString("field"), dynamicObject);
            }
        }
    }

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        this.getView().addCustomControls(new String[]{KEY_BILL_LIST_AP});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LABLE_PAYROLLGRP, LABLE_CALSCENE, "showcurrency", "smallk", KEY_CALREQUESTICON});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.log.info("beforeBindData begin");
        long startTime = System.currentTimeMillis();
        String entityId = this.getView().getEntityId();
        if (entityId.contains("bos_listf7")) {
            return;
        }
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        Set calingTasks = CalRequestHelper.getCalingTask();
        this.getView().setVisible(Boolean.valueOf(calingTasks.contains(calTaskId)), new String[]{KEY_CALINGICON});
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        SalaryDetailResultListHelper helper = new SalaryDetailResultListHelper();
        DynamicObject taskInfo = helper.getTaskInfo(calTaskId);
        if (SWCObjectUtils.isEmpty((Object)taskInfo)) {
            return;
        }
        String calTaskType = (String)this.getView().getFormShowParameter().getCustomParam("calTaskType");
        if (SWCStringUtils.equals((String)calTaskType, (String)"2")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addcalperson", "cal", "calresultcover", "changetmp", "audit", "approve", "createapprove", "calresultcover1", "createpay"});
        }
        Label calTaskTypeLable = (Label)this.getControl(LABLE_CALTASKTYPE);
        Label payRollGroupLable = (Label)this.getControl(LABLE_PAYROLLGRP);
        Label calSceneLable = (Label)this.getControl(LABLE_CALSCENE);
        Label calPeriodLable = (Label)this.getControl(LABEL_CALPERIOD);
        Label calTaskNameLable = (Label)this.getControl(LABEL_CALTASKNAME);
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String props = "payrollgroupv.name,payrollscenev.name,period.name,isautoaddperson,name,calcount";
        QFilter idFilter = new QFilter("id", "=", (Object)calTaskId);
        DynamicObject calTaskDy = calTaskHelper.queryOne(props, new QFilter[]{idFilter});
        this.getView().getPageCache().put("calTaskName", calTaskDy.getString("name"));
        payRollGroupLable.setText(calTaskDy.getString("payrollgroupv.name"));
        calSceneLable.setText(calTaskDy.getString("payrollscenev.name"));
        String countMsg = ResManager.loadKDString((String)"\u7b2c%d\u6b21", (String)"CalPersonListViewPlugin_1", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        int count = calTaskDy.getInt("calcount");
        calPeriodLable.setText(calTaskDy.getString("period.name") + ' ' + String.format(Locale.ROOT, countMsg, count));
        calTaskNameLable.setText(calTaskDy.getString("name"));
        this.getPageCache().put("isAuto", String.valueOf(calTaskDy.getBoolean("isautoaddperson")));
        if (SWCStringUtils.equals((String)pageType, (String)"salaryDetailResultPage")) {
            String prefix = ResManager.loadKDString((String)"\u85aa\u8d44\u660e\u7ec6\u7ed3\u679c", (String)"CalReportViewPlugin_15", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
            String title = prefix + " - " + calTaskDy.getString("name");
            UpdateTabNameHelper.updateTabNameByWholeValue((IFormView)this.getView(), (String)title);
        } else {
            UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)calTaskDy.getString("name"));
        }
        MainEntityType calTask = EntityMetadataCache.getDataEntityType((String)"hsas_calpayrolltask");
        ComboProp taskTypeCombo = (ComboProp)calTask.getProperties().get((Object)"tasktype");
        List comboItems = taskTypeCombo.getComboItems();
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equals(calTaskType)) continue;
            calTaskTypeLable.setText(item.getName().getLocaleValue());
            break;
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeBindData begin,costtime {}", (Object)costTime);
        this.setAllCalPersonMarkInfo(calTaskId);
    }

    private void setAllCalPersonMarkInfo(Long calTaskId) {
        if (this.allCalPersonMarkMap == null) {
            SalaryDetailResultMarkListHelper markHelper = new SalaryDetailResultMarkListHelper();
            this.allCalPersonMarkMap = markHelper.getAllCalPersonMarkInfoByCalTaskId(calTaskId);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType newEntityType = this.getEntityType();
        e.setNewEntityType(newEntityType);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        BillList customControl = null;
        if (KEY_BILL_LIST_AP.equals(key)) {
            customControl = this.createBillList(key);
        }
        if (customControl != null) {
            e.setControl((Control)customControl);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        int i;
        boolean ishandleproration;
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)"hsas_calperson");
        List columns = args.getListColumns();
        CalPersonListHelper listHelper = new CalPersonListHelper();
        columns.removeIf(column -> !SWCStringUtils.equals((String)"fseq", (String)column.getListFieldKey()));
        HashSet<String> freezeLines = new HashSet<String>(16);
        this.log.info("beforeCreateListColumns begin");
        long startTime = System.currentTimeMillis();
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject task = taskHelper.queryOne("ishandleproration", new QFilter("id", "=", (Object)calTaskId).toArray());
        boolean bl = ishandleproration = task == null ? false : SWCStringUtils.equals((String)"1", (String)task.getString("ishandleproration"));
        if (SWCStringUtils.equals((String)pageType, (String)"salaryDetailResultPage")) {
            String orderStr = "filenumber asc";
            List<IListColumn> newColumns = this.loadCalResultDetailInfo(columns);
            HashSet<String> slFieldKeySet = new HashSet<String>(newColumns.size());
            for (IListColumn newColumn : newColumns) {
                if (!(newColumn instanceof ListColumn)) continue;
                ListColumn column2 = (ListColumn)newColumn;
                String fieldKey = column2.getKey();
                if (SWCStringUtils.startsWithIgnoreCase((String)fieldKey, (String)"SL") || SWCStringUtils.startsWithIgnoreCase((String)fieldKey, (String)"SI")) {
                    slFieldKeySet.add(fieldKey);
                }
                if (!this.isHisTask(calTaskId)) continue;
                if (SWCStringUtils.equals((String)fieldKey, (String)"salaryfilev.adminorg.name")) {
                    fieldKey = "adminorg.name";
                    this.getPageCache().put("hasAdminOrg", Boolean.TRUE.toString());
                    column2.setKey(fieldKey);
                    column2.setListFieldKey(fieldKey);
                    column2.setFieldName(fieldKey);
                    continue;
                }
                if (!SWCStringUtils.equals((String)fieldKey, (String)"salaryfilev.empgroup.name")) continue;
                fieldKey = "empgroup.name";
                this.getPageCache().put("hasEmpGroup", Boolean.TRUE.toString());
                column2.setKey(fieldKey);
                column2.setListFieldKey(fieldKey);
                column2.setFieldName(fieldKey);
            }
            if (!CollectionUtils.isEmpty(slFieldKeySet)) {
                try {
                    this.getPageCache().put("SalaryDetailSlFieldKeySet", JSONUtils.toString(slFieldKeySet));
                }
                catch (Exception exception) {
                    this.log.error("\u85aa\u8d44\u7ed3\u679c\u660e\u7ec6\u8868\u85aa\u916c\u5b57\u6bb5\u7f13\u5b58\u5931\u8d25", (Throwable)exception);
                }
            }
            args.setListColumns(newColumns);
            String calListViewIdStr = (String)this.getView().getFormShowParameter().getCustomParam("calListViewVid");
            StringBuilder sortPrioritySb = new StringBuilder();
            HashMap<Integer, String> sortPriorityMap = new HashMap<Integer, String>(16);
            if (!SWCStringUtils.isEmpty((String)calListViewIdStr)) {
                long calListViewId = Long.parseLong(calListViewIdStr);
                SWCDataServiceHelper calListViewHelper = new SWCDataServiceHelper("hsas_callistview");
                DynamicObject calListView = calListViewHelper.queryOne((Object)calListViewId);
                DynamicObjectCollection dynamicObjectCollection = calListView.getDynamicObjectCollection("columnentryentity");
                for (int i2 = 0; i2 < dynamicObjectCollection.size(); ++i2) {
                    DynamicObject dy = (DynamicObject)dynamicObjectCollection.get(i2);
                    if (!dy.getBoolean("isdisplay")) continue;
                    String fieldId = dy.getString("field");
                    int fieldSort = dy.getInt("sort");
                    int fieldSortPriority = dy.getInt("sortpriority");
                    if (fieldSort == 1) {
                        sortPriorityMap.put(fieldSortPriority, fieldId + " asc");
                        continue;
                    }
                    if (fieldSort != 2) continue;
                    sortPriorityMap.put(fieldSortPriority, fieldId + " desc");
                }
                for (int i2 = 1; i2 <= 5; ++i2) {
                    String order = (String)sortPriorityMap.get(i2);
                    if (order == null) continue;
                    if (sortPrioritySb.length() > 0) {
                        sortPrioritySb.append(',').append(order);
                        continue;
                    }
                    sortPrioritySb.append(order);
                }
                if (SWCStringUtils.isNotEmpty((String)sortPrioritySb.toString())) {
                    sortPrioritySb.append(',').append("id asc");
                }
                BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
                orderStr = sortPrioritySb.toString();
                billList.setOrderBy(orderStr);
            } else {
                BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
                billList.setOrderBy("filenumber asc");
            }
            this.log.info("calResult query order is:" + orderStr);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("orderStr", (Object)orderStr);
            return;
        }
        HashMap<Long, String> colorMap = new HashMap<Long, String>(16);
        SWCDataServiceHelper colorHelper = new SWCDataServiceHelper("hsas_calcolor");
        DynamicObject[] colorDys = colorHelper.query("id,number", new QFilter[0]);
        HashMap<Integer, String> sortPriorityMap = new HashMap<Integer, String>(16);
        StringBuilder sortPrioritySb = new StringBuilder();
        for (DynamicObject dy : colorDys) {
            colorMap.put(dy.getLong("id"), dy.getString("number"));
        }
        String calListViewIdStr = (String)this.getView().getFormShowParameter().getCustomParam("calListViewVid");
        if (!SWCStringUtils.isEmpty((String)calListViewIdStr)) {
            long calListViewId = Long.parseLong(calListViewIdStr);
            SWCDataServiceHelper calListViewHelper = new SWCDataServiceHelper("hsas_callistview");
            DynamicObject calListView = calListViewHelper.queryOne((Object)calListViewId);
            DynamicObjectCollection dynamicObjectCollection = calListView.getDynamicObjectCollection("columnentryentity");
            this.groupSpecialFields();
            int seq = 2;
            for (int i3 = 0; i3 < dynamicObjectCollection.size(); ++i3) {
                DynamicObject dy = (DynamicObject)dynamicObjectCollection.get(i3);
                if (!dy.getBoolean("isdisplay")) continue;
                String key = dy.getString("field");
                IListColumn newColumn = this.createListColumn(key, dy.getString("fieldname"), seq);
                if (!SWCStringUtils.equals((String)key, (String)"calstatus") && !SWCStringUtils.equals((String)key, (String)"onholdstatus")) {
                    this.setFontColor(dy, newColumn, colorMap);
                }
                this.setColumnSort(newColumn, dy.getInt("sort"), dy.getInt("sortpriority"), sortPriorityMap);
                columns.add(newColumn);
                if (dy.getBoolean("isfreezecolumn")) {
                    freezeLines.add(newColumn.getListFieldKey());
                }
                ++seq;
            }
            Boolean enableTax = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId);
            if (!enableTax.booleanValue()) {
                columns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"taxstatus"));
            }
            if (!ishandleproration) {
                columns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"isproration"));
            }
        } else {
            int seq = 1;
            columns.add(this.createListColumn("filenumber", ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7", (String)"CalPersonListViewPlugin_5", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++));
            columns.add(this.createListColumn("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"CalPersonListViewPlugin_6", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++));
            columns.add(this.createListColumn("empnumber", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"CalPersonListViewPlugin_7", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++));
            this.groupSpecialFields();
            for (Map.Entry<String, DynamicObject> entry : this.operationFields.entrySet()) {
                DynamicObject operatField = entry.getValue();
                columns.add(this.createOpreationColum(operatField.getString("field"), operatField.getString("name"), operatField));
            }
            Map statusMap = listHelper.getStatusMap();
            Boolean enableTax = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId);
            if (!enableTax.booleanValue()) {
                statusMap.remove("taxstatus");
            }
            if (this.isHisTask(calTaskId)) {
                statusMap.remove("taxstatus");
                statusMap.remove("paystatus");
                statusMap.remove("allotstatus");
            }
            for (Map.Entry entry : statusMap.entrySet()) {
                IListColumn statusColumn = this.createListColumn((String)entry.getKey(), (String)entry.getValue(), seq);
                columns.add(statusColumn);
                ++seq;
            }
            IListColumn addTypeColumn = this.createListColumn("addfiletype", ResManager.loadKDString((String)"\u6dfb\u52a0\u65b9\u5f0f", (String)"CalPersonListViewPlugin_4", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++);
            IListColumn iListColumn = this.createListColumn("salaryfilev.adminorg.name", ResManager.loadKDString((String)"\u6302\u9760\u884c\u653f\u7ec4\u7ec7", (String)"CalPersonListViewPlugin_8", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++);
            IListColumn empGroupColumn = this.createListColumn("salaryfilev.empgroup.name", ResManager.loadKDString((String)"\u8ba1\u85aa\u4eba\u5458\u7ec4", (String)"CalPersonListViewPlugin_9", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), seq++);
            columns.add(addTypeColumn);
            columns.add(iListColumn);
            columns.add(empGroupColumn);
            sortPriorityMap.put(1, "filenumber asc");
        }
        int maxFixColumn = 0;
        for (i = 0; i < columns.size(); ++i) {
            if (!freezeLines.contains(((IListColumn)columns.get(i)).getListFieldKey())) continue;
            maxFixColumn = i + 1;
        }
        for (i = 0; i < maxFixColumn; ++i) {
            ((IListColumn)columns.get(i)).setFixed(true);
        }
        for (i = 1; i <= 5; ++i) {
            String order = (String)sortPriorityMap.get(i);
            if (order == null) continue;
            if (sortPrioritySb.length() > 0) {
                sortPrioritySb.append(',').append(order);
                continue;
            }
            sortPrioritySb.append(order);
        }
        sortPrioritySb.append(',').append("id asc");
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        String orderby = sortPrioritySb.toString();
        billList.setOrderBy(orderby);
        this.log.info("calperson query order is:" + orderby);
        this.getPageCache().put("calpersonorderby", orderby);
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeCreateListColumns end,costtime {}", (Object)costTime);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection calPersonList = e.getPageData();
        List<Long> calPersonIdList = calPersonList.stream().map(calPerson -> calPerson.getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        DynamicObjectCollection persons = helper.queryOriginalCollection("id,calstatus", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
        this.calPersonCalStatusMap = persons.stream().collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("calstatus"), (v1, v2) -> v1));
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)pageType, (String)"salaryDetailResultPage")) {
            this.setHightLight(calPersonIdList);
        }
        boolean hasAdminOrg = SWCStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getPageCache().get("hasAdminOrg"));
        boolean hasEmpGroup = SWCStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getPageCache().get("hasEmpGroup"));
        if (!hasAdminOrg && !hasEmpGroup) {
            return;
        }
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        if (this.isHisTask(calTaskId)) {
            DynamicObjectCollection calPersons = helper.queryOriginalCollection("id,salaryfilev.id,salaryfilev.adminorg.name,salaryfilev.empgroup.name", new QFilter[]{new QFilter("id", "in", calPersonIdList)});
            Map<Long, DynamicObject> calPersonMap = calPersons.stream().collect(Collectors.toMap(calPerson -> calPerson.getLong("id"), calPerson -> calPerson));
            for (DynamicObject row : calPersonList) {
                DynamicObject calPerson2 = calPersonMap.get(row.getLong("id"));
                long salaryFilevId = calPerson2.getLong("salaryfilev.id");
                if (salaryFilevId == 0L) continue;
                if (row.containsProperty("adminorg")) {
                    row.set("adminorg.name", (Object)calPerson2.getString("salaryfilev.adminorg.name"));
                }
                if (!row.containsProperty("empgroup")) continue;
                row.set("empgroup.name", (Object)calPerson2.getString("salaryfilev.empgroup.name"));
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        if (e.getSource() instanceof ListOperationColumnDesc) {
            List operationColItems;
            ListOperationColumnDesc listOperationColumnDesc = (ListOperationColumnDesc)e.getSource();
            String listKey = listOperationColumnDesc.getKey();
            if (SWCStringUtils.equals((String)"viewdetailresult", (String)listKey)) {
                operationColItems = (List)e.getFormatValue();
                if (e.getRowData().containsProperty("id")) {
                    String calStatus = this.calPersonCalStatusMap.get(e.getRowData().getLong("id"));
                    if (SWCStringUtils.equals((String)CalStateEnum.UNCAL.getCode(), (String)calStatus) || SWCStringUtils.equals((String)CalStateEnum.CALING.getCode(), (String)calStatus) || SWCStringUtils.equals((String)CalStateEnum.PRECAL_ERROR.getCode(), (String)calStatus) || SWCStringUtils.equals((String)CalStateEnum.CANCELCALING.getCode(), (String)calStatus)) {
                        operationColItems.forEach(item -> item.setVisible(false));
                    }
                }
            }
            if (SWCStringUtils.equals((String)"calpersonmark", (String)listKey)) {
                operationColItems = (List)e.getFormatValue();
                long calPersonId = e.getRowData().getLong("id");
                if (this.allCalPersonMarkMap == null || this.allCalPersonMarkMap.size() == 0) {
                    operationColItems.forEach(item -> item.setVisible(false));
                } else {
                    List<DynamicObject> markList = this.allCalPersonMarkMap.get(calPersonId);
                    if (markList == null || markList.size() == 0) {
                        operationColItems.forEach(item -> item.setVisible(false));
                    } else {
                        operationColItems.forEach(item -> item.setVisible(true));
                    }
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)pageType, (String)"salaryDetailResultPage")) {
            this.getView().setVisible(Boolean.FALSE, HIDE_BTN);
            this.showCurrency();
        } else {
            this.getView().setVisible(Boolean.FALSE, hideBtn);
            this.getView().setVisible(Boolean.FALSE, new String[]{"showcurrency", "smallk"});
        }
        Object sceneVId = this.getView().getFormShowParameter().getCustomParam("payRollSceneVId");
        if (sceneVId != null) {
            Long payRollSceneVId = Long.parseLong(sceneVId.toString());
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            DynamicObject schemeAfterCalObj = sceneService.getSceneSchemeAfterCalObj(payRollSceneVId);
            String schemeAfterCalNumber = schemeAfterCalObj.getString("number");
            boolean calapprove = schemeAfterCalObj.getBoolean("calapprove");
            boolean costallot = schemeAfterCalObj.getBoolean("costallot");
            boolean genbizdata = schemeAfterCalObj.getBoolean("genbizdata");
            if (!calapprove) {
                this.getView().setVisible(Boolean.FALSE, calapproveBtn);
            }
            if (!costallot) {
                this.getView().setVisible(Boolean.FALSE, costallotBtn);
            }
            if (!genbizdata) {
                this.getView().setVisible(Boolean.FALSE, genbizdataBtn);
            }
            if (!SWCStringUtils.equals((String)"1010_S", (String)schemeAfterCalNumber)) {
                this.getView().setVisible(Boolean.FALSE, commonCalBtn);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, genbizdataBtn);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        switch (opKey = args.getOperateKey()) {
            case "donothing_viewcalresultform": {
                long userId = RequestContext.get().getCurrUserId();
                boolean permFlag = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)"hsas_caltabledetailresult", (String)"47150e89000000ac");
                if (!permFlag) {
                    this.getView().showErrorNotification(SWCPermissionServiceHelper.getNoPermTips((String)ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e0e\u7ed3\u679c\u67e5\u770b", (String)"CalPersonListViewPlugin_2", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0])));
                    return;
                }
                BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
                long pkid = (Long)billList.getFocusRowPkId();
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("hsas_caltabledetailresult");
                parameter.setCustomParam("pkId", (Object)String.valueOf(pkid));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
                break;
            }
            case "viewcalpersonmark": {
                BillList newBillList = (BillList)this.getControl(KEY_BILL_LIST_AP);
                long calPersonId = (Long)newBillList.getFocusRowPkId();
                OperationResult preOpResult = OperationServiceHelper.executeOperate((String)"viewcalpersonmark", (String)"hsas_calperson", (Object[])new Long[]{calPersonId}, null);
                if (!preOpResult.isSuccess()) break;
                this.viewCalPersonMarkInfo();
                break;
            }
            case "showallcalperson": {
                this.delCacheCalPersonIds();
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_switchtpl")) {
            boolean calTaskExist = this.checkCalTaskExists(args);
            if (calTaskExist) {
                this.switchTemplete(args);
            }
        } else if (SWCStringUtils.equals((String)optKey, (String)"refresh")) {
            this.checkCalTaskExists(args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_export")) {
            this.checkCalTaskExists(args);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.log.info("beforeCreateListDataProvider begin");
        long startTime = System.currentTimeMillis();
        super.beforeCreateListDataProvider(args);
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)pageType, (String)"salaryDetailResultPage")) {
            args.setListDataProvider((IListDataProvider)new AbstractCalPersonListViewBasePlugin.CalDetailResultLoadDataImpl());
        } else {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){
                boolean isSelectAllRows = false;

                protected boolean isOnlyPK4SelectedAllRows() {
                    this.isSelectAllRows = true;
                    return true;
                }

                public DynamicObjectCollection getData(int start, int limit) {
                    DynamicObjectCollection rows = super.getData(start, limit);
                    if (rows == null || rows.size() == 0 || this.isSelectAllRows) {
                        return rows;
                    }
                    DynamicProperty calStatusProperty = rows.getDynamicObjectType().getProperty("calstatus");
                    DynamicProperty onholdStatusProperty = rows.getDynamicObjectType().getProperty("onholdstatus");
                    ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(rows.size());
                    for (DynamicObject row : rows) {
                        String onholdStatus;
                        CellStyle cellStyle;
                        if (calStatusProperty != null) {
                            String calStatus = row.getString("calstatus");
                            if (errStatus.contains(calStatus)) {
                                cellStyle = new CellStyle();
                                cellStyle.setFieldKey("calstatus");
                                cellStyle.setRow(start + row.getInt("fseq") - 1);
                                cellStyle.setForeColor("#FF0000");
                                cellStyles.add(cellStyle);
                            }
                        }
                        if (onholdStatusProperty == null || !SWCStringUtils.isNotEmpty((String)(onholdStatus = row.getString("onholdstatus")))) continue;
                        cellStyle = new CellStyle();
                        cellStyle.setFieldKey("onholdstatus");
                        cellStyle.setRow(start + row.getInt("fseq") - 1);
                        switch (onholdStatus) {
                            case "1": {
                                cellStyle.setForeColor("#276FF5");
                                break;
                            }
                            case "2": {
                                cellStyle.setForeColor("#FF991C");
                                break;
                            }
                            case "4": {
                                cellStyle.setForeColor("#FD6C6A");
                                break;
                            }
                            case "5": {
                                cellStyle.setForeColor("#999999");
                            }
                        }
                        cellStyles.add(cellStyle);
                    }
                    BillList billList = (BillList)CalPersonListViewPlugin.this.getView().getControl(CalPersonListViewPlugin.KEY_BILL_LIST_AP);
                    billList.setCellStyle(cellStyles);
                    return rows;
                }
            });
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("beforeCreateListDataProvider end,costtime {}", (Object)costTime);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            if (SWCStringUtils.equals((String)"hsas_onholddetail", (String)parentView.getEntityId()) || SWCStringUtils.equals((String)"hsas_onholdbill", (String)parentView.getEntityId())) {
                return;
            }
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void setColumnSort(IListColumn column, int sort, int sortPriority, Map<Integer, String> sortPriorityMap) {
        if (column instanceof ListColumn) {
            if (sort == 1) {
                sortPriorityMap.put(sortPriority, ((ListColumn)column).getKey() + " asc ");
            } else if (sort == 2) {
                sortPriorityMap.put(sortPriority, ((ListColumn)column).getKey() + " desc ");
            }
        }
    }

    private void setFontColor(DynamicObject dy, IListColumn column, Map<Long, String> colorMap) {
        String color = colorMap.get(dy.getLong("calcolor.id"));
        column.setForeColor(color);
    }

    public void setFilter(SetFilterEvent e) {
        Long startTime = System.currentTimeMillis();
        this.log.info("setFilter begin");
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        e.getQFilters().add(qFilter);
        if (authorizedDataRuleQFilter != null) {
            e.getQFilters().addAll(authorizedDataRuleQFilter);
        } else {
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String calPersonIdStr = (String)pageCache.get(this.getView().getPageId() + "_cacheCalPersonIds", String.class);
        if (!SWCStringUtils.isEmpty((String)calPersonIdStr)) {
            JSONArray calPersonArray = JSONArray.parseArray((String)calPersonIdStr);
            int size = calPersonArray.size();
            long[] calPersonIds = new long[size];
            for (int i = 0; i < size; ++i) {
                calPersonIds[i] = calPersonArray.getLongValue(i);
            }
            QFilter calPersonFilter = new QFilter("id", "in", (Object)calPersonIds);
            e.getQFilters().add(calPersonFilter);
        }
        this.log.info("all filters is:{}", (Object)e.getQFilters().toString());
        Long endTime = System.currentTimeMillis();
        this.log.info("setFilter end,costtime {}", (Object)(endTime - startTime));
    }

    private IListColumn createListColumn(String key, String caption, int colIndex) {
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        if (this.isHisTask(calTaskId)) {
            if (SWCStringUtils.equals((String)key, (String)"salaryfilev.adminorg.name")) {
                key = "adminorg.name";
                this.getPageCache().put("hasAdminOrg", Boolean.TRUE.toString());
            } else if (SWCStringUtils.equals((String)key, (String)"salaryfilev.empgroup.name")) {
                key = "empgroup.name";
                this.getPageCache().put("hasEmpGroup", Boolean.TRUE.toString());
            }
        }
        DynamicObject operationField = this.operationFields.get(key);
        if (this.numberFields.contains(key)) {
            DecimalListColumn decimalCol = new DecimalListColumn();
            decimalCol.setZeroShow(false);
            if (SWCStringUtils.equals((String)"caltask.payrollyear", (String)key)) {
                decimalCol.setDisplayFormatString("0");
            }
            this.makeListColumn((ListColumn)decimalCol, key, caption, colIndex);
            return decimalCol;
        }
        if (this.dateFields.contains(key)) {
            DateListColumn dateListColumn = new DateListColumn();
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            String dateFormat = service.getDateFormat(Long.valueOf(RequestContext.get().getCurrUserId()));
            dateListColumn.setDisplayFormatString(dateFormat);
            if (SWCStringUtils.equals((String)"salaryfilev.startpaydate", (String)key)) {
                dateListColumn.setDisplayFormatString("yyyy-MM");
            }
            this.makeListColumn((ListColumn)dateListColumn, key, caption, colIndex);
            return dateListColumn;
        }
        if (operationField != null) {
            ListOperationColumn column = this.createOpreationColum(key, caption, operationField);
            return column;
        }
        ListColumn col = new ListColumn();
        this.makeListColumn(col, key, caption, colIndex);
        return col;
    }

    private ListOperationColumn createOpreationColum(String key, String caption, DynamicObject operationField) {
        ListOperationColumn column = new ListOperationColumn();
        ArrayList<OperationColItem> items = new ArrayList<OperationColItem>(10);
        OperationColItem copyItem = new OperationColItem();
        FormOperate op = (FormOperate)FormMetadataCache.getFormOperation((String)"hsas_calperson", (String)operationField.getString("number"));
        copyItem.setOperationName(op.getOperateName());
        copyItem.setOperationKey(operationField.getString("number"));
        copyItem.setVisible(true);
        items.add(copyItem);
        column.setOperationColItems(items);
        column.setName(new LocaleString(caption));
        column.setCaption(new LocaleString(caption));
        column.setFieldName(key);
        column.setKey(key);
        return column;
    }

    private void makeListColumn(ListColumn listColumn, String key, String caption, int colIndex) {
        listColumn.setCaption(new LocaleString(caption));
        listColumn.setKey(key);
        listColumn.setListFieldKey(key);
        listColumn.setFieldName(key);
        listColumn.setSeq(colIndex);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        Object sceneVid;
        this.log.info("filterContainerInit begin");
        long startTime = System.currentTimeMillis();
        List schemeFilterColumns = filterContainerInitEvent.getSchemeFilterColumns();
        List commonFilterColumns = filterContainerInitEvent.getCommonFilterColumns();
        String statusFilter = (String)this.getView().getFormShowParameter().getCustomParam("statusFilter");
        this.dealCalPlatformStatus(statusFilter, commonFilterColumns);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        Boolean enableTax = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calTaskId);
        if (!enableTax.booleanValue()) {
            commonFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"taxstatus"));
            schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"taxstatus"));
        }
        if ((sceneVid = this.getView().getFormShowParameter().getCustomParam("payRollSceneVId")) != null) {
            Long payRollSceneVId = Long.parseLong(sceneVid.toString());
            SWCPayRollSceneService sceneService = SWCPayRollSceneService.createInstance();
            DynamicObject schemeAfterCalObj = sceneService.getSceneSchemeAfterCalObj(payRollSceneVId);
            boolean calapprove = schemeAfterCalObj.getBoolean("calapprove");
            boolean costallot = schemeAfterCalObj.getBoolean("costallot");
            String schemeAfterCalNumber = schemeAfterCalObj.getString("number");
            if (!costallot) {
                commonFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"allotstatus"));
                schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"allotstatus"));
            }
            if (!calapprove) {
                this.removeCalStatusApproveValue(schemeFilterColumns, commonFilterColumns);
            }
            if (!SWCStringUtils.equals((String)"1010_S", (String)schemeAfterCalNumber)) {
                commonFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"paystatus"));
                schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"paystatus"));
                commonFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"salarystatus"));
                schemeFilterColumns.removeIf(col -> SWCStringUtils.equals((String)col.getFieldName(), (String)"salarystatus"));
            }
        }
        ArrayList<String> filedList = new ArrayList<String>(10);
        Iterator schemeIterator = schemeFilterColumns.iterator();
        List statusList = CalPersonListHelper.getStatusList();
        String calListViewVidStr = (String)this.getView().getFormShowParameter().getCustomParam("calListViewVid");
        if (!SWCStringUtils.isEmpty((String)calListViewVidStr)) {
            Long calListViewId = Long.parseLong(calListViewVidStr);
            SWCDataServiceHelper calListViewHelper = new SWCDataServiceHelper("hsas_callistview");
            DynamicObject calListView = calListViewHelper.queryOne((Object)calListViewId);
            DynamicObjectCollection viewEntry = calListView.getDynamicObjectCollection("columnentryentity");
            for (DynamicObject dy : viewEntry) {
                if (!dy.getBoolean("isdisplay")) continue;
                filedList.add(dy.getString("field"));
            }
        }
        while (schemeIterator.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)schemeIterator.next();
            String filedKey = filterColumn.getFieldName();
            if (filedList.contains(filedKey) || statusList.contains(filedKey)) continue;
            schemeIterator.remove();
        }
        long costTime = System.currentTimeMillis() - startTime;
        this.log.info("filterContainerInit\u3000end,costtime {}", (Object)costTime);
    }

    private void removeCalStatusApproveValue(List<FilterColumn> schemeFilterColumns, List<FilterColumn> commonFilterColumns) {
        for (SchemeFilterColumn schemeFilterColumn : schemeFilterColumns) {
            String string = schemeFilterColumn.getFieldName();
            if (!"calstatus".equals(string)) continue;
            schemeFilterColumn.getComboItems().removeIf(item -> SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.WAIT_APPROVALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALING.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVAL.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALED_NOT_PASS.getCode()));
        }
        for (CommonFilterColumn commonFilterColumn : commonFilterColumns) {
            String filedKey = commonFilterColumn.getFieldName();
            if (!"calstatus".equals(filedKey)) continue;
            commonFilterColumn.getComboItems().removeIf(item -> SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.WAIT_APPROVALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALING.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVAL.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALED.getCode()) || SWCStringUtils.equals((String)item.getValue(), (String)CalStateEnum.APPROVALED_NOT_PASS.getCode()));
        }
    }

    private void dealCalPlatformStatus(String statusFilter, List<FilterColumn> commonFilterColumnList) {
        if (SWCStringUtils.isNotEmpty((String)statusFilter) && !SWCObjectUtils.isEmpty(commonFilterColumnList)) {
            for (FilterColumn listFilter : commonFilterColumnList) {
                CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
                String fieldName = commFilter.getFieldName();
                if (!fieldName.equals("calstatus")) continue;
                String[] statusArr = statusFilter.split("-");
                commFilter.setDefaultValues(new Object[]{statusArr[1]});
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "payrollgroupvalue": {
                String payRollGroupVid = (String)this.getView().getFormShowParameter().getCustomParam("payrollgroupv");
                this.viewBaseData("hsas_payrollgrp", Long.parseLong(payRollGroupVid), "hsas_payrollgrp");
                break;
            }
            case "calscenevalue": {
                String calSceneVid = (String)this.getView().getFormShowParameter().getCustomParam("payRollSceneVId");
                this.viewBaseData("hsas_payrollscene", Long.parseLong(calSceneVid), "hsas_payrollscene");
                break;
            }
            case "showcurrency": {
                this.setShowCurrencyVal();
                break;
            }
            case "smallk": {
                this.openSalaryResultCheckPage();
                break;
            }
            case "calrequesticon": {
                ListShowParameter listShowParameter = CalRequestHelper.getCalRequestListForm();
                this.getView().showForm((FormShowParameter)listShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() != null) {
            String returnData = String.valueOf(closedCallBackEvent.getReturnData());
            if (SWCStringUtils.equals((String)backKey, (String)"doRefreshBack") && SWCStringUtils.equals((String)returnData, (String)"dorefreshfinish")) {
                Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
                CalPersonListHelper.updatePersonCount((Long)calTaskId);
                BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
                billList.getSelectedRows().removeIf(row -> row.getRowKey() < 0);
                ((IListView)this.getView()).refresh();
            } else if (SWCStringUtils.equals((String)backKey, (String)"closeSwitchTpl")) {
                ListSelectedRowCollection selectRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (SWCObjectUtils.isEmpty((Object)returnData)) {
                    return;
                }
                ListSelectedRow selectRow = selectRows.get(0);
                Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
                this.doSwitchTpl(calResultTplId);
            }
        } else if (SWCStringUtils.equals((String)backKey, (String)CAL_PERSON_MARK_DEL_CALLBACK)) {
            this.getView().invokeOperation("refresh");
        } else if (SWCStringUtils.equals((String)backKey, (String)"smallk_callback")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void viewBaseData(String formId, long pkId, String premItemEntity) {
        String opName = ResManager.loadKDString((String)"\u67e5\u770b\u5386\u53f2", (String)"CalPersonListViewPlugin_0", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]);
        if (this.checkPermission("0=KX5+QZ1K6A", opName, premItemEntity)) {
            this.showBaseDataPage(formId, pkId);
        } else {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)premItemEntity);
            String entityName = mainEntityType.getDisplayName().getLocaleValue();
            String msg = SWCPermissionServiceHelper.getNoPermTips((String)String.format("%s%s", entityName, opName));
            this.getView().showMessage(msg);
        }
    }

    private boolean checkPermission(String permItemId, String opName, String entryName) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)entryName, (String)permItemId);
    }

    private void showBaseDataPage(String formId, long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private List<List<Object>> createEditor() {
        ArrayList<List<Object>> st = new ArrayList<List<Object>>(10);
        List calStatusDefault = CalPersonStatusDefault.getCalStatusValueMapItems();
        for (ValueMapItem mapItem : calStatusDefault) {
            ArrayList<String> items = new ArrayList<String>(10);
            items.add(mapItem.getValue());
            items.add((String)mapItem.getName());
            st.add(items);
        }
        return st;
    }

    private void viewCalPersonMarkInfo() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calpersonmarklist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        long calPersonId = (Long)billList.getFocusRowPkId();
        CalPersonListHelper helper = new CalPersonListHelper();
        String calPersonName = helper.getCalPersonNameByCalPersonId(calPersonId);
        showParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6807\u8bb0\u8be6\u60c5-%s", (String)"CalPersonListViewPlugin_3", (String)SWC_HSAS_FORMPLUGIN, (Object[])new Object[0]), calPersonName));
        showParameter.setCustomParam("calPersonId", (Object)calPersonId);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CAL_PERSON_MARK_DEL_CALLBACK));
        this.getView().showForm(showParameter);
    }

    private void openSalaryResultCheckPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_salaryresultchek");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "smallk_callback"));
        this.getView().showForm(showParameter);
    }

    private void setHightLight(List<Long> calPersonIdList) {
        String slFieldKeySetStr = this.getPageCache().get("SalaryDetailSlFieldKeySet");
        if (SWCStringUtils.isEmpty((String)slFieldKeySetStr)) {
            return;
        }
        String colorStyle = this.getView().getPageCache().get("highlightcolor");
        if (SWCStringUtils.isEmpty((String)colorStyle)) {
            return;
        }
        Set slFieldKeySet = null;
        try {
            slFieldKeySet = (Set)JSONUtils.cast((String)slFieldKeySetStr, HashSet.class);
        }
        catch (Exception exception) {
            this.log.error("\u85aa\u8d44\u7ed3\u679c\u660e\u7ec6\u8868\u85aa\u916c\u5b57\u6bb5\u7f13\u5b58\u53cd\u5e8f\u5217\u5931\u8d25", (Throwable)exception);
        }
        if (CollectionUtils.isEmpty((Collection)slFieldKeySet)) {
            return;
        }
        Map<Long, Set<String>> resultCoverInfo = this.collectResultCoverInfo(calPersonIdList, slFieldKeySet);
        if (resultCoverInfo.size() == 0) {
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILL_LIST_AP);
        int startLine = this.getStartLine(billList);
        LinkedList<CellStyle> cellStyleList = new LinkedList<CellStyle>();
        for (int index = 0; index < calPersonIdList.size(); ++index) {
            Set<String> columnKeySet = resultCoverInfo.get(calPersonIdList.get(index));
            if (CollectionUtils.isEmpty(columnKeySet)) continue;
            for (String columnKey : columnKeySet) {
                CellStyle cs = new CellStyle();
                cs.setFieldKey(columnKey);
                cs.setForeColor(colorStyle);
                cs.setRow(index + startLine);
                cellStyleList.add(cs);
            }
        }
        if (!CollectionUtils.isEmpty(cellStyleList)) {
            billList.setCellStyle(cellStyleList);
        }
    }

    private int getStartLine(BillList billList) {
        AbstractGrid.GridState entryState = billList.getEntryState();
        int startLine = entryState.getCurrentPageIndex() <= 1 ? 0 : (entryState.getCurrentPageIndex() - 1) * entryState.getPageRows();
        if (entryState.isScrollLoad() != null && entryState.isScrollLoad().booleanValue() && entryState.getPageRows() == 10000 && !(this.getView().getFormShowParameter() instanceof MobileListShowParameter)) {
            startLine += entryState.getScrollStart();
        }
        return startLine;
    }

    private boolean isHisTask(Long calTaskId) {
        String isHisTask = this.getPageCache().get("isHisTask");
        if (SWCStringUtils.isNotEmpty((String)isHisTask)) {
            return SWCStringUtils.equals((String)Boolean.TRUE.toString(), (String)isHisTask);
        }
        this.cacheTaskInfo(calTaskId);
        return SWCStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getPageCache().get("isHisTask"));
    }

    private boolean isProrationTask(Long calTaskId) {
        String isProration = this.getPageCache().get("isProration");
        if (SWCStringUtils.isNotEmpty((String)isProration)) {
            return SWCStringUtils.equals((String)"1", (String)isProration);
        }
        this.cacheTaskInfo(calTaskId);
        return SWCStringUtils.equals((String)"1", (String)this.getPageCache().get("ishandleproration"));
    }

    private void cacheTaskInfo(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTask = helper.queryOriginalOne("tasktype,ishandleproration", new QFilter[]{new QFilter("id", "=", (Object)calTaskId)});
        if (calTask != null) {
            this.getPageCache().put("isHisTask", String.valueOf(SWCStringUtils.equals((String)calTask.getString("tasktype"), (String)"2")));
            this.getPageCache().put("isProration", calTask.getString("ishandleproration"));
        }
    }

    private Map<Long, Set<String>> collectResultCoverInfo(List<Long> calPersonIdList, Set<String> slFieldKeySet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calresultcoverdata");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("calperson,salaryitem.uniquecode", new QFilter[]{new QFilter("calperson", "in", calPersonIdList)});
        HashMap<Long, Set<String>> resultCoverMap = new HashMap<Long, Set<String>>(calPersonIdList.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String uniqueCode = dynamicObject.getString("salaryitem.uniquecode");
            String columnKey = uniqueCode.replace("_", "").toLowerCase();
            if (!slFieldKeySet.contains(columnKey)) continue;
            Long calPersonId = dynamicObject.getLong("calperson");
            Set columnKeySet = resultCoverMap.computeIfAbsent(calPersonId, key -> new HashSet(16));
            columnKeySet.add(columnKey);
        }
        Long calTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("payrolltaskdataid");
        if (this.isProrationTask(calTaskId)) {
            helper.setEntityName("hsas_caltable");
            QFilter filter = new QFilter("calpersonid", "in", calPersonIdList);
            filter.and(new QFilter("hsas_caltableentry.resultcover", "=", (Object)"1"));
            filter.and(new QFilter("hsas_caltableentry.slprorationindex", ">", (Object)0));
            DynamicObjectCollection calTables = helper.queryOriginalCollection("hsas_caltableentry.id,hsas_caltableentry.salaryitem.uniquecode,hsas_caltableentry.resultcover,calpersonid", new QFilter[]{filter});
            for (DynamicObject calTable : calTables) {
                String columnKey;
                String uniqueCode = calTable.getString("hsas_caltableentry.salaryitem.uniquecode");
                if (SWCStringUtils.isEmpty((String)uniqueCode) || !slFieldKeySet.contains(columnKey = uniqueCode.replace("_", "").toLowerCase())) continue;
                Long calPersonId = calTable.getLong("calpersonid");
                Set columnKeySet = resultCoverMap.computeIfAbsent(calPersonId, key -> new HashSet(16));
                columnKeySet.add(columnKey);
            }
        }
        return resultCoverMap;
    }

    static {
        errStatus.add(CalStateEnum.PRECAL_ERROR.getCode());
        errStatus.add(CalStateEnum.PUSHTAX_ERROR.getCode());
        errStatus.add(CalStateEnum.TAXCAL_ERROR.getCode());
        errStatus.add(CalStateEnum.PULLTAX_ERROR.getCode());
        errStatus.add(CalStateEnum.AFTERCAL_ERROR.getCode());
        errStatus.add(CalStateEnum.CANCELCAL_ERROR.getCode());
        HIDE_BTN = new String[]{"addcalperson", "cal", "viewcalreporthis", "viewcalresult", "importprorationdata", "audit", "approve", "createapprove", "delcostallot", "viewcostallotdetail", "viewFeedback", "createcostallot", "createsalary", "prorationcover", "calpersonexport", "calresultcover"};
        hideBtn = new String[]{"changetmp", "export", "calresultcover1"};
        commonCalBtn = new String[]{"createsalary", "createpay"};
        calapproveBtn = new String[]{"approve", "createapprove"};
        costallotBtn = new String[]{"createcostallot", "delcostallot", "viewcostallotdetail", "viewFeedback"};
        genbizdataBtn = new String[]{"genbizdata"};
    }
}

