/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.impt.HSASCalTableImportLogHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverImportService;
import kd.swc.hsas.business.cal.service.CalResultCoverService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsas.formplugin.web.guide.AbstractCalPersonList;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class CalPersonResultCoverOperateList
extends AbstractCalPersonList {
    private static final Log logger = LogFactory.getLog(CalPersonResultCoverOperateList.class);
    private static final String SALARYITEM_COVER_OPEN_TYPE = "openType";
    private static final String IMPORTDATA = "importData";
    private static final String IMPORTINGDATA = "importingData";
    private static final int fixHeadHeight = 8;
    private static final int FIX_ROWS = 2;
    private static final int PERSON_SIZE = 20000;

    @Override
    protected List<CalPersonOperationEnum> operationKey() {
        ArrayList<CalPersonOperationEnum> calPersonOperationEnums = new ArrayList<CalPersonOperationEnum>();
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_CAL_RESULT_COVER);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_IMPORT);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEW_IMPORT_DATA);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEW_OP_LOG);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_VIEW_COVER_DATA);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_PRORATION_COVER);
        calPersonOperationEnums.add(CalPersonOperationEnum.OP_IMPORT_PRORATION);
        return calPersonOperationEnums;
    }

    @Override
    protected boolean operationMutex() {
        boolean flag = false;
        switch (this.calPersonOperationEnum) {
            case OP_CAL_RESULT_COVER: 
            case OP_PRORATION_COVER: {
                flag = true;
                break;
            }
            case OP_IMPORT: 
            case OP_IMPORT_PRORATION: {
                String importCheckType = this.getPageCache().get("importCheckType");
                if (SWCStringUtils.equals((String)"usertask", (String)importCheckType)) {
                    flag = false;
                    break;
                }
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    protected boolean isSelectData() {
        boolean flag = true;
        switch (this.calPersonOperationEnum) {
            case OP_IMPORT: 
            case OP_IMPORT_PRORATION: 
            case OP_VIEW_IMPORT_DATA: 
            case OP_VIEW_OP_LOG: 
            case OP_VIEW_COVER_DATA: {
                flag = false;
                break;
            }
        }
        return flag;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("hsas_coversalaryitem".equals(actionId)) {
            this.openCoverView(event);
        } else if ("hsas_calresultcoverlist".equals(actionId) || IMPORTINGDATA.equals(actionId)) {
            this.getView().invokeOperation("refresh");
            this.releaseDistributedLock();
            this.cleanCachePersonData();
        } else if (IMPORTDATA.equals(actionId)) {
            this.openImportProcessView(event);
        }
    }

    @Override
    protected void beforeDoOperation(BeforeDoOperationEventArgs args, CalPayRollTask calPayRollTask) {
        this.cachePageId();
        switch (this.calPersonOperationEnum) {
            case OP_CAL_RESULT_COVER: {
                this.checkAndOpenItemTransView(calPayRollTask);
                break;
            }
            case OP_PRORATION_COVER: {
                this.checkAndOpenCoverView(calPayRollTask);
                break;
            }
            case OP_IMPORT: {
                this.checkAndOpenImportView(calPayRollTask);
                break;
            }
            case OP_IMPORT_PRORATION: {
                this.checkAndOpenProrationImportView(calPayRollTask);
                break;
            }
            case OP_VIEW_IMPORT_DATA: {
                this.openViewImportDataList();
                break;
            }
            case OP_VIEW_OP_LOG: {
                this.openViewOpLogList();
                break;
            }
            case OP_VIEW_COVER_DATA: {
                this.openViewCoverDataList();
                break;
            }
        }
    }

    @Override
    public void pageRelease(EventObject eventObject) {
        super.pageRelease(eventObject);
        this.cleanCachePersonData();
    }

    private void checkAndOpenProrationImportView(CalPayRollTask calPayRollTask) {
        if (this.checkLock(calPayRollTask.getCalPayRollTaskId(), CalPersonOperationEnum.OP_IMPORT)) {
            return;
        }
        if (this.checkImporting("1", calPayRollTask)) {
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)CalPersonOperationEnum.OP_IMPORT.getOperationKey());
            return;
        }
        this.checkAndCachePersonIdForImport(calPayRollTask);
        this.openImportPage("1");
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
    }

    private void checkAndOpenImportView(CalPayRollTask calPayRollTask) {
        if (this.checkImporting("2", calPayRollTask)) {
            return;
        }
        this.checkAndCachePersonIdForImport(calPayRollTask);
        this.openImportPage("2");
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
    }

    private void checkAndOpenCoverView(CalPayRollTask calPayRollTask) {
        if (this.checkLock(calPayRollTask.getCalPayRollTaskId(), CalPersonOperationEnum.OP_CAL_RESULT_COVER)) {
            return;
        }
        try {
            boolean check = this.checkAndCacheProrationData(calPayRollTask, true, false);
            if (check) {
                calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
                this.openCaLResultCoverView("1");
            } else {
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
            }
        }
        catch (Exception exception) {
            logger.error("proration cover error", (Throwable)exception);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
        }
    }

    private void checkAndOpenItemTransView(CalPayRollTask calPayRollTask) {
        this.cleanCache();
        boolean flag = this.checkCalStatusAndCacheData(calPayRollTask, true, false);
        if (flag) {
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Confirm);
            this.openSalaryItemTransView(calPayRollTask, "1");
        }
    }

    private void openImportProcessView(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        Long calTaskId = this.getCalTaskId();
        if (event.getReturnData() != null) {
            if (((Boolean)returnData.get("isOk")).booleanValue()) {
                String coverType = String.valueOf(returnData.get("coverType"));
                String url = String.valueOf(returnData.get("url"));
                String fullPath = String.valueOf(returnData.get("fullPath"));
                int total = this.doImport(coverType, url, fullPath, calTaskId, this.getView().getPageId());
                this.openImportingView(total, coverType);
            }
        } else {
            this.cleanCachePersonData();
            this.releaseDistributedLock();
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calTaskId), (String)CalPersonOperationEnum.OP_IMPORT.getOperationKey());
        }
    }

    private void openCoverView(ClosedCallBackEvent event) {
        Map returnData = (Map)event.getReturnData();
        if (event.getReturnData() != null) {
            if (((Boolean)returnData.get("isOk")).booleanValue() && SWCStringUtils.equals((String)"1", (String)returnData.get(SALARYITEM_COVER_OPEN_TYPE).toString())) {
                this.openCaLResultCoverView("2");
            }
        } else {
            this.releaseDistributedLock();
            this.cleanCachePersonData();
        }
    }

    public int doImport(String coverType, String url, String fullPath, Long taskId, String pageId) {
        ArrayList dataHead = Lists.newArrayListWithCapacity((int)10);
        ArrayList dataRow = Lists.newArrayListWithCapacity((int)10);
        String billFormName = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u5bfc\u5165", (String)"CalPersonResultCoverOperateList_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        long st = System.currentTimeMillis();
        logger.info("CalPersonResultCoverOperateList.readExcelData begin");
        this.readExcelData(url, dataHead, dataRow);
        Object logId = HSASCalTableImportLogHelper.create((String)this.getCacheKey("hsas_calperson", pageId), (String)billFormName, (long)taskId, (String)coverType, (int)dataRow.size());
        String cacheKey = SWCStringUtils.equals((String)"2", (String)coverType) ? "resultcoverimport_%s" : "prorationcoverimport_%s";
        CalResultCoverHelper.initImportProgressMap((String)this.getTraceId(), (int)dataRow.size(), (String)cacheKey);
        logger.info("CalPersonResultCoverOperateList.readExcelData finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        Map exportDescInfo = CalResultCoverHelper.assembleExportDescInfo((Long)taskId);
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)taskId);
        this.asynDoImport(coverType, taxCalEnable, dataHead, dataRow, logId, exportDescInfo, fullPath, taskId, Integer.parseInt(taskMap.get("precision") + ""));
        return dataRow.size();
    }

    private boolean checkImporting(String coverType, CalPayRollTask calPayRollTask) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (this.checkDoingCalOrCancelTask(taskId)) {
            return true;
        }
        String importCheckType = this.getPageCache().get("importCheckType");
        logger.info("importCheckType:{}", (Object)importCheckType);
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasImporting = CalResultCoverHelper.checkImporting((String)importCheckType, (Long)userId, (Long)taskId);
        if (hasImporting) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5bfc\u5165\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"CalPersonResultCoverOperateList_23", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkDoingCalOrCancelTask(Long taskId) {
        boolean check = CalResultCoverHelper.checkHasDoingTask((Long)taskId);
        if (check) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5b58\u5728\u8ba1\u7b97\u4e2d\u6216\u8ba1\u7b97\u56de\u6eda\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u7b49\u5f85\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"CalPersonResultCoverOperateList_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkLock(Long taskId, CalPersonOperationEnum opKey) {
        if (this.checkDoingCalOrCancelTask(taskId)) {
            return true;
        }
        Map taskInfo = CalResultCoverHelper.assembleTaskInfo((Long)taskId);
        String taskNumber = (String)taskInfo.get("taskNumber");
        CalPayRollTaskMutex lock = PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)opKey.getOperationKey());
        if (lock != null) {
            String errorMessage = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a{0}\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6b63\u5728{1}\u4e2d\uff0c\u65e0\u6cd5{2}\u3002", (String)"CalPersonResultCoverOperateList_24", (String)"swc-hsas-formplugin", (Object[])new Object[]{taskNumber, lock.getCalPersonOperationEnum().getOperationName(), opKey.getOperationName()});
            this.getView().showTipNotification(errorMessage);
            return true;
        }
        return false;
    }

    private void asynDoImport(String coverType, Boolean taxCalEnable, List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, Object logId, Map<String, String> exportDescInfo, String fullPath, long taskId, int precision) {
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"IMPORT_RESULT_COVER_POOL", () -> {
            String traceId = this.getTraceId();
            logger.info("asynDoImport,traceId={}", (Object)traceId);
            RequestContext.copyAndSet((RequestContext)ctx);
            this.importData(traceId, coverType, taxCalEnable, dataHead, dataRow, logId, exportDescInfo, fullPath, taskId, precision);
        });
    }

    public void importData(String traceId, String coverType, Boolean taxCalEnable, List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow, Object logId, Map<String, String> exportDescInfo, String fullPath, long taskId, int precision) {
        ArrayList errDataList = new ArrayList(10);
        HashMap salaryItemMap = new HashMap(16);
        HashMap importData = new HashMap(16);
        CalResultCoverImportService importService = new CalResultCoverImportService(traceId, coverType, dataRow, dataHead, errDataList, importData, Long.valueOf(taskId), salaryItemMap, precision, taxCalEnable);
        boolean checkHeadFlag = importService.checkDataHead(taxCalEnable, dataHead, dataRow, logId, exportDescInfo, fullPath, errDataList, salaryItemMap);
        if (!checkHeadFlag) {
            this.logImportLog(false);
            String cacheKey = SWCStringUtils.equals((String)"2", (String)coverType) ? "resultcoverimport_%s" : "prorationcoverimport_%s";
            CalResultCoverHelper.updateImportProgress((String)traceId, (Long)taskId, (int)0, (int)dataRow.size(), (String)cacheKey);
            return;
        }
        importService.doImport();
        logger.info("import finish.errDataList.size:{}", (Object)errDataList.size());
        try {
            importService.genErrDataExcel(taxCalEnable, exportDescInfo, salaryItemMap, dataHead.get(2), dataRow, errDataList, fullPath, logId);
            if (importData.size() > 0) {
                CalResultCoverHelper.checkAndCalBack(new ArrayList(importData.keySet()), (Long)taskId);
            }
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)taskId);
            this.logImportLog(true);
        }
        catch (Exception exception) {
            logger.error("importService.genErrDataExcel error", (Throwable)exception);
        }
    }

    public void logImportLog(boolean success) {
        MultiLangEnumBridge opDescBridge = success ? new MultiLangEnumBridge("\u5bfc\u5165\u6210\u529f\u3002", "CalPersonResultCoverOperateList_19", "swc-hsas-formplugin") : new MultiLangEnumBridge("\u5bfc\u5165\u5931\u8d25\u3002", "CalPersonResultCoverOperateList_20", "swc-hsas-formplugin");
        try {
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5bfc\u5165\u6570\u636e", "CalPersonOperationEnum_42", "swc-hsbp-common");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)CalPersonOperationEnum.OP_IMPORT.getOperationKey(), (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        }
        catch (Exception exception) {
            logger.info("addLog error");
        }
    }

    public void readExcelData(String url, final List<Map<Integer, String>> dataHead, final List<Map<Integer, String>> dataRow) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() <= 2) {
                        dataHead.add(row.getData());
                    } else {
                        dataRow.add(row.getData());
                    }
                }
            });
        }
        catch (Throwable ex) {
            logger.error(ex);
        }
    }

    private String getCacheKey(String formId, String pageid) {
        String cacheKey = String.format("IMPORT_%s_%s", formId, pageid);
        return cacheKey.substring(0, Math.min(cacheKey.length(), 50));
    }

    private void cleanCachePersonData() {
        Long calTaskId = this.getCalTaskId();
        String pageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calTaskId));
        String cachePersonDataKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", calTaskId, pageId);
        String cacheProrationDataKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", calTaskId, pageId);
        String cacheProrationIdDataKey = String.format(Locale.ROOT, "resultCoverImportKey_%d_%s", calTaskId, pageId);
        appCache.remove(cachePersonDataKey);
        appCache.remove(cacheProrationDataKey);
        appCache.remove(cacheProrationIdDataKey);
    }

    private void checkAndCachePersonIdForImport(CalPayRollTask calPayRollTask) {
        List validPersonIdList;
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calPayRollTask.getCalPayRollTaskId());
        List calPersonsIdList = calPayRollTask.getCalPersons();
        if (taxCalEnable.booleanValue()) {
            Map declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus((Long)taskId, (List)calPersonsIdList);
            logger.info("decareStatusMap:{}", (Object)JSONObject.toJSONString((Object)declareStatusMap));
            for (Map.Entry entry : declareStatusMap.entrySet()) {
                if (!SWCStringUtils.equals((String)"1", (String)((String)entry.getValue()))) continue;
                calPersonsIdList.remove(entry.getKey());
            }
        }
        if ((validPersonIdList = CalResultCoverHelper.getValidPersonIdList((List)calPersonsIdList, (Boolean)taxCalEnable)).size() == 0) {
            return;
        }
        try {
            validPersonIdList = CalResultCoverHelper.getSortedPersonIdList((List)validPersonIdList, (Long)taskId);
            String appKey = String.format(Locale.ROOT, "calResultCover_%s", taskId);
            String cacheKey = String.format(Locale.ROOT, "resultCoverImportKey_%d_%s", taskId, this.getView().getPageId());
            ISWCAppCache appCache = SWCAppCache.get((String)appKey);
            appCache.put(cacheKey, (Object)validPersonIdList);
        }
        catch (Exception exception) {
            logger.error("checkAndCachePersonIdForImport_error", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
        }
    }

    private boolean checkAndCacheProrationData(CalPayRollTask calPayRollTask, boolean needWarn, boolean selectAll) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)calPayRollTask.getCalPayRollTaskId());
        List calPersonsIdList = calPayRollTask.getCalPersons();
        DynamicObject[] calPersons = CalResultCoverHelper.getCalPersonData((List)calPersonsIdList, (Long)taskId, (boolean)selectAll, (String)"2DXPSF5JTISP");
        if (needWarn && (calPersons == null || calPersons.length == 0)) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u52fe\u9009\u6570\u636e\u7684\u201c\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonResultCoverOperateList_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(msg);
            return false;
        }
        List validCalPersonList = CalResultCoverHelper.checkValidCalPersonList((Long)taskId, (Boolean)taxCalEnable, (DynamicObject[])calPersons);
        if (validCalPersonList.size() == 0) {
            if (!needWarn) {
                return true;
            }
            this.showPersonStatusErrorMsg(calPayRollTask, taxCalEnable);
            return false;
        }
        List validPersonIdList = validCalPersonList.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)taskId);
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        List personProrationItemList = CalResultCoverHelper.getProrationItemDataList((Long)calRuleHisObj.getLong("id"), validPersonIdList, (boolean)selectAll, (Long)taskId);
        if (SWCListUtils.isEmpty((List)personProrationItemList)) {
            if (!needWarn) {
                return true;
            }
            String msg = ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6838\u7b97\u4eba\u5458\u4e0d\u5b58\u5728\u5206\u6bb5\u4e8b\u4ef6\u6216\u6ca1\u6709\u53ef\u8986\u76d6\u7684\u85aa\u916c\u9879\u76ee\uff0c\u65e0\u9700\u505a\u5206\u6bb5\u7ed3\u679c\u8986\u76d6\u5904\u7406\u3002", (String)"CalPersonResultCoverOperateList_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showTipNotification(msg);
            return false;
        }
        try {
            List prorationItemCoverDataList = CalResultCoverHelper.assembleProrationItemCoverDataList((Long)taskId, (List)personProrationItemList, (boolean)selectAll);
            logger.info("prorationItemCoverDataList:{}", (Object)prorationItemCoverDataList);
            String formId = ((IListView)this.getView()).getBillFormId();
            if (SWCStringUtils.equals((String)formId, (String)"hsas_prorationresult")) {
                AbstractGrid.GridState gridState = ((ListView)this.getView()).getGridState();
                int[] selectedRowIndex = gridState.getSelectedRows();
                Integer currentPageIndex = gridState.getCurrentPageIndex();
                Integer pageRows = gridState.getPageRows();
                int startRowIndex = (currentPageIndex - 1) * pageRows;
                SWCPageCache swcPageCache = new SWCPageCache(this.getView());
                Map indexIdStrMap = (Map)swcPageCache.get("prorationListRowIndexIdStrMap", Map.class);
                logger.info("indexIdStrMap:{}", (Object)indexIdStrMap.toString());
                ArrayList idStrList = new ArrayList(selectedRowIndex.length);
                if (selectedRowIndex.length > 0) {
                    for (int rowIndex : selectedRowIndex) {
                        idStrList.add(indexIdStrMap.get(rowIndex - startRowIndex + ""));
                    }
                }
                Iterator iterator = prorationItemCoverDataList.iterator();
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    String idstr = (String)next.get("idstr");
                    if (idStrList.contains(idstr)) continue;
                    iterator.remove();
                }
                if (prorationItemCoverDataList.size() == 0) {
                    String msg = ResManager.loadKDString((String)"\u52fe\u9009\u7684\u6570\u636e\u5747\u4e0d\u5141\u8bb8\u5206\u6bb5\u7ed3\u679c\u8986\u76d6\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"CalPersonResultCoverOperateList_26", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                    calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
                    this.getView().showTipNotification(msg);
                    return false;
                }
            }
            String appKey = String.format(Locale.ROOT, "calResultCover_%s", taskId);
            String cacheKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, this.getView().getPageId());
            ISWCAppCache appCache = SWCAppCache.get((String)appKey);
            appCache.put(cacheKey, (Object)prorationItemCoverDataList);
            return true;
        }
        catch (Exception exception) {
            logger.error("checkAndCacheProrationData_error", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(calPayRollTask.getCalPayRollTaskId()), (String)this.calPersonOperationEnum.getOperationKey());
            return true;
        }
    }

    private void cleanCache() {
        Long calTaskId = this.getCalTaskId();
        String cachePageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", calTaskId));
        String cacheKey = String.format(Locale.ROOT, "salaryItemTransfer_%d_%s", calTaskId, cachePageId);
        String itemIndexcacheKey = String.format(Locale.ROOT, "itemIndex_%d_%s", calTaskId, cachePageId);
        String curSearchTextcacheKey = String.format(Locale.ROOT, "curSearchText_%d_%s", calTaskId, cachePageId);
        appCache.remove(cacheKey);
        appCache.remove(itemIndexcacheKey);
        appCache.remove(curSearchTextcacheKey);
    }

    private void cachePageId() {
        Long calTaskId = this.getCalTaskId();
        String appKey = String.format(Locale.ROOT, "calResultCover_%s", calTaskId);
        ISWCAppCache appCache = SWCAppCache.get((String)appKey);
        String cacheKey = String.format(Locale.ROOT, "calPersonPageId_%d", calTaskId);
        appCache.put(cacheKey, (Object)this.getView().getPageId());
    }

    private void openImportingView(int total, String coverType) {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_resultcoverimportret");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Long calTaskId = this.getCalTaskId();
        String traceId = this.getTraceId();
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("taskId", calTaskId);
        params.put("traceId", traceId);
        params.put("total", total);
        params.put("coverType", coverType);
        showParameter.setCustomParams((Map)params);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTINGDATA));
        view.showForm(showParameter);
    }

    private void openImportPage(String coverType) {
        Long calTaskId = this.getCalTaskId();
        String pageId = this.getView().getPageId();
        Map exportDescInfo = CalResultCoverHelper.assembleExportDescInfo((Long)calTaskId);
        Map personSortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap((Long)calTaskId);
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)calTaskId);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hsas_resultcoverimport");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("taskId", (Object)calTaskId);
        formShowParameter.setCustomParam("pageId", (Object)pageId);
        formShowParameter.setCustomParam("exportDescInfo", (Object)exportDescInfo);
        formShowParameter.setCustomParam("precision", (Object)Integer.parseInt(taskMap.get("precision") + ""));
        formShowParameter.setCustomParam("personSortColumnMap", (Object)personSortColumnMap);
        formShowParameter.setCustomParam("coverType", (Object)coverType);
        formShowParameter.setCustomParam("taskName", taskMap.get("name"));
        formShowParameter.setCustomParam("traceId", (Object)this.getTraceId());
        String importCheckType = this.getPageCache().get("importCheckType");
        formShowParameter.setCustomParam("importCheckType", (Object)importCheckType);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(formShowParameter);
    }

    private void openViewCoverDataList() {
        FormShowParameter showParameter = new FormShowParameter();
        CalPayRollTask calPayRollTask = (CalPayRollTask)this.calPayRollTaskContext.getValidDatas().get(0);
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)calPayRollTask.getCalPayRollTaskId());
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        showParameter.setPageId("viewcoverdata" + this.getView().getPageId() + this.getCalTaskId());
        showParameter.setFormId("hsas_resultcoverdataview");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("calRuleVid", (Object)calRuleHisObj.getLong("id"));
        showParameter.setCustomParam("personPageId", (Object)this.getView().getPageId());
        showParameter.setCustomParam("taskId", (Object)calPayRollTask.getCalPayRollTaskId());
        showParameter.setCustomParam("selectedPersonList", (Object)calPayRollTask.getCalPersons());
        String formId = ((IListView)this.getView()).getBillFormId();
        String pageType = SWCStringUtils.equals((String)formId, (String)"hsas_prorationresult") ? "prorationResultDetailPage" : (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        showParameter.setCustomParam("pageType", (Object)pageType);
        this.getView().showForm(showParameter);
    }

    private void openViewOpLogList() {
        FormShowParameter showParameter = new FormShowParameter();
        Long calTaskId = this.getCalTaskId();
        String pageId = this.getView().getPageId();
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)calTaskId);
        CalResultCoverService coverService = new CalResultCoverService();
        long calRuleVid = task.getDynamicObject("calrulev").getLong("id");
        Map salaryItemMap = coverService.assembleCoverSalaryItemMap(Long.valueOf(calRuleVid));
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)calTaskId);
        showParameter.setPageId("viewoplog" + pageId + calTaskId);
        showParameter.setFormId("hsas_retcoveroplog");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u65e5\u5fd7\u5217\u8868", (String)"CalPersonResultCoverOperateList_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("taskId", (Object)calTaskId);
        showParameter.setCustomParam("personPageId", (Object)pageId);
        showParameter.setCustomParam("precision", (Object)Integer.parseInt(taskMap.get("precision") + ""));
        showParameter.setCustomParam("currencyId", (Object)Long.parseLong(taskMap.get("currencyId") + ""));
        showParameter.setCustomParam("salaryItemMap", (Object)salaryItemMap);
        String formId = ((IListView)this.getView()).getBillFormId();
        String pageType = SWCStringUtils.equals((String)formId, (String)"hsas_prorationresult") ? "prorationResultDetailPage" : (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        showParameter.setCustomParam("pageType", (Object)pageType);
        this.getView().showForm(showParameter);
    }

    private String getTaskPeriodName(Long calTaskId) {
        CalResultCoverService coverService = new CalResultCoverService();
        DynamicObject taskInfo = coverService.getCalTaskInfo(calTaskId);
        String periodName = taskInfo.getString("period.name");
        return periodName;
    }

    private void openViewImportDataList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setPageId("viewimportdata" + this.getView().getPageId() + this.getCalTaskId());
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("hsas_caltableimportlog");
        showParameter.setCustomParam("taskId", (Object)this.getCalTaskId());
        showParameter.setCustomParam("personPageId", (Object)this.getView().getPageId());
        QFilter filter = new QFilter("billno", "like", (Object)"IMPORT_hsas_calperson%");
        long userId = RequestContext.get().getCurrUserId();
        filter.and("creator", "=", (Object)userId);
        filter.and("caltask", "=", (Object)this.getCalTaskId());
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openSalaryItemTransView(CalPayRollTask calPayRollTask, String openType) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_coversalaryitem");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_coversalaryitem"));
        showParameter.setCustomParam("taskId", (Object)calPayRollTask.getCalPayRollTaskId());
        showParameter.setCustomParam("personPageId", (Object)this.getView().getPageId());
        Map operationParam = calPayRollTask.getOperationParam();
        DynamicObject task = CalPayrollTaskHelper.queryTaskInfoById((Long)calPayRollTask.getCalPayRollTaskId());
        DynamicObject calRuleHisObj = task.getDynamicObject("calrulev");
        operationParam.put("calRuleHisId", String.valueOf(calRuleHisObj.getLong("id")));
        operationParam.put("pageId", this.getView().getPageId());
        operationParam.put(SALARYITEM_COVER_OPEN_TYPE, openType);
        this.getView().showForm(showParameter);
    }

    private void openCaLResultCoverView(String type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calresultcoverlist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calresultcoverlist"));
        CalPayRollTask calPayRollTask = (CalPayRollTask)this.getCalPayRollTaskContext().getValidDatas().get(0);
        String pageId = this.getView().getPageId();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        String traceId = this.getTraceId();
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)taskId);
        Map personSortColumnMap = CalResultCoverHelper.assemblePersonSortColumnMap((Long)taskId);
        showParameter.setCustomParam("taskId", (Object)taskId);
        showParameter.setCustomParam("precision", (Object)Integer.parseInt(taskMap.get("precision") + ""));
        showParameter.setCustomParam("currencyId", (Object)Long.parseLong(taskMap.get("currencyId") + ""));
        showParameter.setCustomParam("personPageId", (Object)pageId);
        showParameter.setCustomParam("coverType", (Object)type);
        showParameter.setCustomParam("taskName", (Object)calPayRollTask.getName());
        showParameter.setCustomParam("periodName", (Object)this.getTaskPeriodName(taskId));
        showParameter.setCustomParam("personSortColumnMap", (Object)personSortColumnMap);
        showParameter.setCustomParam("source", (Object)"1");
        showParameter.setCustomParam("traceId", (Object)traceId);
        this.getView().showForm(showParameter);
    }

    private boolean checkCalStatusAndCacheData(CalPayRollTask calPayRollTask, boolean needWarn, boolean selectAll) {
        this.cleanCachePersonData();
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        if (this.checkDoingCalOrCancelTask(taskId)) {
            return false;
        }
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)taskId);
        List calPersonsIdList = calPayRollTask.getCalPersons();
        DynamicObject[] calPersons = CalResultCoverHelper.getCalPersonData((List)calPersonsIdList, (Long)taskId, (boolean)selectAll, (String)"2DXPSF5JTISP");
        if (needWarn && (calPersons == null || calPersons.length == 0)) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u52fe\u9009\u6570\u636e\u7684\u201c\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalPersonResultCoverOperateList_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            this.getView().showErrorNotification(msg);
            return false;
        }
        List validCalPersonList = !selectAll ? CalResultCoverHelper.checkValidCalPersonList((Long)taskId, (Boolean)taxCalEnable, (DynamicObject[])calPersons) : Arrays.asList(calPersons);
        if (validCalPersonList.size() == 0) {
            if (!needWarn) {
                return true;
            }
            this.showPersonStatusErrorMsg(calPayRollTask, taxCalEnable);
            return false;
        }
        if (needWarn && validCalPersonList.size() > 20000) {
            String msg = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7{0}\u884c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalPersonResultCoverOperateList_21", (String)"swc-hsas-formplugin", (Object[])new Object[]{20000});
            this.getView().showTipNotification(msg);
            return false;
        }
        try {
            this.assembleAndCacheCalPersonData(validCalPersonList, calPayRollTask, selectAll);
            return true;
        }
        catch (Exception exception) {
            logger.error("assembleAndCacheCalPersonData_error", (Throwable)exception);
            this.getView().showErrorNotification(exception.getMessage());
            calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)this.calPersonOperationEnum.getOperationKey());
            return false;
        }
    }

    private void showPersonStatusErrorMsg(CalPayRollTask calPayRollTask, Boolean taxCalEnable) {
        String msg = taxCalEnable != false ? ResManager.loadKDString((String)"\u53ea\u6709\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u672a\u8ba1\u7b97\u201d\u3001\u201c\u7a0e\u524d\u8ba1\u7b97\u5b8c\u6210\u201d\u3001\u201c\u8ba1\u7b97\u5b8c\u6210\uff08\u4e14\u4e2a\u7a0e\u672a\u9501\u5b9a\uff09\u201d\u3001\u201c\u5931\u8d25\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\u3002", (String)"CalPersonResultCoverOperateList_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53ea\u6709\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u672a\u8ba1\u7b97\u201d\u3001\u201c\u7a0e\u524d\u8ba1\u7b97\u5b8c\u6210\u201d\u3001\u201c\u8ba1\u7b97\u5b8c\u6210\u201d\u3001\u201c\u5931\u8d25\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u7ed3\u679c\u8986\u76d6\u3002", (String)"CalPersonResultCoverOperateList_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        calPayRollTask.setCancelEnum(CalPayRollTask.CancelEnum.Cancel);
        this.getView().showErrorNotification(msg);
    }

    private Map<String, Map<String, String>> assembleAndCacheCalPersonData(List<DynamicObject> validCalPersonList, CalPayRollTask calPayRollTask, boolean selectAll) {
        Long taskId = calPayRollTask.getCalPayRollTaskId();
        Map calPersonSimpleDataMap = CalResultCoverHelper.assembleCalPersonSimpleDataMap(validCalPersonList, (Long)taskId, (boolean)selectAll);
        String appKey = String.format(Locale.ROOT, "calResultCover_%s", taskId);
        String cacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, this.getView().getPageId());
        ISWCAppCache appCache = SWCAppCache.get((String)appKey);
        appCache.put(cacheKey, (Object)calPersonSimpleDataMap);
        return calPersonSimpleDataMap;
    }
}

