/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.formplugin.web.calpersonlist.ResultCoverEntryGridControl;
import kd.swc.hsbp.common.enums.SWCShowType;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ProrationResultCoverDataViewPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener {
    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        this.createAndReplaceEntryControl();
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs metasArgs) {
        FormShowParameter formShowParam = (FormShowParameter)metasArgs.getSource();
        Long taskId = (Long)formShowParam.getCustomParam("taskId");
        String personPageId = (String)formShowParam.getCustomParam("personPageId");
        int precision = (Integer)formShowParam.getCustomParam("precision");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)formShowParam.getFormId(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)taskId, (String)personPageId);
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)precision, (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)"1", (boolean)true);
        Object columns = entryAp.createControl().get("columns");
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)columns);
        metasArgs.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs eventArgs) {
        MainEntityType newMainType;
        MainEntityType oldMainType = eventArgs.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        CalResultCoverHelper.registerProp((EntryType)((EntryType)newMainType.getAllEntities().get("entryentity")), (Map)salaryItemMap, (String)"1", (Long)this.getTaskId(), (boolean)true);
        try {
            newMainType = (MainEntityType)newMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDBizException((Throwable)e1, new ErrorCode("", e1.getMessage()), new Object[0]);
        }
        eventArgs.setNewEntityType(newMainType);
    }

    public void afterCreateNewData(EventObject eventObject) {
        CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)1, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)true);
        String isView = (String)this.getFormShowParameter().getCustomParam("isView");
        this.getView().getPageCache().put("isView", isView);
    }

    public void onGetControl(OnGetControlArgs args) {
        String key = args.getKey();
        if (SWCStringUtils.equals((String)key, (String)"entryentity")) {
            EntryGrid entryGrid = this.createEntryControl();
            args.setControl((Control)entryGrid);
        } else {
            this.initItemField(args, key);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        FormShowParameter formShowParam = this.getView().getFormShowParameter();
        Long taskId = (Long)formShowParam.getCustomParam("taskId");
        String personPageId = (String)formShowParam.getCustomParam("personPageId");
        String coverType = (String)formShowParam.getCustomParam("coverType");
        int precision = (Integer)formShowParam.getCustomParam("precision");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_calresultcoverlist", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)taskId, (String)personPageId);
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)precision, (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)coverType, (boolean)false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List controlList = ((Container)entryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : controlList) {
            fieldEdit.setView(this.getView());
            entryGrid.getItems().add(fieldEdit);
        }
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)"donothing_refresh")) {
            Integer currentPageIndex = ((EntryGrid)this.getView().getControl("entryentity")).getEntryState().getCurrentPageIndex();
            CalResultCoverHelper.loadGridData((IDataModel)this.getModel(), (int)currentPageIndex, (int)this.getPageRow(), (IPageCache)this.getView().getPageCache(), (String)"entryentity", (IClientViewProxy)this.getClientService(), (boolean)true);
            this.getView().updateView("entryentity");
        }
    }

    private void initItemField(OnGetControlArgs args, String key) {
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        if (salaryItemMap == null) {
            return;
        }
        String itemId = key.substring(4);
        Map itemMap = (Map)salaryItemMap.get(itemId);
        if (itemMap == null || itemMap.size() == 0) {
            return;
        }
        Object field = SWCShowType.DATE.getCode().equals(itemMap.get("datatype")) ? new DateEdit() : (SWCShowType.AMOUNT.getCode().equals(itemMap.get("datatype")) ? new AmountEdit() : (SWCShowType.NUM.getCode().equals(itemMap.get("datatype")) ? new DecimalEdit() : new TextEdit()));
        field.setFieldKey(key);
        field.setEntryKey("entryentity");
        field.setEntryControlKey("entryentity");
        field.setView(this.getView());
        field.setKey(key);
        field.setModel(this.getView().getModel());
        args.setControl((Control)field);
    }

    private int getPageRow() {
        Map settingMap;
        Object pageRows;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        String setting = UserConfigServiceHelper.getSetting((long)RequestContext.get().getCurrUserId(), (String)"entrygridrowconfig_hsas_prorationcoverlist_entryentity");
        if (SWCStringUtils.isNotEmpty((String)setting) && (pageRows = (settingMap = (Map)JSONObject.parseObject((String)setting, Map.class)).get("PageRows")) != null) {
            return Integer.parseInt(pageRows + "");
        }
        return grid.getPageRow();
    }

    protected IClientViewProxy getClientService() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private void createAndReplaceEntryControl() {
        EntryGrid grid = this.createEntryControl();
        Container entryParentAp = (Container)CalResultCoverHelper.findControl((List)((Container)this.getView().getRootControl()).getItems(), (String)"advconchildpanelap");
        List subItems = entryParentAp.getItems();
        int index = CalResultCoverHelper.findControlIndex((List)subItems, (String)"entryentity");
        if (index >= 0) {
            subItems.set(index, grid);
        }
        this.getView().createControlIndex(grid.getItems());
    }

    private EntryGrid createEntryControl() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_prorationcoverlist", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        Map salaryItemMap = CalResultCoverHelper.getCacheSalaryItemMap((Long)this.getTaskId(), (String)this.getPersonPageId());
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)this.getTaskId());
        EntryAp entryAp = CalResultCoverHelper.createEntryAp((int)Integer.parseInt(taskMap.get("precision") + ""), (EntityMetadata)entityMetadata, (Map)salaryItemMap, (String)"1", (boolean)true);
        ResultCoverEntryGridControl grid = new ResultCoverEntryGridControl();
        grid.setEntryKey("entryentity");
        grid.setKey("entryentity");
        grid.setSplitPage(true);
        grid.getItems().clear();
        grid.getItems().addAll(((Container)entryAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex((List)Lists.newArrayList((Object[])new Control[]{grid}));
        grid.endInit();
        return grid;
    }

    private Long getTaskId() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        Long taskId = (Long)formShowParameter.getCustomParam("taskId");
        this.getPageCache().put("taskId", taskId + "");
        int precision = (Integer)formShowParameter.getCustomParam("precision");
        this.getPageCache().put("precision", precision + "");
        String coverType = (String)formShowParameter.getCustomParam("coverType");
        this.getPageCache().put("coverType", coverType);
        return taskId;
    }

    private FormShowParameter getFormShowParameter() {
        return this.getView().getFormShowParameter();
    }

    private String getPersonPageId() {
        FormShowParameter formShowParameter = this.getFormShowParameter();
        String personPageId = (String)formShowParameter.getCustomParam("personPageId");
        this.getPageCache().put("personPageId", personPageId);
        return personPageId;
    }
}

