/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.cal.service.CalResultCoverImportService;
import kd.swc.hsas.business.cal.service.ResultCoverService;
import kd.swc.hsas.business.cal.vo.CalPayRollTask;
import kd.swc.hsas.business.cal.vo.CalPayRollTaskContext;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.CalPayRollTaskMutex;

public class ResultCoverDataViewListPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(ResultCoverDataViewListPlugin.class);
    private static final String KEY_SUMENTITY = "sumentity";
    private static final String KEY_PRORATIONENTITY = "prorationentity";
    private static final String KEY_SEARCH = "searchap";
    private static final String KEY_SEARCH1 = "searchap1";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_EXPORT = "export";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_TABSUM = "tabsum";
    private static final String KEY_TABPRORATION = "tabproration";
    private static final String KEY_SUMCOVERDATALIST = "hsas_sumcoverdatalist";
    private static final String KEY_PRORATIONCOVERLIST = "hsas_prorationcoverlist";
    private static final String CONFIRM_EXPORT_CALLBACK = "confirm_export_callback";
    private static final String CONFIRM_DELETE_CALLBACK = "confirm_delete_callback";
    private static final String VALID_DELETE_PERSON_CACHE_KEY = "valid_delete_person";

    public void initialize() {
        this.getView().addCustomControls(new String[]{KEY_SUMENTITY, KEY_PRORATIONENTITY});
        String tabKey = this.getPageCache().get("currenttab");
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        if (SWCStringUtils.equals((String)"salaryDetailResultPage", (String)pageType)) {
            tabKey = KEY_TABSUM;
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TABPRORATION});
        }
        if (SWCStringUtils.equals((String)"prorationResultDetailPage", (String)pageType)) {
            tabKey = KEY_TABPRORATION;
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TABSUM});
        }
        if (SWCStringUtils.isEmpty((String)tabKey)) {
            tabKey = KEY_TABSUM;
        }
        this.getPageCache().put("currenttab", tabKey);
        this.setSearchVisible(tabKey);
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        Search search1 = (Search)this.getView().getControl(KEY_SEARCH1);
        search1.addEnterListener((SearchEnterListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void search(SearchEnterEvent evt) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String searchText = evt.getText();
        String pageId = this.getPersonPageId();
        CalResultCoverHelper.cacheSearchText((String)searchText, (Long)this.getTaskId(), (String)pageId);
        String subPageId = (String)pageCache.get(pageId, String.class);
        IFormView childView = this.getView().getView(subPageId);
        childView.invokeOperation("donothing_refresh");
        this.getView().sendFormAction(childView);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.getPageCache().put("currenttab", tabKey);
        this.setSearchVisible(tabKey);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        Search search1 = (Search)this.getView().getControl(KEY_SEARCH1);
        search.setSearchKey("");
        search1.setSearchKey("");
        CalResultCoverHelper.cleanCacheSearchText((Long)this.getTaskId(), (String)this.getPersonPageId());
        this.refreshEntity();
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "delete": {
                this.deleteCoverData();
                break;
            }
            case "modify": {
                this.modifyCoverData();
                break;
            }
            case "refresh": {
                this.refreshEntity();
                break;
            }
            case "export": {
                this.doExportData();
                break;
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        IPageCache pageCache = this.getView().getPageCache();
        String enter = pageCache.get("enter");
        if (SWCStringUtils.isEmpty((String)enter)) {
            pageCache.put("enter", "1");
            String tabKey = pageCache.get("currenttab");
            if (SWCStringUtils.isEmpty((String)tabKey)) {
                tabKey = KEY_TABSUM;
                pageCache.put("currenttab", tabKey);
            }
            this.setSearchVisible(tabKey);
            this.initTaskInfo();
            this.initCalPayRollTaskContext();
            this.cachePersonIdAndSalaryItemData(this.getTaskId(), this.getPersonPageId());
            if (SWCStringUtils.equals((String)KEY_TABSUM, (String)tabKey)) {
                this.openCoverDataEntry(KEY_SUMENTITY, KEY_SUMCOVERDATALIST, "2");
            } else {
                this.openCoverDataEntry(KEY_PRORATIONENTITY, KEY_PRORATIONCOVERLIST, "1");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        switch (callBackId) {
            case "confirm_export_callback": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                CalResultCoverImportService service = new CalResultCoverImportService();
                service.exportResultCoverData(taskId, personPageId, this.getView(), new ArrayList(0), this.getCoverType(), true);
                break;
            }
            case "confirm_delete_callback": {
                if (MessageBoxResult.Yes.equals((Object)result)) {
                    if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"2DXPSF5JTISP")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8986\u76d6\u6570\u636e\u201c\u5220\u9664\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResultCoverDataViewListPlugin_11", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String tabKey = this.getPageCache().get("currenttab");
                    String coverType = SWCStringUtils.equals((String)KEY_TABPRORATION, (String)tabKey) ? "1" : "2";
                    SWCPageCache pageCache = new SWCPageCache(this.getView());
                    List validIdList = (List)pageCache.get(VALID_DELETE_PERSON_CACHE_KEY, List.class);
                    List<String> idList = this.getSelectedIds();
                    ArrayList<String> validIdStrList = new ArrayList<String>(10);
                    for (String idstr : idList) {
                        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
                            if (!validIdList.contains(Long.parseLong(idstr))) continue;
                            validIdStrList.add(idstr);
                            continue;
                        }
                        String[] split = idstr.split("#");
                        if (!validIdList.contains(Long.parseLong(split[0]))) continue;
                        validIdStrList.add(idstr);
                    }
                    this.deleteSelectedCoverData(tabKey, validIdStrList, coverType);
                }
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "hsas_calresultcoverlist": {
                this.refreshEntity();
                PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
                break;
            }
        }
    }

    public void pageRelease(EventObject eventObject) {
        Long taskId = this.getTaskId();
        String pageId = this.getPersonPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cachePersonDataKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, pageId);
        String cacheProrationDataKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, pageId);
        String cacheKey = String.format(Locale.ROOT, "salaryItemTransfer_%d_%s", taskId, pageId);
        String cacheKey1 = String.format(Locale.ROOT, "viewprorationcoverdata_%d_%s", taskId, pageId);
        String cacheKey2 = String.format(Locale.ROOT, "viewsumcoverdata_%d_%s", taskId, pageId);
        String cacheKey3 = String.format(Locale.ROOT, "resultcoverdatacount_%d_%s", taskId, pageId);
        String cacheKey4 = String.format(Locale.ROOT, "viewpersonidlist_%d_%s", taskId, pageId);
        String cacheKey5 = String.format(Locale.ROOT, "viewsearchtext_%d_%s", taskId, pageId);
        appCache.remove(cachePersonDataKey);
        appCache.remove(cacheProrationDataKey);
        appCache.remove(cacheKey);
        appCache.remove(cacheKey1);
        appCache.remove(cacheKey2);
        appCache.remove(cacheKey3);
        appCache.remove(cacheKey4);
        appCache.remove(cacheKey5);
        CalResultCoverHelper.cleanCacheSearchText((Long)taskId, (String)pageId);
        PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
    }

    private void setSearchVisible(String tabKey) {
        if (SWCStringUtils.equals((String)KEY_TABSUM, (String)tabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SEARCH1});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SEARCH});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SEARCH1});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SEARCH});
        }
    }

    private void doExportData() {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"4730fc9f000004ae")) {
            return;
        }
        if (!this.checkDataAuth()) {
            return;
        }
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        List<String> idStrList = this.getSelectedIds();
        String coverType = this.getCoverType();
        if (SWCListUtils.isEmpty(idStrList)) {
            int dataSize = this.getDataSize(taskId, personPageId, coverType);
            if (dataSize == 0) {
                String noDataMsg = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ResultCoverDataViewListPlugin_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(noDataMsg);
            } else {
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa{0}\u5f20\u8986\u76d6\u6570\u636e\uff0c\u662f\u5426\u5bfc\u51fa\uff1f", (String)"ResultCoverDataViewListPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]), dataSize);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_EXPORT_CALLBACK, (IFormPlugin)this));
            }
        } else {
            boolean dataAuth = this.checkHasDataAuth(idStrList, coverType, taskId);
            if (!dataAuth) {
                String noDataMsg = ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[\u5bfc\u51fa][\u6838\u7b97\u540d\u5355]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ResultCoverDataViewListPlugin_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(noDataMsg);
            } else {
                CalResultCoverImportService service = new CalResultCoverImportService();
                service.exportResultCoverData(taskId, personPageId, this.getView(), idStrList, coverType, false);
            }
        }
    }

    private boolean checkHasDataAuth(List<String> idStrList, String coverType, Long taskId) {
        List personIds = CalResultCoverHelper.getResultCoverDataPersonIdList((Long)taskId, (String)"4730fc9f000004ae", (String)coverType);
        Iterator<String> iterator = idStrList.iterator();
        while (iterator.hasNext()) {
            Long personId;
            String personIdStr = iterator.next();
            if (SWCStringUtils.equals((String)"2", (String)coverType)) {
                personId = Long.valueOf(personIdStr);
            } else {
                String[] split = personIdStr.split("#");
                personId = Long.valueOf(split[0]);
            }
            if (personIds.contains(personId)) continue;
            iterator.remove();
        }
        return !SWCListUtils.isEmpty(idStrList);
    }

    private boolean checkDataAuth() {
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getView().getFormShowParameter().getParentPageId());
        if (parentViewParameter != null && parentViewParameter.isCancelDataRight()) {
            this.getView().getFormShowParameter().setCancelDataRight(true);
            String msg = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ResultCoverDataViewListPlugin_10", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("1000200"));
            return false;
        }
        return true;
    }

    private int getDataSize(Long taskId, String personPageId, String coverType) {
        int dataSize;
        String searchText = CalResultCoverHelper.getCacheSearchText((Long)taskId, (String)personPageId);
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            List personIds = CalResultCoverHelper.getResultCoverDataPersonIdList((Long)taskId, (String)"4730fc9f000004ae", (String)coverType);
            dataSize = CalResultCoverHelper.getCalPersonDyObjCount((List)personIds, (Long)taskId, (String)searchText);
        } else {
            dataSize = CalResultCoverHelper.getProrationCoverDataCount((Long)taskId, (String)searchText);
        }
        return dataSize;
    }

    private String getCoverType() {
        String tabKey = this.getPageCache().get("currenttab");
        return SWCStringUtils.equals((String)KEY_TABPRORATION, (String)tabKey) ? "1" : "2";
    }

    private void refreshEntity() {
        this.cachePersonIdAndSalaryItemData(this.getTaskId(), this.getPersonPageId());
        String tabKey = this.getPageCache().get("currenttab");
        if (SWCStringUtils.isEmpty((String)tabKey)) {
            tabKey = KEY_TABSUM;
            this.getPageCache().put("currenttab", tabKey);
        }
        if (SWCStringUtils.equals((String)KEY_TABSUM, (String)tabKey)) {
            this.openCoverDataEntry(KEY_SUMENTITY, KEY_SUMCOVERDATALIST, "2");
        } else {
            this.openCoverDataEntry(KEY_PRORATIONENTITY, KEY_PRORATIONCOVERLIST, "1");
        }
    }

    private void cacheProrationCoverData(List<String> selectedIdList, Long taskId, String curPageId) {
        List prorationItemCoverDataList = CalResultCoverHelper.assembleSelectedProrationCoverDataList((Long)taskId, selectedIdList, (boolean)false);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "prorationCoverData_%d_%s", taskId, curPageId);
        appCache.put(cacheKey, (Object)prorationItemCoverDataList);
    }

    private void cachePersonIdAndSalaryItemData(Long taskId, String curPageId) {
        Map itemMap = CalResultCoverHelper.assembleCoverSalaryItemMap((Long)this.getCalRuleVid());
        if (itemMap.size() == 0) {
            return;
        }
        LinkedHashMap<Long, Map> salaryItemMap = new LinkedHashMap<Long, Map>(itemMap.size());
        for (Map.Entry obj : itemMap.entrySet()) {
            Map map = salaryItemMap.computeIfAbsent(Long.parseLong((String)obj.getKey()), single -> new HashMap(2));
            map.put("itemid", obj.getKey());
            map.put("itemname", obj.getValue().toString());
        }
        CalResultCoverHelper.assembleSalaryItemData(salaryItemMap);
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "salaryItemTransfer_%d_%s", taskId, curPageId);
        String personIdCacheKey = String.format(Locale.ROOT, "viewpersonidlist_%d_%s", taskId, curPageId);
        appCache.put(cacheKey, salaryItemMap);
        appCache.put(personIdCacheKey, this.getSelectedPersonList());
    }

    private void cacheSumCoverData(List<String> selectedIdList, Long taskId, String curPageId, boolean isView) {
        Map itemMap = CalResultCoverHelper.assembleCoverSalaryItemMap((Long)this.getCalRuleVid());
        if (itemMap.size() == 0) {
            return;
        }
        LinkedHashMap<Long, Map> salaryItemMap = new LinkedHashMap<Long, Map>(itemMap.size());
        for (Map.Entry obj : itemMap.entrySet()) {
            Map map = salaryItemMap.computeIfAbsent(Long.parseLong((String)obj.getKey()), single -> new HashMap(2));
            map.put("itemid", obj.getKey());
            map.put("itemname", obj.getValue().toString());
        }
        CalResultCoverHelper.assembleSalaryItemData(salaryItemMap);
        List idList = selectedIdList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toList());
        DynamicObject[] calPersons = CalResultCoverHelper.getCalPersonData(idList, (Long)taskId, (boolean)isView, (String)"2DXPU453B4ZK");
        ISWCAppCache appCache = SWCAppCache.get((String)String.format(Locale.ROOT, "calResultCover_%s", taskId));
        String cacheKey = String.format(Locale.ROOT, "salaryItemTransfer_%d_%s", taskId, curPageId);
        appCache.put(cacheKey, salaryItemMap);
        if (calPersons != null && calPersons.length > 0) {
            this.assembleAndCacheCalPersonData(Arrays.asList(calPersons), taskId);
            String personSimpleDataCacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, curPageId);
            Map personSimpleDataMap = (Map)appCache.get(personSimpleDataCacheKey, Map.class);
            appCache.put(personSimpleDataCacheKey, (Object)personSimpleDataMap);
        }
    }

    private Map<String, Map<String, String>> assembleAndCacheCalPersonData(List<DynamicObject> validCalPersonList, Long taskId) {
        Map calPersonSimpleDataMap = CalResultCoverHelper.assembleCalPersonSimpleDataMap(validCalPersonList, (Long)taskId, (boolean)true);
        String appKey = String.format(Locale.ROOT, "calResultCover_%s", taskId);
        String cacheKey = String.format(Locale.ROOT, "personSimpleData_%d_%s", taskId, this.getPersonPageId());
        ISWCAppCache appCache = SWCAppCache.get((String)appKey);
        appCache.put(cacheKey, (Object)calPersonSimpleDataMap);
        return calPersonSimpleDataMap;
    }

    private void openCoverDataEntry(String targetKey, String formId, String coverType) {
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)KEY_SUMCOVERDATALIST);
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)KEY_PRORATIONCOVERLIST);
        FormShowParameter formShow = new FormShowParameter();
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)taskId);
        OpenStyle openStyle = formShow.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(ShowType.InContainer);
        formShow.setFormId(formId);
        formShow.setParentPageId(personPageId);
        formShow.setCustomParam("taskId", (Object)taskId);
        formShow.setCustomParam("precision", (Object)Integer.parseInt(taskMap.get("precision") + ""));
        formShow.setCustomParam("currencyId", (Object)Long.parseLong(taskMap.get("currencyId") + ""));
        formShow.setCustomParam("personPageId", (Object)personPageId);
        formShow.setCustomParam("coverType", (Object)coverType);
        formShow.setCustomParam("isView", (Object)"1");
        this.getView().showForm(formShow);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("personPageId", (Object)personPageId);
        pageCache.put(personPageId, (Object)formShow.getPageId());
    }

    private void modifyCoverData() {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"2DXPSF5JTISP")) {
            return;
        }
        String coverType = this.getCoverType();
        Long taskId = this.getTaskId();
        if (this.checkLock(taskId)) {
            return;
        }
        String pageId = this.getPersonPageId();
        List<String> idStrList = this.getSelectedIds();
        if (SWCListUtils.isEmpty(idStrList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ResultCoverDataViewListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
            return;
        }
        List validIdStrList = CalResultCoverHelper.checkPersonStatus((Long)taskId, idStrList, (String)coverType, (String)"2DXPSF5JTISP");
        if (SWCListUtils.isEmpty((List)validIdStrList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u6838\u7b97\u72b6\u6001\u5747\u4e0d\u5141\u8bb8\u4fee\u6539\u8986\u76d6\u6570\u636e\uff0c\u6216\u65e0\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ResultCoverDataViewListPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
            return;
        }
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            this.cacheProrationCoverData(validIdStrList, taskId, pageId);
        } else {
            this.cacheSumCoverData(validIdStrList, taskId, pageId, false);
        }
        this.openCaLResultCoverView(coverType);
    }

    private void deleteCoverData() {
        if (!SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"2DXPSF5JTISP")) {
            return;
        }
        if (!this.checkDataAuth()) {
            return;
        }
        Long taskId = this.getTaskId();
        if (this.checkLock(taskId)) {
            return;
        }
        String tabKey = this.getPageCache().get("currenttab");
        List<String> idList = this.getSelectedIds();
        if (idList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ResultCoverDataViewListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
            return;
        }
        String coverType = SWCStringUtils.equals((String)KEY_TABPRORATION, (String)tabKey) ? "1" : "2";
        List<Long> personIdList = this.assemblePersonIdList(idList, coverType);
        DynamicObjectCollection calPersonData = CalResultCoverHelper.getCalPersonData(personIdList, (String)"2DXPSF5JTISP");
        Map<String, List<Long>> personCheckMap = this.checkPersonCalStatus(calPersonData, taskId);
        List<Long> validList = personCheckMap.get("validList");
        List<Long> unValidList = personCheckMap.get("unValidList");
        if (validList.size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u7684\u6838\u7b97\u72b6\u6001\u5747\u4e0d\u5141\u8bb8\u5220\u9664\u8986\u76d6\u6570\u636e\uff0c\u6216\u65e0\u6570\u636e\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"ResultCoverDataViewListPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(this.getTaskId()), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
            return;
        }
        int totalCnt = idList.size();
        int unValidCnt = 0;
        if (SWCStringUtils.equals((String)"2", (String)coverType)) {
            unValidCnt = unValidList.size();
        } else {
            for (String idstr : idList) {
                String[] split = idstr.split("#");
                String personId = split[0];
                if (!SWCStringUtils.isNotEmpty((String)personId) || !unValidList.contains(Long.parseLong(personId))) continue;
                ++unValidCnt;
            }
        }
        String msg = unValidList.size() > 0 ? MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u4e2d{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d{1}\u6761\u6570\u636e\u56e0\u6838\u7b97\u72b6\u6001\u4e0d\u7b26\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\u5220\u9664\u5269\u4f59\u6570\u636e\uff1f", (String)"ResultCoverDataViewListPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalCnt, unValidCnt) : MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u4e2d{0}\u6761\u6570\u636e\uff0c\u5220\u9664\u540e\u6570\u636e\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"ResultCoverDataViewListPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), totalCnt);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(VALID_DELETE_PERSON_CACHE_KEY, validList);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DELETE_CALLBACK, (IFormPlugin)this));
    }

    private boolean checkLock(Long taskId) {
        boolean check = CalResultCoverHelper.checkHasDoingTask((Long)taskId);
        if (check) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u4efb\u52a1\u5b58\u5728\u8ba1\u7b97\u4e2d\u6216\u8ba1\u7b97\u56de\u6eda\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u7b49\u5f85\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"CalPersonResultCoverOperateList_25", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        Map taskInfo = CalResultCoverHelper.assembleTaskInfo((Long)taskId);
        String taskNumber = (String)taskInfo.get("taskNumber");
        CalPayRollTaskMutex lock = PayrollTaskHelper.tryLock((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_CAL_RESULT_COVER.getOperationKey());
        if (lock != null) {
            String msg = ResManager.loadKDString((String)"\u7f16\u7801\u4e3a{0}\u7684\u6838\u7b97\u4efb\u52a1\uff1a\u6b63\u5728{1}\u4e2d\uff0c\u65e0\u6cd5\u8ba1\u7b97\u7ed3\u679c\u8986\u76d6\u3002", (String)"ResultCoverDataViewListPlugin_12", (String)"swc-hsas-formplugin", (Object[])new Object[]{taskNumber, lock.getCalPersonOperationEnum().getOperationName()});
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    private void deleteSelectedCoverData(String tabKey, List<String> idList, String coverType) {
        Long taskId = this.getTaskId();
        String personPageId = this.getPersonPageId();
        ResultCoverService resultCoverService = CalResultCoverHelper.getResultCoverService((String)coverType);
        resultCoverService.saveOpLogData(idList, taskId, personPageId);
        if (SWCStringUtils.equals((String)KEY_TABPRORATION, (String)tabKey)) {
            CalResultCoverHelper.deleteProrationCoverDataByKeys(idList);
        } else {
            CalResultCoverHelper.deleteSumCoverDataByIds(idList);
        }
        Map personIdListCalblockMap = CalResultCoverHelper.assembleNeedCalBackPersonId((Long)taskId, idList, (String)coverType);
        if (personIdListCalblockMap.size() > 0) {
            ArrayList allIdList = new ArrayList(10);
            personIdListCalblockMap.values().forEach(allIdList::addAll);
            CalResultCoverHelper.doCalBack((Long)taskId, allIdList);
        }
        String successMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ResultCoverDataViewListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(successMsg);
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "ResultCoverDataViewListPlugin_1", "swc-hsas-formplugin");
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5220\u9664\u7ed3\u679c\u8986\u76d6\u6570\u636e", "ResultCoverDataViewListPlugin_2", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)KEY_DELETE, (MultiLangEnumBridge)opNameBridge, null, (MultiLangEnumBridge)opDescBridge, null);
        CalResultCoverHelper.removeResultCoverDataCountCache((Long)taskId, (String)personPageId);
        this.refreshEntity();
    }

    private Map<String, List<Long>> checkPersonCalStatus(DynamicObjectCollection calPersonData, Long taskId) {
        HashMap<String, List<Long>> checkMap = new HashMap<String, List<Long>>(16);
        ArrayList<Long> validList = new ArrayList<Long>(10);
        ArrayList<Long> unValidList = new ArrayList<Long>(10);
        Boolean taxCalEnable = TaxCalServiceHelper.getTaxCalEnableStatusByTaskId((Long)this.getTaskId());
        List<String> taxOnValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.PUSHTAX_ERROR.getCode(), CalStateEnum.TAXCAL_ERROR.getCode(), CalStateEnum.PULLTAX_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List<String> taxOffValidCalStatus = Arrays.asList(CalStateEnum.UNCAL.getCode(), CalStateEnum.PARTIAL_CALED.getCode(), CalStateEnum.ALL_CALED.getCode(), CalStateEnum.PRECAL_ERROR.getCode(), CalStateEnum.AFTERCAL_ERROR.getCode(), CalStateEnum.CANCELCAL_ERROR.getCode());
        List personIdList = calPersonData.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        Map declareStatusMap = CalResultCoverHelper.getCalPersonTaxDeclareStatus((Long)taskId, personIdList);
        for (DynamicObject personObj : calPersonData) {
            long personId = personObj.getLong("id");
            String calStatus = personObj.getString("calstatus");
            String declareStatus = (String)declareStatusMap.get(personId);
            if (SWCStringUtils.equals((String)"1", (String)declareStatus)) {
                unValidList.add(personId);
                continue;
            }
            if (taxCalEnable.booleanValue()) {
                if (taxOnValidCalStatus.contains(calStatus)) {
                    validList.add(personId);
                    continue;
                }
                unValidList.add(personId);
                continue;
            }
            if (taxOffValidCalStatus.contains(calStatus)) {
                validList.add(personId);
                continue;
            }
            unValidList.add(personId);
        }
        checkMap.put("validList", validList);
        checkMap.put("unValidList", unValidList);
        return checkMap;
    }

    private List<Long> assemblePersonIdList(List<String> idList, String coverType) {
        Set<Object> personIdSet = new HashSet(16);
        if (SWCStringUtils.equals((String)"1", (String)coverType)) {
            for (String idStr : idList) {
                String[] split = idStr.split("#");
                personIdSet.add(Long.valueOf(split[0]));
            }
        } else {
            personIdSet = idList.stream().map(single -> Long.valueOf(single)).collect(Collectors.toSet());
        }
        return new ArrayList<Long>(personIdSet);
    }

    private List<String> getSelectedIds() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String subPageId = (String)pageCache.get(this.getPersonPageId(), String.class);
        EntryGrid entryGrid = (EntryGrid)this.getView().getView(subPageId).getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> idList = new ArrayList<String>(10);
        if (selectRows == null || selectRows.length == 0) {
            return idList;
        }
        DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
        int pageRows = entryGrid.getPageRow();
        Integer pageIndex = entryGrid.getEntryState().getCurrentPageIndex();
        int startRowIndex = (pageIndex - 1) * pageRows;
        logger.info("startRowIndex:{},pageRows:{},dataEntitys.length:{},selectRows:{}", new Object[]{startRowIndex, pageRows, dataEntitys.length, selectRows});
        for (int row : selectRows) {
            int index = row - startRowIndex;
            idList.add(dataEntitys[index].getString("idstr"));
        }
        return idList;
    }

    private void openCaLResultCoverView(String type) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calresultcoverlist");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calresultcoverlist"));
        Long taskId = this.getTaskId();
        Map taskInfo = CalResultCoverHelper.assembleTaskInfo((Long)taskId);
        String pageId = this.getPersonPageId();
        Map taskMap = CalResultCoverHelper.getTaskCurrencyPrecision((Long)taskId);
        showParameter.setCustomParam("taskId", (Object)taskId);
        showParameter.setCustomParam("precision", (Object)Integer.parseInt(taskMap.get("precision") + ""));
        showParameter.setCustomParam("currencyId", (Object)Long.parseLong(taskMap.get("currencyId") + ""));
        showParameter.setCustomParam("personPageId", (Object)pageId);
        showParameter.setCustomParam("coverType", (Object)type);
        showParameter.setCustomParam("taskName", taskInfo.get("taskName"));
        showParameter.setCustomParam("periodName", taskInfo.get("payrollDate"));
        showParameter.setCustomParam("source", (Object)"2");
        this.getView().showForm(showParameter);
    }

    private Long getTaskId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("taskId");
    }

    private Long getCalRuleVid() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("calRuleVid");
    }

    private String getPersonPageId() {
        return this.getView().getPageId();
    }

    private List<Long> getSelectedPersonList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (List)formShowParameter.getCustomParam("selectedPersonList");
    }

    private void initTaskInfo() {
        Map taskInfo = CalResultCoverHelper.assembleTaskInfo((Long)this.getTaskId());
        Label taskName = (Label)this.getView().getControl("caltasknamevalue");
        taskName.setText((String)taskInfo.get("taskName"));
        UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)((String)taskInfo.get("taskName")));
        Label taskType = (Label)this.getView().getControl("caltasktypevalue");
        taskType.setText(this.getTaskTypeName((String)taskInfo.get("taskType")));
        Label groupName = (Label)this.getView().getControl("payrollgroupvalue");
        groupName.setText((String)taskInfo.get("payrollGroupName"));
        Label payrollScene = (Label)this.getView().getControl("calscenevalue");
        payrollScene.setText((String)taskInfo.get("payrollScene"));
        Label payrollDate = (Label)this.getView().getControl("calperiodvalue");
        String msg = ResManager.loadKDString((String)"\u7b2c{0}\u6b21", (String)"CalResultCoverListViewPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        payrollDate.setText((String)taskInfo.get("payrollDate") + "  " + MessageFormat.format(msg, taskInfo.get("calCount")));
    }

    private void initCalPayRollTaskContext() {
        CalPayRollTaskContext context = new CalPayRollTaskContext();
        ArrayList<CalPayRollTask> taskList = new ArrayList<CalPayRollTask>(1);
        CalPayRollTask task = new CalPayRollTask();
        task.setOperationParam(new HashMap(5));
        task.setCalPayRollTaskId(this.getTaskId());
        taskList.add(task);
        context.setValidDatas(taskList);
        this.getView().getPageCache().put("calPayRollTaskContext", SerializationUtils.toJsonString((Object)context));
    }

    private String getTaskTypeName(String type) {
        String taskTypeName = SWCStringUtils.equals((String)"0", (String)type) ? ResManager.loadKDString((String)"\u5e38\u89c4\u85aa\u8d44\u6838\u7b97", (String)"CalPersonResultCoverOperateList_14", (String)"swc-hsas-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8ffd\u52a0\u85aa\u8d44\u6838\u7b97", (String)"CalPersonResultCoverOperateList_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        return taskTypeName;
    }
}

