/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calpersonlist;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ResultCoverOpLogListPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Map<String, String> tabKeyMap = Maps.newHashMapWithExpectedSize((int)2);
    private static final Map<String, String> coverTypeMap = Maps.newHashMapWithExpectedSize((int)2);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pageType");
        String tabKey = "tabsum";
        if (SWCStringUtils.equals((String)"salaryDetailResultPage", (String)pageType)) {
            tabKey = "tabsum";
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabproration"});
        }
        if (SWCStringUtils.equals((String)"prorationResultDetailPage", (String)pageType)) {
            tabKey = "tabproration";
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabsum"});
        }
        tab.activeTab(tabKey);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String coverType = tabKeyMap.get(tabKey);
        String targetKey = coverTypeMap.get(coverType);
        if (!this.checkDataAuth()) {
            return;
        }
        this.showLogListView(coverType, targetKey);
    }

    private boolean checkDataAuth() {
        FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getView().getFormShowParameter().getParentPageId());
        if (parentViewParameter != null && parentViewParameter.isCancelDataRight()) {
            this.getView().getFormShowParameter().setCancelDataRight(true);
            String msg = ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ResultCoverOpLogListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("1000200"));
            return false;
        }
        return true;
    }

    private void showLogListView(String coverType, String targetKey) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hsas_resultcoveroplog");
        showParameter.setCustomParam("coverType", (Object)coverType);
        showParameter.setCustomParam("taskId", (Object)this.getTaskId());
        QFilter filter = new QFilter("caltask.id", "=", (Object)this.getTaskId());
        filter.and("covertype", "=", (Object)coverType);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setTargetKey(targetKey);
        openStyle.setShowType(ShowType.InContainer);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u65e5\u5fd7", (String)"ResultCoverOpLogListPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
        IFormView listView = this.getView().getView(showParameter.getPageId());
        if (null != listView) {
            this.getView().sendFormAction(listView);
        }
    }

    private Long getTaskId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (Long)formShowParameter.getCustomParam("taskId");
    }

    static {
        tabKeyMap.put("tabsum", "2");
        tabKeyMap.put("tabproration", "1");
        coverTypeMap.put("2", "sumflex");
        coverTypeMap.put("1", "prorationflex");
    }
}

