/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalPlatformPlugin
extends GridContainerPlugin
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_CALPERIOD = "calperiod";
    private static final String KEY_CALPERIODTYPE = "calperiodtype";
    private static final String KEY_TABTYPE = "tabtype";
    private static final String KEY_DEFAULTCONFIG = "defaultconfig";
    private static final String KEY_BTNOK = "btn_ok";
    private static final String KEY_REFRESH = "refresh";
    private static final String KEY_BTNSALARYCALENDAR = "btn_salarycalendar";
    private static final String KEY_BTNSTATUSTRACK = "btn_statustrack";
    private static final String KEY_BTNRESULTANALYSIS = "btn_resultanalysis";
    private static final String KEY_CALENDAR_FLEX = "calendarflex";
    private static final Log logger = LogFactory.getLog(CalPlatformPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = this.getView().getPageCache().get(KEY_TABTYPE);
        if (!StringUtils.isEmpty((CharSequence)currentTab)) {
            this.setUserData(currentTab);
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calplatformscheme");
        QFilter userFilter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject[] schemes = helper.query("payrollgroup.id,isshow,tabtype,payrollscene.id,calperiodscheme,creator.id,calperiodtype.id", new QFilter[]{userFilter});
        if (schemes == null || schemes.length == 0) {
            this.dealPageButton(tab, KEY_BTNSALARYCALENDAR);
        } else {
            Set tabTypes = Arrays.stream(schemes).filter(scheme -> !scheme.getBoolean("isshow")).map(dy -> dy.getInt(KEY_TABTYPE)).collect(Collectors.toSet());
            for (Integer tabType : tabTypes) {
                int btnNum = tabType - 1;
                if (btnNum == 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNSALARYCALENDAR});
                    continue;
                }
                if (btnNum == 1) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNSTATUSTRACK});
                    continue;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNRESULTANALYSIS});
            }
            int activePage = 0;
            for (int i = 0; i < 3; ++i) {
                if (tabTypes.contains(i + 1)) continue;
                activePage = i;
                break;
            }
            if (activePage == 0) {
                this.dealPageButton(tab, KEY_BTNSALARYCALENDAR);
            } else if (activePage == 1) {
                this.dealPageButton(tab, KEY_BTNSTATUSTRACK);
            } else {
                this.dealPageButton(tab, KEY_BTNRESULTANALYSIS);
            }
        }
    }

    public void tabSelected(TabSelectEvent event) {
        super.tabSelected(event);
        String tabKey = event.getTabKey();
        this.setUserData(tabKey);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_DEFAULTCONFIG, KEY_BTNOK, KEY_REFRESH, KEY_BTNSALARYCALENDAR, KEY_BTNSTATUSTRACK, KEY_BTNRESULTANALYSIS});
        BasedataEdit payrollgroup = (BasedataEdit)this.getControl(KEY_PAYROLLGROUP);
        BasedataEdit payrollscene = (BasedataEdit)this.getControl(KEY_PAYROLLSCENE);
        BasedataEdit calperiod = (BasedataEdit)this.getControl(KEY_CALPERIOD);
        payrollgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        payrollscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        calperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        switch (key = beforeF7SelectEvent.getProperty().getName()) {
            case "payrollgroup": {
                this.addGroupOrSceneF7Filter(beforeF7SelectEvent, true);
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                beforeF7SelectEvent.addCustomQFilter(statusFilter);
                beforeF7SelectEvent.addCustomQFilter(enableFilter);
                logger.info("payrollgrp_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
            case "payrollscene": {
                DynamicObject payrollgroup = this.getModel().getDataEntity().getDynamicObject(KEY_PAYROLLGROUP);
                if (payrollgroup == null) {
                    beforeF7SelectEvent.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u7684\u503c\u3002", (String)"CalPlatformHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
                    return;
                }
                IFormView view = this.getView();
                String method = beforeF7SelectEvent.getSourceMethod();
                if ("setItemByNumber".equals(method) || "setItemByIdFromClient".equals(method)) break;
                ListShowParameter param = CalPlatformHelper.beforeCalRuleSelect((BeforeF7SelectEvent)beforeF7SelectEvent, (DynamicObject)payrollgroup, (IFormView)view);
                if (param != null) {
                    param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_payrollscene"));
                }
                this.addGroupOrSceneF7Filter(beforeF7SelectEvent, false);
                logger.info("payrollscene_f7filter:{}", (Object)beforeF7SelectEvent.getCustomQFilters().toString());
                break;
            }
            case "calperiod": {
                this.beforeCalPeriodSelect(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void addGroupOrSceneF7Filter(BeforeF7SelectEvent beforeF7SelectEvent, boolean isGroup) {
        ArrayList qFilters = new ArrayList(10);
        String tabStr = this.getView().getPageCache().get(KEY_TABTYPE);
        CalPlatformHelper.addGroupOrSceneAuthFilter(qFilters, (String)tabStr, (boolean)isGroup);
        for (QFilter qFilter : qFilters) {
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    private void setUserData(String tabKey) {
        int tabType = "tabpageap".equals(tabKey) ? 1 : ("tabpageap1".equals(tabKey) ? 2 : 3);
        this.getView().getPageCache().put(KEY_TABTYPE, String.valueOf(tabType));
        this.loadUserScheme(tabType);
        String errMsg = this.checkViewAuth(tabType);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return;
        }
        if (tabType == 1) {
            this.showCalendarPage();
        }
        this.getView().updateView();
    }

    private void loadUserScheme(int tabType) {
        QFilter tabFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calplatformscheme");
        QFilter userFilter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObject scheme = helper.queryOne("payrollgroup.id,payrollscene.id,calperiodscheme,creator.id,calperiodtype.id", new QFilter[]{userFilter, tabFilter = new QFilter(KEY_TABTYPE, "=", (Object)String.valueOf(tabType))});
        if (scheme != null) {
            if (scheme.getLong("payrollgroup.id") == 0L || scheme.getLong("payrollscene.id") == 0L) {
                this.setDefaultGroupAndSceneValue(tabType);
            } else {
                this.setGroupAndSceneValue(scheme.getLong("payrollgroup.id"), scheme.getLong("payrollscene.id"), scheme.getLong("calperiodtype.id"), tabType, scheme.getString("calperiodscheme"));
            }
        } else {
            this.setDefaultGroupAndSceneValue(tabType);
        }
    }

    private void setGroupAndSceneValue(Long payrollGroupId, Long payrollSceneId, Long periodTypeId, int tabType, String periodScheme) {
        if (payrollSceneId != null) {
            if (!this.checkCurrentPayrollSceneAuth(payrollSceneId, tabType)) {
                this.getModel().setValue(KEY_PAYROLLSCENE, null);
                this.getModel().setValue(KEY_CALPERIODTYPE, null);
            } else {
                this.getModel().setValue(KEY_PAYROLLSCENE, (Object)payrollSceneId);
                if (SWCStringUtils.isNotEmpty((String)periodScheme)) {
                    this.setSchemeValue(periodTypeId, periodScheme);
                } else {
                    this.getModel().setValue(KEY_CALPERIOD, null);
                }
            }
        }
        if (payrollGroupId != null) {
            if (!this.checkCurrentPayrollGroupAuth(payrollGroupId, tabType)) {
                this.getModel().setValue(KEY_PAYROLLGROUP, null);
                this.getModel().setValue(KEY_PAYROLLSCENE, null);
            } else {
                this.getModel().setValue(KEY_PAYROLLGROUP, (Object)payrollGroupId);
                this.getModel().setValue(KEY_PAYROLLSCENE, (Object)payrollSceneId);
            }
        }
    }

    private void setDefaultGroupAndSceneValue(int tabType) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject payrollGroup = dataEntity.getDynamicObject(KEY_PAYROLLGROUP);
        DynamicObject payrollScene = dataEntity.getDynamicObject(KEY_PAYROLLSCENE);
        if (payrollGroup != null) {
            this.setGroupAndSceneValue(payrollGroup.getLong("id"), null, null, tabType, null);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_PAYROLLGROUP, null);
            this.getModel().setValue(KEY_PAYROLLSCENE, null);
            this.getModel().endInit();
        }
        if (payrollScene != null) {
            this.setGroupAndSceneValue(null, payrollScene.getLong("id"), payrollScene.getLong("periodtype.id"), tabType, null);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_PAYROLLSCENE, null);
            this.getModel().endInit();
        }
    }

    private boolean checkCurrentPayrollGroupAuth(long groupId, int tabType) {
        ArrayList groupFilter = new ArrayList(10);
        CalPlatformHelper.addGroupOrSceneAuthFilter(groupFilter, (String)String.valueOf(tabType), (boolean)true);
        SWCDataServiceHelper groupHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        DynamicObjectCollection groupObjs = groupHelper.queryOriginalCollection("id", groupFilter.toArray(new QFilter[groupFilter.size()]));
        if (SWCListUtils.isEmpty((List)groupObjs)) {
            return false;
        }
        List groupIdList = groupObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        return groupIdList.contains(groupId);
    }

    private boolean checkCurrentPayrollSceneAuth(long sceneId, int tabType) {
        ArrayList sceneFilter = new ArrayList(10);
        CalPlatformHelper.addGroupOrSceneAuthFilter(sceneFilter, (String)String.valueOf(tabType), (boolean)false);
        SWCDataServiceHelper sceneHelper = new SWCDataServiceHelper("hsas_payrollscene");
        DynamicObjectCollection sceneObjs = sceneHelper.queryOriginalCollection("id", sceneFilter.toArray(new QFilter[sceneFilter.size()]));
        if (SWCListUtils.isEmpty((List)sceneObjs)) {
            return false;
        }
        List groupIdList = sceneObjs.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        return groupIdList.contains(sceneId);
    }

    private void beforeCalPeriodSelect(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject payrollScene = this.getModel().getDataEntity().getDynamicObject(KEY_PAYROLLSCENE);
        if (payrollScene == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u548c\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u7684\u503c\u3002", (String)"CalPlatformPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long periodTypeId = payrollScene.getLong("periodtype.id");
        String payrollSceneName = payrollScene.getString("periodtype.name");
        beforeF7SelectEvent.addCustomQFilter(new QFilter("periodtypeid", "in", (Object)periodTypeId));
        this.getView().getPageCache().put("periodtypename", payrollSceneName);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tabStr = this.getView().getPageCache().get(KEY_TABTYPE);
        int tabType = StringUtils.isEmpty((CharSequence)tabStr) ? 1 : Integer.parseInt(tabStr);
        switch (key) {
            case "payrollgroup": {
                this.getModel().beginInit();
                this.getModel().setValue(KEY_PAYROLLSCENE, null);
                this.getModel().setValue(KEY_CALPERIOD, null);
                this.getModel().endInit();
                this.getView().updateView(KEY_PAYROLLSCENE);
                this.getView().updateView(KEY_CALPERIOD);
                break;
            }
            case "payrollscene": {
                DynamicObject scene = dataEntity.getDynamicObject(KEY_PAYROLLSCENE);
                if (scene != null) {
                    SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
                    DynamicObject sceneObj = helper.queryOne("id,periodtype.id", scene.get("id"));
                    helper = new SWCDataServiceHelper("hsas_calplatformscheme");
                    QFilter userFilter = new QFilter("creator.id", "=", (Object)RequestContext.get().getCurrUserId());
                    QFilter tabFilter = new QFilter(KEY_TABTYPE, "=", (Object)String.valueOf(tabType));
                    DynamicObject scheme = helper.queryOne("payrollgroup.id,payrollscene.id,calperiodscheme,creator.id,calperiodtype.id", new QFilter[]{userFilter, tabFilter});
                    if (!SWCObjectUtils.isEmpty((Object)sceneObj) && scheme != null) {
                        this.setGroupAndSceneValue(null, sceneObj.getLong("id"), sceneObj.getLong("periodtype.id"), tabType, scheme.getString("calperiodscheme"));
                        break;
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(KEY_CALPERIOD, null);
                    this.getModel().endInit();
                    this.getView().updateView(KEY_CALPERIOD);
                    break;
                }
                this.getModel().beginInit();
                this.getModel().setValue(KEY_CALPERIOD, null);
                this.getModel().endInit();
                this.getView().updateView(KEY_CALPERIOD);
                break;
            }
            case "calperiod": {
                this.getView().getPageCache().remove("personGroup");
                this.getView().getPageCache().remove("isContainTempTask");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        String key = ((Control)evt.getSource()).getKey();
        String tabStr = this.getView().getPageCache().get(KEY_TABTYPE);
        int tabType = StringUtils.isEmpty((CharSequence)tabStr) ? 1 : Integer.parseInt(tabStr);
        switch (key) {
            case "defaultconfig": {
                BaseShowParameter showParameter = new BaseShowParameter();
                showParameter.setFormId("hsas_calplatformscheme");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "hsas_calplatformscheme"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "btn_ok": 
            case "refresh": {
                DynamicObject payrollgroup = this.getModel().getDataEntity().getDynamicObject(KEY_PAYROLLGROUP);
                DynamicObject payRollScene = this.getModel().getDataEntity().getDynamicObject(KEY_PAYROLLSCENE);
                DynamicObject calperiod = this.getModel().getDataEntity().getDynamicObject(KEY_CALPERIOD);
                String errMsg = this.checkViewAuth(tabType);
                if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                    this.getView().showErrorNotification(errMsg);
                    return;
                }
                if (tabType != 1) {
                    if (payrollgroup == null || payRollScene == null || calperiod == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u4e09\u4e2a\u7b5b\u9009\u6761\u4ef6\u90fd\u5df2\u8f93\u5165\u503c\u3002", (String)"CalPlatformPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if (payrollgroup == null || payRollScene == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u548c\u201c\u85aa\u8d44\u6838\u7b97\u573a\u666f\u201d\u5747\u5df2\u586b\u5199\u3002", (String)"CalPlatformPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().updateView();
                this.showCalendarPage();
                break;
            }
            case "btn_salarycalendar": {
                this.dealPageButton(tab, KEY_BTNSALARYCALENDAR);
                break;
            }
            case "btn_statustrack": {
                this.dealPageButton(tab, KEY_BTNSTATUSTRACK);
                break;
            }
            case "btn_resultanalysis": {
                this.dealPageButton(tab, KEY_BTNRESULTANALYSIS);
                break;
            }
        }
    }

    private String checkViewAuth(int tabType) {
        String errMsg = "";
        Long currUserId = RequestContext.get().getCurrUserId();
        String viewId = "47150e89000000ac";
        if (tabType == 1) {
            boolean flag = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"hsas_payschedule", (String)viewId);
            if (!flag) {
                errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u65e5\u7a0b\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"CalPlatformPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
        } else {
            boolean flag = SWCPermissionServiceHelper.hasPerm((long)currUserId, (String)"hsas_calpayrolltask", (String)viewId);
            if (!flag) {
                errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u85aa\u8d44\u6838\u7b97\u4efb\u52a1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"CalPlatformPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            }
        }
        return errMsg;
    }

    private void dealPageButton(Tab tab, String btnName) {
        switch (btnName) {
            case "btn_salarycalendar": {
                tab.activeTab("tabpageap");
                this.setLabelColor(KEY_BTNSALARYCALENDAR, "#5582F3", "#FFFFFF");
                this.setLabelColor(KEY_BTNSTATUSTRACK, "#FFFFFF", "#666666");
                this.setLabelColor(KEY_BTNRESULTANALYSIS, "#FFFFFF", "#666666");
                break;
            }
            case "btn_statustrack": {
                tab.activeTab("tabpageap1");
                this.setLabelColor(KEY_BTNSALARYCALENDAR, "#FFFFFF", "#666666");
                this.setLabelColor(KEY_BTNSTATUSTRACK, "#5582F3", "#FFFFFF");
                this.setLabelColor(KEY_BTNRESULTANALYSIS, "#FFFFFF", "#666666");
                break;
            }
            case "btn_resultanalysis": {
                tab.activeTab("tabpageap2");
                this.setLabelColor(KEY_BTNSALARYCALENDAR, "#FFFFFF", "#666666");
                this.setLabelColor(KEY_BTNSTATUSTRACK, "#FFFFFF", "#666666");
                this.setLabelColor(KEY_BTNRESULTANALYSIS, "#5582F3", "#FFFFFF");
                break;
            }
        }
    }

    private void setLabelColor(String label, String backColor, String foreColor) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("bc", backColor);
        ctrl.put("fc", foreColor);
        this.getView().updateControlMetadata(label, ctrl);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "hsas_payrollscene": {
                Object returnData1 = closedCallBackEvent.getReturnData();
                if (!(returnData1 instanceof ListSelectedRowCollection)) break;
                ListSelectedRow listSelectedRow = ((ListSelectedRowCollection)returnData1).get(0);
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
                DynamicObject calRuleHelperDy = helper.queryOne("id,calrule.id,periodtype.id", listSelectedRow.getPrimaryKeyValue());
                this.getModel().setValue(KEY_PAYROLLSCENE, calRuleHelperDy.get("id"));
                this.getModel().setValue(KEY_CALPERIODTYPE, calRuleHelperDy.get("periodtype.id"));
                break;
            }
        }
    }

    private void setSchemeValue(long periodTypeId, String calperiodscheme) {
        QFilter dateFilter = null;
        String orderBy = null;
        Date now = SWCDateTimeUtils.getTodayDateWithoutTime();
        switch (calperiodscheme) {
            case "pre": {
                dateFilter = new QFilter("enddate", "<", (Object)now);
                orderBy = "enddate desc";
                break;
            }
            case "now": {
                dateFilter = new QFilter("startdate", "<=", (Object)now).and(new QFilter("enddate", ">=", (Object)now));
                orderBy = "startdate asc";
                break;
            }
            case "next": {
                dateFilter = new QFilter("startdate", ">", (Object)now);
                orderBy = "startdate asc";
                break;
            }
        }
        if (!SWCStringUtils.isEmpty((String)calperiodscheme)) {
            this.getModel().setValue(KEY_CALPERIODTYPE, (Object)periodTypeId);
            SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
            DynamicObject period = periodHelper.queryOne("id", new QFilter[]{new QFilter("periodtypeid", "=", (Object)periodTypeId), dateFilter}, orderBy);
            if (period != null) {
                this.getModel().setValue(KEY_CALPERIOD, (Object)period.getLong("id"));
            } else {
                this.getModel().setValue(KEY_CALPERIOD, null);
            }
        }
    }

    private void showCalendarPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(KEY_CALENDAR_FLEX);
        showParameter.setFormId("hsas_salarycalendar");
        showParameter.setCustomParam("isCalPlatform", (Object)Boolean.TRUE);
        this.getView().showForm(showParameter);
    }
}

