/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calpayrolltask.CalPayrollTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalTaskCardPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String KEY_STATUSAP = "statusap";
    public static final String KEY_CALTASKNAME = "caltaskname";
    public static final String KEY_CALPERIODNAME = "calperiodname";
    public static final String KEY_CALCOUNT = "calcount";
    public static final String KEY_TASKSTATUS = "taskstatus";
    public static final String KEY_TASKTYPE = "tasktype";
    public static final String KEY_CALPERSONCOUNT = "calpersoncount";
    public static final String KEY_PAYROLLSCENE = "payrollscene";
    public static final String KEY_CALRULEPIC = "calrulepic";
    public static final String KEY_TIME = "time";
    public static final String KEY_TEMPIC = "tempic";
    public static final String KEY_REFRESH = "refresh";
    private static final String KEY_CALSTATUS = "calstatus";
    private static Map<String, String> statusLangMap;
    private static final Log LOGGER;

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{KEY_CALTASKNAME, KEY_CALPERSONCOUNT, KEY_PAYROLLSCENE, KEY_CALRULEPIC, KEY_REFRESH});
    }

    public void afterBindData(EventObject eventObject) {
        CalTaskCardPlugin.setStatusMap();
        this.refreshPage();
    }

    private void refreshPage() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        String followStatus = (String)this.getView().getFormShowParameter().getCustomParam("followstatus");
        List statusList = JSON.parseArray((String)followStatus, String.class);
        HashMap<String, List> statusMap = new HashMap<String, List>(16);
        if (statusList != null && statusList.size() > 0) {
            for (String status : statusList) {
                String[] split = status.split("-");
                List list = statusMap.computeIfAbsent(split[0], val -> new ArrayList(10));
                list.add(split[1]);
            }
        }
        LOGGER.info("followStatus :{}", (Object)followStatus);
        LOGGER.info("statusList :{}", (Object)statusList);
        LOGGER.info("statusLangMap :{}", statusLangMap);
        HashMap<String, Integer> statusCountMap = new HashMap<String, Integer>(16);
        List<QFilter> permFilter = this.getPermFilter();
        for (Map.Entry entry : statusMap.entrySet()) {
            QFilter filter = new QFilter("caltask.id", "=", (Object)taskId);
            filter.and(new QFilter((String)entry.getKey(), "in", entry.getValue()));
            if (permFilter != null && permFilter.size() > 0) {
                permFilter.stream().forEach(perm -> filter.and(perm));
            }
            SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
            DataSet dataSet = calPersonHelper.queryDataSet(((Object)((Object)this)).getClass().getName(), (String)entry.getKey(), new QFilter[]{filter, new QFilter("calmainid", "=", (Object)0L)});
            DataSet rows = dataSet.groupBy(new String[]{(String)entry.getKey()}).count().finish();
            for (Row rs : rows) {
                String statusType = rs.getString((String)entry.getKey());
                int count = rs.getInteger("count");
                statusCountMap.put((String)entry.getKey() + "-" + statusType, count);
            }
        }
        SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject dynamicObject = taskHelper.queryOne("number,name,period,calcount,startdate,enddate,calpersoncount,taskstatus,createtime,calrule.name,payrollscenev.name,tasktype", (Object)taskId);
        if (dynamicObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"CalTaskCardPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)taskId);
        if (permFilter != null && permFilter.size() > 0) {
            permFilter.stream().forEach(perm -> calPersonFilter.and(perm));
        }
        calPersonFilter.and(new QFilter("calmainid", "=", (Object)0L));
        String calpersonCount = String.valueOf(calPersonHelper.count(calPersonFilter.toArray()));
        this.setLabelText(KEY_CALTASKNAME, dynamicObject.getString("name"));
        this.setLabelText(KEY_CALPERIODNAME, dynamicObject.getString("period.name"));
        this.setLabelText(KEY_CALCOUNT, dynamicObject.getString(KEY_CALCOUNT));
        this.setLabelText(KEY_TASKSTATUS, CalPayrollTaskStateEnum.getDesc((String)dynamicObject.getString(KEY_TASKSTATUS)));
        this.setLabelStatusColor(KEY_TASKSTATUS, dynamicObject.getString(KEY_TASKSTATUS));
        String taskTypeName = SWCStringUtils.equals((String)dynamicObject.getString(KEY_TASKTYPE), (String)"0") ? new LocaleString(ResManager.loadKDString((String)"\u5e38\u89c4", (String)"CalTaskCardPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0])).toString() : new LocaleString(ResManager.loadKDString((String)"\u8ffd\u52a0", (String)"CalTaskCardPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0])).toString();
        this.setLabelText(KEY_TASKTYPE, taskTypeName);
        this.setLabelText(KEY_CALPERSONCOUNT, calpersonCount);
        this.setLabelText(KEY_PAYROLLSCENE, dynamicObject.getString("payrollscenev.name"));
        String timeText = this.getTimeText(dynamicObject);
        this.setLabelText(KEY_TIME, timeText);
        FlexPanelAp statusAp = this.initStatusAp(statusList, statusCountMap, calpersonCount);
        this.getView().updateControlMetadata(KEY_STATUSAP, statusAp.createControl());
    }

    private FlexPanelAp initStatusAp(List<String> statusList, Map<String, Integer> statusCountMap, String calpersoncount) {
        FlexPanelAp statusAp = new FlexPanelAp();
        statusAp.setKey(KEY_STATUSAP);
        statusAp.setBackColor("#FFFFFF");
        statusAp.setGrow(0);
        statusAp.setShrink(0);
        statusAp.setWidth(new LocaleString("100%"));
        statusAp.setHeight(new LocaleString("110px"));
        statusAp.setWrap(false);
        statusAp.setOverflow("auto");
        statusAp.setDirection("column");
        statusAp.setJustifyContent("flex-start");
        statusAp.setAlignItems("stretch");
        if (statusList != null && statusList.size() > 0) {
            for (String key : statusList) {
                FlexPanelAp parentAp = new FlexPanelAp();
                parentAp.setKey("flex" + key);
                parentAp.setBackColor("#FFFFFF");
                parentAp.setGrow(0);
                parentAp.setShrink(0);
                parentAp.setWidth(new LocaleString("100%"));
                parentAp.setHeight(new LocaleString("16.66%"));
                parentAp.setWrap(false);
                parentAp.setOverflow("hidden");
                parentAp.setDirection("row");
                parentAp.setJustifyContent("flex-start");
                parentAp.setAlignItems("center");
                Style style = new Style();
                Margin margin = new Margin();
                margin.setBottom("10px");
                style.setMargin(margin);
                parentAp.setStyle(style);
                if (!this.addStatusNameAp(key, parentAp)) continue;
                Integer count = statusCountMap.get(key);
                if (count == null) {
                    count = 0;
                }
                int personCount = Integer.parseInt(calpersoncount);
                Integer percent = 0;
                if (personCount > 0) {
                    percent = new BigDecimal(count).divide(new BigDecimal(personCount), 2, 4).multiply(new BigDecimal(100)).intValue();
                }
                this.addProgressAp(key, parentAp, percent);
                this.addPercentAp(key, parentAp, percent);
                this.addPersonCountAp(key, parentAp, count);
                statusAp.getItems().add(parentAp);
            }
        }
        return statusAp;
    }

    private List<QFilter> getPermFilter() {
        List permissionFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        return permissionFilter;
    }

    private static synchronized void setStatusMap() {
        List<CalStateEnum> itemList = Arrays.asList(CalStateEnum.values());
        HashMap<String, String> map = new HashMap<String, String>(itemList.size());
        for (CalStateEnum key : itemList) {
            map.put("calstatus-" + key.getCode(), key.getDesc());
        }
        statusLangMap = map;
    }

    private String getTimeText(DynamicObject task) {
        String timeText;
        if (SWCStringUtils.equals((String)task.getString(KEY_TASKSTATUS), (String)CalPayrollTaskStateEnum.APPROVALED.getCode())) {
            timeText = ResManager.loadKDString((String)"\u5df2\u5ba1\u6279\u901a\u8fc7", (String)"CalTaskCardPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        } else {
            Date createtime = task.getDate("createtime");
            long currentTimeMillis = System.currentTimeMillis();
            long createTimeMillis = createtime.getTime();
            long time = currentTimeMillis - createTimeMillis;
            long day = time / 86400000L;
            long hour = time % 86400000L / 3600000L;
            StringBuilder sb = new StringBuilder();
            sb.append(day).append(ResManager.loadKDString((String)"\u5929", (String)"CalTaskCardPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])).append(hour).append(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"CalTaskCardPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            timeText = sb.toString();
        }
        return timeText;
    }

    private void setLabelText(String key, String value) {
        Label label = (Label)this.getControl(key);
        label.setText(value);
    }

    private void setLabelStatusColor(String label, String status) {
        if (CalPayrollTaskStateEnum.CREATE.getCode().equals(status)) {
            this.setLabelColor(label, "#F2F9FF", "#276FF5", "#85B8FF");
        } else if (CalPayrollTaskStateEnum.UNCAL.getCode().equals(status)) {
            this.setLabelColor(label, "#FFFBF2", "#FF991C", "#FFCB78");
        } else if (CalPayrollTaskStateEnum.CALPROCESSING.getCode().equals(status)) {
            this.setLabelColor(label, "#F2F9FF", "#276FF5", "#85B8FF");
        } else if (CalPayrollTaskStateEnum.AUDIT.getCode().equals(status)) {
            this.setLabelColor(label, "#F2FFF5", "#1BA854", "#6DD18E");
        } else if (CalPayrollTaskStateEnum.APPROVALEDING.getCode().equals(status)) {
            this.setLabelColor(label, "#F2F9FF", "#276FF5", "#85B8FF");
        } else if (CalPayrollTaskStateEnum.APPROVALED.getCode().equals(status)) {
            this.setLabelColor(label, "#F2FFF5", "#1BA854", "#6DD18E");
        } else if (CalPayrollTaskStateEnum.APPROVALED_NOT_PASS.getCode().equals(status)) {
            this.setLabelColor(label, "#FFF2F4", "#FB2323", "#FF8088");
        } else if (CalPayrollTaskStateEnum.DISUSED.getCode().equals(status)) {
            this.setLabelColor(label, "#FAFAFA", "#999999", "#D9D9D9");
        }
    }

    private void setLabelColor(String label, String backColor, String foreColor, String borderColor) {
        HashMap<String, String> ctrl = new HashMap<String, String>(3);
        ctrl.put("bc", backColor);
        ctrl.put("fc", foreColor);
        ctrl.put("b", borderColor);
        this.getView().updateControlMetadata(label, ctrl);
    }

    private void addPercentAp(String key, FlexPanelAp parentAp, Integer percent) {
        FlexPanelAp percentAp = new FlexPanelAp();
        percentAp.setKey("percentap_" + key);
        percentAp.setWrap(false);
        percentAp.setGrow(0);
        percentAp.setShrink(1);
        percentAp.setWidth(new LocaleString("14%"));
        percentAp.setDirection("row");
        percentAp.setJustifyContent("flex-end");
        percentAp.setAlignItems("center");
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(percent + "%"));
        labelAp.setForeColor("#333333");
        labelAp.setFontSize(12);
        labelAp.setClickable(false);
        percentAp.getItems().add(labelAp);
        percentAp.setClickable(false);
        parentAp.getItems().add(percentAp);
    }

    private void addPersonCountAp(String key, FlexPanelAp parentAp, Integer personCount) {
        FlexPanelAp personCountAp = new FlexPanelAp();
        personCountAp.setKey("personCountAp" + key);
        personCountAp.setWrap(false);
        personCountAp.setGrow(0);
        personCountAp.setShrink(1);
        personCountAp.setWidth(new LocaleString("17%"));
        personCountAp.setHeight(new LocaleString("100%"));
        personCountAp.setDirection("row");
        personCountAp.setJustifyContent("flex-end");
        personCountAp.setAlignItems("center");
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(personCount + ""));
        labelAp.setClickable(true);
        labelAp.setForeColor("#308AF0");
        labelAp.setFontSize(12);
        if (0 == personCount) {
            labelAp.setClickable(false);
            labelAp.setForeColor("#666666");
        }
        LabelAp personAp = new LabelAp();
        personAp.setKey("labelap_person" + key);
        personAp.setName(new LocaleString(ResManager.loadKDString((String)"\u4eba", (String)"CalTaskCardPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        personAp.setForeColor("#666666");
        personAp.setFontSize(12);
        personAp.setWidth(new LocaleString("25px"));
        personCountAp.getItems().add(labelAp);
        personCountAp.getItems().add(personAp);
        parentAp.getItems().add(personCountAp);
    }

    private void addProgressAp(String key, FlexPanelAp parentAp, Integer percent) {
        FlexPanelAp progressAllAp = new FlexPanelAp();
        progressAllAp.setKey("processgressAllap" + key);
        progressAllAp.setWrap(false);
        progressAllAp.setGrow(0);
        progressAllAp.setShrink(1);
        progressAllAp.setWidth(new LocaleString("50%"));
        progressAllAp.setHeight(new LocaleString("12px"));
        progressAllAp.setBackColor("#cccccc");
        progressAllAp.setRadius("8px");
        FlexPanelAp progressAp = new FlexPanelAp();
        progressAp.setKey("processgressAp" + key);
        progressAp.setWrap(false);
        progressAp.setGrow(0);
        progressAp.setShrink(1);
        progressAp.setWidth(new LocaleString(percent + "%"));
        progressAp.setHeight(new LocaleString("12px"));
        progressAp.setForeColor("#5582F3");
        progressAp.setBackColor("#5582F3");
        if ("calstatus-1".equals(key)) {
            progressAp.setForeColor("#FF991C");
            progressAp.setBackColor("#FF991C");
        }
        progressAp.setDirection("row");
        progressAp.setRadius("8px");
        progressAllAp.getItems().add(progressAp);
        parentAp.getItems().add(progressAllAp);
    }

    private boolean addStatusNameAp(String key, FlexPanelAp parentAp) {
        FlexPanelAp stateAp = new FlexPanelAp();
        stateAp.setKey("status_" + key);
        stateAp.setWrap(false);
        stateAp.setGrow(0);
        stateAp.setShrink(1);
        stateAp.setWidth(new LocaleString("25%"));
        stateAp.setDirection("row");
        stateAp.setJustifyContent("flex-start");
        stateAp.setAlignItems("center");
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("labelap_caption" + key);
        String statusValue = statusLangMap.get(key);
        if (statusValue == null) {
            return false;
        }
        labelAp.setWidth(new LocaleString("100%"));
        labelAp.setName(new LocaleString(statusValue + " :"));
        labelAp.setForeColor("#666666");
        labelAp.setShrink(1);
        labelAp.setFontSize(12);
        stateAp.getItems().add(labelAp);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("0");
        style.setMargin(margin);
        labelAp.setStyle(style);
        parentAp.getItems().add(stateAp);
        return true;
    }

    public void click(EventObject evt) {
        ListShowParameter showParameter;
        String key = ((Control)evt.getSource()).getKey();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        switch (key) {
            case "caltaskname": {
                this.showBaseDataPage("hsas_calpayrolltask", taskId);
                break;
            }
            case "payrollscene": 
            case "calrulepic": {
                SWCDataServiceHelper taskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
                DynamicObject task = taskHelper.queryOne("payrollscenev.id", (Object)taskId);
                if (task == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"CalTaskCardPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBaseDataPage("hsas_payrollscene", task.getLong("payrollscenev.id"));
                break;
            }
            case "calpersoncount": {
                ListShowParameter showParameter2 = CalPayrollTaskHelper.getCalTableListForm((String)this.getView().getPageId(), (long)taskId);
                this.getView().showForm((FormShowParameter)showParameter2);
                break;
            }
            case "refresh": {
                this.refreshPage();
                break;
            }
        }
        String followStatus = (String)this.getView().getFormShowParameter().getCustomParam("followstatus");
        if (StringUtils.isEmpty((CharSequence)followStatus)) {
            return;
        }
        List statusList = JSON.parseArray((String)followStatus, String.class);
        if (statusList.contains(key) && (showParameter = CalPayrollTaskHelper.getCalTableListForm((String)this.getView().getPageId(), (long)taskId)) != null) {
            showParameter.setCustomParam("statusFilter", (Object)key);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        String followStatus = (String)this.getView().getFormShowParameter().getCustomParam("followstatus");
        if (StringUtils.isEmpty((CharSequence)followStatus)) {
            return;
        }
        List statusList = JSON.parseArray((String)followStatus, String.class);
        if (statusList.contains(args.getKey())) {
            Label label = new Label();
            label.setKey(args.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            args.setControl((Control)label);
        }
    }

    protected void showBaseDataPage(String formId, long pkId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void onProgress(ProgressEvent progressEvent) {
    }

    static {
        LOGGER = LogFactory.getLog(CalTaskCardPlugin.class);
    }
}

