/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FollowStatusConfigPulgin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    private static final String KEY_LEFTTREE = "lefttree";
    private static final String KEY_RIGHTTREE = "righttree";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_REMOVE = "remove";
    private static final String KEY_ADD = "add";
    private static final String KEY_LEFTCHECK = "leftcheck";
    private static final String KEY_LEFTCOUNT = "leftcount";
    private static final String KEY_RIGHTCHECK = "rightcheck";
    private static final String KEY_RIGHTCOUNT = "rightcount";
    private static final String KEY_PAYROLLGROUP = "payrollgroup";
    private static final String KEY_PAYROLLSCENE = "payrollscene";
    private static final String KEY_CALSTATUS = "calstatus";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_ADD, KEY_REMOVE});
        TreeView leftTreeView = (TreeView)this.getView().getControl(KEY_LEFTTREE);
        TreeView rightTreeView = (TreeView)this.getView().getControl(KEY_RIGHTTREE);
        leftTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        rightTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject e) {
        TreeView leftTreeView = (TreeView)this.getView().getControl(KEY_LEFTTREE);
        TreeView rightTreeView = (TreeView)this.getView().getControl(KEY_RIGHTTREE);
        DynamicObject params = this.getView().getParentView().getModel().getDataEntity();
        Long payrollgroupId = params.getLong("payrollgroup.id");
        Long payrollSceneId = params.getLong("payrollscene.id");
        SWCDataServiceHelper configHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
        DynamicObject cfg = configHelper.queryOne("taxopenfollstatus,taxclosefollstatus", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollgroupId), new QFilter("payrollscene.id", "=", (Object)payrollSceneId)});
        String followStatusJson = null;
        if (cfg != null) {
            followStatusJson = cfg.getString("taxopenfollstatus");
        }
        ArrayList<String> statusList = new ArrayList(10);
        if (SWCStringUtils.isNotEmpty((String)followStatusJson)) {
            statusList = JSON.parseArray((String)followStatusJson, String.class);
        }
        TreeNode leftRootNode = new TreeNode(null, "all", ResManager.loadKDString((String)"\u5168\u90e8", (String)"FollowStatusConfigPulgin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), true);
        TreeNode rightRootNode = new TreeNode(null, "all", ResManager.loadKDString((String)"\u5168\u90e8", (String)"FollowStatusConfigPulgin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), true);
        leftRootNode.setIsOpened(true);
        leftRootNode.setCheckable(true);
        rightRootNode.setIsOpened(true);
        rightRootNode.setCheckable(true);
        this.initRootNode(statusList, leftRootNode, rightRootNode);
        leftTreeView.addNode(leftRootNode);
        rightTreeView.addNode(rightRootNode);
        this.getPageCache().put(KEY_LEFTTREE, JSON.toJSONString((Object)leftRootNode));
        this.getPageCache().put(KEY_RIGHTTREE, JSON.toJSONString((Object)rightRootNode));
        this.setLabelValue(leftTreeView, leftRootNode, KEY_LEFTCHECK, KEY_LEFTCOUNT);
        this.setLabelValue(rightTreeView, rightRootNode, KEY_RIGHTCHECK, KEY_RIGHTCOUNT);
    }

    private void initRootNode(List<String> statusList, TreeNode leftRootNode, TreeNode rightRootNode) {
        String calName = ResManager.loadKDString((String)"\u6838\u7b97\u72b6\u6001", (String)"FollowStatusConfigPulgin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        List<CalStateEnum> itemList = Arrays.asList(CalStateEnum.values());
        TreeNode leftParent = new TreeNode("all", KEY_CALSTATUS, calName, true);
        leftParent.setIsOpened(true);
        leftParent.setCheckable(true);
        TreeNode rightParent = new TreeNode("all", KEY_CALSTATUS, calName, true);
        rightParent.setIsOpened(true);
        for (CalStateEnum item : itemList) {
            String childKey = "calstatus-" + item.getCode();
            TreeNode treeNode = new TreeNode(KEY_CALSTATUS, childKey, item.getDesc());
            treeNode.setIsOpened(true);
            treeNode.setCheckable(true);
            leftParent.addChild(treeNode);
            if (statusList == null || !statusList.contains(childKey)) continue;
            rightParent.addChild(treeNode);
        }
        if (leftParent.getChildren().isEmpty()) {
            leftParent.setCheckable(false);
        }
        leftRootNode.addChild(leftParent);
        if (!rightParent.getChildren().isEmpty()) {
            rightRootNode.addChild(rightParent);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                TreeNode returnNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_RIGHTTREE), TreeNode.class);
                ArrayList ids = new ArrayList(10);
                for (TreeNode child : returnNode.getChildren()) {
                    child.getChildren().forEach(o -> ids.add(o.getId()));
                }
                String followstatus = JSON.toJSONString(ids);
                this.saveStatusConfig(followstatus);
                this.getView().getParentView().updateView();
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                break;
            }
            case "add": {
                TreeView leftTreeView = (TreeView)this.getView().getControl(KEY_LEFTTREE);
                TreeView rightTreeView = (TreeView)this.getView().getControl(KEY_RIGHTTREE);
                TreeNode leftNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_LEFTTREE), TreeNode.class);
                TreeNode rightNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_RIGHTTREE), TreeNode.class);
                this.moveTree(leftTreeView, leftNode, rightNode, false);
                this.dealEmptyCondition(leftTreeView, rightTreeView, leftNode, rightNode);
                break;
            }
            case "remove": {
                TreeView leftView = (TreeView)this.getView().getControl(KEY_LEFTTREE);
                TreeView rightView = (TreeView)this.getView().getControl(KEY_RIGHTTREE);
                TreeNode leftRootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_LEFTTREE), TreeNode.class);
                TreeNode rightRootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_RIGHTTREE), TreeNode.class);
                this.moveTree(rightView, rightRootNode, leftRootNode, true);
                this.dealEmptyCondition(leftView, rightView, leftRootNode, rightRootNode);
                break;
            }
        }
    }

    private void saveStatusConfig(String followStatus) {
        DynamicObject params = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject payrollGroupDy = params.getDynamicObject(KEY_PAYROLLGROUP);
        DynamicObject payrollSceneDy = params.getDynamicObject(KEY_PAYROLLSCENE);
        if (SWCObjectUtils.isEmpty((Object)payrollGroupDy) || SWCObjectUtils.isEmpty((Object)payrollSceneDy)) {
            return;
        }
        SWCDataServiceHelper configHelper = new SWCDataServiceHelper("hsas_calplatformcfg");
        DynamicObject cfg = configHelper.queryOne("taxopenfollstatus,taxclosefollstatus,creator,createtime,modifier,modifytime", new QFilter[]{new QFilter("payrollgroup.id", "=", (Object)payrollGroupDy.getLong("id")), new QFilter("payrollscene.id", "=", (Object)payrollSceneDy.getLong("id"))});
        if (cfg != null) {
            cfg.set("taxopenfollstatus", (Object)followStatus);
            CalPlatformHelper.setSystemFieldValue((DynamicObject)cfg, (boolean)true);
        } else {
            cfg = configHelper.generateEmptyDynamicObject();
            cfg.set(KEY_PAYROLLGROUP, (Object)payrollGroupDy);
            cfg.set(KEY_PAYROLLSCENE, (Object)payrollSceneDy);
            cfg.set("enable", (Object)"1");
            cfg.set("number", (Object)(payrollGroupDy.getString("number") + payrollSceneDy.getString("number")));
            cfg.set("name", (Object)(payrollGroupDy.getString("name") + payrollSceneDy.get("name")));
            cfg.set("status", (Object)"A");
            cfg.set("taxopenfollstatus", (Object)followStatus);
            CalPlatformHelper.setSystemFieldValue((DynamicObject)cfg, (boolean)false);
        }
        configHelper.saveOne(cfg);
    }

    private void setTaxFollowStatus(DynamicObject dynamicObject, String followStatus) {
        dynamicObject.set("taxopenfollstatus", (Object)followStatus);
    }

    private void dealEmptyCondition(TreeView leftTreeView, TreeView rightTreeView, TreeNode leftNode, TreeNode rightNode) {
        Iterator iterator = leftNode.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode child;
            child.setCheckable(!(child = (TreeNode)iterator.next()).getChildren().isEmpty());
        }
        ArrayList<String> deleteIds = new ArrayList<String>(10);
        for (TreeNode child : rightNode.getChildren()) {
            if (!child.getChildren().isEmpty()) continue;
            deleteIds.add(child.getId());
        }
        deleteIds.forEach(arg_0 -> ((TreeNode)rightNode).deleteChildNode(arg_0));
        leftTreeView.deleteAllNodes();
        leftTreeView.addNode(leftNode);
        rightTreeView.deleteAllNodes();
        rightTreeView.addNode(rightNode);
        this.getPageCache().put(KEY_LEFTTREE, JSON.toJSONString((Object)leftNode));
        this.getPageCache().put(KEY_RIGHTTREE, JSON.toJSONString((Object)rightNode));
        this.setLabelValue(leftTreeView, leftNode, KEY_LEFTCHECK, KEY_LEFTCOUNT);
        this.setLabelValue(rightTreeView, rightNode, KEY_RIGHTCHECK, KEY_RIGHTCOUNT);
    }

    private void setLabelValue(TreeView leftTreeView, TreeNode leftNode, String keyCheck, String keyCount) {
        int count = 0;
        for (Object child : leftNode.getChildren()) {
            count += child.getChildren().size();
        }
        int select = 0;
        for (Map selectedNode : leftTreeView.getTreeState().getSelectedNodes()) {
            Boolean isParent = (Boolean)selectedNode.get("isParent");
            if (isParent.booleanValue()) continue;
            ++select;
        }
        Label checkLabel = (Label)this.getControl(keyCheck);
        checkLabel.setText(String.valueOf(select));
        Label countLabel = (Label)this.getControl(keyCount);
        countLabel.setText(String.valueOf(count));
    }

    private void moveTree(TreeView oriTree, TreeNode oriNode, TreeNode goalNode, boolean isDeleteOri) {
        List checkedNodes = oriTree.getTreeState().getSelectedNodes();
        for (Map checkedNode : checkedNodes) {
            String parentid = (String)checkedNode.get("parentid");
            String id = (String)checkedNode.get("id");
            String text = (String)checkedNode.get("text");
            Boolean isParent = (Boolean)checkedNode.get("isParent");
            if (goalNode.getTreeNode(id, 2) == null) {
                if (goalNode.getTreeNode(parentid, 1) == null) {
                    TreeNode parentNode = oriNode.getTreeNode(parentid, 1);
                    TreeNode newParentNode = new TreeNode(parentNode.getParentid(), parentNode.getId(), parentNode.getText(), true);
                    newParentNode.setIsOpened(true);
                    goalNode.addChild(newParentNode);
                }
                TreeNode treeNode = new TreeNode(parentid, id, text, (Object)isParent);
                treeNode.setIsOpened(true);
                goalNode.getTreeNode(parentid, 1).addChild(treeNode);
            }
            if (isDeleteOri) {
                oriNode.deleteChildNode(id);
                continue;
            }
            oriTree.uncheckNode(id);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
        TreeView treeView = (TreeView)arg0.getSource();
        if (SWCStringUtils.equals((String)treeView.getKey(), (String)KEY_LEFTTREE)) {
            TreeNode treeNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_LEFTTREE), TreeNode.class);
            this.setLabelValue(treeView, treeNode, KEY_LEFTCHECK, KEY_LEFTCOUNT);
        } else if (SWCStringUtils.equals((String)treeView.getKey(), (String)KEY_RIGHTTREE)) {
            TreeNode treeNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(KEY_RIGHTTREE), TreeNode.class);
            this.setLabelValue(treeView, treeNode, KEY_RIGHTCHECK, KEY_RIGHTCOUNT);
        }
    }
}

