/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryResultPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SalaryResultPlugin.class);
    public static final String KEY_PAYROLLSCENE = "payrollscene";
    public static final String KEY_ARROWUP = "\u2191";
    public static final String KEY_ARROWDOWN = "\u2193";
    public static final String KEY_PERIODTYPEID = "periodtypeid";

    public void afterBindData(EventObject e) {
        this.refreshPage();
    }

    private void refreshPage() {
        DynamicObject preYearPeriod;
        DynamicObject params = this.getView().getModel().getDataEntity();
        if (params == null) {
            return;
        }
        DynamicObject periodObj = params.getDynamicObject("calperiod");
        if (periodObj == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapcheck"});
            return;
        }
        Long calperiod = periodObj.getLong("id");
        Long payrollgroupId = params.getLong("payrollgroup.id");
        Long payrollsceneId = params.getLong("payrollscene.id");
        if (calperiod == null || payrollgroupId == null || payrollsceneId == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapcheck"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapcheck"});
        Date salaryStartDate = periodObj.getDate("startdate");
        Long periodTypeid = periodObj.getLong(KEY_PERIODTYPEID);
        SWCDataServiceHelper periodHelper = new SWCDataServiceHelper("hsbs_calperiod");
        DynamicObject period = periodHelper.queryOne("periodcalfrequency.type", (Object)calperiod);
        String periodFrequencyType = period.getString("periodcalfrequency.type");
        List<String> periodFrequencyTypeList = Arrays.asList("HALF_MONTH", "BIWEEKLY", "WEEK", "DAY", "OTHER");
        Date preYearStartDate = SWCDateTimeUtils.addYear((Date)salaryStartDate, (int)-1);
        ArrayList<Long> periodList = new ArrayList<Long>();
        Long preCalperiod = null;
        Long preYearCalperiod = null;
        DynamicObject prePeriod = periodHelper.queryOne("id", new QFilter[]{new QFilter("startdate", "<", (Object)salaryStartDate), new QFilter(KEY_PERIODTYPEID, "=", (Object)periodTypeid)}, "startdate desc");
        if (prePeriod != null) {
            preCalperiod = prePeriod.getLong("id");
            periodList.add(preCalperiod);
        }
        boolean showYearData = true;
        if (SWCStringUtils.isEmpty((String)periodFrequencyType) || periodFrequencyTypeList.contains(periodFrequencyType)) {
            showYearData = false;
        }
        if (showYearData && (preYearPeriod = periodHelper.queryOne("id", new QFilter[]{new QFilter("startdate", "=", (Object)preYearStartDate), new QFilter(KEY_PERIODTYPEID, "=", (Object)periodTypeid)})) != null) {
            preYearCalperiod = preYearPeriod.getLong("id");
            periodList.add(preYearCalperiod);
        }
        periodList.add(calperiod);
        long st = System.currentTimeMillis();
        log.info("getResultFilter_begin");
        QFilter resultFilter = this.getResultFilter(payrollgroupId, payrollsceneId, periodList);
        log.info("getResultFilter_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        SWCDataServiceHelper resultHelper = new SWCDataServiceHelper("hsas_salaryresult");
        BigDecimal currentTatalSalary = new BigDecimal(0);
        BigDecimal currentNetSalary = new BigDecimal(0);
        BigDecimal preTatalSalary = new BigDecimal(0);
        BigDecimal preNetSalary = new BigDecimal(0);
        BigDecimal lastYearTatalSalary = new BigDecimal(0);
        BigDecimal lastYearNetSalary = new BigDecimal(0);
        DynamicObject[] dynamicObjects = resultHelper.query("id,totalsalary,netsalary,calperiod", new QFilter[]{resultFilter});
        log.info("querySalaryResultData_finish,cost:{} ms", (Object)(System.currentTimeMillis() - st));
        Map<Long, List<DynamicObject>> periodsMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getLong("calperiod.id")));
        for (Map.Entry<Long, List<DynamicObject>> periodsGroup : periodsMap.entrySet()) {
            Long periodId = periodsGroup.getKey();
            if (periodId == null) continue;
            List<DynamicObject> periodsDys = periodsGroup.getValue();
            if (periodId.equals(calperiod)) {
                for (DynamicObject dy2 : periodsDys) {
                    currentTatalSalary = currentTatalSalary.add(dy2.getBigDecimal("totalsalary"));
                    currentNetSalary = currentNetSalary.add(dy2.getBigDecimal("netsalary"));
                }
                continue;
            }
            if (periodId.equals(preCalperiod)) {
                for (DynamicObject dy2 : periodsDys) {
                    preTatalSalary = preTatalSalary.add(dy2.getBigDecimal("totalsalary"));
                    preNetSalary = preNetSalary.add(dy2.getBigDecimal("netsalary"));
                }
                continue;
            }
            if (!periodId.equals(preYearCalperiod)) continue;
            for (DynamicObject dy2 : periodsDys) {
                lastYearTatalSalary = lastYearTatalSalary.add(dy2.getBigDecimal("totalsalary"));
                lastYearNetSalary = lastYearNetSalary.add(dy2.getBigDecimal("netsalary"));
            }
        }
        this.setValueView(showYearData, currentTatalSalary, currentNetSalary, preTatalSalary, preNetSalary, lastYearTatalSalary, lastYearNetSalary);
    }

    private QFilter getResultFilter(Long payrollgroupId, Long payrollsceneId, List<Long> periodList) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        SWCDataServiceHelper personHelper = new SWCDataServiceHelper("hsas_calperson");
        List authFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)"47150e89000000ac");
        if (authFilter != null) {
            filterList.addAll(authFilter);
        } else {
            filterList.add(new QFilter("1", "!=", (Object)1));
        }
        filterList.add(new QFilter("calperiod.id", "in", periodList));
        log.info("SalaryResultPlugin_filterList:{}", (Object)((Object)filterList).toString());
        DynamicObjectCollection personObjs = personHelper.queryOriginalCollection("calresultid", filterList.toArray(new QFilter[filterList.size()]));
        List<Object> caltableIdList = new ArrayList(10);
        if (personObjs != null && personObjs.size() > 0) {
            caltableIdList = personObjs.stream().filter(single -> single.getLong("calresultid") > 0L).map(person -> person.getLong("calresultid")).collect(Collectors.toList());
        }
        log.info("caltableIdList.size:{}", (Object)caltableIdList.size());
        QFilter resultFilter = new QFilter("payrollgroup.id", "=", (Object)payrollgroupId).and(new QFilter("payrollscene.id", "=", (Object)payrollsceneId)).and(new QFilter("calperiod.id", "in", periodList));
        log.info("SalaryResultPlugin_resultFilter:{}", (Object)resultFilter.toString());
        if (!SWCListUtils.isEmpty(caltableIdList)) {
            resultFilter.and("caltableid", "in", caltableIdList);
        } else {
            resultFilter.and("1", "!=", (Object)1);
        }
        return resultFilter;
    }

    private void showEmptyPage() {
        FormShowParameter emptyPage = CalPlatformHelper.getEmptyPage((String)ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u786e\u4fdd\u6240\u6709\u7b5b\u9009\u6761\u4ef6\u6709\u503c\u3002", (String)"CalTaskCardListPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]), (String)"flexpanelap40");
        this.getView().showForm(emptyPage);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap40"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapcheck"});
    }

    private void setValueView(boolean showYearData, BigDecimal currentTatalSalary, BigDecimal currentNetSalary, BigDecimal preTatalSalary, BigDecimal preNetSalary, BigDecimal lastYearTatalSalary, BigDecimal lastYearNetSalary) {
        BigDecimal preTotalGrowthRate = this.calGrowthRate(currentTatalSalary, preTatalSalary);
        BigDecimal preNetGrowthRate = this.calGrowthRate(currentNetSalary, preNetSalary);
        BigDecimal lastYearTotalGrowthRate = this.calGrowthRate(currentTatalSalary, lastYearTatalSalary);
        BigDecimal lastYearNetGrowthRate = this.calGrowthRate(currentNetSalary, lastYearNetSalary);
        this.setLabelText("currenttotalsalary", this.transferDispay(currentTatalSalary));
        this.setLabelText("currentnetsalary", this.transferDispay(currentNetSalary));
        this.setLabelText("pretotalsalary", this.transferDispay(preTatalSalary));
        this.setLabelText("prenetsalary", this.transferDispay(preNetSalary));
        this.setLabelText("lastyeartotalsalary", showYearData ? this.transferDispay(lastYearTatalSalary) : "--");
        this.setLabelText("lastyearnetsalary", showYearData ? this.transferDispay(lastYearNetSalary) : "--");
        this.setLabelText("pretotalarrow", this.isArrowDirection(preTotalGrowthRate));
        this.setLabelText("lastyeartotalarrow", showYearData ? this.isArrowDirection(lastYearTotalGrowthRate) : "&nbsp;");
        this.setLabelText("prenetarrow", this.isArrowDirection(preNetGrowthRate));
        this.setLabelText("lastyearnetarrow", showYearData ? this.isArrowDirection(lastYearNetGrowthRate) : "&nbsp;");
        this.setLabelColor("pretotalarrow", this.isArrowAndRateColor(preTotalGrowthRate));
        this.setLabelColor("lastyeartotalarrow", this.isArrowAndRateColor(lastYearTotalGrowthRate));
        this.setLabelColor("prenetarrow", this.isArrowAndRateColor(preNetGrowthRate));
        this.setLabelColor("lastyearnetarrow", this.isArrowAndRateColor(lastYearNetGrowthRate));
        this.setLabelText("pretotalgrowthrate", this.transferRateDispay(preTotalGrowthRate.abs()) + "%");
        this.setLabelText("lastyeartotalgrowthrate", showYearData ? this.transferRateDispay(lastYearTotalGrowthRate.abs()) + "%" : "--");
        this.setLabelText("prenetgrowthrate", this.transferRateDispay(preNetGrowthRate.abs()) + "%");
        this.setLabelText("lastyearnetgrowthrate", showYearData ? this.transferRateDispay(lastYearNetGrowthRate.abs()) + "%" : "--");
        this.setLabelColor("pretotalgrowthrate", this.isArrowAndRateColor(preTotalGrowthRate));
        this.setLabelColor("lastyeartotalgrowthrate", showYearData ? this.isArrowAndRateColor(lastYearTotalGrowthRate) : "#212121");
        this.setLabelColor("prenetgrowthrate", this.isArrowAndRateColor(preNetGrowthRate));
        this.setLabelColor("lastyearnetgrowthrate", showYearData ? this.isArrowAndRateColor(lastYearNetGrowthRate) : "#212121");
    }

    private BigDecimal calGrowthRate(BigDecimal salary, BigDecimal preSalary) {
        if (preSalary.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal growSalary = salary.subtract(preSalary);
        BigDecimal growRate = growSalary.multiply(new BigDecimal("100")).divide(preSalary.abs(), 2, 4);
        return growRate;
    }

    private String transferDispay(BigDecimal value) {
        DecimalFormat decimalFormat = new DecimalFormat(",###,##0.00");
        return decimalFormat.format(value);
    }

    private String transferRateDispay(BigDecimal value) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        return decimalFormat.format(value);
    }

    private String isArrowDirection(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) >= 0) {
            return KEY_ARROWUP;
        }
        return KEY_ARROWDOWN;
    }

    private String isArrowAndRateColor(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) >= 0) {
            return "#FB2323";
        }
        return "#1BA854";
    }

    private void setLabelText(String labelName, String value) {
        Label label = (Label)this.getView().getControl(labelName);
        if (SWCStringUtils.isEmpty((String)value)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelName"});
        } else {
            label.setText(value);
        }
    }

    private void setLabelColor(String label, String foreColor) {
        HashMap<String, String> ctrl = new HashMap<String, String>();
        ctrl.put("fc", foreColor);
        this.getView().updateControlMetadata(label, ctrl);
    }
}

