/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calplatform;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.swc.hsas.business.calplatform.CalPlatformHelper;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultListHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalarySingleCheckPlugin
extends AbstractFormPlugin {
    public static final String CLOSE_CALL_BACK_ID = "closecaldetailpage";
    public static final String CLOSE_CALL_BACK_TASK_ID = "closechecktaskpage";
    public static final String KEY_CALPERSONCOUNT = "itemcount";
    public static final String KEY_ITEMID = "itemid";
    public static final String KEY_ITEMNAME = "itemname";
    public static final String KEY_ITEMTEXT = "itemtext";
    public static final String KEY_ZERO = "0";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_CALPERSONCOUNT});
    }

    public void afterBindData(EventObject e) {
        this.refreshPage();
    }

    private void refreshPage() {
        Long taskId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam(KEY_ITEMID).toString());
        Map itemMap = (Map)this.getView().getFormShowParameter().getCustomParam("itemmap");
        this.dealCheckScheme(taskId, itemMap);
    }

    private void dealCheckScheme(Long itemId, Map<Long, Object> itemMap) {
        Map resultMap = (Map)JSON.parse((String)this.getView().getParentView().getPageCache().get("data"));
        List itemList = (List)resultMap.get(itemId);
        if (itemList == null || itemList.size() == 0) {
            this.setLabelText(KEY_ITEMNAME, String.valueOf(itemMap.get(itemId)));
            this.setLabelText(KEY_CALPERSONCOUNT, "--");
            this.getModel().setValue(KEY_ITEMID, (Object)String.valueOf(itemId));
            this.getModel().setValue(KEY_ITEMTEXT, (Object)"--");
        } else {
            String itemName = String.valueOf(((Map)itemList.get(0)).getOrDefault("itemName", ""));
            Long count = itemList.stream().mapToLong(item -> Long.parseLong(String.valueOf(item.get("count")))).sum();
            this.setLabelText(KEY_ITEMNAME, itemName);
            this.setLabelText(KEY_CALPERSONCOUNT, String.valueOf(count));
            this.getModel().setValue(KEY_ITEMID, (Object)String.valueOf(itemId));
            this.getModel().setValue(KEY_ITEMTEXT, (Object)String.valueOf(count));
        }
    }

    private void setLabelText(String labelName, String value) {
        Label label = (Label)this.getView().getControl(labelName);
        label.setText(value);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_CALPERSONCOUNT.equals(key)) {
            Long itemId = Long.parseLong(String.valueOf(this.getModel().getValue(KEY_ITEMID)));
            this.dealClickNumber(itemId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actId = closedCallBackEvent.getActionId();
        if (SWCStringUtils.equals((String)actId, (String)CLOSE_CALL_BACK_ID)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (SWCObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            ListSelectedRow selectRow = returnData.get(0);
            Long calResultTplId = (Long)selectRow.getPrimaryKeyValue();
            Map params = (Map)JSON.parse((String)this.getPageCache().get("tplpageid"));
            Long calTaskId = Long.parseLong(String.valueOf(params.get("taskid")));
            List calPersonList = (List)params.get("personList");
            ListShowParameter formShowParameter = (ListShowParameter)SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
            CalPlatformHelper.showSalaryResultPage((ListShowParameter)formShowParameter, (List)calPersonList, (IFormView)this.getView());
        } else if (SWCStringUtils.equals((String)actId, (String)CLOSE_CALL_BACK_TASK_ID)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            Long calTaskId = Long.parseLong(String.valueOf(returnData.get("taskid")));
            List personList = (List)returnData.get("personList");
            Long calResultTplId = Long.parseLong(String.valueOf(returnData.get("tplid")));
            ListShowParameter formShowParameter = (ListShowParameter)SalaryDetailResultListHelper.openCalResultDetailPage((Long)calResultTplId, (Long)calTaskId, (String)this.getView().getPageId());
            if (formShowParameter == null) {
                return;
            }
            CalPlatformHelper.showSalaryResultPage((ListShowParameter)formShowParameter, (List)personList, (IFormView)this.getView());
        }
    }

    private void dealClickNumber(Long itemId) {
        DynamicObject params = this.getView().getParentView().getModel().getDataEntity();
        Long payRollGroupId = params.getLong("payrollgroup.id");
        Map resultMap = (Map)JSON.parse((String)this.getView().getParentView().getPageCache().get("data"));
        List itemList = (List)resultMap.get(itemId);
        if (itemList == null || itemList.size() == 0) {
            return;
        }
        String itemText = String.valueOf(this.getModel().getValue(KEY_ITEMTEXT));
        if (KEY_ZERO.equals(itemText)) {
            return;
        }
        if (itemList.size() == 1) {
            List personList = (List)((Map)itemList.get(0)).get("personList");
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_ID);
            Long taskId = Long.parseLong(String.valueOf(((Map)itemList.get(0)).get("taskid")));
            CalPlatformHelper.dealCalReslutTpl((Long)payRollGroupId, (Long)taskId, (List)personList, (IFormView)this.getView(), (CloseCallBack)callBack);
        } else {
            this.showCheckTaskTip(itemList);
        }
    }

    private void showCheckTaskTip(List<Map<String, Object>> itemList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(true);
        parameter.setFormId("hsas_checktaskshow");
        parameter.setCustomParam("itemlist", itemList);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_TASK_ID);
        parameter.setCloseCallBack(callBack);
        this.getView().showForm(parameter);
    }
}

