/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calresulttpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsas.business.calresulttpl.helper.CalPersonAddItemServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import org.apache.commons.collections4.CollectionUtils;

public class CalPersonAddItemPlugin
extends SWCDataBaseEdit
implements SearchEnterListener {
    private static final String KEY_TREE_VIEW = "treeviewap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnsave"});
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
        Search tableSearch = (Search)this.getView().getControl("columnsearchap");
        tableSearch.addEnterListener((SearchEnterListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTreeNode();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadMainPageData();
    }

    public void loadMainPageData() {
        IFormView parentView = this.getView().getParentView();
        DynamicObjectCollection calPersonDatas = parentView.getModel().getEntryEntity("payrolllist");
        if (calPersonDatas == null || calPersonDatas.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : calPersonDatas) {
            int detailIndex = model.createNewEntryRow("itemselectentry");
            model.setValue("fieldsource", dataObj.get("fieldsource"), detailIndex);
            model.setValue("itemname", dataObj.get("fieldname"), detailIndex);
            model.setValue("itemcategory", dataObj.get("fieldtype"), detailIndex);
            model.setValue("treenodeid", dataObj.get("fieldnumber"), detailIndex);
            model.setValue("field", dataObj.get("field"), detailIndex);
            model.setValue("number", dataObj.get("fieldnumber"), detailIndex);
            model.setValue("perruleobj", dataObj.get("perruleobj"), detailIndex);
        }
        this.getView().updateView("itemselectentry");
    }

    private void initTreeNode() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        CalPersonAddItemServiceHelper helper = new CalPersonAddItemServiceHelper();
        TreeNode rootNode = helper.queryAndBuildTreeNode(pageCache);
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(10);
        list.add(rootNode);
        Map treeNodeMap = list.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put("cal_person_tree", (Object)SerializationUtils.serializeToBase64(treeNodeMap));
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnsave": {
                this.btnOkClickEvent();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "do_addcolumn": {
                this.addColumn();
                break;
            }
            case "do_removecolumn": {
                this.removeColumn();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String optKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (optKey = formOperate.getOperateKey()) {
            case "do_moveto": {
                this.openMoveToPage(args);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "movetoclosed": {
                this.moveToClosedEvent(evt);
                break;
            }
        }
    }

    public void moveToClosedEvent(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String clickStatus = (String)returnData.get("clickStatus");
        if (!SWCStringUtils.equals((String)"ok", (String)clickStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        int oldRow = rows[0];
        int newRow = (Integer)returnData.get("rownumber");
        IDataModel model = this.getModel();
        DynamicObjectCollection datas = model.getEntryEntity("itemselectentry");
        int size = datas.size();
        if (--newRow > size - 1) {
            newRow = size - 1;
        }
        if (oldRow == newRow) {
            return;
        }
        DynamicObject oldObj = (DynamicObject)datas.get(oldRow);
        model.deleteEntryRow("itemselectentry", oldRow);
        model.createNewEntryRow("itemselectentry", newRow, oldObj);
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        grid.selectRows(newRow, true);
    }

    public void openMoveToPage(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CalPersonAddItemPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"CalPersonAddItemPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"CalPersonAddItemPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "movetoclosed"));
        this.getView().showForm(showParameter);
    }

    public void addColumn() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"CalPersonAddItemPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("cal_person_tree", String.class);
        Map rootMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("treenodeid", new Object[0]);
        vs.addField("number", new Object[0]);
        vs.addField("fieldsource", new Object[0]);
        vs.addField("itemcategory", new Object[0]);
        vs.addField("perruleobj", new Object[0]);
        vs.addField("field", new Object[0]);
        Map cacheMap = (Map)pageCache.get("cal_person_data", Map.class);
        for (String selectNodeId : selectNodeIds) {
            List childTrees;
            TreeNode treeNode = this.getTreeNodeByTreeId(rootMap, selectNodeId);
            if (treeNode == null || SWCStringUtils.isEmpty((String)treeNode.getId()) || (childTrees = treeNode.getChildren()) != null && childTrees.size() > 0 || this.isExistTreeNode(selectNodeId)) continue;
            Map dataMap = (Map)cacheMap.get(selectNodeId);
            String dataSource = this.getDataSourceByTreeId(rootMap, treeNode.getParentid());
            if (dataMap != null && dataMap.size() > 0) {
                String type = (String)dataMap.get("type");
                Object idObj = dataMap.get("perruleobjId");
                Long perruleobjId = null;
                perruleobjId = idObj instanceof Integer ? Long.valueOf(((Integer)idObj).longValue()) : (Long)dataMap.get("perruleobjId");
                String alias = (String)dataMap.get("alias");
                vs.addRow(new Object[]{treeNode.getText(), selectNodeId, selectNodeId, dataSource, type, perruleobjId, alias});
                continue;
            }
            vs.addRow(new Object[]{treeNode.getText(), selectNodeId, selectNodeId, dataSource, null, null, null});
        }
        model.batchCreateNewEntryRow("itemselectentry", vs);
        model.endInit();
        this.getView().updateView("itemselectentry");
    }

    public void removeColumn() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalPersonAddItemPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("itemselectentry", rows);
    }

    public String getDataSourceByTreeId(Map<String, TreeNode> nodeMap, String treeId) {
        TreeNode parentNode;
        String dataSource = "";
        TreeNode treeNode = this.getTreeNodeByTreeId(nodeMap, treeId);
        if (treeNode != null && !StringUtil.isEmpty((CharSequence)treeNode.getParentid()) && (parentNode = this.getTreeNodeByTreeId(nodeMap, treeNode.getParentid())) != null) {
            dataSource = parentNode.getText();
        }
        return dataSource;
    }

    public boolean isExistTreeNode(String selectTreeNodeId) {
        DynamicObjectCollection itemDatas = this.getModel().getEntryEntity("itemselectentry");
        for (DynamicObject itemData : itemDatas) {
            String treeNodeId = itemData.getString("treenodeid");
            if (!SWCStringUtils.equals((String)treeNodeId, (String)selectTreeNodeId)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getTreeNodeByTreeId(Map<String, TreeNode> nodeMap, String treeId) {
        TreeNode treeNode = new TreeNode();
        for (Map.Entry<String, TreeNode> entry : nodeMap.entrySet()) {
            TreeNode value = entry.getValue();
            this.getSubTreeNode(treeNode, treeId, value);
            if (!SWCStringUtils.isNotEmpty((String)treeNode.getId())) continue;
            return treeNode;
        }
        return treeNode;
    }

    public void getSubTreeNode(TreeNode treeNode, String treeId, TreeNode subTreeNode) {
        String subTreeId = subTreeNode.getId();
        if (SWCStringUtils.equals((String)treeId, (String)subTreeId)) {
            this.copyTreeNode(treeNode, subTreeNode);
        } else {
            List childTrees = subTreeNode.getChildren();
            if (childTrees != null && childTrees.size() > 0) {
                for (TreeNode childTree : childTrees) {
                    this.getSubTreeNode(treeNode, treeId, childTree);
                }
            }
        }
    }

    public void copyTreeNode(TreeNode newTreeNode, TreeNode oldTreeNode) {
        newTreeNode.setId(oldTreeNode.getId());
        newTreeNode.setText(oldTreeNode.getText());
        newTreeNode.setParentid(oldTreeNode.getParentid());
        newTreeNode.setData(oldTreeNode.getData());
        newTreeNode.setChildren(oldTreeNode.getChildren());
        newTreeNode.setExpend(oldTreeNode.isExpend());
        newTreeNode.setIsOpened(oldTreeNode.getIsOpened());
        newTreeNode.setType(oldTreeNode.getType());
        newTreeNode.setColor(oldTreeNode.getColor());
        newTreeNode.setLongNumber(oldTreeNode.getLongNumber());
        newTreeNode.setLeaf(oldTreeNode.isLeaf());
        newTreeNode.setCheckable(oldTreeNode.isCheckable());
        newTreeNode.setIcon(oldTreeNode.getIcon());
    }

    public void search(SearchEnterEvent arg) {
        String searchText = arg.getText();
        Search search = (Search)arg.getSource();
        String key = search.getKey();
        if (SWCStringUtils.equals((String)key, (String)"treesearchap")) {
            this.treeSearch(searchText);
        } else if (SWCStringUtils.equals((String)key, (String)"columnsearchap")) {
            this.tableSearch(searchText);
        }
    }

    private void tableSearch(String searchText) {
        if (SWCStringUtils.isEmpty((String)searchText)) {
            return;
        }
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("itemselectentry");
        if (SWCObjectUtils.isEmpty((Object)entryDatas)) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] selectRows = grid.getSelectRows();
        List<Integer> matchLine = this.getMatchColumn(entryDatas, searchText);
        if (selectRows.length == 0 || selectRows.length > 1) {
            if (matchLine.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalPersonAddItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else {
                grid.selectRows(matchLine.get(0).intValue(), true);
            }
            return;
        }
        if (matchLine.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalPersonAddItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (matchLine.size() == 1) {
            grid.selectRows(matchLine.get(0).intValue(), true);
            return;
        }
        if (this.isMatch(selectRows, matchLine)) {
            if (selectRows[0] == matchLine.get(0)) {
                grid.selectRows(matchLine.get(1).intValue(), true);
            } else if (selectRows[0] == matchLine.get(matchLine.size() - 1)) {
                grid.selectRows(matchLine.get(0).intValue(), true);
            } else {
                for (int i = 0; i < matchLine.size(); ++i) {
                    if (matchLine.get(i) != selectRows[0]) continue;
                    grid.selectRows(matchLine.get(i + 1).intValue(), true);
                    return;
                }
            }
            return;
        }
        grid.selectRows(matchLine.get(0).intValue(), true);
    }

    public boolean isMatch(int[] selectRows, List<Integer> matchLine) {
        int selectRow = selectRows[0];
        for (Integer index : matchLine) {
            if (selectRow != index) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getMatchColumn(DynamicObjectCollection entryDatas, String searchText) {
        ArrayList<Integer> matchLine = new ArrayList<Integer>(10);
        int size = entryDatas.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dataObj = (DynamicObject)entryDatas.get(i);
            String itemName = dataObj.getString("itemname");
            if (!itemName.contains(searchText)) continue;
            matchLine.add(i);
        }
        return matchLine;
    }

    /*
     * WARNING - void declaration
     */
    private void treeSearch(String searchText) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get("cal_person_tree", String.class);
        Map rootMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        if (SWCStringUtils.isEmpty((String)searchText)) {
            for (Map.Entry entry : rootMap.entrySet()) {
                TreeNode treeNode = (TreeNode)entry.getValue();
                TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
                treeView.deleteAllNodes();
                treeView.addNode(treeNode);
            }
        }
        ArrayList<TreeNode> fourthList = new ArrayList<TreeNode>(10);
        this.getTreeNodeBySearchText(fourthList, rootMap, searchText);
        if (fourthList == null || fourthList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalPersonAddItemPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, void> thirdMap = new LinkedHashMap<String, void>(16);
        for (TreeNode treeNode : fourthList) {
            void var10_18;
            String string = treeNode.getParentid();
            TreeNode treeNode2 = (TreeNode)thirdMap.get(string);
            if (treeNode2 == null) {
                TreeNode treeNode3 = this.getTreeNodeByTreeId(rootMap, string);
                treeNode3.setIsOpened(true);
                treeNode3.setChildren(null);
            }
            var10_18.addChild(treeNode);
            thirdMap.put(string, var10_18);
        }
        LinkedHashMap<String, TreeNode> secondMap = new LinkedHashMap<String, TreeNode>(16);
        for (Map.Entry entry : thirdMap.entrySet()) {
            TreeNode treeNode = (TreeNode)entry.getValue();
            String parentId = treeNode.getParentid();
            TreeNode secondNode = (TreeNode)secondMap.get(parentId);
            if (secondNode == null) {
                secondNode = this.getTreeNodeByTreeId(rootMap, parentId);
                secondNode.setIsOpened(true);
                secondNode.setChildren(null);
            }
            secondNode.addChild(treeNode);
            secondMap.put(parentId, secondNode);
        }
        TreeNode treeNode = new TreeNode();
        treeNode.setId("all");
        treeNode.setParentid("");
        treeNode.setText(ResManager.loadKDString((String)"\u5b57\u6bb5\u6765\u6e90", (String)"CalPersonAddItemPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        treeNode.setIsOpened(true);
        for (Map.Entry entry : secondMap.entrySet()) {
            TreeNode secondNode = (TreeNode)entry.getValue();
            treeNode.addChild(secondNode);
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE_VIEW);
        treeView.deleteAllNodes();
        treeView.addNode(treeNode);
    }

    private void getTreeNodeBySearchText(List<TreeNode> fourthList, Map<String, TreeNode> rootMap, String searchText) {
        for (Map.Entry<String, TreeNode> entry : rootMap.entrySet()) {
            TreeNode treeNode = entry.getValue();
            this.getSubTreeNodeBySearchText(fourthList, treeNode, searchText);
        }
    }

    private void getSubTreeNodeBySearchText(List<TreeNode> fourthList, TreeNode treeNode, String searchText) {
        List childNodes = treeNode.getChildren();
        if (childNodes != null && childNodes.size() > 0) {
            for (TreeNode childNode : childNodes) {
                this.getSubTreeNodeBySearchText(fourthList, childNode, searchText);
            }
        } else {
            String name = treeNode.getText();
            if (name.contains(searchText)) {
                TreeNode newNode = new TreeNode();
                this.copyTreeNode(newNode, treeNode);
                fourthList.add(newNode);
            }
        }
    }

    public void btnOkClickEvent() {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("itemselectentry");
        if (entryDatas == null || entryDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u9879\u76ee\u3002", (String)"CalPersonAddItemPlugin_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)entryDatas);
        this.getView().close();
    }
}

