/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calresulttpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.WtcInteCfgConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class CalResultTplItemTreePlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getView().getControl("treesearchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent arg) {
        String searchText = arg.getText();
        List<TreeNode> nodeItemList = null;
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get("allItemData", Map.class);
        boolean isExpend = false;
        if (!SWCStringUtils.isEmpty((String)searchText)) {
            isExpend = true;
        }
        nodeItemList = this.loadFTTreeNodeList(searchText, isExpend, dataMap);
        nodeItemList.addAll(this.loadSLItemChildNode(searchText, isExpend, dataMap));
        nodeItemList.addAll(CalResultTplItemTreePlugin.loadBSTreeNodeList(searchText, isExpend, dataMap));
        nodeItemList.addAll(this.loadSPTreeNodeList(searchText, isExpend, dataMap));
        nodeItemList.addAll(this.loadACTreeNodeList(searchText, isExpend, dataMap));
        if (ObjectUtils.isEmpty(nodeItemList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalResultTplItemTreePlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.addNodes(nodeItemList);
        this.checkSelectedTreeNode(treeView, nodeItemList);
    }

    private void checkSelectedTreeNode(TreeView treeView, List<TreeNode> nodeList) {
        DynamicObjectCollection selectDatas = this.getView().getModel().getEntryEntity("itemselectentry");
        Set uniqueCodeSet = selectDatas.stream().map(selectData -> selectData.getString("itemunicodeid")).collect(Collectors.toSet());
        List checkNodeList = FormulaItemOrFuncTreeHelper.getCheckTreeNodeList(nodeList, uniqueCodeSet);
        if (CollectionUtils.isNotEmpty((Collection)checkNodeList)) {
            treeView.checkNodes(checkNodeList);
        }
    }

    private List<TreeNode> loadACTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List<Map<String, Object>> result = null;
        result = name == null ? FormulaDataServiceHelper.mapToList(dataMap.get("ackey")) : this.findItemByName(name, "ackey", dataMap);
        if (result == null || result.size() == 0) {
            return new ArrayList<TreeNode>(10);
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(result.size());
        for (Map<String, Object> acc : result) {
            treeNodeList.add(new TreeNode("_@_AC", String.valueOf(acc.get("uniquecode")), (String)acc.get("name")));
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (treeNodeList.size() > 0) {
            TreeNode node = new TreeNode("", "_@_AC", ResManager.loadKDString((String)"\u7d2f\u52a0\u5668-AC", (String)"FormulaItemOrFuncTreeHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]));
            node.setChildren(treeNodeList);
            node.setExpend(isExpend);
            node.setIsOpened(isExpend);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TreeNode> loadFTTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List<Map<String, Object>> result = null;
        result = name == null ? FormulaDataServiceHelper.mapToList(dataMap.get("ftitemkey")) : this.findItemByName(name, "ftitemkey", dataMap);
        if (result == null || result.size() == 0) {
            return new ArrayList<TreeNode>(10);
        }
        HashMap<String, ArrayList<TreeNode>> ftNodeMap = new HashMap<String, ArrayList<TreeNode>>(result.size());
        LinkedHashMap<String, TreeNode> ftGroupNodeMap = new LinkedHashMap<String, TreeNode>(result.size());
        List<Object> ftNodeList = null;
        String ftItemGroupNumber = null;
        for (Map<String, Object> ftItem : result) {
            ftItemGroupNumber = (String)ftItem.get("ftItemGroupNumber");
            ftNodeList = (ArrayList<TreeNode>)ftNodeMap.get(ftItemGroupNumber);
            if (ftNodeList == null) {
                ftNodeList = new ArrayList<TreeNode>(10);
            }
            ftNodeList.add(new TreeNode(ftItemGroupNumber + "_@_" + "FT", String.valueOf(ftItem.get("uniquecode")), (String)ftItem.get("name")));
            ftNodeMap.put(ftItemGroupNumber, (ArrayList<TreeNode>)ftNodeList);
            if (ftGroupNodeMap.containsKey(ftItemGroupNumber)) continue;
            ftGroupNodeMap.put(ftItemGroupNumber, new TreeNode("_@_FT", ftItemGroupNumber + "_@_" + "FT", (String)ftItem.get("ftItemGroupName")));
        }
        TreeNode ftGroupNode = null;
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(ftGroupNodeMap.size());
        for (Map.Entry entry : ftGroupNodeMap.entrySet()) {
            ftGroupNode = (TreeNode)entry.getValue();
            ftNodeList = (List)ftNodeMap.get(entry.getKey());
            ftGroupNode.setChildren(ftNodeList);
            ftGroupNode.setExpend(isExpend);
            ftGroupNode.setIsOpened(isExpend);
            treeNodeList.add(ftGroupNode);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (treeNodeList.size() > 0) {
            TreeNode node = new TreeNode("", "_@_FT", ResManager.loadKDString((String)"\u53d6\u6570\u9879\u76ee-FT", (String)"FormulaItemOrFuncTreeHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]));
            node.setChildren(treeNodeList);
            node.setExpend(isExpend);
            node.setIsOpened(isExpend);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TreeNode> loadSLItemChildNode(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        List<Map<String, Object>> salaryItemList = null;
        salaryItemList = SWCStringUtils.isEmpty((String)name) ? FormulaDataServiceHelper.mapToList(dataMap.get("salaryitemkey")) : this.findItemByName(name, "salaryitemkey", dataMap);
        if (salaryItemList == null || salaryItemList.size() == 0) {
            return childNodes;
        }
        LinkedHashMap<String, TreeNode> itemTypeNodeMap = new LinkedHashMap<String, TreeNode>(salaryItemList.size());
        HashMap salaryItemNodeMap = new HashMap(16);
        List<TreeNode> treeNodeList = null;
        String itemTypeNum = null;
        for (Map<String, Object> map : salaryItemList) {
            itemTypeNum = (String)map.get("salaryitemtype_number");
            String string = (String)map.get("salaryitemtype_name");
            treeNodeList = (List)salaryItemNodeMap.get(itemTypeNum);
            if (treeNodeList == null) {
                treeNodeList = new ArrayList(10);
                salaryItemNodeMap.put(itemTypeNum, treeNodeList);
            }
            treeNodeList.add(new TreeNode(itemTypeNum + "_@_" + "SL", String.valueOf(map.get("uniquecode")), (String)map.get("name")));
            if (itemTypeNodeMap.containsKey(itemTypeNum)) continue;
            TreeNode itemTreeNode = new TreeNode("SL", itemTypeNum + "_@_" + "SL", string);
            itemTreeNode.setExpend(isExpend);
            itemTreeNode.setIsOpened(isExpend);
            itemTypeNodeMap.put(itemTypeNum, itemTreeNode);
        }
        treeNodeList = new ArrayList(itemTypeNodeMap.size());
        TreeNode typeNode = null;
        for (Map.Entry entry : itemTypeNodeMap.entrySet()) {
            typeNode = (TreeNode)entry.getValue();
            typeNode.setChildren((List)salaryItemNodeMap.get(entry.getKey()));
            treeNodeList.add(typeNode);
        }
        if (!ObjectUtils.isEmpty(treeNodeList)) {
            TreeNode treeNode = new TreeNode("", "SL", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee-SL", (String)"FormulaItemOrFuncTreeHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            treeNode.setChildren(treeNodeList);
            treeNode.setExpend(isExpend);
            treeNode.setIsOpened(isExpend);
            childNodes.add(treeNode);
        }
        return childNodes;
    }

    public static List<TreeNode> loadBSTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List<Map<String, Object>> result = new ArrayList(0);
        List attResult = new ArrayList(0);
        if (name == null) {
            result = FormulaDataServiceHelper.mapToList(dataMap.get("bsitemkey"));
            if (CalResultTplItemTreePlugin.isEnableWtcInte()) {
                attResult = FormulaDataServiceHelper.mapToList(dataMap.get("bsattitemkey"));
            }
        } else {
            result = FormulaDataServiceHelper.findItemByName((String)name, (String)"bsitemkey", dataMap);
            if (CalResultTplItemTreePlugin.isEnableWtcInte()) {
                attResult = FormulaDataServiceHelper.findItemByName((String)name, (String)"bsattitemkey", dataMap);
            }
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (result.size() == 0 && attResult.size() == 0) {
            return nodeList;
        }
        TreeNode node = new TreeNode("", "_@_ALL", ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee-BS", (String)"FormulaItemOrFuncTreeHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
        node.setExpend(isExpend);
        node.setIsOpened(isExpend);
        nodeList.add(node);
        List bsNodeList = null;
        String bizTypNumber = null;
        List<TreeNode> treeNodeList = CalResultTplItemTreePlugin.getTreeNodes(isExpend, result);
        if (CalResultTplItemTreePlugin.isEnableWtcInte()) {
            ArrayList<TreeNode> childrenList = new ArrayList<TreeNode>(10);
            TreeNode bizItemNode = new TreeNode("_@_ALL", "_@_BS", ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee", (String)"FormulaItemOrFuncTreeHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]));
            bizItemNode.setExpend(isExpend);
            bizItemNode.setIsOpened(isExpend);
            childrenList.add(bizItemNode);
            TreeNode attItemNode = new TreeNode("_@_ALL", "ATT_@_BS", ResManager.loadKDString((String)"\u8003\u52e4\u4e1a\u52a1\u9879\u76ee", (String)"FormulaItemOrFuncTreeHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]));
            attItemNode.setExpend(isExpend);
            attItemNode.setIsOpened(isExpend);
            childrenList.add(attItemNode);
            node.setChildren(childrenList);
            bizItemNode.setChildren(treeNodeList);
            HashMap<String, List<TreeNode>> attBsNodeMap = new HashMap<String, List<TreeNode>>(result.size());
            LinkedHashMap<String, TreeNode> attBsTypeNodeMap = new LinkedHashMap<String, TreeNode>(result.size());
            if (!ObjectUtils.isEmpty(attResult)) {
                for (Map bsItem : attResult) {
                    bizTypNumber = (String)bsItem.get("bizTypeNumber");
                    CalResultTplItemTreePlugin.getTreeNodeList(attBsNodeMap, attBsTypeNodeMap, bizTypNumber, bsItem, "ATT_@_");
                }
            }
            TreeNode bsTypeNode1 = null;
            ArrayList<TreeNode> attTreeNodeList = new ArrayList<TreeNode>(attBsTypeNodeMap.size());
            for (Map.Entry entry : attBsTypeNodeMap.entrySet()) {
                bsTypeNode1 = (TreeNode)entry.getValue();
                bsNodeList = (List)attBsNodeMap.get(entry.getKey());
                bsTypeNode1.setChildren(bsNodeList);
                bsTypeNode1.setExpend(isExpend);
                bsTypeNode1.setIsOpened(isExpend);
                attTreeNodeList.add(bsTypeNode1);
            }
            attItemNode.setChildren(attTreeNodeList);
        } else {
            node.setChildren(treeNodeList);
        }
        return nodeList;
    }

    @NotNull
    private static List<TreeNode> getTreeNodes(boolean isExpend, List<Map<String, Object>> result) {
        HashMap<String, List<TreeNode>> bsNodeMap = new HashMap<String, List<TreeNode>>(result.size());
        LinkedHashMap<String, TreeNode> bsTypeNodeMap = new LinkedHashMap<String, TreeNode>(result.size());
        for (Map<String, Object> bsItem : result) {
            String bizTypNumber = (String)bsItem.get("bizTypeNumber");
            CalResultTplItemTreePlugin.getTreeNodeList(bsNodeMap, bsTypeNodeMap, bizTypNumber, bsItem, "_@_");
        }
        TreeNode bsTypeNode = null;
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(bsTypeNodeMap.size());
        for (Map.Entry entry : bsTypeNodeMap.entrySet()) {
            bsTypeNode = (TreeNode)entry.getValue();
            List bsNodeList = (List)bsNodeMap.get(entry.getKey());
            bsTypeNode.setChildren(bsNodeList);
            bsTypeNode.setExpend(isExpend);
            bsTypeNode.setIsOpened(isExpend);
            treeNodeList.add(bsTypeNode);
        }
        return treeNodeList;
    }

    private static boolean isEnableWtcInte() {
        Map paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((String)"wtcinte");
        boolean enableWtcInte = Boolean.FALSE;
        if (paramMap != null) {
            Boolean wtcinte = (Boolean)paramMap.get("enableWtcInte");
            Integer scheme = paramMap.getOrDefault("scheme", WtcInteCfgConstants.FIELD_SCHEME_THREE);
            if (wtcinte.booleanValue() && (WtcInteCfgConstants.FIELD_SCHEME_ONE.equals(scheme) || WtcInteCfgConstants.FIELD_SCHEME_TWO.equals(scheme))) {
                enableWtcInte = Boolean.TRUE;
            }
        }
        return enableWtcInte;
    }

    private static void getTreeNodeList(Map<String, List<TreeNode>> bsNodeMap, Map<String, TreeNode> bsTypeNodeMap, String bizTypNumber, Map<String, Object> bsItem, String prefixKey) {
        TreeNode bsNode = new TreeNode(bizTypNumber + "_@_" + "BS", String.valueOf(bsItem.get("uniquecode")), (String)bsItem.get("name"));
        List bsNodeList = bsNodeMap.getOrDefault(bizTypNumber, new ArrayList(10));
        bsNodeList.add(bsNode);
        bsNodeMap.put(bizTypNumber, bsNodeList);
        if (!bsTypeNodeMap.containsKey(bizTypNumber)) {
            bsTypeNodeMap.put(bizTypNumber, new TreeNode(prefixKey + "BS", bizTypNumber + "_@_" + "BS", (String)bsItem.get("bizTypeName")));
        }
    }

    private List<TreeNode> loadSPTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List<Map<String, Object>> result = null;
        result = name == null ? FormulaDataServiceHelper.mapToList(dataMap.get("spitemkey")) : this.findItemByName(name, "spitemkey", dataMap);
        if (result == null || result.size() == 0) {
            return new ArrayList<TreeNode>(10);
        }
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(result.size());
        for (Map<String, Object> spItem : result) {
            treeNodeList.add(new TreeNode("_@_SP", String.valueOf(spItem.get("uniquecode")), (String)spItem.get("name")));
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (treeNodeList.size() > 0) {
            TreeNode node = new TreeNode("", "_@_SP", ResManager.loadKDString((String)"\u652f\u6301\u9879\u76ee-SP", (String)"FormulaItemOrFuncTreeHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]));
            node.setChildren(treeNodeList);
            node.setExpend(isExpend);
            node.setIsOpened(isExpend);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<Map<String, Object>> findItemByName(String name, String itemName, Map<String, Map<String, Map<String, Object>>> dataMap) {
        ArrayList<Map<String, Object>> filterItemsList = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> result = dataMap.get(itemName);
        if (result == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            Map<String, Object> itemMap = entry.getValue();
            if (itemMap == null || itemMap.size() == 0) {
                if (!entry.getKey().contains(name)) continue;
                filterItemsList.add(entry.getValue());
                continue;
            }
            String number = (String)itemMap.get("number");
            if (!SWCStringUtils.isNotEmpty((String)number) || !number.contains(name) && !entry.getKey().contains(name)) continue;
            filterItemsList.add(entry.getValue());
        }
        return filterItemsList;
    }
}

