/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.calview;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalSortColumnPlugin
extends AbstractBillPlugIn
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener,
TreeNodeCheckListener {
    private static final Log logger = LogFactory.getLog(CalSortColumnPlugin.class);
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_ROOT = "root";
    private static final String SORT_PRIORITY = "sortpriority";
    private static final String FIELD_NAME = "fieldname";
    private static final String TREE_NODE = "treeNode";
    private static final String SEARCH_TEXT = "searchText";
    private static final String COLUMN_ENTRY_ENTITY = "columnentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        this.addClickListeners(new String[]{"btn_add"});
        this.addClickListeners(new String[]{"btn_remove"});
        this.addClickListeners(new String[]{"btn_confirm"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : entryEntity) {
            String fieldname = dynamicObject.getString(FIELD_NAME);
            String sort = dynamicObject.getString("sort");
            if ("0".equals(sort)) continue;
            if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                String fieldKey = dynamicObject.getString("sourcekey") + '.' + dynamicObject.getString("fieldkey");
                sortList.add(fieldKey);
                continue;
            }
            sortList.add(fieldname);
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.setMulti(true);
        String text = "";
        List<TreeNode> treeNodeList = this.buildTree(entryEntity, text, sortList, Boolean.FALSE);
        try {
            String treeNodeStr = null;
            treeNodeStr = SWCJSONUtils.toString(treeNodeList);
            this.getPageCache().put(TREE_NODE, treeNodeStr);
            this.getPageCache().put(SEARCH_TEXT, text);
        }
        catch (IOException exception) {
            logger.error(exception.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalSortColumnPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        this.buildTable(entryEntity);
    }

    private void buildTable(DynamicObjectCollection entryEntity) {
        int newSize = 0;
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : entryEntity) {
            String sortpriority = dynamicObject.getString(SORT_PRIORITY);
            if ("0".equals(sortpriority)) continue;
            ++newSize;
            resultMap.put(sortpriority, dynamicObject);
        }
        if (newSize == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, newSize);
        int index = 0;
        for (int i = 1; i <= 5; ++i) {
            DynamicObject dynamicObject = (DynamicObject)resultMap.get(String.valueOf(i));
            if (dynamicObject == null) continue;
            if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                String fieldKey = dynamicObject.getString("sourcekey") + '.' + dynamicObject.getString("fieldkey");
                this.getModel().setValue("fieldkey", (Object)fieldKey, index);
            }
            this.getModel().setValue(FIELD_NAME, (Object)dynamicObject.getString(FIELD_NAME), index);
            this.getModel().setValue(SORT_PRIORITY, (Object)(index + 1), index);
            this.getModel().setValue("sort", (Object)dynamicObject.getString("sort"), index);
            ++index;
        }
    }

    private List<TreeNode> buildTree(DynamicObjectCollection entryEntityentryEntity, String text, List<String> sortList, Boolean isSearch) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        treeView.addNode(this.getRootNode());
        treeView.setMulti(true);
        treeView.setRootVisible(true);
        treeView.expand(KEY_ROOT);
        treeView.setDraggable(true);
        treeView.setDroppable(true);
        SWCDataServiceHelper calFieldHelper = new SWCDataServiceHelper("hsbs_callistfieldcfg");
        QFilter numberFilter = new QFilter("type", "=", (Object)"operation");
        DynamicObject[] fields = calFieldHelper.query("field,type,number", new QFilter[]{numberFilter});
        Set operatFields = Arrays.stream(fields).map(o -> o.getString("field")).collect(Collectors.toSet());
        if (text.isEmpty()) {
            for (int i = 0; i < entryEntityentryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntityentryEntity.get(i);
                String fieldkey = dynamicObject.getString("fieldkey");
                String field = dynamicObject.getString("field");
                if (operatFields.contains(field)) continue;
                String fieldname = dynamicObject.getString(FIELD_NAME);
                if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                    String key = dynamicObject.getString("sourcekey") + '.' + dynamicObject.getString("fieldkey");
                    if (sortList.contains(key)) continue;
                    nodes.add(new TreeNode(KEY_ROOT, key, dynamicObject.getString(FIELD_NAME)));
                    continue;
                }
                if ("salaryitem".equals(fieldkey) || sortList.contains(fieldname)) continue;
                nodes.add(new TreeNode(KEY_ROOT, String.valueOf(i), dynamicObject.getString(FIELD_NAME)));
            }
        } else {
            boolean flag = false;
            for (int i = 0; i < entryEntityentryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntityentryEntity.get(i);
                String fieldkey = dynamicObject.getString("fieldkey");
                String field = dynamicObject.getString("field");
                if (operatFields.contains(field)) continue;
                String fieldname = dynamicObject.getString(FIELD_NAME);
                if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                    String key = dynamicObject.getString("sourcekey") + '.' + dynamicObject.getString("fieldkey");
                    if (!fieldname.contains(text) || sortList.contains(key)) continue;
                    nodes.add(new TreeNode(KEY_ROOT, key, dynamicObject.getString(FIELD_NAME)));
                    flag = true;
                    continue;
                }
                if (!fieldname.contains(text) || "salaryitem".equals(fieldkey) || sortList.contains(fieldname)) continue;
                nodes.add(new TreeNode(KEY_ROOT, String.valueOf(i), dynamicObject.getString(FIELD_NAME)));
                flag = true;
            }
            if (!flag && isSearch.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CalSortColumnPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
        treeView.addNodes(nodes);
        return nodes;
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode("", KEY_ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"CalSortColumnPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        return root;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String key = ctlSource.getKey();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        switch (key) {
            case "btn_add": {
                this.checkIsNeedAddSortColumn(entryentity);
                break;
            }
            case "btn_remove": {
                this.removeSortColumn(entryentity);
                break;
            }
            case "btn_confirm": {
                this.saveSortColumn(entryentity);
                break;
            }
        }
    }

    private void saveSortColumn(DynamicObjectCollection entryEntity) {
        HashMap<String, DynamicObjectCollection> sortColumnMap = new HashMap<String, DynamicObjectCollection>();
        sortColumnMap.put("sortEntryEntity", entryEntity);
        this.getView().setReturnData(sortColumnMap);
        this.getView().close();
    }

    private void removeSortColumn(DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            int seq = dynamicObject.getInt("seq");
            dynamicObject.set(SORT_PRIORITY, (Object)seq);
        }
        this.rebuildLeftTree(Boolean.FALSE);
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private void checkIsNeedAddSortColumn(DynamicObjectCollection entryEntity) {
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        List selectedNodesList = tree.getTreeState().getSelectedNodes();
        ArrayList<Map<String, Object>> resultNodesList = new ArrayList<Map<String, Object>>();
        for (Map selectedNodes : selectedNodesList) {
            String id = (String)selectedNodes.get("id");
            if (KEY_ROOT.equals(id)) continue;
            resultNodesList.add(selectedNodes);
        }
        int selectSize = resultNodesList.size();
        if (selectSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CalSortColumnPlugin_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int cunt = model.getEntryRowCount(KEY_ENTRYENTITY);
        int totalSize = cunt + selectSize;
        if (totalSize > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6027\u80fd\uff0c\u53ef\u9009\u62e95\u4e2a\u4ee5\u5185\u7684\u5b57\u6bb5\u4f5c\u4e3a\u6392\u5e8f\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalSortColumnPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.addSortEntryRow(entryEntity, resultNodesList, model, cunt);
        this.rebuildLeftTree(Boolean.FALSE);
    }

    private void addSortEntryRow(DynamicObjectCollection entryEntity, List<Map<String, Object>> resultNodesList, AbstractFormDataModel model, int cunt) {
        HashMap fieldNameMap = new HashMap();
        int newSize = 0;
        for (Map<String, Object> selectedNodes : resultNodesList) {
            String fieldName = (String)selectedNodes.get("text");
            if (fieldNameMap.containsKey(fieldName)) continue;
            ++newSize;
        }
        if (newSize == 0) {
            return;
        }
        model.batchCreateNewEntryRow(KEY_ENTRYENTITY, newSize);
        int tag = 0;
        DynamicObjectCollection parentEtryEntity = this.getParentEntryEntity();
        for (Map<String, Object> selectedNodes : resultNodesList) {
            String fieldName = (String)selectedNodes.get("text");
            if (fieldNameMap.containsKey(fieldName)) continue;
            if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                String fieldKey = selectedNodes.get("id").toString();
                this.getModel().setValue("fieldkey", (Object)fieldKey, cunt + tag);
            }
            this.getModel().setValue(FIELD_NAME, (Object)fieldName, cunt + tag);
            this.getModel().setValue("sort", (Object)"1", cunt + tag);
            this.getModel().setValue(SORT_PRIORITY, (Object)(cunt + tag + 1), cunt + tag);
            ++tag;
        }
        this.getView().sendFormAction(this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("moveentryup".equals(opKey) || "moveentrydown".equals(opKey)) {
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
            for (DynamicObject dynamicObject : entryEntity) {
                int seq = dynamicObject.getInt("seq");
                dynamicObject.set(SORT_PRIORITY, (Object)seq);
            }
            entryEntity.size();
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().updateView(SORT_PRIORITY, i);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        String text = evt.getText();
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        DynamicObjectCollection rightEntryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : rightEntryEntity) {
            if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                String key = dynamicObject.getString("fieldkey");
                sortList.add(key);
                continue;
            }
            String fieldname = dynamicObject.getString(FIELD_NAME);
            sortList.add(fieldname);
        }
        this.updateTreeNodeCache(entryEntity, sortList, text, Boolean.TRUE);
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        Object returnData = this.getView().getReturnData();
        if (returnData != null) {
            this.getView().returnDataToParent(returnData);
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        Object nodeId = e.getNodeId();
        if (KEY_ROOT.equals(nodeId)) {
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
            String treeNodeStr = this.getPageCache().get(TREE_NODE);
            Boolean flag = e.getChecked();
            try {
                List treeNodeList = JSON.parseArray((String)treeNodeStr, TreeNode.class);
                if (flag.booleanValue()) {
                    treeView.checkNodes(treeNodeList);
                } else {
                    List ids = treeNodeList.stream().map(TreeNode::getId).collect(Collectors.toList());
                    treeView.uncheckNodes(ids);
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalSortColumnPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObjectCollection getParentEntryEntity() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        IDataModel model = parentView.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(COLUMN_ENTRY_ENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            return null;
        }
        return entryEntity;
    }

    private void rebuildLeftTree(Boolean isSearch) {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView.deleteAllNodes();
        DynamicObjectCollection entryEntity = this.getParentEntryEntity();
        if (entryEntity == null) {
            return;
        }
        DynamicObjectCollection rightEntryEntity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
        ArrayList<String> sortList = new ArrayList<String>();
        for (DynamicObject dynamicObject : rightEntryEntity) {
            if (SWCStringUtils.equals((String)this.getView().getParentView().getEntityId(), (String)"hsas_callistview")) {
                String fieldKey = dynamicObject.getString("fieldkey");
                sortList.add(fieldKey);
                continue;
            }
            String fieldname = dynamicObject.getString(FIELD_NAME);
            sortList.add(fieldname);
        }
        String text = this.getPageCache().get(SEARCH_TEXT);
        this.updateTreeNodeCache(entryEntity, sortList, text, isSearch);
    }

    private void updateTreeNodeCache(DynamicObjectCollection entryEntity, List<String> sortList, String text, Boolean isSearch) {
        TreeView treeView1 = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        treeView1.setMulti(true);
        List<TreeNode> treeNodeList = this.buildTree(entryEntity, text, sortList, isSearch);
        try {
            String treeNodeStr = null;
            treeNodeStr = SWCJSONUtils.toString(treeNodeList);
            this.getPageCache().put(TREE_NODE, treeNodeStr);
            this.getPageCache().put(SEARCH_TEXT, text);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalSortColumnPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }
}

