/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.checkscheme;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCNumberValidateUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class ResultCheckSchemeEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String SYSTEM_TYPE = "swc-hsas-formplugin";
    private static final Log log = LogFactory.getLog(ResultCheckSchemeEdit.class);
    private static final String IS_CONTINUE_CLOSE = "afterconfirm";
    private static final String IS_SAVE_CLOSE = "saveClose";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "modifybtn": {
                if ("0".equals(this.getModel().getDataEntity().getString("enable"))) {
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"modifybtn", "bar_disable"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                this.getView().updateView("modifybtn");
                this.getView().updateView("bar_disable");
                this.getView().updateView("bar_save");
                break;
            }
        }
    }

    private boolean showCloseConfirm(String operateKey) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        IFormView view = this.getView();
        SWCPageCache cache = new SWCPageCache(view);
        String entryPageId = (String)cache.get(view.getPageId(), String.class);
        boolean mainDataChanged = this.getView().getModel().getDataChanged();
        String mainDataChangedDesc = this.getView().getModel().getChangeDesc();
        boolean entryDataChanged = this.getView().getView(entryPageId).getModel().getDataChanged();
        Boolean isContinueChange = (Boolean)pageCache.get(IS_CONTINUE_CLOSE, Boolean.class);
        Boolean isSaveClose = (Boolean)pageCache.get(IS_SAVE_CLOSE, Boolean.class);
        if (isSaveClose != null && isSaveClose.booleanValue()) {
            return false;
        }
        if (isContinueChange == null) {
            isContinueChange = Boolean.FALSE;
        }
        if (!isContinueChange.booleanValue() && (entryDataChanged || mainDataChanged)) {
            StringBuilder descSb = new StringBuilder();
            this.getView().getView(entryPageId).getModel().setDataChanged(entryDataChanged);
            String changeDesc = this.getView().getView(entryPageId).getModel().getChangeDesc();
            if (SWCStringUtils.isNotEmpty((String)mainDataChangedDesc)) {
                descSb.append(mainDataChangedDesc).append("\r\n");
            }
            if (SWCStringUtils.isNotEmpty((String)changeDesc)) {
                descSb.append(changeDesc);
            }
            if (descSb.length() > 0) {
                ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("resultCheckSchemeCallBack", (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ResultCheckSchemeEdit_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ResultCheckSchemeEdit_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ResultCheckSchemeEdit_14", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                this.getView().showConfirm(msg, descSb.toString(), options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
                this.getView().getPageCache().put("operateKey", operateKey);
                return true;
            }
        }
        return false;
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setStatus(OperationStatus.VIEW);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initItemEntry();
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "additem", "delete", "import", "export", "moveup", "movedown"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"itementry"});
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "chainincrease": 
            case "chaingrowth": 
            case "yearincrease": 
            case "yeargrowth": {
                this.openItemEntryPage();
                break;
            }
        }
    }

    public void pageRelease(EventObject e) {
        String pageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)"resultCheck");
        String cacheKey = String.format(Locale.ROOT, "resultCheckItemEntry_%s", pageId);
        appCache.remove(cacheKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String optKey = formOperate.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"first") || SWCStringUtils.equals((String)optKey, (String)"previous") || SWCStringUtils.equals((String)optKey, (String)"next") || SWCStringUtils.equals((String)optKey, (String)"last")) {
            boolean ret;
            if (SWCStringUtils.isEmpty((String)formOperate.getOption().getVariableValue("ignoreCheck", null)) && (ret = this.showCloseConfirm(optKey))) {
                args.setCancel(true);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"modifybtn", "bar_disable"});
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_delete") || SWCStringUtils.equals((String)optKey, (String)"donothing_import") || SWCStringUtils.equals((String)optKey, (String)"donothing_export") || SWCStringUtils.equals((String)optKey, (String)"donothing_moveup") || SWCStringUtils.equals((String)optKey, (String)"donothing_movedown")) {
            this.mainPageOpereationInvokeSubPageBeforeEvent(optKey, args);
        } else if (SWCStringUtils.equals((String)optKey, (String)"save")) {
            boolean check;
            String cacheKey;
            String pageId = this.getView().getPageId();
            ISWCAppCache appCache = SWCAppCache.get((String)"resultCheck");
            List itemEntryData = (List)appCache.get(cacheKey = String.format(Locale.ROOT, "resultCheckItemEntry_%s", pageId), List.class);
            if (!SWCListUtils.isEmpty((List)itemEntryData) && !(check = this.checkItemEntryData(itemEntryData))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6307\u6807\u5185\u5bb9\u53ea\u80fd\u4e3a\u201c\u6570\u503c\u201d\u7c7b\u578b\u3002", (String)"ResultCheckSchemeItemEntryPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.fillItemEntryData(itemEntryData);
        } else if (SWCStringUtils.equals((String)optKey, (String)"modify")) {
            if ("0".equals(this.getModel().getDataEntity().getString("enable"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7981\u7528\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"ResultCheckSchemeEdit_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.getView().setStatus(OperationStatus.VIEW);
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save", "additem", "delete", "import", "export", "moveup", "movedown"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modifybtn", "bar_disable", "first", "previous", "next", "last"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"itementry"});
            this.getView().updateView("modifybtn");
            this.getView().updateView("bar_disable");
            this.getView().updateView("bar_save");
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String optKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_additem")) {
            boolean hasGroup = this.checkSelectedPayrollGroup();
            if (!hasGroup) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u85aa\u8d44\u6838\u7b97\u7ec4\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ResultCheckSchemeEdit_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            this.getView().updateView("bar_disable");
            this.openAddItemView();
        } else if (SWCStringUtils.equals((String)optKey, (String)"save")) {
            if (args.getOperationResult().isSuccess()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"additem", "delete", "import", "export", "moveup", "movedown", "bar_save"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"modifybtn", "bar_disable", "first", "previous", "next", "last"});
                this.getView().updateView("modifybtn");
                this.getView().updateView("bar_disable");
                this.getView().updateView("bar_save");
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(IS_SAVE_CLOSE, (Object)Boolean.TRUE);
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.VIEW);
                this.getView().updateView();
                this.getModel().setDataChanged(false);
            }
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_delete")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            this.getView().updateView("bar_disable");
            this.openItemEntryPage();
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_moveup") || SWCStringUtils.equals((String)optKey, (String)"donothing_movedown")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            this.getView().updateView("bar_disable");
        } else if (SWCStringUtils.equals((String)optKey, (String)"disable") || SWCStringUtils.equals((String)optKey, (String)"enable")) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "additemclose": {
                this.addItemCloseEvent(evt);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "resultCheckSchemeCallBack": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                SWCPageCache pageCache = new SWCPageCache(this.getView());
                pageCache.put(IS_CONTINUE_CLOSE, (Object)Boolean.TRUE);
                OperateOption operation = OperateOption.create();
                operation.setVariableValue("ignoreCheck", "1");
                this.getView().invokeOperation(this.getView().getPageCache().get("operateKey"), operation);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isContinueClose = (Boolean)pageCache.get(IS_CONTINUE_CLOSE, Boolean.class);
        if (isContinueClose != null && isContinueClose.booleanValue()) {
            this.getView().getModel().setDataChanged(false);
            return;
        }
        boolean ret = this.showCloseConfirm("close");
        if (ret) {
            event.setCancel(true);
        }
    }

    private boolean checkItemEntryData(List<Map<String, Object>> itemEntryData) {
        boolean flag = true;
        List<String> valueFieldList = Arrays.asList("valueequals", "valueless", "valuebigger", "chainincreasebigger", "chainincreaseless", "chaingrowthbigger", "chaingrowthless", "yearincreasebigger", "yearincreaseless", "yeargrowthbigger", "yeargrowthless");
        for (Map<String, Object> dyObj : itemEntryData) {
            for (Map.Entry<String, Object> entry : dyObj.entrySet()) {
                flag = this.checkSingleValue(valueFieldList, entry);
                if (flag) continue;
                return flag;
            }
        }
        return flag;
    }

    private boolean checkSingleValue(List<String> valueFieldList, Map.Entry<String, Object> entry) {
        boolean checkRet = true;
        String value = entry.getValue() + "";
        if (valueFieldList.contains(entry.getKey()) && SWCStringUtils.isNotEmpty((String)value)) {
            return SWCNumberValidateUtils.isRealNumber((String)value);
        }
        return checkRet;
    }

    private void fillItemEntryData(List<Map<String, Object>> itemEntryData) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("valueentry");
        if (SWCListUtils.isEmpty(itemEntryData)) {
            return;
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemid", new Object[0]);
        vs.addField("itemtype", new Object[0]);
        vs.addField("itemnumber", new Object[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("workbenchshow", new Object[0]);
        vs.addField("valueequals", new Object[0]);
        vs.addField("valueless", new Object[0]);
        vs.addField("valuebigger", new Object[0]);
        vs.addField("chainincreaseless", new Object[0]);
        vs.addField("chainincreasebigger", new Object[0]);
        vs.addField("chaingrowthless", new Object[0]);
        vs.addField("chaingrowthbigger", new Object[0]);
        vs.addField("yearincreaseless", new Object[0]);
        vs.addField("yearincreasebigger", new Object[0]);
        vs.addField("yeargrowthless", new Object[0]);
        vs.addField("yeargrowthbigger", new Object[0]);
        for (Map<String, Object> dyObj : itemEntryData) {
            boolean isBs;
            String itemTypeStr = dyObj.get("itemtype").toString();
            boolean isSl = SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee", (String)"ResultCheckSchemeEdit_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)itemTypeStr) || SWCStringUtils.equals((String)"SL", (String)itemTypeStr);
            boolean bl = isBs = SWCStringUtils.equals((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee", (String)"ResultCheckSchemeEdit_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), (String)itemTypeStr) || SWCStringUtils.equals((String)"BS", (String)itemTypeStr);
            String itemType = isSl ? "SL" : (isBs ? "BS" : "SL");
            String itemId = dyObj.get("itemid").toString();
            String itemNum = dyObj.get("itemnumber").toString();
            String itemName = dyObj.get("itemname").toString();
            boolean workBenchShow = Boolean.parseBoolean(dyObj.get("workbenchshow").toString());
            String valueEquals = dyObj.get("valueequals") + "";
            String valueLess = dyObj.get("valueless") + "";
            String valueBigger = dyObj.get("valuebigger") == null ? "" : dyObj.get("valuebigger") + "";
            String chainIncreaseLess = dyObj.get("chainincreaseless") == null ? "" : dyObj.get("chainincreaseless") + "";
            String chainIncreaseBigger = dyObj.get("chainincreasebigger") == null ? "" : dyObj.get("chainincreasebigger") + "";
            String chainGrowthLess = dyObj.get("chaingrowthless") == null ? "" : dyObj.get("chaingrowthless") + "";
            String chainGrowthBigger = dyObj.get("chaingrowthbigger") == null ? "" : dyObj.get("chaingrowthbigger") + "";
            String yearIncreaseLess = dyObj.get("yearincreaseless") == null ? "" : dyObj.get("yearincreaseless") + "";
            String yearIncreaseBigger = dyObj.get("yearincreasebigger") == null ? "" : dyObj.get("yearincreasebigger") + "";
            String yearGrowthLess = dyObj.get("yeargrowthless") == null ? "" : dyObj.get("yeargrowthless") + "";
            String yearGrowthBigger = dyObj.get("yeargrowthbigger") == null ? "" : dyObj.get("yeargrowthbigger") + "";
            vs.addRow(new Object[]{itemId, itemType, itemNum, itemName, workBenchShow, valueEquals, valueLess, valueBigger, chainIncreaseLess, chainIncreaseBigger, chainGrowthLess, chainGrowthBigger, yearIncreaseLess, yearIncreaseBigger, yearGrowthLess, yearGrowthBigger});
        }
        model.batchCreateNewEntryRow("valueentry", vs);
        model.endInit();
        this.getView().updateView("valueentry");
    }

    private void initItemEntry() {
        this.assembleEntryDataList();
        this.openItemEntryPage();
    }

    private boolean checkSelectedPayrollGroup() {
        DynamicObject payrollgroupObj = (DynamicObject)this.getModel().getDataEntity().get("payrollgroup");
        return payrollgroupObj != null;
    }

    private void assembleEntryDataList() {
        DynamicObjectCollection itemValueEntry = this.getModel().getEntryEntity("valueentry");
        if (itemValueEntry.size() == 0) {
            return;
        }
        String pageId = this.getView().getPageId();
        Map<String, Boolean> checkParamMap = this.getCheckParamMap(this.getModel().getDataEntity());
        ArrayList entryDataList = Lists.newArrayListWithExpectedSize((int)itemValueEntry.size());
        for (DynamicObject dyObj : itemValueEntry) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            map.put("itemid", dyObj.getString("itemid"));
            map.put("itemtype", dyObj.getString("itemtype"));
            map.put("itemnumber", dyObj.getString("itemnumber"));
            map.put("itemname", dyObj.getString("itemname"));
            map.put("workbenchshow", dyObj.getString("workbenchshow"));
            map.put("valueequals", dyObj.getString("valueequals"));
            map.put("valueless", dyObj.getString("valueless"));
            map.put("valuebigger", dyObj.getString("valuebigger"));
            if (checkParamMap.get("chainincrease").booleanValue()) {
                map.put("chainincreaseless", dyObj.getString("chainincreaseless"));
                map.put("chainincreasebigger", dyObj.getString("chainincreasebigger"));
            }
            if (checkParamMap.get("chaingrowth").booleanValue()) {
                map.put("chaingrowthless", dyObj.getString("chaingrowthless"));
                map.put("chaingrowthbigger", dyObj.getString("chaingrowthbigger"));
            }
            if (checkParamMap.get("yearincrease").booleanValue()) {
                map.put("yearincreaseless", dyObj.getString("yearincreaseless"));
                map.put("yearincreasebigger", dyObj.getString("yearincreasebigger"));
            }
            if (checkParamMap.get("yeargrowth").booleanValue()) {
                map.put("yeargrowthless", dyObj.getString("yeargrowthless"));
                map.put("yeargrowthbigger", dyObj.getString("yeargrowthbigger"));
            }
            entryDataList.add(map);
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"resultCheck");
        String cacheKey = String.format(Locale.ROOT, "resultCheckItemEntry_%s", pageId);
        appCache.put(cacheKey, (Object)entryDataList);
    }

    public void addItemCloseEvent(ClosedCallBackEvent evt) {
        DynamicObjectCollection itemDatas = (DynamicObjectCollection)evt.getReturnData();
        if (itemDatas == null || itemDatas.size() == 0) {
            return;
        }
        String pageId = this.getView().getPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)"resultCheck");
        String cacheKey = String.format(Locale.ROOT, "resultCheckItemEntry_%s", pageId);
        ArrayList entryDataList = (ArrayList)appCache.get(cacheKey, List.class);
        HashSet<String> itemList = new HashSet<String>(16);
        if (SWCListUtils.isEmpty((List)entryDataList)) {
            entryDataList = new ArrayList(10);
        } else {
            for (Map map : entryDataList) {
                itemList.add(map.get("itemid").toString());
            }
        }
        for (DynamicObject dynamicObject : itemDatas) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            String itemId = dynamicObject.getString("itemid");
            if (itemList.contains(itemId)) continue;
            String itemCategory = dynamicObject.getString("itemcategory");
            String itemNum = dynamicObject.getString("itemnumber");
            String itemName = dynamicObject.getString("itemname");
            dataMap.put("itemid", itemId);
            dataMap.put("itemtype", itemCategory);
            dataMap.put("itemnumber", itemNum);
            dataMap.put("itemname", itemName);
            dataMap.put("workbenchshow", "0");
            dataMap.put("valueequals", 0);
            dataMap.put("valueless", 0);
            entryDataList.add(dataMap);
        }
        appCache.put(cacheKey, entryDataList);
        this.openItemEntryPage();
    }

    private void openAddItemView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_checkschemeitem");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u9879\u76ee", (String)"ResultCheckSchemeEdit_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "additemclose"));
        this.getView().showForm(showParameter);
    }

    private void mainPageOpereationInvokeSubPageBeforeEvent(String optKey, BeforeDoOperationEventArgs args) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String subPageId = (String)pageCache.get(this.getView().getPageId(), String.class);
        IFormView childView = this.getView().getView(subPageId);
        if (SWCStringUtils.equals((String)optKey, (String)"donothing_delete")) {
            childView.invokeOperation("deleteentry");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_moveup")) {
            childView.invokeOperation("moveentryup");
        } else if (SWCStringUtils.equals((String)optKey, (String)"donothing_movedown")) {
            childView.invokeOperation("moveentrydown");
        } else {
            childView.invokeOperation(optKey);
        }
        this.getView().sendFormAction(childView);
    }

    private void openItemEntryPage() {
        FormShowParameter formShow = new FormShowParameter();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map<String, Boolean> checkParamMap = this.getCheckParamMap(dataEntity);
        OpenStyle openStyle = formShow.getOpenStyle();
        openStyle.setTargetKey("itementry");
        openStyle.setShowType(ShowType.InContainer);
        formShow.setFormId("hsas_checkitementry");
        formShow.setParentPageId(this.getView().getPageId());
        formShow.setCustomParam("paramMap", checkParamMap);
        this.getView().showForm(formShow);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(this.getView().getPageId(), (Object)formShow.getPageId());
    }

    private Map<String, Boolean> getCheckParamMap(DynamicObject dataEntity) {
        boolean chainincrease = dataEntity.getBoolean("chainincrease");
        boolean chaingrowth = dataEntity.getBoolean("chaingrowth");
        boolean yearincrease = dataEntity.getBoolean("yearincrease");
        boolean yeargrowth = dataEntity.getBoolean("yeargrowth");
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("chainincrease", chainincrease);
        map.put("chaingrowth", chaingrowth);
        map.put("yearincrease", yearincrease);
        map.put("yeargrowth", yeargrowth);
        return map;
    }
}

