/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.checkscheme;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.swc.hsas.business.checkscheme.helper.ResultCheckSchemeHelper;
import kd.swc.hsas.business.formula.helper.FormulaDataServiceHelper;
import kd.swc.hsas.business.formula.helper.FormulaItemOrFuncTreeHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ResultCheckSchemeSelectItemPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    public static final String CACHE_TREE = "tree";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search formSearch = (Search)this.getView().getControl("columnsearchap");
        formSearch.addEnterListener((SearchEnterListener)this);
        Search treeSearch = (Search)this.getView().getControl("treesearchap");
        treeSearch.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"btnsave"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        DynamicObject payrollgroupObj = (DynamicObject)this.getView().getParentView().getModel().getDataEntity().get("payrollgroup");
        ResultCheckSchemeHelper helper = new ResultCheckSchemeHelper();
        IDataModel model = this.getModel();
        Map dataMap = helper.getAllItemData(model, payrollgroupObj);
        this.initItemTree(dataMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String optKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (optKey = formOperate.getOperateKey()) {
            case "donothing_moveto": {
                this.openMoveToPage(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        switch (args.getOperateKey()) {
            case "donothing_additem": {
                this.addItem();
                break;
            }
            case "donothing_removeitem": {
                this.removeItem();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btnsave": {
                this.btnOkClickEvent();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "movetoclosed": {
                this.moveToClosedEvent(evt);
                break;
            }
        }
    }

    public void search(SearchEnterEvent arg) {
        String searchText = arg.getText();
        Search search = (Search)arg.getSource();
        String key = search.getKey();
        if (SWCStringUtils.equals((String)key, (String)"treesearchap")) {
            this.treeSearch(searchText);
        } else if (SWCStringUtils.equals((String)key, (String)"columnsearchap")) {
            this.tableSearch(searchText);
        }
    }

    public void btnOkClickEvent() {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("itemselectentry");
        if (entryDatas == null || entryDatas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u9879\u76ee\u3002", (String)"ResultCheckSchemeEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)entryDatas);
        this.getView().close();
    }

    private void tableSearch(String searchText) {
        if (SWCStringUtils.isEmpty((String)searchText)) {
            return;
        }
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity("itemselectentry");
        if (SWCObjectUtils.isEmpty((Object)entryDatas)) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] selectRows = grid.getSelectRows();
        List<Integer> matchLine = this.getMatchColumn(entryDatas, searchText);
        if (selectRows.length == 0 || selectRows.length > 1) {
            if (matchLine.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ResultCheckSchemeEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else {
                grid.selectRows(matchLine.get(0).intValue(), true);
            }
            return;
        }
        if (matchLine.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ResultCheckSchemeEdit_15", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (matchLine.size() == 1) {
            grid.selectRows(matchLine.get(0).intValue(), true);
            return;
        }
        if (this.isMatch(selectRows, matchLine)) {
            if (selectRows[0] == matchLine.get(0)) {
                grid.selectRows(matchLine.get(1).intValue(), true);
            } else if (selectRows[0] == matchLine.get(matchLine.size() - 1)) {
                grid.selectRows(matchLine.get(0).intValue(), true);
            } else {
                for (int i = 0; i < matchLine.size(); ++i) {
                    if (matchLine.get(i) != selectRows[0]) continue;
                    grid.selectRows(matchLine.get(i + 1).intValue(), true);
                    return;
                }
            }
            return;
        }
        grid.selectRows(matchLine.get(0).intValue(), true);
    }

    public List<Integer> getMatchColumn(DynamicObjectCollection entryDatas, String searchText) {
        ArrayList<Integer> matchLine = new ArrayList<Integer>(10);
        int size = entryDatas.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject dataObj = (DynamicObject)entryDatas.get(i);
            String itemName = dataObj.getString("itemname");
            String itemNumber = dataObj.getString("itemnumber");
            if (!itemName.contains(searchText) && !itemNumber.contains(searchText)) continue;
            matchLine.add(i);
        }
        return matchLine;
    }

    public boolean isMatch(int[] selectRows, List<Integer> matchLine) {
        int selectRow = selectRows[0];
        for (Integer index : matchLine) {
            if (selectRow != index) continue;
            return true;
        }
        return false;
    }

    private void treeSearch(String searchText) {
        List<TreeNode> nodeItemList = null;
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get("allItemData", Map.class);
        boolean isExpend = false;
        if (!SWCStringUtils.isEmpty((String)searchText)) {
            isExpend = true;
        }
        nodeItemList = this.loadSLItemChildNode(searchText, isExpend, dataMap);
        nodeItemList.addAll(this.loadBSTreeNodeList(searchText, isExpend, dataMap));
        if (ObjectUtils.isEmpty(nodeItemList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ResultCheckSchemeEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.addNodes(nodeItemList);
    }

    private List<TreeNode> loadBSTreeNodeList(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        List<Map<String, Object>> result = null;
        result = name == null ? FormulaDataServiceHelper.mapToList(dataMap.get("bsitemkey")) : this.findItemByName(name, "bsitemkey", dataMap);
        if (result == null || result.size() == 0) {
            return new ArrayList<TreeNode>(10);
        }
        HashMap<String, ArrayList<TreeNode>> bsNodeMap = new HashMap<String, ArrayList<TreeNode>>(result.size());
        LinkedHashMap<String, TreeNode> bsTypeNodeMap = new LinkedHashMap<String, TreeNode>(result.size());
        List<Object> bsNodeList = null;
        String funcTypNumber = null;
        for (Map<String, Object> bsItem : result) {
            funcTypNumber = (String)bsItem.get("bizTypeNumber");
            bsNodeList = (ArrayList<TreeNode>)bsNodeMap.get(funcTypNumber);
            if (bsNodeList == null) {
                bsNodeList = new ArrayList<TreeNode>(10);
            }
            bsNodeList.add(new TreeNode(funcTypNumber + "_@_" + "BS", String.valueOf(bsItem.get("uniquecode")), (String)bsItem.get("name")));
            bsNodeMap.put(funcTypNumber, (ArrayList<TreeNode>)bsNodeList);
            if (bsTypeNodeMap.containsKey(funcTypNumber)) continue;
            bsTypeNodeMap.put(funcTypNumber, new TreeNode("_@_BS", funcTypNumber + "_@_" + "BS", (String)bsItem.get("bizTypeName")));
        }
        TreeNode bsTypeNode = null;
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(bsTypeNodeMap.size());
        for (Map.Entry entry : bsTypeNodeMap.entrySet()) {
            bsTypeNode = (TreeNode)entry.getValue();
            bsNodeList = (List)bsNodeMap.get(entry.getKey());
            bsTypeNode.setChildren(bsNodeList);
            bsTypeNode.setExpend(isExpend);
            bsTypeNode.setIsOpened(isExpend);
            treeNodeList.add(bsTypeNode);
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        if (treeNodeList.size() > 0) {
            TreeNode node = new TreeNode("", "_@_BS", ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee-BS", (String)"FormulaItemOrFuncTreeHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]));
            node.setChildren(treeNodeList);
            node.setExpend(isExpend);
            node.setIsOpened(isExpend);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TreeNode> loadSLItemChildNode(String name, boolean isExpend, Map<String, Map<String, Map<String, Object>>> dataMap) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(10);
        List<Map<String, Object>> salaryItemList = null;
        salaryItemList = SWCStringUtils.isEmpty((String)name) ? FormulaDataServiceHelper.mapToList(dataMap.get("salaryitemkey")) : this.findItemByName(name, "salaryitemkey", dataMap);
        if (salaryItemList == null || salaryItemList.size() == 0) {
            return childNodes;
        }
        LinkedHashMap<String, TreeNode> itemTypeNodeMap = new LinkedHashMap<String, TreeNode>(salaryItemList.size());
        HashMap salaryItemNodeMap = new HashMap(16);
        List<TreeNode> treeNodeList = null;
        String itemTypeNum = null;
        for (Map<String, Object> map : salaryItemList) {
            itemTypeNum = (String)map.get("salaryitemtype_number");
            String string = (String)map.get("salaryitemtype_name");
            treeNodeList = (List)salaryItemNodeMap.get(itemTypeNum);
            if (treeNodeList == null) {
                treeNodeList = new ArrayList(10);
                salaryItemNodeMap.put(itemTypeNum, treeNodeList);
            }
            treeNodeList.add(new TreeNode(itemTypeNum + "_@_" + "SL", String.valueOf(map.get("uniquecode")), (String)map.get("name")));
            if (itemTypeNodeMap.containsKey(itemTypeNum)) continue;
            TreeNode itemTreeNode = new TreeNode("SL", itemTypeNum + "_@_" + "SL", string);
            itemTreeNode.setExpend(isExpend);
            itemTreeNode.setIsOpened(isExpend);
            itemTypeNodeMap.put(itemTypeNum, itemTreeNode);
        }
        treeNodeList = new ArrayList(itemTypeNodeMap.size());
        TreeNode typeNode = null;
        for (Map.Entry entry : itemTypeNodeMap.entrySet()) {
            typeNode = (TreeNode)entry.getValue();
            typeNode.setChildren((List)salaryItemNodeMap.get(entry.getKey()));
            treeNodeList.add(typeNode);
        }
        if (!ObjectUtils.isEmpty(treeNodeList)) {
            TreeNode treeNode = new TreeNode("", "SL", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee-SL", (String)"FormulaItemOrFuncTreeHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]));
            treeNode.setChildren(treeNodeList);
            treeNode.setExpend(isExpend);
            treeNode.setIsOpened(isExpend);
            childNodes.add(treeNode);
        }
        return childNodes;
    }

    private List<Map<String, Object>> findItemByName(String name, String itemName, Map<String, Map<String, Map<String, Object>>> dataMap) {
        ArrayList<Map<String, Object>> filterItemsList = new ArrayList<Map<String, Object>>();
        Map<String, Map<String, Object>> result = dataMap.get(itemName);
        for (Map.Entry<String, Map<String, Object>> entry : result.entrySet()) {
            Map<String, Object> itemMap = entry.getValue();
            if (itemMap == null || itemMap.size() == 0) {
                if (!entry.getKey().contains(name)) continue;
                filterItemsList.add(entry.getValue());
                continue;
            }
            String number = (String)itemMap.get("number");
            if (!SWCStringUtils.isNotEmpty((String)number) || !number.contains(name) && !entry.getKey().contains(name)) continue;
            filterItemsList.add(entry.getValue());
        }
        return filterItemsList;
    }

    public void removeItem() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ResultCheckSchemeEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows("itemselectentry", rows);
    }

    public void moveToClosedEvent(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        if (SWCObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        String clickStatus = (String)returnData.get("clickStatus");
        if (!SWCStringUtils.equals((String)"ok", (String)clickStatus)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        int oldRow = rows[0];
        int newRow = (Integer)returnData.get("rownumber");
        IDataModel model = this.getModel();
        DynamicObjectCollection datas = model.getEntryEntity("itemselectentry");
        int size = datas.size();
        if (--newRow > size - 1) {
            newRow = size - 1;
        }
        if (oldRow == newRow) {
            return;
        }
        DynamicObject oldObj = (DynamicObject)datas.get(oldRow);
        model.deleteEntryRow("itemselectentry", oldRow);
        model.createNewEntryRow("itemselectentry", newRow, oldObj);
        EntryGrid grid = (EntryGrid)this.getView().getControl("itemselectentry");
        grid.selectRows(newRow, true);
    }

    public void addItem() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List selectNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)selectNodeIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u6570\u636e\u3002", (String)"ResultCheckSchemeEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        String cacheTreeNodeStr = (String)pageCache.get(CACHE_TREE, String.class);
        Map nodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheTreeNodeStr);
        Map dataMap = (Map)pageCache.get("allItemData", Map.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("itemcategory", new Object[0]);
        vs.addField("itemnumber", new Object[0]);
        vs.addField("itemname", new Object[0]);
        vs.addField("itemunicodeid", new Object[0]);
        vs.addField("treenodeid", new Object[0]);
        vs.addField("itemid", new Object[0]);
        for (String selectNodeId : selectNodeIds) {
            List childTrees;
            String parentId;
            TreeNode treeNode = this.getTreeNodeByTreeId(nodeMap, selectNodeId);
            if (treeNode == null || SWCStringUtils.isEmpty((String)treeNode.getId()) || SWCStringUtils.isEmpty((String)(parentId = treeNode.getParentid())) || (childTrees = treeNode.getChildren()) != null && childTrees.size() > 0 || this.isExistTreeNode(selectNodeId)) continue;
            String treeNodeId = treeNode.getId();
            String itemCategory = treeNodeId.substring(0, treeNodeId.indexOf(95));
            if (SWCStringUtils.equals((String)itemCategory, (String)"SI")) {
                itemCategory = "SL";
            } else if (SWCStringUtils.equals((String)itemCategory, (String)"BI")) {
                itemCategory = "BC";
            }
            String treeNodeName = treeNode.getText();
            String itemNum = this.getItemNumber(dataMap, itemCategory, treeNodeName);
            String itemUnicodeId = this.getItemUnicodeId(treeNodeId, treeNodeName);
            String itemId = this.getItemId(dataMap, itemCategory, treeNodeName);
            vs.addRow(new Object[]{itemCategory, itemNum, treeNodeName, itemUnicodeId, treeNodeId, itemId});
        }
        model.batchCreateNewEntryRow("itemselectentry", vs);
        model.endInit();
        this.getView().updateView("itemselectentry");
    }

    public String getItemUnicodeId(String treeNodeId, String treeNodeName) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map dataMap = (Map)pageCache.get("simpleAllItemData", Map.class);
        if (SWCObjectUtils.isEmpty((Object)dataMap)) {
            return "";
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            Map itemData = (Map)entry.getValue();
            String uniqueCode = (String)itemData.get(treeNodeName);
            if (!SWCStringUtils.equals((String)uniqueCode, (String)treeNodeId)) continue;
            return uniqueCode;
        }
        return "";
    }

    public String getItemId(Map<String, Map<String, Map<String, Object>>> dataMap, String itemCategory, String treeNodeName) {
        Map<String, Map<String, Object>> itemMap = null;
        if (SWCStringUtils.equals((String)"SL", (String)itemCategory)) {
            itemMap = dataMap.get("salaryitemkey");
        } else if (SWCStringUtils.equals((String)"BS", (String)itemCategory)) {
            itemMap = dataMap.get("bsitemkey");
        }
        if (itemMap == null) {
            return "";
        }
        Map<String, Object> nameMap = itemMap.get(treeNodeName);
        if (nameMap == null || nameMap.size() == 0) {
            return "";
        }
        return nameMap.get("id") + "";
    }

    private String getItemNumber(Map<String, Map<String, Map<String, Object>>> dataMap, String itemCategory, String treeNodeName) {
        Map<String, Map<String, Object>> itemMap = null;
        if (SWCStringUtils.equals((String)"SL", (String)itemCategory)) {
            itemMap = dataMap.get("salaryitemkey");
        } else if (SWCStringUtils.equals((String)"BS", (String)itemCategory)) {
            itemMap = dataMap.get("bsitemkey");
        }
        if (itemMap == null) {
            return "";
        }
        Map<String, Object> nameMap = itemMap.get(treeNodeName);
        if (nameMap == null || nameMap.size() == 0) {
            return "";
        }
        String number = (String)nameMap.get("number");
        return SWCStringUtils.isEmpty((String)number) ? "" : number;
    }

    public boolean isExistTreeNode(String selectTreeNodeId) {
        DynamicObjectCollection itemDatas = this.getModel().getEntryEntity("itemselectentry");
        for (DynamicObject itemData : itemDatas) {
            String treeNodeId = itemData.getString("treenodeid");
            if (!SWCStringUtils.equals((String)treeNodeId, (String)selectTreeNodeId)) continue;
            return true;
        }
        return false;
    }

    public TreeNode getTreeNodeByTreeId(Map<String, TreeNode> nodeMap, String treeId) {
        TreeNode treeNode = new TreeNode();
        for (Map.Entry<String, TreeNode> entry : nodeMap.entrySet()) {
            TreeNode value = entry.getValue();
            this.getSubTreeNode(treeNode, treeId, value);
            if (!SWCStringUtils.isNotEmpty((String)treeNode.getId())) continue;
            return treeNode;
        }
        return treeNode;
    }

    public void getSubTreeNode(TreeNode treeNode, String treeId, TreeNode subTreeNode) {
        String subTreeId = subTreeNode.getId();
        if (SWCStringUtils.equals((String)treeId, (String)subTreeId)) {
            this.copyTreeNode(treeNode, subTreeNode);
        } else {
            List childTrees = subTreeNode.getChildren();
            if (childTrees != null && childTrees.size() > 0) {
                for (TreeNode childTree : childTrees) {
                    this.getSubTreeNode(treeNode, treeId, childTree);
                }
            }
        }
    }

    public void copyTreeNode(TreeNode newTreeNode, TreeNode oldTreeNode) {
        newTreeNode.setId(oldTreeNode.getId());
        newTreeNode.setText(oldTreeNode.getText());
        newTreeNode.setParentid(oldTreeNode.getParentid());
        newTreeNode.setData(oldTreeNode.getData());
        newTreeNode.setChildren(oldTreeNode.getChildren());
        newTreeNode.setExpend(oldTreeNode.isExpend());
        newTreeNode.setIsOpened(oldTreeNode.getIsOpened());
        newTreeNode.setType(oldTreeNode.getType());
        newTreeNode.setColor(oldTreeNode.getColor());
        newTreeNode.setLongNumber(oldTreeNode.getLongNumber());
        newTreeNode.setLeaf(oldTreeNode.isLeaf());
        newTreeNode.setCheckable(oldTreeNode.isCheckable());
        newTreeNode.setIcon(oldTreeNode.getIcon());
    }

    public void openMoveToPage(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("itemselectentry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ResultCheckSchemeEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (rows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"ResultCheckSchemeEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsas_calitemmoveto");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5230", (String)"ResultCheckSchemeEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "movetoclosed"));
        this.getView().showForm(showParameter);
    }

    private void initItemTree(Map<String, Map<String, Map<String, Object>>> dataMap) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List list = FormulaItemOrFuncTreeHelper.loadSLItemChildNode(null, (boolean)false, dataMap);
        list.addAll(FormulaItemOrFuncTreeHelper.loadBSTreeNodeListWithoutAttBizItem(null, (boolean)false, dataMap));
        treeView.deleteAllNodes();
        treeView.addNodes(list);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map treeNodeMap = list.stream().collect(Collectors.toMap(TreeNode::getId, Function.identity(), (entity1, entity2) -> entity2));
        pageCache.put(CACHE_TREE, (Object)SerializationUtils.serializeToBase64(treeNodeMap));
        pageCache.put("allItemData", dataMap);
        Map<String, Map<String, String>> simpleDataMap = this.rebuildData(dataMap);
        pageCache.put("simpleAllItemData", simpleDataMap);
    }

    private Map<String, Map<String, String>> rebuildData(Map<String, Map<String, Map<String, Object>>> dataMap) {
        if (dataMap == null || dataMap.size() == 0) {
            return null;
        }
        HashMap retMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            Map<String, Map<String, Object>> value = entry.getValue();
            HashMap<String, String> innerMap = new HashMap<String, String>(16);
            for (Map.Entry<String, Map<String, Object>> innerEntry : value.entrySet()) {
                String innerKey = innerEntry.getKey();
                Map<String, Object> innerValue = innerEntry.getValue();
                String uniqueCode = (String)innerValue.get("uniquecode");
                innerMap.put(innerKey, uniqueCode);
                innerMap.put("id", innerValue.get("id") + "");
            }
            retMap.put(key, innerMap);
        }
        return retMap;
    }
}

