/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.datagrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class DataGradeBatchImportEdit
extends SWCDataBaseEdit
implements IDataPort {
    private static Log log = LogFactory.getLog(DataGradeBatchImportEdit.class);
    private static final int MAXROWCOUNT = 5000;

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)"donothing_import")) {
            IDataPort.openImportWindow((IFormView)this.getView(), (IFormPlugin)this, (String)ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868\u6279\u91cf\u5bfc\u5165\u8d77\u59cb\u9875", (String)"DataGradeBatchImportEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
    }

    public void dataImport(DataImportEvent evt) {
        ProgressHandler processHandler;
        List dataRow;
        Map nameMap;
        List dataHead = evt.getDataHead();
        Map colMap = (Map)dataHead.get(0);
        boolean checkResult = this.checkImportData(colMap, nameMap = (Map)dataHead.get(2), dataRow = evt.getDataRow(), processHandler = evt.getProcessHandler());
        if (!checkResult) {
            return;
        }
        this.addSubDataRows(colMap, dataRow);
        this.setGradeDataToCache();
    }

    private void setGradeDataToCache() {
        String valueType;
        String number;
        String id;
        int index;
        ArrayList dataList = new ArrayList(10);
        DynamicObjectCollection gradeDatas = this.getModel().getEntryEntity("entryentity");
        if (gradeDatas == null || gradeDatas.size() == 0) {
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
            String parentPageId = this.getView().getParentView().getPageId();
            appCache.put(parentPageId + "_subPageGradeCache", dataList);
            return;
        }
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String conditionStr = (String)cache.get("conditiondatas", String.class);
        String resultStr = (String)cache.get("resultdatas", String.class);
        JSONArray conditionArray = JSONArray.parseArray((String)conditionStr);
        JSONArray resultArray = JSONArray.parseArray((String)resultStr);
        HashMap<String, Integer> accurencyMap = new HashMap<String, Integer>(16);
        for (index = 0; index < conditionArray.size(); ++index) {
            JSONObject conditionObj = conditionArray.getJSONObject(index);
            id = conditionObj.getString("conditionid");
            number = conditionObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("conditionaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("amtPrecision"));
        }
        for (index = 0; index < resultArray.size(); ++index) {
            JSONObject resultObj = resultArray.getJSONObject(index);
            id = resultObj.getString("resultid");
            number = resultObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("resultaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("amtPrecision"));
        }
        for (DynamicObject dataObj : gradeDatas) {
            DataEntityPropertyCollection properties = dataObj.getDynamicObjectType().getProperties();
            int seq = 0;
            for (IDataEntityProperty propertie : properties) {
                String fieldId = propertie.getName();
                if (SWCStringUtils.equals((String)fieldId, (String)"seq")) {
                    seq = dataObj.getInt("seq");
                    continue;
                }
                if (!fieldId.startsWith("condition-") && !fieldId.startsWith("result-")) continue;
                LocaleString fieldNameLocal = propertie.getDisplayName();
                String fieldName = fieldNameLocal.toString();
                Object value = dataObj.get(fieldId);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("rownum", seq);
                dataMap.put("fieldid", fieldId);
                dataMap.put("fieldName", fieldName);
                dataMap.put("value", this.setValStr(value, fieldId, accurencyMap));
                dataList.add(dataMap);
            }
        }
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String parentPageId = this.getView().getParentView().getPageId();
        appCache.put(parentPageId + "_subPageGradeCache", dataList);
    }

    private String setValStr(Object value, String fieldId, Map<String, Integer> accurencyMap) {
        String valStr = value.toString().trim();
        if (fieldId.contains(DataGradeValueTypeEnum.DECIMAL.getDesc()) || fieldId.contains(DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            Integer currency = accurencyMap.get(fieldId);
            if (currency == null) {
                return valStr;
            }
            BigDecimal decimalVal = new BigDecimal(valStr);
            return decimalVal.setScale((int)currency, RoundingMode.HALF_UP).toPlainString();
        }
        if (fieldId.contains(DataGradeValueTypeEnum.DATE.getDesc()) && value instanceof Date) {
            return SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
        }
        return valStr;
    }

    private String getValueTypeDesc(String number) {
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            return DataGradeValueTypeEnum.DECIMAL.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return DataGradeValueTypeEnum.AMOUNT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            return DataGradeValueTypeEnum.TEXT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            return DataGradeValueTypeEnum.INTEGER.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            return DataGradeValueTypeEnum.DATE.getDesc();
        }
        return null;
    }

    public boolean checkImportData(Map<Integer, String> colMap, Map<Integer, String> nameMap, List<Map<Integer, String>> dataRow, ProgressHandler processHandler) {
        if (!this.nullDataCheck(colMap, nameMap, dataRow, processHandler)) {
            return false;
        }
        if (!this.dataTypeCheck(colMap, nameMap, dataRow, processHandler)) {
            return false;
        }
        if (this.conditionValueCheck(colMap, nameMap, dataRow, processHandler)) {
            return false;
        }
        processHandler.updateProgress(dataRow.size(), 0);
        return true;
    }

    public boolean conditionValueCheck(Map<Integer, String> colMap, Map<Integer, String> nameMap, List<Map<Integer, String>> dataRow, ProgressHandler processHandler) {
        int rowSize = dataRow.size();
        if (rowSize == 1) {
            return false;
        }
        LinkedHashMap<Integer, String> conditionFieldMap = new LinkedHashMap<Integer, String>(16);
        for (Map.Entry<Integer, String> entry : colMap.entrySet()) {
            String fieldId = entry.getValue();
            if (!fieldId.startsWith("condition-")) continue;
            conditionFieldMap.put(entry.getKey(), entry.getValue());
        }
        int lineSize = conditionFieldMap.size();
        for (int i = 0; i < rowSize - 1; ++i) {
            Map<Integer, String> preRowMap = dataRow.get(i);
            Integer preExcelRow = Integer.valueOf(preRowMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            for (int j = i + 1; j < rowSize; ++j) {
                Map<Integer, String> lastRowMap = dataRow.get(j);
                Integer afterExcelRow = Integer.valueOf(lastRowMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
                boolean isMatch = true;
                for (int m = 0; m < lineSize; ++m) {
                    String fieldId = (String)conditionFieldMap.get(m);
                    if (!fieldId.contains("-")) {
                        isMatch = false;
                        break;
                    }
                    String preVal = preRowMap.get(m);
                    String lastVal = lastRowMap.get(m);
                    String valueType = fieldId.substring(fieldId.indexOf(45) + 1, fieldId.lastIndexOf(45));
                    if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.TEXT.getDesc(), (String)valueType)) {
                        if (SWCStringUtils.equals((String)preVal, (String)lastVal)) continue;
                        isMatch = false;
                        break;
                    }
                    if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DECIMAL.getDesc(), (String)valueType) || SWCStringUtils.equals((String)DataGradeValueTypeEnum.AMOUNT.getDesc(), (String)valueType)) {
                        BigDecimal lastBd;
                        BigDecimal preBd = new BigDecimal(preVal = preVal.replace(",", ""));
                        if (preBd.compareTo(lastBd = new BigDecimal(lastVal = lastVal.replace(",", ""))) == 0) continue;
                        isMatch = false;
                        break;
                    }
                    if (!SWCStringUtils.equals((String)DataGradeValueTypeEnum.DATE.getDesc(), (String)valueType)) continue;
                    try {
                        Date preDate = SWCDateTimeUtils.parseDate((String)preVal, (String)"yyyy-MM-dd");
                        Date lastDate = SWCDateTimeUtils.parseDate((String)lastVal, (String)"yyyy-MM-dd");
                        if (preDate.getTime() == lastDate.getTime()) continue;
                        isMatch = false;
                    }
                    catch (ParseException e) {
                        isMatch = false;
                    }
                    break;
                }
                if (!isMatch) continue;
                processHandler.updateProgress(0, rowSize);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u4e0e\u7b2c{1}\u884c\u6570\u636e\u6761\u4ef6\u503c\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_9", (String)"swc-hsas-formplugin", (Object[])new Object[0]), preExcelRow + 1, afterExcelRow + 1);
                processHandler.putRowError(preExcelRow, msg);
                return true;
            }
        }
        return false;
    }

    public boolean dataTypeCheck(Map<Integer, String> colMap, Map<Integer, String> nameMap, List<Map<Integer, String>> dataRow, ProgressHandler processHandler) {
        int size = dataRow.size();
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String conditionStr = (String)cache.get("conditiondatas", String.class);
        String resultStr = (String)cache.get("resultdatas", String.class);
        for (int i = 0; i < size; ++i) {
            Map<Integer, String> dataMap = dataRow.get(i);
            Integer excelRow = Integer.valueOf(dataMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            int index = colMap.size();
            for (int j = 0; j < index; ++j) {
                String fieldId = colMap.get(j);
                if (!fieldId.contains("-")) {
                    return false;
                }
                String valueType = fieldId.substring(fieldId.indexOf(45) + 1, fieldId.lastIndexOf(45));
                String value = dataMap.get(j);
                try {
                    JSONArray resultArray;
                    String msg;
                    String decimalNumber;
                    int flag;
                    JSONArray conditionArray;
                    JSONObject dataObj;
                    String id;
                    if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                        int accuracy;
                        value = value.replace(",", "");
                        new BigDecimal(value);
                        id = fieldId.substring(fieldId.lastIndexOf(45) + 1);
                        if (fieldId.startsWith("condition")) {
                            if (SWCStringUtils.isEmpty((String)conditionStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(conditionArray = JSONArray.parseArray((String)conditionStr), id, "condition")))) continue;
                            accuracy = dataObj.getIntValue("conditionaccuracy");
                            flag = 0;
                            if (value.indexOf(46) != -1) {
                                decimalNumber = value.substring(value.indexOf(46) + 1);
                                flag = decimalNumber.length();
                            }
                            if (flag <= accuracy) continue;
                            processHandler.updateProgress(0, size);
                            msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7cbe\u5ea6\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                            processHandler.putRowError(excelRow, msg);
                            return false;
                        }
                        if (!fieldId.startsWith("result") || SWCStringUtils.isEmpty((String)resultStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(resultArray = JSONArray.parseArray((String)resultStr), id, "result")))) continue;
                        accuracy = dataObj.getIntValue("resultaccuracy");
                        flag = 0;
                        if (value.indexOf(46) != -1) {
                            decimalNumber = value.substring(value.indexOf(46) + 1);
                            flag = decimalNumber.length();
                        }
                        if (flag <= accuracy) continue;
                        processHandler.updateProgress(0, size);
                        msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7cbe\u5ea6\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                        processHandler.putRowError(excelRow, msg);
                        return false;
                    }
                    if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                        int currency;
                        value = value.replace(",", "");
                        new BigDecimal(value);
                        id = fieldId.substring(fieldId.lastIndexOf(45) + 1);
                        if (fieldId.startsWith("condition")) {
                            if (SWCStringUtils.isEmpty((String)conditionStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(conditionArray = JSONArray.parseArray((String)conditionStr), id, "condition")))) continue;
                            currency = dataObj.getIntValue("amtPrecision");
                            flag = 0;
                            if (value.indexOf(46) != -1) {
                                decimalNumber = value.substring(value.indexOf(46) + 1);
                                flag = decimalNumber.length();
                            }
                            if (flag <= currency) continue;
                            processHandler.updateProgress(0, size);
                            msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7cbe\u5ea6\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                            processHandler.putRowError(excelRow, msg);
                            return false;
                        }
                        if (!fieldId.startsWith("result") || SWCStringUtils.isEmpty((String)resultStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(resultArray = JSONArray.parseArray((String)resultStr), id, "result")))) continue;
                        currency = dataObj.getIntValue("amtPrecision");
                        flag = 0;
                        if (value.indexOf(46) != -1) {
                            decimalNumber = value.substring(value.indexOf(46) + 1);
                            flag = decimalNumber.length();
                        }
                        if (flag <= currency) continue;
                        processHandler.updateProgress(0, size);
                        msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7cbe\u5ea6\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_7", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                        processHandler.putRowError(excelRow, msg);
                        return false;
                    }
                    if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                        Integer.valueOf(value);
                        continue;
                    }
                    if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                        int length;
                        id = fieldId.substring(fieldId.lastIndexOf(45) + 1);
                        if (fieldId.startsWith("condition")) {
                            if (SWCStringUtils.isEmpty((String)conditionStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(conditionArray = JSONArray.parseArray((String)conditionStr), id, "condition")))) continue;
                            length = dataObj.getIntValue("conditionlength");
                            if (value.length() <= length) continue;
                            processHandler.updateProgress(0, size);
                            String msg2 = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                            processHandler.putRowError(excelRow, msg2);
                            return false;
                        }
                        if (!fieldId.startsWith("result") || SWCStringUtils.isEmpty((String)resultStr) || SWCObjectUtils.isEmpty((Object)(dataObj = this.getObjById(resultArray = JSONArray.parseArray((String)resultStr), id, "result")))) continue;
                        length = dataObj.getIntValue("resultlength");
                        if (value.length() <= length) continue;
                        processHandler.updateProgress(0, size);
                        String msg3 = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u957f\u5ea6\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_8", (String)"swc-hsas-formplugin", (Object[])new Object[0]), excelRow + 1, nameMap.get(j));
                        processHandler.putRowError(excelRow, msg3);
                        return false;
                    }
                    if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) continue;
                    SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
                    continue;
                }
                catch (Exception e) {
                    processHandler.updateProgress(0, size);
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u7684\u6570\u636e\u7c7b\u578b\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u6570\u636e\u3002", (String)"DataGradeBatchImportEdit_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                    processHandler.putRowError(excelRow, msg);
                    return false;
                }
            }
        }
        return true;
    }

    public JSONObject getObjById(JSONArray dataArray, String id, String entryType) {
        int size = dataArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dataObj = dataArray.getJSONObject(i);
            String fieldId = "";
            if (SWCStringUtils.equals((String)entryType, (String)"condition")) {
                fieldId = dataObj.getString("conditionid");
            } else if (SWCStringUtils.equals((String)entryType, (String)"result")) {
                fieldId = dataObj.getString("resultid");
            }
            if (!SWCStringUtils.equals((String)id, (String)fieldId)) continue;
            return dataObj;
        }
        return null;
    }

    public boolean nullDataCheck(Map<Integer, String> colMap, Map<Integer, String> nameMap, List<Map<Integer, String>> dataRow, ProgressHandler processHandler) {
        int size = dataRow.size();
        for (int i = 0; i < size; ++i) {
            Map<Integer, String> dataMap = dataRow.get(i);
            Integer excelRow = Integer.valueOf(dataMap.get(EntryImportContext.EXCEL_ROW_NUMBER));
            int index = colMap.size();
            for (int j = 0; j < index; ++j) {
                if (dataMap.containsKey(j)) continue;
                processHandler.updateProgress(0, size);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u5bfc\u5165\u6570\u636e\u586b\u5199\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5b8c\u5584\u540e\u518d\u5bfc\u5165\u3002", (String)"DataGradeBatchImportEdit_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]), nameMap.get(j));
                processHandler.putRowError(excelRow, msg);
                return false;
            }
        }
        return true;
    }

    public void afterImport(DataImportEvent evt) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void addSubDataRows(Map<Integer, String> colMap, List<Map<Integer, String>> dataRow) {
        int i;
        String valueType;
        String number;
        String id;
        int index;
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String conditionStr = (String)cache.get("conditiondatas", String.class);
        String resultStr = (String)cache.get("resultdatas", String.class);
        JSONArray conditionArray = JSONArray.parseArray((String)conditionStr);
        JSONArray resultArray = JSONArray.parseArray((String)resultStr);
        HashMap<String, Integer> accurencyMap = new HashMap<String, Integer>(16);
        for (index = 0; index < conditionArray.size(); ++index) {
            JSONObject conditionObj = conditionArray.getJSONObject(index);
            id = conditionObj.getString("conditionid");
            number = conditionObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("conditionaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("amtPrecision"));
        }
        for (index = 0; index < resultArray.size(); ++index) {
            JSONObject resultObj = resultArray.getJSONObject(index);
            id = resultObj.getString("resultid");
            number = resultObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("resultaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("amtPrecision"));
        }
        this.getView().getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        int size = colMap.size();
        for (i = 0; i < size; ++i) {
            setter.addField(colMap.get(i), new Object[0]);
        }
        size = dataRow.size();
        for (i = 0; i < size; ++i) {
            Map<Integer, String> dataMap = dataRow.get(i);
            Object[] rowObj = new Object[colMap.size()];
            int length = dataMap.size() - 1;
            for (int j = 0; j < length; ++j) {
                String fieldId = colMap.get(j);
                String value = dataMap.get(j);
                int index2 = fieldId.indexOf(45);
                if (index2 == -1) continue;
                String valType = fieldId.substring(index2 + 1, fieldId.lastIndexOf(45));
                if (SWCStringUtils.equals((String)valType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc()) || SWCStringUtils.equals((String)valType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                    value = value.trim();
                    Integer currency = (Integer)accurencyMap.get(fieldId);
                    if (currency == null) {
                        rowObj[j] = new BigDecimal(value);
                        continue;
                    }
                    rowObj[j] = new BigDecimal(value).setScale((int)currency, RoundingMode.HALF_UP).toPlainString();
                    continue;
                }
                if (SWCStringUtils.equals((String)valType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                    rowObj[j] = value;
                    continue;
                }
                if (!SWCStringUtils.equals((String)valType, (String)DataGradeValueTypeEnum.DATE.getDesc())) continue;
                try {
                    rowObj[j] = SWCDateTimeUtils.parseDate((String)value, (String)"yyyy-MM-dd");
                    continue;
                }
                catch (ParseException e) {
                    log.error((Throwable)e);
                }
            }
            setter.addRow(rowObj);
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        DynamicObjectCollection gradeDatas = model.getEntryEntity("entryentity");
        model.updateEntryCache(gradeDatas);
        model.endInit();
    }

    public void addMainDataRows(Map<Integer, String> colMap, Map<Integer, String> nameMap, List<Map<Integer, String>> dataRow) {
        this.getView().getParentView().getModel().deleteEntryData("dataentry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getParentView().getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("rownum", new Object[0]);
        setter.addField("fieldid", new Object[0]);
        setter.addField("value", new Object[0]);
        setter.addField("fieldname", new Object[0]);
        int size = dataRow.size();
        for (int i = 0; i < size; ++i) {
            Map<Integer, String> dataMap = dataRow.get(i);
            for (Map.Entry<Integer, String> entry : dataMap.entrySet()) {
                Integer index = entry.getKey();
                String fieldId = colMap.get(index);
                String value = entry.getValue();
                value = value.replace(",", "");
                String fieldname = nameMap.get(index);
                setter.addRow(new Object[]{i + 1, fieldId, value, fieldname});
            }
        }
        model.batchCreateNewEntryRow("dataentry", setter);
        DynamicObjectCollection gradeDatas = model.getEntryEntity("dataentry");
        model.updateEntryCache(gradeDatas);
        model.endInit();
    }

    private List<Map<Integer, String>> copyList(List<Map<Integer, String>> dataRows) {
        ArrayList<Map<Integer, String>> deepCopyList = new ArrayList<Map<Integer, String>>(dataRows.size());
        for (Map<Integer, String> dataRow : dataRows) {
            try {
                Map newInstance = (Map)dataRow.getClass().newInstance();
                newInstance.putAll(dataRow);
                deepCopyList.add(newInstance);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
        }
        return deepCopyList;
    }

    public boolean chekMapEqual(Map<Integer, String> map, Map<Integer, String> beCompareMap) {
        if (map.size() != beCompareMap.size()) {
            return false;
        }
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String m2value;
            String m1value = entry.getValue() == null ? "" : entry.getValue();
            if (m1value.equals(m2value = beCompareMap.get(entry.getKey()) == null ? "" : beCompareMap.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean isEqualCollection(List<Map<Integer, String>> beCompareList, List<Map<Integer, String>> compareList) {
        if (null == beCompareList || null == compareList || beCompareList.size() != compareList.size()) {
            return false;
        }
        for (int i = 0; i < beCompareList.size(); ++i) {
            if (this.chekMapEqual(beCompareList.get(i), compareList.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<Map<Integer, String>> getSourceHeadData(List<EntryColumnContainer> containers, int headHeight, IDataModel model) {
        Map captions = SWCExportEntryHelper.getEntryFieldCaptions(containers);
        Map<Integer, String> entryColId = this.getEntryFiledId(captions);
        String[][] headArray = new String[headHeight][captions.size()];
        SWCExportEntryHelper.fillSheetHeadArray(containers, (String[][])headArray, (int)0, (int)0);
        List<Map<Integer, String>> headList = this.getEntryHeadStructs(headArray);
        ArrayList dataHeadSource = Lists.newArrayListWithCapacity((int)(headHeight + 1));
        dataHeadSource.add(entryColId);
        dataHeadSource.addAll(headList);
        return dataHeadSource;
    }

    public List<Map<Integer, String>> getEntryHeadStructs(String[][] strArray) {
        ArrayList<Map<Integer, String>> resultList = new ArrayList<Map<Integer, String>>(strArray.length);
        for (int i = 0; i < strArray.length; ++i) {
            HashMap<Integer, String> map = new HashMap<Integer, String>(strArray[i].length);
            for (int j = 0; j < strArray[i].length; ++j) {
                if (null == strArray[i][j]) continue;
                map.put(j, strArray[i][j]);
            }
            resultList.add(map);
        }
        return resultList;
    }

    public Map<Integer, String> getEntryFiledId(Map<String, KeyValue> captions) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        int i = 0;
        for (String key : captions.keySet()) {
            result.put(i, key);
            ++i;
        }
        return result;
    }

    public List<Map<String, Object>> geEntryColumns(IFormView entryView) {
        Map map = SWCExportEntryHelper.invokeLoadCustomControlMetas((IFormView)entryView);
        return SWCExportEntryHelper.getEntryColumnsFromMeta((Map)((Map)map.get("metas")), (String)"entryentity");
    }

    public List<EntryColumnContainer> getEntryColumnContainers(List<Map<String, Object>> columns, Set<String> ignoreSet) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.convertToEntryColumnInfo(columns);
        List containers = wrapper.getContainers();
        SWCExportEntryHelper.removeIgnoreColumn((List)containers, ignoreSet);
        return containers;
    }

    public void onGetImportConfig(OnGetImportConfigEvent evt) {
        ImportConfig config = new ImportConfig();
        config.setImportType(ImportConfig.ImportType.Complete);
        config.setMaxRowCount(5000);
        String templateFirstName = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868-\u6279\u91cf\u5bfc\u5165\u6a21\u677f", (String)"DataGradeBatchImportEdit_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setTemplateCaption(templateFirstName);
        String modelName = ResManager.loadKDString((String)"\u6570\u636e\u5206\u7ea7\u8868", (String)"DataGradeBatchImportEdit_3", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setModelName(modelName);
        LocalDate now = LocalDate.now();
        String str = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_\u6570\u636e\u5206\u7ea7\u8868\u5bfc\u5165\u6a21\u677f_", (String)"DataGradeBatchImportEdit_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        config.setTemplateFileName(str.concat(String.format(Locale.ROOT, "%02d", now.getMonthValue())).concat(String.format(Locale.ROOT, "%02d", now.getDayOfMonth())));
        evt.setImportConfig(config);
    }

    public void onValidateTemplate(DataImportEvent evt) {
        List dataHead = evt.getDataHead();
        List dataRow = evt.getDataRow();
        List<Map<String, Object>> columns = this.geEntryColumns(this.getView());
        HashSet<String> ignoreColumns = new HashSet<String>(16);
        List<EntryColumnContainer> containers = this.getEntryColumnContainers(columns, ignoreColumns);
        int headHeight = SWCExportEntryHelper.calcSheetHeadHeight(containers);
        List<Map<Integer, String>> dataHeadSource = this.getSourceHeadData(containers, headHeight, this.getModel());
        AbstractFormPlugin source = (AbstractFormPlugin)evt.getSource();
        ValidateResults validateResult = new ValidateResults(ErrorLevel.Error);
        if (!this.isEqualCollection(dataHeadSource, dataHead)) {
            validateResult.failed();
            source.getView().showErrorNotification(ImportConstants.IMPORT_TEMPLATE_ERROR());
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef\u3002", "DataGradeBatchImportEdit_11", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            evt.setValidateResults(validateResult);
            return;
        }
        List<Map<Integer, String>> copyList = this.copyList(dataRow);
        if (copyList == null || copyList.size() == 0) {
            validateResult.failed();
            source.getView().showMessage(ImportConstants.PARSED_INVALID_DATA(), ImportConstants.LOGGING_DATA(), MessageTypes.Default);
            MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "DataGradeBatchImportEdit_12", "swc-hsas-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
            evt.setValidateResults(validateResult);
            return;
        }
        MultiLangEnumBridge enumBridge = new MultiLangEnumBridge("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f", "DataGradeBatchImportEdit_13", "swc-hsas-formplugin");
        SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"donothing_import", (String)"", (MultiLangEnumBridge)enumBridge, (String[])new String[0]);
        evt.setValidateResults(validateResult);
    }

    public void loadCustomEntryMetas(LoadCustomEntryMetasEvent evt) {
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getView(), (String)"entryentity");
        evt.setEntryColumnWrapper(wrapper);
    }
}

