/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.datagrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class DataGradeCalPlugin
extends SWCDataBaseEdit {
    private static final String CONDITION_AREA = "conditionarea";
    private static final String RESULT_AREA = "resultarea";
    private static final String BTN_CAL = "btncal";
    private static final String BTN_CANCLE = "btncancel";
    private static final Log log = LogFactory.getLog(DataGradeCalPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CAL, BTN_CANCLE});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        FormShowParameter formShow = (FormShowParameter)e.getSource();
        DynamicObjectCollection conditionDatas = (DynamicObjectCollection)formShow.getCustomParam("conditionDatas");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_datagradesimulacal", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        FlexPanelAp conditionAp = this.createDynamicConditionPanel(conditionDatas, entityMetadata);
        HashMap<String, String> mapCondition = new HashMap<String, String>(16);
        mapCondition.put("id", CONDITION_AREA);
        mapCondition.put("items", (String)conditionAp.createControl().get("items"));
        e.getItems().add(mapCondition);
        DynamicObjectCollection resultDatas = (DynamicObjectCollection)formShow.getCustomParam("resultDatas");
        FlexPanelAp resultAp = this.createDynamicResultPanel(resultDatas, entityMetadata);
        HashMap<String, String> mapResult = new HashMap<String, String>(16);
        mapResult.put("id", RESULT_AREA);
        mapResult.put("items", (String)resultAp.createControl().get("items"));
        e.getItems().add(mapResult);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDException((Throwable)e1, new ErrorCode("getEntityType", e1.getMessage()), new Object[0]);
        }
        this.registConditionDynamicProps(newMainType);
        this.registResultDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_datagradesimulacal", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObjectCollection conditionDatas = model.getEntryEntity("conditionentryidentify");
        FlexPanelAp conditionAp = this.createDynamicConditionPanel(conditionDatas, entityMetadata);
        Container conditionContainer = (Container)this.getView().getControl(CONDITION_AREA);
        conditionContainer.getItems().addAll(((Container)conditionAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(conditionContainer.getItems());
        DynamicObjectCollection resultDatas = model.getEntryEntity("resultentryidentify");
        FlexPanelAp resultAp = this.createDynamicResultPanel(resultDatas, entityMetadata);
        Container resultContainer = (Container)this.getView().getControl(RESULT_AREA);
        resultContainer.getItems().addAll(((Container)resultAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(resultContainer.getItems());
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("condition-")) {
            this.createGetControlByType(e, key);
        }
        if (key.startsWith("result-")) {
            this.createGetControlByType(e, key);
        }
    }

    private void createGetControlByType(OnGetControlArgs e, String key) {
        int index = key.indexOf(45);
        if (index != -1) {
            String valueType = key.substring(index + 1, key.lastIndexOf(45));
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                TextEdit textEdit = new TextEdit();
                this.setFieldEditControl(key, e, (FieldEdit)textEdit);
            } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                IntegerEdit integerEdit = new IntegerEdit();
                this.setFieldEditControl(key, e, (FieldEdit)integerEdit);
            } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                DecimalEdit decimalEdit = new DecimalEdit();
                this.setFieldEditControl(key, e, (FieldEdit)decimalEdit);
            } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                DateEdit dateEdit = new DateEdit();
                this.setFieldEditControl(key, e, (FieldEdit)dateEdit);
            } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
                AmountEdit amountEdit = new AmountEdit();
                this.setFieldEditControl(key, e, (FieldEdit)amountEdit);
            }
        }
    }

    private void setFieldEditControl(String key, OnGetControlArgs e, FieldEdit edit) {
        edit.setFlatField(true);
        edit.setKey(key);
        edit.setView(this.getView());
        edit.setFieldKey(key.toLowerCase());
        edit.setModel(this.getView().getModel());
        e.setControl((Control)edit);
    }

    public void click(EventObject evt) {
        String clickedKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (clickedKey = source.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btncal": {
                this.simulationCal();
                break;
            }
        }
    }

    public void simulationCal() {
        String valueType;
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObjectCollection conditionEntity = model.getEntryEntity("conditionentryidentify");
        ArrayList<String> fieldIds = new ArrayList<String>(10);
        ArrayList<String> fieldNames = new ArrayList<String>(10);
        for (DynamicObject obj : conditionEntity) {
            String id = obj.getString("conditionid");
            DynamicObject valTypeObj = obj.getDynamicObject("conditionvaltype");
            String number = valTypeObj.getString("number");
            String valueType2 = this.getValueTypeDesc(number);
            fieldIds.add("condition-" + valueType2 + '-' + (String)id);
            OrmLocaleValue localName = (OrmLocaleValue)obj.get("conditionitemname");
            String fieldName = localName.getLocaleValue();
            fieldNames.add(fieldName);
        }
        DynamicObjectCollection resultEntity = model.getEntryEntity("resultentryidentify");
        ArrayList<String> resultIds = new ArrayList<String>(10);
        for (DynamicObject obj : resultEntity) {
            String id = obj.getString("resultid");
            DynamicObject valTypeObj = obj.getDynamicObject("resultvaltype");
            String number = valTypeObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            resultIds.add("result-" + valueType + '-' + id);
        }
        ArrayList<String> nullIds = new ArrayList<String>(10);
        ArrayList nullNames = new ArrayList(10);
        for (int i = 0; i < fieldIds.size(); ++i) {
            Object value;
            String key = (String)fieldIds.get(i);
            int index = key.indexOf(45);
            if (index == -1) continue;
            valueType = key.substring(index + 1, key.lastIndexOf(45));
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
                value = (String)this.getModel().getValue(key);
                if (SWCStringUtils.isEmpty((String)value)) {
                    nullIds.add(key);
                    nullNames.add(fieldNames.get(i));
                    continue;
                }
                this.getView().showFieldTip(this.showValidateTip(true, null, key));
                continue;
            }
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
                value = (Integer)this.getModel().getValue(key);
                if (SWCObjectUtils.isEmpty((Object)value)) {
                    nullIds.add(key);
                    nullNames.add(fieldNames.get(i));
                    continue;
                }
                this.getView().showFieldTip(this.showValidateTip(true, null, key));
                continue;
            }
            if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                value = (Date)this.getModel().getValue(key);
                if (SWCObjectUtils.isEmpty((Object)value)) {
                    nullIds.add(key);
                    nullNames.add(fieldNames.get(i));
                    continue;
                }
                this.getView().showFieldTip(this.showValidateTip(true, null, key));
                continue;
            }
            if (!SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) && !SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) continue;
            value = (BigDecimal)this.getModel().getValue(key);
            if (SWCObjectUtils.isEmpty((Object)value)) {
                nullIds.add(key);
                nullNames.add(fieldNames.get(i));
                continue;
            }
            this.getView().showFieldTip(this.showValidateTip(true, null, key));
        }
        if (nullIds != null && nullIds.size() > 0) {
            String nullMsg = ResManager.loadKDString((String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataGradeCalPlugin_6", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a", (String)"DataGradeCalPlugin_4", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            int count = nullIds.size();
            for (int i = 0; i < count; ++i) {
                String key = (String)nullIds.get(i);
                FieldTip referReportFieldTip = this.showValidateTip(false, nullMsg, key);
                this.getView().showFieldTip(referReportFieldTip);
                sb.append("%s");
                if (i == count - 1) continue;
                sb.append('\u3001');
            }
            String msg = "";
            if (count == 1) {
                msg = String.format(Locale.ROOT, sb.toString(), nullNames.get(0));
            } else if (count == 2) {
                msg = String.format(Locale.ROOT, sb.toString(), nullNames.get(0), nullNames.get(1));
            } else if (count == 3) {
                msg = String.format(Locale.ROOT, sb.toString(), nullNames.get(0), nullNames.get(1), nullNames.get(2));
            } else if (count == 4) {
                msg = String.format(Locale.ROOT, sb.toString(), nullNames.get(0), nullNames.get(1), nullNames.get(2), nullNames.get(3));
            } else if (count == 5) {
                msg = String.format(Locale.ROOT, sb.toString(), nullNames.get(0), nullNames.get(1), nullNames.get(2), nullNames.get(3), nullNames.get(4));
            }
            this.getView().showTipNotification(msg);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        SWCPageCache pageCache = new SWCPageCache(this.getView().getParentView());
        String subPageId = (String)pageCache.get(this.getView().getParentView().getPageId(), String.class);
        IFormView childView = this.getView().getView(subPageId);
        DynamicObjectCollection subEntryColl = childView.getModel().getEntryEntity("entryentity");
        String matchMethod = (String)model.getValue("matchmethod");
        params.put("matchmethod", matchMethod);
        List<Map<String, Object>> gradeDatas = this.getGradeList(subEntryColl);
        if (SWCStringUtils.equals((String)matchMethod, (String)"2") || SWCStringUtils.equals((String)matchMethod, (String)"5") || SWCStringUtils.equals((String)matchMethod, (String)"1")) {
            params.put("gradeDatas", gradeDatas);
        }
        if (SWCStringUtils.equals((String)matchMethod, (String)"3") || SWCStringUtils.equals((String)matchMethod, (String)"4")) {
            HashMap<String, List<Map<String, Object>>> gradeDataMap = new HashMap<String, List<Map<String, Object>>>(subEntryColl.size());
            this.buildDataGradeEntry(gradeDatas, gradeDataMap, fieldIds);
            params.put("gradeDataMap", gradeDataMap);
        }
        params.put("conditionIds", fieldIds);
        params.put("resultIds", resultIds);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>(fieldIds.size());
        for (String conditionId : fieldIds) {
            conditionMap.put(conditionId, this.getModel().getValue(conditionId));
        }
        params.put("conditionMap", conditionMap);
        String failPolicy = (String)model.getValue("failpolice");
        params.put("failpolice", failPolicy);
        String beyondPolicy = (String)model.getValue("beyondpolicy");
        params.put("beyondpolicy", beyondPolicy);
        DynamicObjectCollection resultColl = model.getEntryEntity("resultentryidentify");
        List<Map<String, Object>> resultDatas = this.getResultList(resultColl);
        params.put("resultDatas", resultDatas);
        DynamicObject dataRound = (DynamicObject)model.getValue("dataround");
        if (!SWCObjectUtils.isEmpty((Object)dataRound)) {
            String number = dataRound.getString("number");
            params.put("dataround", number);
        }
        try {
            List gradeSourceList = (List)params.get("gradeDatas");
            List<List<Map<String, Object>>> gradeList = this.groupCollection(gradeSourceList);
            HashMap<String, HashMap<String, Object>> matchSourceMap = new HashMap<String, HashMap<String, Object>>(gradeList.size());
            for (List<Map<String, Object>> row : gradeList) {
                ArrayList<String> conditionValues = new ArrayList<String>(10);
                HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                this.assembleSingleConditionResult(row, conditionValues, resultMap);
                matchSourceMap.put(String.join((CharSequence)"#", conditionValues), resultMap);
            }
            params.put("matchSourceMap", matchSourceMap);
        }
        catch (Exception exception) {
            log.error("assemble matchSourceMap error", (Throwable)exception);
        }
        Map calResult = (Map)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IDataGradeCalService", (String)"calculation", (Object[])new Object[]{params});
        this.setCalResult(calResult);
    }

    private void assembleSingleConditionResult(List<Map<String, Object>> rows, List<String> conditionValues, Map<String, Object> resultMap) {
        for (Map<String, Object> entry : rows) {
            String fieldId = (String)entry.get("fieldid");
            Object value = entry.get("value");
            String[] split = fieldId.split("-");
            if (SWCStringUtils.equals((String)"condition", (String)split[0])) {
                conditionValues.add(this.assembleSingleConditionValue(split, value));
            }
            if (!SWCStringUtils.equals((String)"result", (String)split[0])) continue;
            resultMap.put(fieldId, value);
        }
    }

    private String assembleSingleConditionValue(String[] split, Object value) {
        String dataType = split[1];
        try {
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc()) || SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
                return ((BigDecimal)value).stripTrailingZeros().toPlainString();
            }
            if (SWCStringUtils.equals((String)dataType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
                return SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
            }
            return (String)value;
        }
        catch (Exception exception) {
            log.error("assembleSingleConditionValue_error", (Throwable)exception);
            return "";
        }
    }

    private void buildDataGradeEntry(List<Map<String, Object>> gradeDatas, Map<String, List<Map<String, Object>>> gradeDataMap, List<String> conditionIds) {
        ArrayList gradeDataList = new ArrayList(gradeDatas.size());
        ArrayList<String> conditionIdStrList = new ArrayList<String>(16);
        ArrayList<String> conditionIdOtherList = new ArrayList<String>(16);
        for (String conditionId : conditionIds) {
            if (conditionId.contains(DataGradeValueTypeEnum.TEXT.getDesc())) {
                conditionIdStrList.add(conditionId);
                continue;
            }
            conditionIdOtherList.add(conditionId);
        }
        int preRowNum = 0;
        HashMap<Object, Object> rowMap = new HashMap<Object, Object>(16);
        for (Map<String, Object> map : gradeDatas) {
            int rowNum = (Integer)map.get("rownum");
            if (preRowNum != rowNum) {
                rowMap = new HashMap(16);
                preRowNum = rowNum;
                gradeDataList.add(rowMap);
            }
            String fieldId = (String)map.get("fieldid");
            Object value = map.get("value");
            rowMap.put(fieldId, value);
        }
        for (Map<String, Object> map : gradeDataList) {
            StringBuilder rowKey = new StringBuilder("###");
            for (String conditionIdStr : conditionIdStrList) {
                rowKey.append('#').append(map.get(conditionIdStr));
            }
            List<Map<String, Object>> dataList = gradeDataMap.get(rowKey.toString());
            if (dataList == null) {
                dataList = new ArrayList<Map<String, Object>>(10);
            }
            dataList.add(map);
            gradeDataMap.put(rowKey.toString(), dataList);
        }
        for (Map.Entry entry : gradeDataMap.entrySet()) {
            this.sortList((List)entry.getValue(), conditionIdOtherList, "asc");
        }
    }

    public List<Map<String, Object>> sortList(List<Map<String, Object>> dataList, List<String> arrColList, String order) {
        Comparator comparator = (o1, o2) -> {
            for (String arrCol : arrColList) {
                int compareResult;
                Object value1 = o1.get(arrCol);
                Object value2 = o2.get(arrCol);
                if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable) || (compareResult = ((Comparable)value1).compareTo((Comparable)value2)) == 0) continue;
                return order.equalsIgnoreCase("asc") ? compareResult : -compareResult;
            }
            return 0;
        };
        Collections.sort(dataList, comparator);
        return dataList;
    }

    public List<List<Map<String, Object>>> groupCollection(List<Map<String, Object>> datas) {
        ArrayList<List<Map<String, Object>>> list = new ArrayList<List<Map<String, Object>>>(10);
        Map<String, Object> firstObj = datas.get(0);
        Map<String, Object> lastObj = datas.get(datas.size() - 1);
        int lastIndex = (Integer)lastObj.get("rownum");
        for (int index = ((Integer)firstObj.get("rownum")).intValue(); index <= lastIndex; ++index) {
            ArrayList<Map<String, Object>> coll = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> obj : datas) {
                int rowNum = (Integer)obj.get("rownum");
                if (rowNum != index) continue;
                coll.add(obj);
            }
            list.add(coll);
        }
        return list;
    }

    public void setCalResult(Map<String, Object> resultDatas) {
        if (SWCObjectUtils.isEmpty(resultDatas)) {
            return;
        }
        HashMap<String, String> ctrl = new HashMap<String, String>(16);
        String result = (String)resultDatas.get("result");
        if (SWCStringUtils.equals((String)result, (String)"success")) {
            ctrl.put("fc", "#1BA854");
        } else if (SWCStringUtils.equals((String)result, (String)"continueCal")) {
            ctrl.put("fc", "#FF991C");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c\u3002", (String)"DataGradeCalPlugin_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        } else if (SWCStringUtils.equals((String)result, (String)"stopCal")) {
            ctrl.put("fc", "#FB2323");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff0c\u505c\u6b62\u8ba1\u7b97\u3002", (String)"DataGradeCalPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
        }
        for (Map.Entry<String, Object> entry : resultDatas.entrySet()) {
            String id = entry.getKey();
            if (SWCStringUtils.equals((String)id, (String)"result")) continue;
            Object value = entry.getValue();
            this.getView().updateControlMetadata(id, ctrl);
            this.getModel().setValue(id, value);
            this.getView().updateView(id);
        }
    }

    private List<Map<String, Object>> getResultList(DynamicObjectCollection resultDatas) {
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(resultDatas.size());
        for (DynamicObject resultObj : resultDatas) {
            Object defValObj;
            Object resultIdObj;
            DynamicObject currencyObj;
            Object lengthObj;
            Object accuracyObj;
            DynamicObject valTypeObj;
            HashMap<String, Object> retMap = new HashMap<String, Object>(16);
            Object nameObj = resultObj.get("resultitemname");
            if (!SWCObjectUtils.isEmpty((Object)nameObj)) {
                OrmLocaleValue localObj = (OrmLocaleValue)nameObj;
                String resultName = localObj.getLocaleValue();
                retMap.put("resultitemname", resultName);
            }
            if (!SWCObjectUtils.isEmpty((Object)(valTypeObj = resultObj.getDynamicObject("resultvaltype")))) {
                String number = valTypeObj.getString("number");
                retMap.put("number", number);
                String id = valTypeObj.getString("id");
                retMap.put("resultvaltype", id);
            }
            if (!SWCObjectUtils.isEmpty((Object)(accuracyObj = resultObj.get("resultaccuracy")))) {
                String accuracy = (String)accuracyObj;
                retMap.put("resultaccuracy", accuracy);
            }
            if (!SWCObjectUtils.isEmpty((Object)(lengthObj = resultObj.get("resultlength")))) {
                int length = (Integer)lengthObj;
                retMap.put("resultlength", length);
            }
            if (!SWCObjectUtils.isEmpty((Object)(currencyObj = resultObj.getDynamicObject("resultcurrency")))) {
                Integer amtPrecision = currencyObj.getInt("amtprecision");
                String id = currencyObj.getString("id");
                retMap.put("resultcurrency", id);
                retMap.put("amtPrecision", amtPrecision);
            }
            if (!SWCObjectUtils.isEmpty((Object)(resultIdObj = resultObj.get("resultid")))) {
                String resultId = (String)resultIdObj;
                retMap.put("resultid", resultId);
            }
            if (!SWCObjectUtils.isEmpty((Object)(defValObj = resultObj.get("resultdefaultval")))) {
                String defVal = (String)defValObj;
                retMap.put("resultdefaultval", defVal);
            }
            retList.add(retMap);
        }
        return retList;
    }

    private List<Map<String, Object>> getGradeList(DynamicObjectCollection gradeDatas) {
        String valueType;
        String number;
        String id;
        int index;
        ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(10);
        if (gradeDatas == null || gradeDatas.size() == 0) {
            return retList;
        }
        SWCPageCache cache = new SWCPageCache(this.getView().getParentView());
        String conditionStr = (String)cache.get("conditiondatas", String.class);
        String resultStr = (String)cache.get("resultdatas", String.class);
        JSONArray conditionArray = JSONArray.parseArray((String)conditionStr);
        JSONArray resultArray = JSONArray.parseArray((String)resultStr);
        HashMap<String, Integer> accurencyMap = new HashMap<String, Integer>(16);
        for (index = 0; index < conditionArray.size(); ++index) {
            JSONObject conditionObj = conditionArray.getJSONObject(index);
            id = conditionObj.getString("conditionid");
            number = conditionObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("conditionaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("condition-" + valueType + '-' + id, conditionObj.getInteger("amtPrecision"));
        }
        for (index = 0; index < resultArray.size(); ++index) {
            JSONObject resultObj = resultArray.getJSONObject(index);
            id = resultObj.getString("resultid");
            number = resultObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
                accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("resultaccuracy"));
                continue;
            }
            if (!SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) continue;
            accurencyMap.put("result-" + valueType + '-' + id, resultObj.getInteger("amtPrecision"));
        }
        for (DynamicObject dataObj : gradeDatas) {
            DataEntityPropertyCollection propertyColl = dataObj.getDynamicObjectType().getProperties();
            int seq = 0;
            for (IDataEntityProperty iDataEntityProperty : propertyColl) {
                String fieldId = iDataEntityProperty.getName();
                if (SWCStringUtils.equals((String)fieldId, (String)"seq")) {
                    seq = dataObj.getInt("seq");
                    continue;
                }
                if (!fieldId.startsWith("condition-") && !fieldId.startsWith("result-")) continue;
                LocaleString fieldNameLocal = iDataEntityProperty.getDisplayName();
                String fieldName = fieldNameLocal.toString();
                Object value = dataObj.get(fieldId);
                HashMap<String, Object> retMap = new HashMap<String, Object>(16);
                retMap.put("rownum", seq);
                retMap.put("fieldid", fieldId);
                retMap.put("fieldname", fieldName);
                retMap.put("value", this.setVal(value, fieldId, accurencyMap));
                retList.add(retMap);
            }
        }
        return retList;
    }

    private Object setVal(Object value, String fieldId, Map<String, Integer> accurencyMap) {
        String valStr = value.toString().trim();
        if (fieldId.contains(DataGradeValueTypeEnum.DECIMAL.getDesc()) || fieldId.contains(DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            Integer currency = accurencyMap.get(fieldId);
            if (currency == null) {
                return valStr;
            }
            BigDecimal decimalVal = new BigDecimal(valStr);
            return decimalVal.setScale((int)currency, RoundingMode.HALF_UP);
        }
        if (fieldId.contains(DataGradeValueTypeEnum.DATE.getDesc())) {
            return value;
        }
        return valStr;
    }

    private FieldTip showValidateTip(boolean isHide, String msg, String field) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setSuccess(isHide);
        fieldTip.setFieldKey(field);
        if (!isHide) {
            fieldTip.setTip(msg);
        }
        return fieldTip;
    }

    public List<DynamicObjectCollection> groupCollection(DynamicObjectCollection datas) {
        ArrayList<DynamicObjectCollection> list = new ArrayList<DynamicObjectCollection>(10);
        DynamicObject firstObj = (DynamicObject)datas.get(0);
        DynamicObject lastObj = (DynamicObject)datas.get(datas.size() - 1);
        int lastIndex = lastObj.getInt("rownum");
        for (int index = firstObj.getInt("rownum"); index <= lastIndex; ++index) {
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (DynamicObject obj : datas) {
                int rowNum = obj.getInt("rownum");
                if (rowNum != index) continue;
                coll.add((Object)obj);
            }
            list.add(coll);
        }
        return list;
    }

    private void registConditionDynamicProps(MainEntityType newMainType) {
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObjectCollection conditionDatas = model.getEntryEntity("conditionentryidentify");
        for (DynamicObject obj : conditionDatas) {
            String id = obj.getString("conditionid");
            DynamicObject valTypeObj = obj.getDynamicObject("conditionvaltype");
            String number = valTypeObj.getString("number");
            String valueType = this.getValueTypeDesc(number);
            id = "condition-" + valueType + '-' + id;
            OrmLocaleValue localName = (OrmLocaleValue)obj.get("conditionitemname");
            String name = localName.getLocaleValue();
            int maxLength = 200;
            Object lengthObj = obj.get("conditionlength");
            if (lengthObj != null) {
                maxLength = (Integer)lengthObj;
            }
            int accuracy = 2;
            String fieldAccuracy = obj.getString("conditionaccuracy");
            if (SWCStringUtils.isNotEmpty((String)fieldAccuracy)) {
                accuracy = Integer.parseInt(fieldAccuracy);
            }
            int currency = 2;
            DynamicObject currencyObj = obj.getDynamicObject("conditioncurrency");
            if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
                int amtPrecision;
                currency = amtPrecision = currencyObj.getInt("amtprecision");
            }
            this.createPropertiesByType(newMainType, id, name, valueType, maxLength, accuracy, currency);
        }
    }

    private void registResultDynamicProps(MainEntityType newMainType) {
        IDataModel model = this.getView().getParentView().getModel();
        DynamicObjectCollection resultDatas = model.getEntryEntity("resultentryidentify");
        for (DynamicObject obj : resultDatas) {
            String id = obj.getString("resultid");
            DynamicObject valTypeObj = obj.getDynamicObject("resultvaltype");
            String number = valTypeObj.getString("number");
            String valueType = this.getValueTypeDesc(number);
            id = "result-" + valueType + '-' + id;
            OrmLocaleValue localName = (OrmLocaleValue)obj.get("resultitemname");
            String name = localName.getLocaleValue();
            int maxLength = 200;
            Integer length = obj.getInt("resultlength");
            if (length != null) {
                maxLength = length;
            }
            int accuracy = 2;
            String fieldAccuracy = obj.getString("resultaccuracy");
            if (SWCStringUtils.isNotEmpty((String)fieldAccuracy)) {
                accuracy = Integer.parseInt(fieldAccuracy);
            }
            int currency = 2;
            DynamicObject currencyObj = obj.getDynamicObject("resultcurrency");
            if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
                int amtPrecision;
                currency = amtPrecision = currencyObj.getInt("amtprecision");
            }
            this.createPropertiesByType(newMainType, id, name, valueType, maxLength, accuracy, currency);
        }
    }

    private void createPropertiesByType(MainEntityType newMainType, String id, String name, String valueType, int maxLength, int accuracy, int currency) {
        if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
            TextProp textProp = new TextProp();
            textProp.setName(id);
            textProp.setDisplayName(new LocaleString(name));
            textProp.setDefaultValue((Object)"");
            textProp.setDbIgnore(true);
            textProp.setDefValue((Object)"");
            textProp.setAlias(null);
            textProp.setMaxLenth(maxLength);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
            IntegerProp prop = new IntegerProp();
            prop.setName(id);
            prop.setDisplayName(new LocaleString(name));
            prop.setControlPropName("integerfield");
            prop.setDbIgnore(true);
            prop.setDefValue(null);
            prop.setZeroShow(true);
            prop.setEnableNull(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(id);
            decimalProp.setDisplayName(new LocaleString(name));
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            decimalProp.setPrecision(23);
            decimalProp.setScale(accuracy);
            decimalProp.setZeroShow(true);
            decimalProp.setEnableNull(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(id);
            decimalProp.setDisplayName(new LocaleString(name));
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            decimalProp.setPrecision(23);
            decimalProp.setScale(currency);
            decimalProp.setZeroShow(true);
            decimalProp.setEnableNull(true);
            newMainType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
            DateProp dateProp = new DateProp();
            dateProp.setName(id);
            dateProp.setDisplayName(new LocaleString(name));
            dateProp.setDbIgnore(true);
            dateProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)dateProp);
        }
    }

    private FlexPanelAp createDynamicConditionPanel(DynamicObjectCollection conditionDatas, EntityMetadata entityMetadata) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("conditionAp");
        for (DynamicObject obj : conditionDatas) {
            String id = obj.getString("conditionid");
            DynamicObject valTypeObj = obj.getDynamicObject("conditionvaltype");
            String number = valTypeObj.getString("number");
            String valueType = this.getValueTypeDesc(number);
            id = "condition-" + valueType + '-' + id;
            OrmLocaleValue localName = (OrmLocaleValue)obj.get("conditionitemname");
            String name = localName.getLocaleValue();
            int maxLength = 200;
            Object lengthObj = obj.get("conditionlength");
            if (lengthObj != null) {
                maxLength = (Integer)lengthObj;
            }
            int accuracy = 2;
            String fieldAccuracy = obj.getString("conditionaccuracy");
            if (SWCStringUtils.isNotEmpty((String)fieldAccuracy)) {
                accuracy = Integer.parseInt(fieldAccuracy);
            }
            int currency = 2;
            DynamicObject currencyObj = obj.getDynamicObject("conditioncurrency");
            if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
                int amtPrecision;
                currency = amtPrecision = currencyObj.getInt("amtprecision");
            }
            FieldAp fieldAp = this.createFieldAp(id, name, entityMetadata, maxLength, accuracy, currency);
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }

    private String getValueTypeDesc(String number) {
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            return DataGradeValueTypeEnum.DECIMAL.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return DataGradeValueTypeEnum.AMOUNT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            return DataGradeValueTypeEnum.TEXT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            return DataGradeValueTypeEnum.INTEGER.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            return DataGradeValueTypeEnum.DATE.getDesc();
        }
        return null;
    }

    private FlexPanelAp createDynamicResultPanel(DynamicObjectCollection resultDatas, EntityMetadata entityMetadata) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("resultAp");
        for (DynamicObject obj : resultDatas) {
            String id = obj.getString("resultid");
            DynamicObject valTypeObj = obj.getDynamicObject("resultvaltype");
            String number = valTypeObj.getString("number");
            String valueType = this.getValueTypeDesc(number);
            id = "result-" + valueType + '-' + id;
            OrmLocaleValue localName = (OrmLocaleValue)obj.get("resultitemname");
            String name = localName.getLocaleValue();
            int maxLength = 200;
            Integer length = obj.getInt("resultlength");
            if (length != null) {
                maxLength = length;
            }
            int accuracy = 2;
            String fieldAccuracy = obj.getString("resultaccuracy");
            if (SWCStringUtils.isNotEmpty((String)fieldAccuracy)) {
                accuracy = Integer.parseInt(fieldAccuracy);
            }
            int currency = 2;
            DynamicObject currencyObj = obj.getDynamicObject("resultcurrency");
            if (!SWCObjectUtils.isEmpty((Object)currencyObj)) {
                int amtPrecision;
                currency = amtPrecision = currencyObj.getInt("amtprecision");
            }
            FieldAp fieldAp = this.createFieldAp(id, name, entityMetadata, maxLength, accuracy, currency);
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }

    private FieldAp createFieldAp(String fieldId, String fieldName, EntityMetadata entityMetadata, int maxLength, int accuracy, int currency) {
        int index;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(fieldId);
        fieldAp.setKey(fieldId);
        fieldAp.setName(new LocaleString(fieldName));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFontSize(14);
        if (fieldId.startsWith("result-")) {
            fieldAp.setLock("new,edit,view,submit,audit");
        }
        if ((index = fieldId.indexOf(45)) == -1) {
            return fieldAp;
        }
        String valueType = fieldId.substring(index + 1, fieldId.lastIndexOf(45));
        if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
            TextField field = new TextField();
            field.setId(fieldId);
            field.setKey(fieldId);
            field.setEnableNull(false);
            field.setLockedEmptyTip(new LocaleString(""));
            field.setDefValue("");
            field.setEntityMetadata(entityMetadata);
            field.setMaxLength(maxLength);
            fieldAp.setField((Field)field);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
            IntegerField field = new IntegerField();
            field.setKey(fieldId);
            field.setZeroShow(true);
            field.setEnableNull(true);
            fieldAp.setField((Field)field);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            DecimalField decimalField = new DecimalField();
            decimalField.setKey(fieldId);
            decimalField.setScale(accuracy);
            decimalField.setPrecision(23);
            decimalField.setZeroShow(true);
            decimalField.setEnableNull(true);
            fieldAp.setField((Field)decimalField);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            DecimalField decimalField = new DecimalField();
            decimalField.setKey(fieldId);
            decimalField.setScale(currency);
            decimalField.setPrecision(23);
            decimalField.setZeroShow(true);
            decimalField.setEnableNull(true);
            fieldAp.setField((Field)decimalField);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
            DateField dateField = new DateField();
            dateField.setKey(fieldId);
            dateField.setDefValue(null);
            dateField.setEntityMetadata(entityMetadata);
            fieldAp.setField((Field)dateField);
        }
        return fieldAp;
    }
}

