/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.formplugin.web.datagrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.swc.hsas.business.datagrade.helper.DataGradeHelper;
import kd.swc.hsbp.business.datagrade.enums.DataGradeValueTypeEnum;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;

public class DataGradeEntryPlugin
extends SWCDataBaseEdit {
    private static Log log = LogFactory.getLog(DataGradeEntryPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShow = (FormShowParameter)e.getSource();
        String parentPageId = formShow.getParentPageId();
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String conditionStr = (String)appCache.get(parentPageId + "_conditionentry", String.class);
        if (SWCStringUtils.isEmpty((String)conditionStr)) {
            return;
        }
        JSONArray conditionArray = JSONArray.parseArray((String)conditionStr);
        String resultStr = (String)appCache.get(parentPageId + "_resultentry", String.class);
        if (SWCStringUtils.isEmpty((String)resultStr)) {
            return;
        }
        JSONArray resultArray = JSONArray.parseArray((String)resultStr);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_datagradeentry", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryAp entryAp = this.createEntryAp(conditionArray, resultArray, entityMetadata);
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", "entryentity");
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new KDException((Throwable)e1, new ErrorCode("getEntityType", e1.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("condition-") || key.startsWith("result-")) {
            boolean needUpdate = this.checkGradNeedUpdate();
            if (needUpdate) {
                return;
            }
            this.createGetControlByType(e, key);
        }
    }

    public void beforeBindData(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        List<Control> allControls = this.getControls();
        if (allControls == null || allControls.size() == 0) {
            return;
        }
        for (Control control : allControls) {
            control.setView(this.getView());
            entryGrid.getItems().add(control);
        }
    }

    public boolean checkGradNeedUpdate() {
        IDataModel parentModel = this.getView().getParentView().getModel();
        DynamicObjectCollection conditionDatas = parentModel.getEntryEntity("conditionentryidentify");
        if (CollectionUtil.isEmpty((Collection)conditionDatas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        DataGradeHelper helper = new DataGradeHelper();
        Boolean isNull = helper.checkConditionRequired(conditionDatas, this.getView().getParentView());
        if (isNull.booleanValue()) {
            return true;
        }
        DynamicObjectCollection resultDatas = parentModel.getEntryEntity("resultentryidentify");
        if (CollectionUtil.isEmpty((Collection)resultDatas)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6761\u4ef6\u8bbe\u7f6e\u548c\u7ed3\u679c\u8bbe\u7f6e\u3002", (String)"DataGradeBaseEdit_1", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            return true;
        }
        Boolean isNeedFrash = this.isNeedUpdateGrade(conditionDatas, resultDatas);
        if (isNeedFrash.booleanValue()) {
            SWCPageCache parentPageCache = new SWCPageCache(this.getView().getParentView());
            Boolean onceThrow = (Boolean)parentPageCache.get("setOneTimeThrow", Boolean.class);
            if (onceThrow == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6216\u7ed3\u679c\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u8bf7\u66f4\u65b0\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
            } else if (onceThrow.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8bbe\u7f6e\u6216\u7ed3\u679c\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u8bf7\u66f4\u65b0\u6570\u636e\u5206\u7ea7\u8868\u3002", (String)"DataGradeBaseEdit_13", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                parentPageCache.put("setOneTimeThrow", (Object)Boolean.FALSE);
            }
            return true;
        }
        return false;
    }

    public Boolean isNeedUpdateGrade(DynamicObjectCollection conditionDatas, DynamicObjectCollection resultDatas) {
        String fieldName;
        String valueType;
        String number;
        DynamicObject valTypeObj;
        String id;
        ArrayList<String> mainEntryList = new ArrayList<String>(10);
        for (DynamicObject dataObj : conditionDatas) {
            id = dataObj.getString("conditionid");
            valTypeObj = dataObj.getDynamicObject("conditionvaltype");
            number = valTypeObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            mainEntryList.add("condition-" + valueType + "-" + id);
            fieldName = dataObj.getString("conditionitemname");
            mainEntryList.add(fieldName);
        }
        for (DynamicObject dataObj : resultDatas) {
            id = dataObj.getString("resultid");
            valTypeObj = dataObj.getDynamicObject("resultvaltype");
            number = valTypeObj.getString("number");
            valueType = this.getValueTypeDesc(number);
            mainEntryList.add("result-" + valueType + "-" + id);
            fieldName = dataObj.getString("resultitemname");
            mainEntryList.add(fieldName);
        }
        SWCPageCache parentCache = new SWCPageCache(this.getView().getParentView());
        List subEntryList = (List)parentCache.get("conditionAndResultFieldInfo", List.class);
        int size = mainEntryList.size();
        if (size != subEntryList.size()) {
            return Boolean.TRUE;
        }
        for (int i = 0; i < size; ++i) {
            if (SWCStringUtils.equals((String)((String)mainEntryList.get(i)), (String)((String)subEntryList.get(i)))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getValueTypeDesc(String number) {
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DECIMAL.getCode())) {
            return DataGradeValueTypeEnum.DECIMAL.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.AMOUNT.getCode())) {
            return DataGradeValueTypeEnum.AMOUNT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.TEXT.getCode())) {
            return DataGradeValueTypeEnum.TEXT.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.INTEGER.getCode())) {
            return DataGradeValueTypeEnum.INTEGER.getDesc();
        }
        if (SWCStringUtils.equals((String)number, (String)DataGradeValueTypeEnum.DATE.getCode())) {
            return DataGradeValueTypeEnum.DATE.getDesc();
        }
        return null;
    }

    private void createGetControlByType(OnGetControlArgs e, String key) {
        int index = key.indexOf(45);
        if (index == -1) {
            return;
        }
        String valueType = key.substring(index + 1, key.lastIndexOf(45));
        if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setEntryKey("entryentity");
            textEdit.setView(this.getView());
            textEdit.setFieldKey(key.toLowerCase());
            textEdit.setModel(this.getView().getModel());
            e.setControl((Control)textEdit);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(key);
            integerEdit.setEntryKey("entryentity");
            integerEdit.setView(this.getView());
            integerEdit.setFieldKey(key.toLowerCase());
            integerEdit.setModel(this.getView().getModel());
            e.setControl((Control)integerEdit);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            DecimalEdit decimalEdit = new DecimalEdit();
            decimalEdit.setKey(key);
            decimalEdit.setEntryKey("entryentity");
            decimalEdit.setView(this.getView());
            decimalEdit.setFieldKey(key.toLowerCase());
            decimalEdit.setModel(this.getView().getModel());
            e.setControl((Control)decimalEdit);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
            DateEdit dateEdit = new DateEdit();
            dateEdit.setKey(key);
            dateEdit.setEntryKey("entryentity");
            dateEdit.setView(this.getView());
            dateEdit.setFieldKey(key.toLowerCase());
            dateEdit.setModel(this.getView().getModel());
            e.setControl((Control)dateEdit);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            AmountEdit amountEdit = new AmountEdit();
            amountEdit.setKey(key);
            amountEdit.setEntryKey("entryentity");
            amountEdit.setView(this.getView());
            amountEdit.setFieldKey(key.toLowerCase());
            amountEdit.setModel(this.getView().getModel());
            e.setControl((Control)amountEdit);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String parentPageId = this.getView().getParentView().getPageId();
        List gradeDatas = (List)appCache.get(parentPageId + "_subPageGradeCache", List.class);
        SWCPageCache parentCache = new SWCPageCache(this.getView().getParentView());
        if (gradeDatas == null || gradeDatas.size() == 0) {
            return;
        }
        List<List<Map<String, Object>>> groupList = this.groupList(gradeDatas);
        String dataStr = (String)parentCache.get("conditiondatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return;
        }
        JSONArray conditionArray = JSONArray.parseArray((String)dataStr);
        dataStr = (String)parentCache.get("resultdatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return;
        }
        JSONArray resultArray = JSONArray.parseArray((String)dataStr);
        List<String> orderList = this.getFieldOrderList(conditionArray, resultArray);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        for (List<Map<String, Object>> dataList : groupList) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            for (String key : orderList) {
                Object value = this.getValueByKey(key, dataList);
                if (value != null && key.contains("-date-")) {
                    if (value instanceof String) {
                        String[] strs = ((String)value).split(" ");
                        try {
                            newRow.set(key, (Object)SWCDateTimeUtils.parseDate((String)strs[0]));
                        }
                        catch (ParseException e1) {
                            newRow.set(key, null);
                        }
                        continue;
                    }
                    if (!(value instanceof Date)) continue;
                    String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
                    try {
                        newRow.set(key, (Object)SWCDateTimeUtils.parseDate((String)dateStr));
                    }
                    catch (ParseException e1) {
                        newRow.set(key, null);
                    }
                    continue;
                }
                newRow.set(key, value);
            }
            rows.add((Object)newRow);
        }
        e.setDataEntity((Object)dataEntity);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.startsWith("condition-")) {
            ChangeData[] changes = e.getChangeSet();
            ChangeData changeData = changes[0];
            int rowIndex = changeData.getRowIndex();
            if (this.conditionValueValidate(key, rowIndex)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u503c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataGradeEntryPlugin_2", (String)"swc-hsas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(key, null, rowIndex);
                return;
            }
            this.setGradeDataToCache();
        } else if (key.startsWith("result-")) {
            this.setGradeDataToCache();
        }
    }

    private void setGradeDataToCache() {
        ArrayList dataList = new ArrayList(10);
        DynamicObjectCollection gradeDatas = this.getModel().getEntryEntity("entryentity");
        if (gradeDatas == null || gradeDatas.size() == 0) {
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
            String parentPageId = this.getView().getParentView().getPageId();
            appCache.put(parentPageId + "_subPageGradeCache", dataList);
            return;
        }
        for (DynamicObject dataObj : gradeDatas) {
            DataEntityPropertyCollection properties = dataObj.getDynamicObjectType().getProperties();
            int seq = 0;
            for (IDataEntityProperty propertie : properties) {
                String fieldId = propertie.getName();
                if (SWCStringUtils.equals((String)fieldId, (String)"seq")) {
                    seq = dataObj.getInt("seq");
                    continue;
                }
                if (!fieldId.startsWith("condition-") && !fieldId.startsWith("result-")) continue;
                LocaleString fieldNameLocal = propertie.getDisplayName();
                String fieldName = fieldNameLocal.toString();
                Object value = dataObj.get(fieldId);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                dataMap.put("rownum", seq);
                dataMap.put("fieldid", fieldId);
                dataMap.put("fieldName", fieldName);
                dataMap.put("value", value);
                dataList.add(dataMap);
            }
        }
        Iterator appCache = SWCAppCache.get((String)"hsas_datagrade_appcache");
        String parentPageId = this.getView().getParentView().getPageId();
        appCache.put(parentPageId + "_subPageGradeCache", dataList);
    }

    public boolean conditionValueValidate(String key, int rowIndex) {
        DynamicObjectCollection dataColl = this.getModel().getEntryEntity("entryentity");
        if (dataColl == null || dataColl.size() == 0) {
            return false;
        }
        int dataLen = dataColl.size();
        if (rowIndex > dataLen - 1) {
            return false;
        }
        Map<String, Object> conditionFieldMap = this.getConditionIdAndName(dataColl);
        DynamicObject rowData = (DynamicObject)dataColl.get(rowIndex);
        for (Map.Entry<String, Object> entry : conditionFieldMap.entrySet()) {
            String fieldId = entry.getKey();
            Object valObj = rowData.get(fieldId);
            if (!SWCObjectUtils.isEmpty((Object)valObj)) continue;
            return false;
        }
        for (int i = 0; i < dataLen; ++i) {
            if (i == rowIndex) continue;
            DynamicObject currentData = (DynamicObject)dataColl.get(i);
            boolean isMatch = true;
            for (Map.Entry<String, Object> entry : conditionFieldMap.entrySet()) {
                Object rowVal;
                Object currentVal;
                String fieldId = entry.getKey();
                Object currentObj = currentData.get(fieldId);
                if (SWCObjectUtils.isEmpty((Object)currentObj)) {
                    isMatch = false;
                    break;
                }
                String valueType = DataGradeValueTypeEnum.TEXT.getDesc();
                int index = fieldId.indexOf(45);
                if (index != -1) {
                    valueType = fieldId.substring(index + 1, fieldId.lastIndexOf(45));
                }
                if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.TEXT.getDesc(), (String)valueType)) {
                    currentVal = (String)currentObj;
                    rowVal = rowData.getString(fieldId);
                    if (SWCStringUtils.equals((String)currentVal, (String)rowVal)) continue;
                    isMatch = false;
                    break;
                }
                if (SWCStringUtils.equals((String)DataGradeValueTypeEnum.DECIMAL.getDesc(), (String)valueType) || SWCStringUtils.equals((String)DataGradeValueTypeEnum.AMOUNT.getDesc(), (String)valueType)) {
                    currentVal = (BigDecimal)currentObj;
                    rowVal = rowData.getBigDecimal(fieldId);
                    if (((BigDecimal)currentVal).compareTo((BigDecimal)rowVal) == 0) continue;
                    isMatch = false;
                    break;
                }
                if (!SWCStringUtils.equals((String)DataGradeValueTypeEnum.DATE.getDesc(), (String)valueType)) continue;
                currentVal = (Date)currentObj;
                rowVal = rowData.getDate(fieldId);
                if (((Date)currentVal).getTime() == ((Date)rowVal).getTime()) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getConditionIdAndName(DynamicObjectCollection dataColl) {
        LinkedHashMap<String, Object> retMap = new LinkedHashMap<String, Object>(16);
        DynamicObject firstData = (DynamicObject)dataColl.get(0);
        DataEntityPropertyCollection propertyColl = firstData.getDynamicObjectType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : propertyColl) {
            String fieldId = iDataEntityProperty.getName();
            if (!fieldId.startsWith("condition-")) continue;
            String fieldName = iDataEntityProperty.getDisplayName().toString();
            HashMap<String, String> fieldInfoMap = new HashMap<String, String>(2);
            fieldInfoMap.put("fieldId", fieldId);
            fieldInfoMap.put("fieldName", fieldName);
            retMap.put(fieldId, fieldInfoMap);
        }
        return retMap;
    }

    private List<String> getFieldOrderList(JSONArray conditionDatas, JSONArray resultDatas) {
        String valueType;
        String id;
        JSONObject dataObj;
        int i;
        ArrayList<String> orderList = new ArrayList<String>(10);
        int size = conditionDatas.size();
        for (i = 0; i < size; ++i) {
            dataObj = conditionDatas.getJSONObject(i);
            id = dataObj.getString("conditionid");
            valueType = dataObj.getString("valueType");
            if (!SWCStringUtils.isNotEmpty((String)id) || !SWCStringUtils.isNotEmpty((String)valueType)) continue;
            id = "condition-" + valueType + '-' + id;
            orderList.add(id);
        }
        size = resultDatas.size();
        for (i = 0; i < size; ++i) {
            dataObj = resultDatas.getJSONObject(i);
            id = dataObj.getString("resultid");
            valueType = dataObj.getString("valueType");
            if (!SWCStringUtils.isNotEmpty((String)id) || !SWCStringUtils.isNotEmpty((String)valueType)) continue;
            id = "result-" + valueType + '-' + id;
            orderList.add(id);
        }
        return orderList;
    }

    private Object getValueByKey(String key, List<Map<String, Object>> dataList) {
        for (Map<String, Object> dataMap : dataList) {
            String fieldid = (String)dataMap.get("fieldid");
            if (!SWCStringUtils.equals((String)key, (String)fieldid)) continue;
            return dataMap.get("value");
        }
        return null;
    }

    private List<List<Map<String, Object>>> groupList(List<Map<String, Object>> dataList) {
        ArrayList<List<Map<String, Object>>> retList = new ArrayList<List<Map<String, Object>>>(10);
        Map<String, Object> firstMap = dataList.get(0);
        Map<String, Object> lastMap = dataList.get(dataList.size() - 1);
        int lastIndex = (Integer)lastMap.get("rownum");
        for (int firstIndex = ((Integer)firstMap.get("rownum")).intValue(); firstIndex <= lastIndex; ++firstIndex) {
            ArrayList<Map<String, Object>> innerList = new ArrayList<Map<String, Object>>(10);
            for (Map<String, Object> dataObj : dataList) {
                int rowNum = (Integer)dataObj.get("rownum");
                if (rowNum != firstIndex) continue;
                innerList.add(dataObj);
            }
            retList.add(innerList);
        }
        return retList;
    }

    public List<DynamicObjectCollection> groupCollection(DynamicObjectCollection datas) {
        ArrayList<DynamicObjectCollection> list = new ArrayList<DynamicObjectCollection>(10);
        DynamicObject firstObj = (DynamicObject)datas.get(0);
        DynamicObject lastObj = (DynamicObject)datas.get(datas.size() - 1);
        int lastIndex = lastObj.getInt("rownum");
        for (int index = firstObj.getInt("rownum"); index <= lastIndex; ++index) {
            DynamicObjectCollection coll = new DynamicObjectCollection();
            for (DynamicObject obj : datas) {
                int rowNum = obj.getInt("rownum");
                if (rowNum != index) continue;
                coll.add((Object)obj);
            }
            list.add(coll);
        }
        return list;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (SWCStringUtils.equals((String)operateKey, (String)"addentrydata")) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            DynamicObject rowDataEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            model.endInit();
            BindingContext bindCtx = new BindingContext(rowDataEntity.getDataEntityType(), rowDataEntity, rowDataEntity.getInt("seq") - 1);
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            List<Object> rowValues = this.getRowBindValue(bindCtx, this.getView());
            if (SWCObjectUtils.isEmpty(rowValues) || rowValues.size() == 0) {
                return;
            }
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.appendRow(grid.getKey(), rowValues);
            this.setGradeDataToCache();
        } else if (SWCStringUtils.equals((String)operateKey, (String)"deleteentry") || SWCStringUtils.equals((String)operateKey, (String)"moveentryup") || SWCStringUtils.equals((String)operateKey, (String)"moveentrydown")) {
            this.setGradeDataToCache();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDataGradeTableEnable(Boolean.FALSE);
        this.setDataGradeEnableStatus();
    }

    private void setDataGradeEnableStatus() {
        log.info("has datagrade permition new :{}", (Object)SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_datagrade", (String)"4715a0df000000ac"));
        if (SWCPermissionServiceHelper.hasPerm((String)"/UHMBBGZQ65X", (String)"hsas_datagrade", (String)"4715a0df000000ac")) {
            IFormView parentView = this.getView().getParentView();
            boolean isHisPage = BaseDataHisHelper.isHisPage((IFormView)parentView);
            if (isHisPage) {
                this.setDataGradeTableEnable(Boolean.TRUE);
            } else {
                String status = (String)parentView.getModel().getValue("status");
                if (SWCStringUtils.equals((String)status, (String)"A")) {
                    this.setDataGradeTableEnable(Boolean.TRUE);
                }
            }
        }
    }

    private void setDataGradeTableEnable(Boolean isLock) {
        DynamicObjectCollection dataColl = this.getModel().getEntryEntity("entryentity");
        if (dataColl == null || dataColl.size() == 0) {
            return;
        }
        DynamicObject firstData = (DynamicObject)dataColl.get(0);
        DataEntityPropertyCollection propertyColl = firstData.getDynamicObjectType().getProperties();
        ArrayList<String> gradeList = new ArrayList<String>();
        for (IDataEntityProperty iDataEntityProperty : propertyColl) {
            String name = iDataEntityProperty.getName();
            if (!name.startsWith("condition-") && !name.startsWith("result-")) continue;
            gradeList.add(name);
        }
        int len = gradeList.size();
        String[] gradeArray = new String[len];
        for (int i = 0; i < len; ++i) {
            gradeArray[i] = (String)gradeList.get(i);
        }
        int size = dataColl.size();
        for (int i = 0; i < size; ++i) {
            this.getView().setEnable(isLock, i, gradeArray);
        }
    }

    private List<Control> getControls() {
        IFormView parentView = this.getView().getParentView();
        if (SWCObjectUtils.isEmpty((Object)parentView)) {
            return null;
        }
        SWCPageCache parentCache = new SWCPageCache(parentView);
        String dataStr = (String)parentCache.get("conditiondatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return null;
        }
        JSONArray conditionDatas = JSONArray.parseArray((String)dataStr);
        dataStr = (String)parentCache.get("resultdatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return null;
        }
        JSONArray resultDatas = JSONArray.parseArray((String)dataStr);
        ArrayList<Control> allControls = new ArrayList<Control>(10);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"hsas_datagradeentry", (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        EntryAp dynamicEntryAp = this.createEntryApByJson(conditionDatas, resultDatas, entityMetadata);
        List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
        for (Control fieldEdit : fieldEdits) {
            Container container = (Container)fieldEdit;
            List items = container.getItems();
            for (Control control : items) {
                allControls.add(control);
            }
        }
        return allControls;
    }

    private EntryAp createEntryAp(JSONArray conditionDatas, JSONArray resultDatas, EntityMetadata entityMetadata) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        EntryFieldGroupAp conditionGroupAp = new EntryFieldGroupAp();
        conditionGroupAp.setKey("condition");
        conditionGroupAp.setName(new LocaleString(ResManager.loadKDString((String)"\u6761\u4ef6", (String)"DataGradeEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        int size = conditionDatas.size();
        for (int i = 0; i < size; ++i) {
            JSONObject conditionObj = conditionDatas.getJSONObject(i);
            String id = conditionObj.getString("conditionid");
            String valueType = conditionObj.getString("valueType");
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            id = "condition-" + valueType + '-' + id;
            String name = conditionObj.getString("conditionitemname");
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setKey(id);
            fieldAp.setName(new LocaleString(name));
            fieldAp.setFireUpdEvt(true);
            int maxLength = 200;
            if (conditionObj.containsKey((Object)"conditionlength")) {
                maxLength = conditionObj.getIntValue("conditionlength");
            }
            int accuracy = 2;
            if (conditionObj.containsKey((Object)"conditionaccuracy")) {
                accuracy = conditionObj.getIntValue("conditionaccuracy");
            }
            int currency = 2;
            if (conditionObj.containsKey((Object)"amtPrecision")) {
                currency = conditionObj.getIntValue("amtPrecision");
            }
            this.createFieldByType(fieldAp, id, valueType, entityMetadata, maxLength, accuracy, currency);
            conditionGroupAp.getItems().add(fieldAp);
        }
        entryAp.getItems().add(conditionGroupAp);
        EntryFieldGroupAp resultGroupAp = new EntryFieldGroupAp();
        resultGroupAp.setKey("result");
        resultGroupAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u679c", (String)"DataGradeEntryPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        size = resultDatas.size();
        for (int i = 0; i < size; ++i) {
            JSONObject resultObj = resultDatas.getJSONObject(i);
            String id = resultObj.getString("resultid");
            String valueType = resultObj.getString("valueType");
            id = "result-" + valueType + '-' + id;
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            String name = resultObj.getString("resultitemname");
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setKey(id);
            fieldAp.setName(new LocaleString(name));
            fieldAp.setFireUpdEvt(true);
            int maxLength = 200;
            if (resultObj.containsKey((Object)"resultlength")) {
                maxLength = resultObj.getIntValue("resultlength");
            }
            int accuracy = 2;
            if (resultObj.containsKey((Object)"resultaccuracy")) {
                accuracy = resultObj.getIntValue("resultaccuracy");
            }
            int currency = 2;
            if (resultObj.containsKey((Object)"amtPrecision")) {
                currency = resultObj.getIntValue("amtPrecision");
            }
            this.createFieldByType(fieldAp, id, valueType, entityMetadata, maxLength, accuracy, currency);
            resultGroupAp.getItems().add(fieldAp);
        }
        entryAp.getItems().add(resultGroupAp);
        return entryAp;
    }

    private EntryAp createEntryApByJson(JSONArray conditionDatas, JSONArray resultDatas, EntityMetadata entityMetadata) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryentity");
        EntryFieldGroupAp conditionGroupAp = new EntryFieldGroupAp();
        conditionGroupAp.setKey("condition");
        conditionGroupAp.setName(new LocaleString(ResManager.loadKDString((String)"\u6761\u4ef6", (String)"DataGradeEntryPlugin_0", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        int size = conditionDatas.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dataObj = conditionDatas.getJSONObject(i);
            String id = dataObj.getString("conditionid");
            String valueType = dataObj.getString("valueType");
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            id = "condition-" + valueType + '-' + id;
            String name = dataObj.getString("conditionitemname");
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setKey(id);
            fieldAp.setName(new LocaleString(name));
            fieldAp.setFireUpdEvt(true);
            int maxLength = 200;
            if (dataObj.containsKey((Object)"conditionlength")) {
                maxLength = dataObj.getIntValue("conditionlength");
            }
            int accuracy = 2;
            if (dataObj.containsKey((Object)"conditionaccuracy")) {
                accuracy = dataObj.getIntValue("conditionaccuracy");
            }
            int currency = 2;
            if (dataObj.containsKey((Object)"amtPrecision")) {
                currency = dataObj.getIntValue("amtPrecision");
            }
            this.createFieldByType(fieldAp, id, valueType, entityMetadata, maxLength, accuracy, currency);
            conditionGroupAp.getItems().add(fieldAp);
        }
        entryAp.getItems().add(conditionGroupAp);
        EntryFieldGroupAp resultGroupAp = new EntryFieldGroupAp();
        resultGroupAp.setKey("result");
        resultGroupAp.setName(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u679c", (String)"DataGradeEntryPlugin_1", (String)"swc-hsas-formplugin", (Object[])new Object[0])));
        size = resultDatas.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dataObj = resultDatas.getJSONObject(i);
            String id = dataObj.getString("resultid");
            String valueType = dataObj.getString("valueType");
            id = "result-" + valueType + '-' + id;
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            String name = dataObj.getString("resultitemname");
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setKey(id);
            fieldAp.setName(new LocaleString(name));
            fieldAp.setFireUpdEvt(true);
            int maxLength = 200;
            if (dataObj.containsKey((Object)"resultlength")) {
                maxLength = dataObj.getIntValue("resultlength");
            }
            int accuracy = 2;
            if (dataObj.containsKey((Object)"resultaccuracy")) {
                accuracy = dataObj.getIntValue("resultaccuracy");
            }
            int currency = 2;
            if (dataObj.containsKey((Object)"amtPrecision")) {
                currency = dataObj.getIntValue("amtPrecision");
            }
            this.createFieldByType(fieldAp, id, valueType, entityMetadata, maxLength, accuracy, currency);
            conditionGroupAp.getItems().add(fieldAp);
        }
        entryAp.getItems().add(resultGroupAp);
        return entryAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        IFormView parentView = this.getView().getParentView();
        if (SWCObjectUtils.isEmpty((Object)parentView)) {
            return;
        }
        SWCPageCache parentCache = new SWCPageCache(parentView);
        String dataStr = (String)parentCache.get("conditiondatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return;
        }
        JSONArray conditionArray = JSONArray.parseArray((String)dataStr);
        int size = conditionArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dataObj = conditionArray.getJSONObject(i);
            String id = dataObj.getString("conditionid");
            String valueType = dataObj.getString("valueType");
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            id = "condition-" + valueType + '-' + id;
            String name = dataObj.getString("conditionitemname");
            int maxLength = 200;
            if (dataObj.containsKey((Object)"conditionlength")) {
                maxLength = dataObj.getIntValue("conditionlength");
            }
            int accuracy = 2;
            if (dataObj.containsKey((Object)"conditionaccuracy")) {
                accuracy = dataObj.getIntValue("conditionaccuracy");
            }
            int currency = 2;
            if (dataObj.containsKey((Object)"amtPrecision")) {
                currency = dataObj.getIntValue("amtPrecision");
            }
            this.createPropertiesByType(entryType, valueType, id, name, maxLength, accuracy, currency);
        }
        dataStr = (String)parentCache.get("resultdatas", String.class);
        if (SWCStringUtils.isEmpty((String)dataStr)) {
            return;
        }
        JSONArray resultArray = JSONArray.parseArray((String)dataStr);
        size = resultArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject dataObj = resultArray.getJSONObject(i);
            String id = dataObj.getString("resultid");
            String valueType = dataObj.getString("valueType");
            if (SWCStringUtils.isEmpty((String)id) || SWCStringUtils.isEmpty((String)valueType)) continue;
            id = "result-" + valueType + '-' + id;
            String name = dataObj.getString("resultitemname");
            int maxLength = 200;
            if (dataObj.containsKey((Object)"resultlength")) {
                maxLength = dataObj.getIntValue("resultlength");
            }
            int accuracy = 2;
            if (dataObj.containsKey((Object)"resultaccuracy")) {
                accuracy = dataObj.getIntValue("resultaccuracy");
            }
            int currency = 2;
            if (dataObj.containsKey((Object)"amtPrecision")) {
                currency = dataObj.getIntValue("amtPrecision");
            }
            this.createPropertiesByType(entryType, valueType, id, name, maxLength, accuracy, currency);
        }
    }

    private List<Object> getRowBindValue(BindingContext arg, IFormView view) {
        ArrayList<Object> entryRow = new ArrayList<Object>(10);
        entryRow.add(arg.getRowIndex());
        entryRow.add(arg.getRowIndex() + 1);
        if (arg.getDataEntity() instanceof DynamicObject && arg.getEntityEntityType() != null && arg.getEntityEntityType() instanceof TreeEntryType) {
            DynamicObject obj = (DynamicObject)arg.getDataEntity();
            entryRow.add("" + obj.getPkValue());
            entryRow.add("" + obj.get("pid"));
            entryRow.add(obj.get("isGroupNode"));
        } else {
            entryRow.add(null);
            entryRow.add(null);
        }
        List<Control> allControls = this.getControls();
        if (SWCObjectUtils.isEmpty(allControls) || allControls.size() == 0) {
            return null;
        }
        for (Control ctl : allControls) {
            Object formatVal = null;
            ArrayList<OperationColItem> operationColItems = new ArrayList<OperationColItem>(10);
            if (ctl instanceof FieldEdit) {
                FieldEdit fldEdit = (FieldEdit)ctl;
                if (fldEdit instanceof LargeTextOtherEdit && StringUtils.isBlank((Object)(formatVal = view.getModel().getValue(fldEdit.getFieldKey() + "_tag", arg.getRowIndex()))) && StringUtils.isNotBlank((Object)fldEdit.getBindingValue(arg))) {
                    formatVal = fldEdit.getBindingValue(arg);
                }
            } else if (ctl instanceof OperationColumn) {
                for (OperationColItem operationColItem : ((OperationColumn)ctl).getOperationColItems()) {
                    OperationColItem newOperationColItem = new OperationColItem(operationColItem);
                    operationColItems.add(newOperationColItem);
                }
                formatVal = operationColItems;
            }
            PackageDataEvent packageDataEvent = new PackageDataEvent((Object)ctl, (DynamicObject)arg.getDataEntity(), formatVal);
            if (ctl instanceof OperationColumn) {
                entryRow.add(((OperationColumn)ctl).getBindingOperationColItems(operationColItems));
                continue;
            }
            if (!(ctl instanceof FieldEdit) || ((FieldEdit)ctl).isFlatField()) continue;
            entryRow.add(packageDataEvent.getFormatValue());
        }
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        entryRow.add(new HashMap(0));
        return entryRow;
    }

    private void createFieldByType(EntryFieldAp fieldAp, String id, String valueType, EntityMetadata entityMetadata, int maxLength, int accuracy, int currency) {
        if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
            TextField field = new TextField();
            field.setId(id);
            field.setKey(id);
            field.setEnableNull(true);
            field.setLockedEmptyTip(new LocaleString(""));
            field.setMaxLength(maxLength);
            field.setEntityMetadata(entityMetadata);
            field.setFeatures(new Features());
            fieldAp.setField((Field)field);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
            IntegerField field = new IntegerField();
            field.setKey(id);
            field.setEnableNull(true);
            field.setScale(0);
            field.setFeatures(new Features());
            fieldAp.setField((Field)field);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            DecimalField decimalField = new DecimalField();
            decimalField.setKey(id);
            decimalField.setEnableNull(true);
            decimalField.setScale(accuracy);
            decimalField.setPrecision(23);
            decimalField.setZeroShow(true);
            decimalField.setFeatures(new Features());
            fieldAp.setField((Field)decimalField);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            DecimalField decimalField = new DecimalField();
            decimalField.setKey(id);
            decimalField.setEnableNull(true);
            decimalField.setScale(currency);
            decimalField.setPrecision(23);
            decimalField.setZeroShow(true);
            decimalField.setFeatures(new Features());
            fieldAp.setField((Field)decimalField);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
            DateField dateField = new DateField();
            dateField.setKey(id);
            dateField.setDefValue(null);
            dateField.setEntityMetadata(entityMetadata);
            dateField.setEnableNull(true);
            dateField.setFeatures(new Features());
            fieldAp.setField((Field)dateField);
        }
    }

    private void createPropertiesByType(EntryType entryType, String valueType, String id, String name, int maxLength, int accuracy, int currency) {
        if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.TEXT.getDesc())) {
            TextProp textProp = new TextProp();
            textProp.setName(id);
            textProp.setDisplayName(new LocaleString(name));
            textProp.setDefaultValue((Object)"");
            textProp.setDbIgnore(true);
            textProp.setAlias(null);
            textProp.setMaxLenth(maxLength);
            textProp.setEnableNull(true);
            textProp.setFeatures(new Features().getValue());
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.INTEGER.getDesc())) {
            IntegerProp prop = new IntegerProp();
            prop.setName(id);
            prop.setDisplayName(new LocaleString(name));
            prop.setControlPropName("integerfield");
            prop.setDbIgnore(true);
            prop.setDefValue(null);
            prop.setEnableNull(true);
            prop.setScale(0);
            prop.setFeatures(new Features().getValue());
            entryType.registerSimpleProperty((DynamicSimpleProperty)prop);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DECIMAL.getDesc())) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(id);
            decimalProp.setDisplayName(new LocaleString(name));
            decimalProp.setEnableNull(true);
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            decimalProp.setPrecision(23);
            decimalProp.setScale(accuracy);
            decimalProp.setZeroShow(true);
            decimalProp.setFeatures(new Features().getValue());
            entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.AMOUNT.getDesc())) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(id);
            decimalProp.setDisplayName(new LocaleString(name));
            decimalProp.setEnableNull(true);
            decimalProp.setDbIgnore(true);
            decimalProp.setAlias("");
            decimalProp.setPrecision(23);
            decimalProp.setScale(currency);
            decimalProp.setZeroShow(true);
            decimalProp.setFeatures(new Features().getValue());
            entryType.registerSimpleProperty((DynamicSimpleProperty)decimalProp);
        } else if (SWCStringUtils.equals((String)valueType, (String)DataGradeValueTypeEnum.DATE.getDesc())) {
            DateProp dateProp = new DateProp();
            dateProp.setName(id);
            dateProp.setDisplayName(new LocaleString(name));
            dateProp.setDbIgnore(true);
            dateProp.setAlias("");
            dateProp.setEnableNull(true);
            dateProp.setFeatures(new Features().getValue());
            entryType.registerSimpleProperty((DynamicSimpleProperty)dateProp);
        }
    }
}

